#!/usr/bin/perl
#
# User authentication module for Foton BBS
#

sub authenticate {
  login: {
    unless (defined($tries)) {
      $tries=1;
    } else {
      ++$tries;
    }
    if ($tries eq 4) {
      bye();
    }
    writeline($theme{'login'});
    $info{'handle'}=getline(text,20);
    chomp ($info{'handle'});
    $info{'handle'}=ucfirst($info{'handle'});
    if ($info{'handle'} eq "") {
      $info{'handle'}="erfere43453trqer234";
    }
    if ($info{'handle'} =~/[Nn][Ee][Ww]/) {
      newuser();
    }
    if ($firstlogon ne "1") {
      $ucheck=finduser();
      if ($ucheck =~/invalid/) {
        writeline($theme{'nouser'});
        goto login;
      }
      $tries="";
      testpasswd: {
        writeline($theme{'passwordprompt'});
        $result=getline(password,20);
        $tstpassword=crypt($result,ord($info{'handle'}));
        until ($tstpassword eq $info{'password'}) {
          writeline($theme{'mismatch'});
          logger($info{'handle'}." incorrect password on node ".$info{'tty'}." via ".$info{'connect'});
          $tstpassword="";
          unless (defined($tries)) {
            $tries=1;
          } else {
            ++$tries;
          }
          if ($tries eq 4) {
            bye();
          }
          goto testpasswd;
        }
      }
    } else {
      writeline($theme{'fstwelcome'});
    }
    pageall("just logged in on node ".$info{'node'});		### Put in theme!
    logger($info{'handle'}." logged in on node ".$info{'tty'}." via ".$info{'connect'});
  }
}

sub setupdoors{
  unless (-d "$config{'doors'}/nodes") {
    mkdir ("$config{'doors'}/nodes");
  }
  unless (-d "$config{'doors'}/nodes/$info{'node'}") {
    mkdir ("$config{'doors'}/nodes/$info{'node'}");
  }
  open (out,">$config{'doors'}/nodes/$info{'node'}/dorinfo$info{'node'}.def");
    print out "$config{'systemname'}\r\n$config{'sysop'}\r\n\r\nCOM1:\r\n19200 BAUD,N,8,1\r\n1\r\n$info{'handle'}\r\n\r\n$info{'location'}\r\n$info{'ANSI'}\r\n110\r\n110\r\n1\r\n";
  close (out);
  open (out,">$config{'doors'}/nodes/$info{'node'}/dorinfo1.def");
    print out "$config{'systemname'}\r\n$config{'sysop'}\r\n\r\nCOM1:\r\n19200 BAUD,N,8,1\r\n1\r\n$info{'handle'}\r\n\r\n$info{'location'}\r\n$info{'ANSI'}\r\n110\r\n110\r\n1\r\n";
  close (out);
  open (out,">$config{'doors'}/nodes/$info{'node'}/door.sys");
        print out "COM1:\r\n38400\r\n8\r\n1\r\n38400\r\nY\r\nY\r\nY\r\nY\r\n$info{'handle'}\r\n$info{'location'}\r\n$info{'phonenumber'}\r\n$info{'phonenumber'}\r\nPASSWORD\r\n110\r\n1456\r\n03/14/88\r\n7560\r\n126\r\nGR\r\n23\r\nY\r\n1,2,3,4,5,6,7\r\n7\r\n12/31/99\r\n1\r\nY\r\n0\r\n0\r\n0\r\n999999\r\n10/22/88\r\nG:\\GAP\\MAIN\r\nG:\\GAP\\GEN\r\n$config{'sysop'}\r\n$config{'sysop'}\r\n00:05\r\nY\r\n$info{'ansi'}\r\nY\r\n14\r\n10\r\n07/07/90\r\n14:32\r\n07:30\r\n6\r\n3\r\n23456\r\n76329\r\n$config{'systemname'}\r\n10\r\n10283\r\n";
  close (out);
  open (out,">$config{'doors'}/nodes/$info{'node'}/fusiondoor");
   print out "username=$info{'handle'}\nservername=$info{'systemname'}\nnode=$info{'node'}\nsecurity=$userinfo{'security'}\nansi=$info{'ansi'}\n";
  close (out);
}

sub finduser {
  $fuser=$config{'home'}.$config{'data'}."/users.dat";
  open (in,"<$fuser");
  while (<in>) {
    $line=$_;
    chomp ($line);
    ($chkid,$chkname)=split(/\|/,$line);
    if ($chkname eq $info{'handle'}) {
      close (in);
      loaduser($chkid);
      return "valid";
    }
  }
  close (in);
  return "invalid";
}

sub finduserid {
  $fuser=$config{'home'}.$config{'data'}."/users.dat";
  open (in,"<$fuser");
  $idcount=0;
  while (<in>) {
    $line=$_;
    chomp ($line);
    ($chkid,$chkname)=split(/\|/,$line);
    if ($chkname eq $info{'handle'}) {
      close (in);
      return $chkid;
    }
    ++$idcount;
  }
  close (in);
  return $idcount;
}

sub loaduser {
  $ruser=$config{'home'}.$config{'data'}."/users/".$_[0].".dat";
  open (in,"<$ruser");
  while (<in>) {
    $line=$_;
    chomp $line;
    unless ($line =~/^#/) {
      if ($line =~/#/i) {
        ($newline,$junk)=split(/#/,$line);
        while ($newline =~/\s$/) {
          chop $newline;
        }
        $line=$newline;
      }
      ($key,$value)=split(/=/,$line);
      unless ($key =~/node/){
        $info{$key}=$value;
      } else {
        $info{'lastnode'}=$value;
      }
    }
  }
  close (in);
}

sub updateuser {
  unless (defined($info{'id'})) {
    $info{'id'}=finduserid();
    $outto=$config{'home'}.$config{'data'}."/users.dat";
    open (out,">>$outto");
      print out $info{'id'}."|".$info{'handle'}."\n";
    close (out);
  }
  $outto=$config{'home'}.$config{'data'}."/users/".$info{'id'}.".dat";
  open (out,">$outto");
  foreach $key(keys %info) {
    print out $key."=".$info{$key}."\n";
  }
  logger("Saved ".$info{'handle'}." to record number ".$info{'id'});
  close (out);
}

sub newuser {
  if($config{'public'} eq "0") {
    writeline($theme{'nonewusers'});
    bye();
  }
  logger("New user on Node".$info{'tty'});
  iamat("New User","Creating an account");
  $readit=0;
  if (-e $info{'home'}."/".$info{'text'}."/welcome.txt") {
    readfile($info{'home'}."/".$info{'text'}."/welcome.txt");
    $readit=1;
  }
  if (-e $info{'home'}."/".$info{'text'}."/welcome".$info{'ext'} && $readit ne 1) {
    readfile($info{'home'}."/".$info{'text'}."/welcome".$info{'ext'});
    $readit=1;
  }
  if ($readit eq 1) {
    writeline($theme{'agreeprompt'});
    $result=waitkey("N");
    unless ($result =~/[Yy]/) {
      $noevents=1;
      writeline($theme{'noagree'});
      $noevents="";
      bye();
    }
  }
  $readit="";
  writeline($theme{'newprompta'});
  writeline($theme{'ansiprompt'});
  $noevents=1;
  $result=waitkey("Y");
  $noevents="";
  if ($result =~/[Yy]/) {
    $info{'ansi'}=1;
  } else {
    $info{'ansi'}=0;
  }

  colorize();
  applytheme($config{'theme'});

  if ($config{'usefullname'} eq "1") {
    fullname: {
      writeline($theme{'fullname'});
      $info{'rname'}=getline(text,50,"",1);
      unless ($info{'rname'} =~/\s/i) {
        writeline($theme{'fullnwrong'});
        goto fullname;
      }
    }
  }
  if ($config{'usephonenum'} eq "1") {
    phonenumber: {
      writeline($theme{'phoneprompt'});
      $info{'phonenumber'}=getline(phone,14,"",1);
    }
    ### Add validate phone here (IE: no 555-1212)
  }
  writeline($theme{'locationprompt'});
  $info{'location'}=getline(text,50,"",1);
  email: {
    writeline($theme{'setemaila'});
    $info{'email'}=getline(text,40,"",1);
    unless ($info{'email'} =~/\@/i && $info{'email'} =~/\./i) {
      goto email;
    }
  }
  writeline($theme{'dobprompt'});
  $info{'dob'}=getline(dob,10,"",1);
  until ($info{'sex'} =~/[M|F]/) {
    writeline($theme{'mfprompt'});
    $info{'sex'}=waitkey("M");
    $info{'sex'}=uc($info{'sex'});
  }
  newid: {
    writeline($theme{'useridprompt'});
    $info{'handle'}=getline(text,16,"",1);
    $info{'handle'}=ucfirst($info{'handle'});
    chomp ($info{'handle'});
    $handletest=uc($info{'handle'});
    if ($handletest =~/New/gi) {
      $test=" ";
    }
    unless ($handletest =~/\w/i) {
      $test="valid";
    } else {
      $test=finduser($info{'handle'});
    }
    until ($test =~/invalid/i) {
      writeline($theme{'usedidprompt'});
      writeline($theme{'useridprompt'});
      $info{'handle'}=getline(text,16,"",1);
      $info{'handle'}=ucfirst($info{'handle'});
      $handletest=uc($info{'handle'});
      if ($handletest =~/New/gi) {
        $test=" ";
      }
      unless ($handletest =~/\w/i) {
        $test="valid";
      } else {
        $test=finduser($info{'handle'});
      }
    }
  }
  applytheme($config{'theme'});
  writeline($theme{'idokprompt'});
  $result=waitkey("Y");
  unless ($result =~/[Yy]/) {
    writeline("\n");
    goto newid;
  }
  setpassword: { 
    writeline($theme{'setpassword'}.$theme{'setpasswordb'});
    $tmppass=getline(password,16,"",1);
    $info{'password'}=crypt($tmppass,ord($info{'handle'}));
    $tmppass="";
    writeline($theme{'setpasswordc'});
    $tmppass=getline(password,16,"",1);
    $comppass=crypt($tmppass,ord($info{'handle'}));
    if ($comppass ne $info{'password'}) {
      writeline($theme{'passmatch'});
      goto setpassword;
    }
  }
  $info{'security'}=$config{'defsecurity'};
  $info{'mflags'}=$config{'defmflags'};
  $info{'fflags'}=$config{'deffflags'};
  $info{'uflags'}=$config{'defuflags'};
  $info{'credits'}=$config{'defcredits'};
  $info{'tlimit'}=$config{'deftlimit'};
  $info{'theme'}=$config{'deftheme'};;
  $info{'dnd'}="0";
  writeline($theme{'remember'});
  $null=waitkey();
  updateuser();
  $firstlogon=1;
}

sub chansi {
  writeline($theme{'ansiprompt'});
  $noevents=1;
  $result=waitkey("Y");
  $noevents="";
  if ($result =~/[Yy]/) {
    $info{'ansi'}=1;
  } else {
    $info{'ansi'}=0;
  }
  updateuser();
  colorize();
  applytheme($config{'theme'});
}

sub chsex {
  $info{'sex'}="";
  until ($info{'sex'} =~/[M|F]/) {
    writeline($theme{'mfprompt'});
    $info{'sex'}=waitkey("M");
    $info{'sex'}=uc($info{'sex'});
  }
  updateuser();
}

sub chphone {
  writeline($theme{'phoneprompt'});
  $info{'phonenumber'}=getline(phone,14,"",1);
  updateuser();
}

sub chdob {
  writeline($theme{'dobprompt'});
  $info{'dob'}=getline(dob,10,"",1);
  updateuser();
}

sub chrealname {
  fullname: {
    writeline($theme{'fullname'});
    $info{'rname'}=getline(text,50,"",1);
    unless ($info{'rname'} =~/\s/i) {
      writeline($theme{'fullnwrong'});
      goto fullname;
    }
  }
  updateuser();
}

sub chpassword {
  passwordch: {
    writeline($theme{'newpassa'});
    $tmppass=getline(password,16,"",1);
    $info{'password'}=crypt($tmppass,ord($info{'handle'}));
    $tmppass="";
    writeline($theme{'newpassb'});
    $tmppass=getline(password,16,"",1);
    $comppass=crypt($tmppass,ord($info{'handle'}));
    if ($comppass ne $info{'password'}) {
      writeline($theme{'passmatch'});
      goto passwordch;
    }
  }
  updateuser();
}

sub chlocal {
  writeline($theme{'locationprompt'});
  $info{'location'}=getline(text,50,"",1);
  updateuser();
}

sub chdnd {
  unless ($info{'dnd'} eq "1") {
    writeline($LGN."Do not disturb is now ".$YLW."ON".$LGN."\nIt will not be disabled until ".$RED."YOU".$LGN." turn it off",1);
    $info{'dnd'}="1";
  } else {
    writeline($LGN."Do not disturb is now ".$YLW."OFF".$LGN."\nIt will be disabled until ".$RED."YOU".$LGN." turn it on",1);
    $info{'dnd'}="0";
  }
  updateuser();
}

sub chemail {
  writeline($theme{'setemaila'});
  $info{'email'}=getline(text,40,"",1);
  updateuser();
}

return 1;
