#!/usr/bin/perl
#
# This is the BBS's main module, it includes the menuing system, and bulletins
# 
#

sub bulletins {
  $bullidx=$config{'home'}.$config{'data'}."/bullidx.dat";
  if (-e $bullidx) {
    open (in,"<$bullidx");
    @bulls=<in>;
    close (in);
    writeline($LGN."Found ".$LTB.scalar(@bulls).$LGN." bulletins!",1); ### -> Theme
  } else {
    writeline($LGN."No Bulletins found!",1);	### -> Theme
    return;
  }
  if ($config{'forcebulls'} eq 0) {
    return;
  }
  bullmenu();
}

sub bullmenu {
  bullmenu: {
    writeline("\n");
    iamat($info{'handle'},"Bulletins Menu");
    $count=1;
    if (-e "$config{'home'}/$config{'text'}/bulletins.txt") {
       readfile("bulletins.txt",1);
       $readit=1;
    }
    if (-e "$config{'home'}/$config{'text'}/bulletins.ans" && $readit ne 1) {
       readfile("bulletins.ans",1);
       $readit=1;
    }
    unless($readit eq 1) {
      ### -> bulletins index textfile..
      foreach $bull(@bulls) {
        chomp ($bull);
        ($bullnum,$bullinfo)=split(/\|/,$bull);
        writeline($LTB.$count.$YLW." ...".$LGN." ".$bullinfo,1);
        ++$count;
      }
    }
    writeline($LTG."\nYour choice (or X to exit): ");   ### -> Theme
    $result=getline(text,1);
    unless ($result =~/[Xx]/) {
      iamat($info{'handle'},"Reading a bulletin");
      --$result;
      $getbull="bull".$result.".txt";
      if (-e "$config{'home'}/$config{'text'}/$getbull") {
        writeline("\n");
        readfile($getbull,1);
        writeline("\n");
        goto bullmenu;
      }
    }
    writeline("\n");
  }
}

sub pageall {
  if ($info{'handle'} eq "erfere43453trqer234") {
    return;
  }
  $msg=$_[0];
  @sendtonodes=`ls $config{'home'}$config{'nodes'}`;
  foreach $snode(@sendtonodes) {
    chomp $snode;
    unless ($snode eq $info{'node'}) {
      open(out,">>$config{'home'}$config{'messages'}/$snode.page");
      print out "\n".$LTB."[".$YLW.$info{'handle'}.$LTB."] ".$WHT.$msg."\n";
      close (out);
    }
  }
}

sub sendpage {
   $page=$_[0];
   chomp ($page);
   @parts=split(/\s/,$page);
   $pguser=shift(@parts);
   $found=0;
   @usersonline=`cat $config{'home'}/$config{'nodes'}/* 2>/dev/null`;
   foreach $rec(@usersonline) {
     chomp ($rec);
     ($pnode,$user,$where)=split(/\|/,$rec);
     $pguser=uc($pguser);
     $user=uc($user);
     if ($user eq "$pguser") {
        $found=1;
        $pmsg=join(' ',@parts);
     }
     $parts[0]=uc($parts[0]);
     if ($user eq "$pguser $parts[0]") {
        $pguser=$pguser.$parts[0];
        $junk=shift(@parts);
        $found=1;
        $pmsg=join(' ',@parts);
     }
     $parts[1]=uc($parts[1]);
     if ($user eq "$pguser $parts[0] $parts[1]") {
       $pguser=$pguser.$parts[0].$parts[1];
       $junk=shift(@parts);
       $junk=shift(@parts);
       $found=1;
       $pmsg=join(' ',@parts);
     }
     if ($found eq "1") {
       ($pnode,$user,$where)=split(/\|/,$rec);
       writeline($LTG."Paging ".$user."..",1);
       open (out,">>$config{'home'}$config{'messages'}/$pnode.page");
       print out "\n".$LTB."[".$YLW.$info{'handle'}.$LTB."]".$WHT." is paging you from the ".$PRED.$_[1].$WHT." ..\n";
       print out $WHT.$pmsg."\n".$RST;
       close (out);
       last;
     }
  }
  if ($found ne "1") {
    writeline($LTB.$pguser.$PPL." is not online",1);
  }
}

sub getpages {
  if (-e "$config{'home'}/$config{'messages'}/$info{'node'}.page") {
    open(in,"<$config{'home'}/$config{'messages'}/$info{'node'}.page");
    unless ($info{'dnd'} eq 1) {
      while (<in>) {
        unless ($inteleconf eq 1) {
          print $_;
        } else {
          chomp $_;
          unless ($_ eq "") {
            print "\e[80D\e[2K".$_."\n";
            $gotapage="1";
          }
        }
      }
      if ($gotapage eq "1") {
        print $WHT.": ".$result;
      }
    }
    close (in);
    unlink("$config{'home'}/$config{'messages'}/$info{'node'}.page");
  }
}

sub menu {
  if ($_[0]) {
    $current=$_[0];
  }
  if ($_[1]) {
    $last=$_[1];
  }
  @mitems=();
  for (;;) {
    open (menu,"<$config{'home'}$config{'menus'}/$current.mnu") || errorout ( $current." menu not found");
     @mitems=(<menu>);
    close(menu);
    if (-e "$config{'home'}/$config{'menus'}/global.mnu") {
      open (global,"<$config{'home'}/$config{'menus'}/global.mnu");
       @gitems=(<global>);
      close(global);
    }
    $header=shift(@mitems);
    chomp ($header);
    $prompt="";
    ($menuname,$menudesc)=split(/\|/,$header);
    iamat($info{'handle'},$menudesc);
    logger($info{'handle'}." is at ".$menudesc);
    $menufile=lc($menuname);
    $readit="";
    if (-e "$config{'home'}$config{'text'}/$menufile.txt") {
      readfile("$menufile.txt");
      $readit=1;
    }
    if (-e "$config{'home'}$config{'text'}/$menufile.$info{'ext'}" && $readit ne 1) {
      readfile("$menufile.$info{'ext'}");
      $readit=1;
    }
    if ($readit ne 1) {
      writeline("\n");
    }
    foreach $mitem(@mitems) {
      chomp ($mitem);
      ($item,$desc,$exec,$seclevel,$disable,$special,$submenu,$numusers)=split(/\|/,$mitem);
      unless ($info{'security'} lt $seclevel || $disable eq 1) {
        if ($readit ne 1) {
          writeline($LGN.$item.$YLW." ... ".$LTB.$desc,1);
        }
        $prompt=$prompt.$item.",";
      }
    }
    writeline("\n".$LGN.$menudesc." (".$WHT.uc($menuname).$LGN.")\n".$LGN."Make your selection (".$prompt."? for help, or X to exit): ");
    doevents();
    $mchoice="";
    $atmenu="1";
    $mchoice=getline(text,255,"",0);
    $atmenu="0";
    foreach $gitem(@gitems) {
      chomp ($gitem);
      push (@mitems,$gitem);
    }
    procmenu: {
      if ($mchoice eq "") {
        $processed="1";
        last;
      }
      if ($mchoice =~/\s/i) {
        @parts=split(//,$mchoice);
        $mchoice="";
        for (@parts) {
          $test=shift(@parts);
          if ($test eq " ") {
            last;
          }
          $mchoice=$mchoice.$test;
        }
        $data=join('',@parts);
      }
      $mchoice=lc($mchoice);
      foreach $mitem(@mitems) {
        ($item,$desc,$exec,$seclevel,$disable,$special,$submenu,$numusers)=split(/\|/,$mitem);
        $item=lc($item);
        if ($mchoice =~/\?/) {
          $processed="1";
          applytheme($config{'theme'});
          writeline($theme{'quest'});
          pause();
          last;
        }
        if ($item =~/$mchoice/ && $info{'security'} ge $seclevel) {
          logger ($info{'handle'}." -> ".$desc);
          iamat($info{'handle'},$desc);
          if ($special =~/menu/) {
             $last=$current;
             $current=$exec;
             return;
          }
          if ($special =~/who/) {
             whosonline();
          }
          if ($special =~/internal/) {
             &$exec($data,$menudesc);
             doevents();
          }
          if ($special =~/bulletins/) {
             bulletinsmenu();
          }
          if ($special =~/quit/) {
             quit();
          }
          if ($special =~/exit/) {
             $current=$last;
             return;
          }
          if ($special =~/bye/) {
             bye();
          }
          if ($special =~/help/) {
          }
          if ($special =~/external/) {
             $dndmode=$info{'dnd'};
             $info{'dnd'}="1";
             $run=$config{'home'}.$config{'sbin'}."/".$exec." ".$config{'home'}." ".$info{'node'}." \"".$info{'handle'}."\"";
             system ($run);
             doevents();
             $info{'dnd'}=$dndmode;
          }
          if ($special =~/rlogin/) {
             $dndmode=$info{'dnd'};
             $info{'dnd'}="1";
             $run="export TERM=none && telnet ".$exec." -E -8 -l \"".$info{'handle'}."\"";
             system ($run);
             doevents();
             $info{'dnd'}=$dndmode;
          }
          if ($special =~/telnet/) {
             $dndmode=$info{'dnd'};
             $info{'dnd'}="1";
             $run="export TERM=none && telnet ".$exec." -E -8 -l \"".$info{'handle'}."\"";
             system ($run);
             doevents();
             $info{'dnd'}=$dndmode;
          }
          $processed="1";
          last;
        } 
      }
      unless ($processed eq "1") {
        writeline($theme{'invalida'}.$mchoice.$theme{'invalidb'});
        $mchoice="";
      }
      $processed="";
    }
  }
}

sub telechannel {
    $channel=$_[0];
    unless (-d "$config{'home'}$config{'messages'}/teleconf/TELEPUB_") {
      mkdir ("$config{'home'}$config{'messages'}/teleconf/TELEPUB_");
    }
    unless (-d "$config{'home'}$config{'messages'}/teleconf/$channel") {
      mkdir ("$config{'home'}$config{'messages'}/teleconf/$channel");
      mkdir ("$config{'home'}$config{'messages'}/teleconf/$channel/users");
      mkdir ("$config{'home'}$config{'messages'}/teleconf/$channel/messages");
    }

    open (out,">$config{'home'}$config{'messages'}/teleconf/TELEPUB_/$info{'node'}");
     print out $info{'node'}."|".$info{'handle'}."|".$channel."\n";
    close (out);

    open (out,">$config{'home'}$config{'messages'}/teleconf/$channel/users/$info{'node'}");
     print out $info{'handle'};
    close (out);

    $channelusers="";
    @teleusers=`ls $config{'home'}$config{'messages'}/teleconf/$channel/users/* 2>/dev/null`;
    $telelen=scalar(@teleusers);
    @teleusers=sort @teleusers;
    $tlucount=scalar(@teleusers);
    if (scalar(@teleusers) gt "1") {
      foreach $teleuser(@teleusers) {
        chomp ($teleuser);
        open (in,"<$teleuser");
        $line=(<in>);
        close (in);
        chomp ($line);
        --$tlucount;
        unless ($line eq $info{'handle'}) {
          if ($tlucount le "1") {
            $channelusers=$channelusers.$line;
          } elsif ($channelusers eq "") {
            $channelusers=$line;
          } else {
            $channelusers=$channelusers.", ".$line;
          }
          if ($tlucount eq "1") {
             $channelusers=$channelusers.", and ";
          }
        }
      }
    } else {
      $channelusers="There is nobody else here with you.";
    }

    if (scalar(@teleusers) eq 2) {
      $channelusers=~s/^,\s//;
      $channelusers=$channelusers." is here with you.";
    }
    if (scalar(@teleusers) gt 2) {
      $channelusers=$channelusers." are here with you.";
    }
    $leaving="1";
    unless ($rescan eq "1") {
      telesend("just entered the room!");
    }
    $leaving="0";
}

sub teleconf {
  $dndmode=$info{'dnd'};
  $info{'dnd'}="0";
  writeline ($WHT."\nEntering teleconference ..");
  unless (-d "$config{'home'}$config{'messages'}/teleconf") {
    mkdir ("$config{'home'}$config{'messages'}/teleconf");
  }
  telechannel($config{'defchannel'});
 channel: {
    writeline ($YLW."\n\nTeleconference\n".$LGN."You are in the ".$PPL.$channel.$LGN." channel.\n".$RST.$channelusers."\n".$YLW."Just press \"".$LTB."?".$YLW."\" if you need any assistance.\n");
  telemain: {
    writeline($WHT.": ");
    $atmenu="1";
    $inteleconf="1";
    doevents();
    $chatline=getline(chat,255);
    if ($chatline eq "") {
      $rescan="1";
      telechannel($channel);
      $rescan="0";
      goto channel;
    }
    if ($chatline =~/^users/ || $chatline =~/#/) {
      if (length($chatline) le "6") {
        whosonline(nopause);
        goto telemain;
      }
    }
    if ($chatline =~/^scan/ || $chatline =~/\/s/) {
      if (length($chatline) le "6") {
        telescan();
        goto telemain;
      }
    }
    if ($chatline eq "?") {
       readfile("telehelp.txt",1);
      goto telemain;
    }
    if ($chatline =~/^\/j/i || $chatline =~/^JOIN/i) {
      $leaving="1";
      telesend("just left the channel!");
      $leaving="0";
      unlink ("$config{'home'}$config{'messages'}/teleconf/$channel/users/$info{'node'}");
      ($junk,$channel)=split(/\s/,$chatline);
      writeline($WHT."Entering channel ".$YLW.$channel,1);
      telechannel($channel);
      goto telemain;
    }
    if ($chatline =~/^\/w/i || $chatline =~/^whisper/i) {
      @parts=split(//,$chatline);
      $mchoice="";
      for (@parts) {
        $test=shift(@parts);
        if ($test eq " ") {
          last;
        }
        $mchoice=$mchoice.$test;
      }
      $data=join('',@parts);
      telewhisper($data);
      goto telemain;
    }
    if ($chatline =~/^\/a/i || $chatline =~/^action/i) {
      @parts=split(//,$chatline);
      $mchoice="";
      for (@parts) {
        $test=shift(@parts);
        if ($test eq " ") {
          last;
        }
        $mchoice=$mchoice.$test;
      }
      $chatline=join('',@parts);  
      $chatline =~s/\@LGN/$LGN/g;     $chatline =~s/\@BLK/$BLK/g;
      $chatline =~s/\@RED/$RED/g;     $chatline =~s/\@GRN/$GRN/g;
      $chatline =~s/\@BRN/$BRN/g;     $chatline =~s/\@BLU/$BLU/g;
      $chatline =~s/\@PPL/$PPL/g;     $chatline =~s/\@LGR/$LGN/g;
      $chatline =~s/\@GRY/$GRY/g;     $chatline =~s/\@PNK/$PNK/g;
      $chatline =~s/\@YLW/$YLW/g;     $chatline =~s/\@ALB/$ALB/g;
      $chatline =~s/\@VLT/$VLT/g;     $chatline =~s/\@WHT/$WHT/g;
      $chatline =~s/\@LTB/$LTB/g;     $chatline =~s/\@RST/$RST/g;
      telesend($chatline);
      goto telemain;
    }
    if ($chatline =~/^\/p/i || $chatline =~/^page/i) {
      @parts=split(//,$chatline);
      $mchoice="";
      for (@parts) {
        $test=shift(@parts);
        if ($test eq " ") {
          last;
        }
        $mchoice=$mchoice.$test;
      }
      $data=join('',@parts);
      sendpage($data,"Teleconference");
      goto telemain;
    }
    if ($chatline eq "x") {
      writeline ($WHT."\nLeaving teleconference ..",1);
      $leaving="1";
      telesend("just left the channel!");
      $leaving="0";
      $atmenu="0";
      $inteleconf="0";
      $info{'dnd'}=$dndmode;
      unlink ("$config{'home'}$config{'messages'}/teleconf/$channel/users/$info{'node'}");
      goto leave;
    }
    telesend();
  }
  goto telemain;
  leave: {
    last;
    $plcholder="1";
  }
 }
}

sub telesend {
  $sendmessage=$_[0];
  @telesendto=`ls $config{'home'}$config{'messages'}/teleconf/$channel/users 2>/dev/null`;
  if (scalar(@telesendto) eq 1) {
    unless ($leaving eq 1) {
      writeline ($LGN."There is no one here with you!",1);
    }
  } else {
    foreach $channode(@telesendto) {
      chomp ($channode);
      if ($leaving eq "1") {
        if ($channode eq $info{'node'}) {
          next;
        }
      }
      open(out,">>$config{'home'}$config{'messages'}/$channode.page");
       unless (defined($sendmessage)) {
         print out $YLW.$info{'handle'}.$LTB.": ".$WHT.$chatline.$WHT."\n";
       } else {
         print out $WHT.$info{'handle'}." ".$sendmessage.$WHT."\n";
       }
      close (out);
    }
  }
}

sub telewhisper {
   $page=$_[0];
   chomp ($page);
   @parts=split(/\s/,$page);
   $pguser=shift(@parts);
   $found=0;
   @usersonline=`cat $config{'home'}/$config{'nodes'}/* 2>/dev/null`;
   foreach $rec(@usersonline) {
     chomp ($rec);
     ($pnode,$user,$where)=split(/\|/,$rec);
     $pguser=uc($pguser);
     $user=uc($user);
     if ($user eq "$pguser") {
        $found=1;
        $pmsg=join(' ',@parts);
     }
     $parts[0]=uc($parts[0]);
     if ($user eq "$pguser $parts[0]") {
        $pguser=$pguser.$parts[0];
        $junk=shift(@parts);
        $found=1;
        $pmsg=join(' ',@parts);
     }
     $parts[1]=uc($parts[1]);
     if ($user eq "$pguser $parts[0] $parts[1]") {
       $pguser=$pguser.$parts[0].$parts[1];
       $junk=shift(@parts);
       $junk=shift(@parts);
       $found=1;
       $pmsg=join(' ',@parts);
     }
     if ($found eq "1") {
       writeline($YLW."whispered: ".$pmsg,1);
       ($pnode,$user,$where)=split(/\|/,$rec);
       open (out,">>$config{'home'}$config{'messages'}/$pnode.page");
        print out $YLW.$info{'handle'}.$YLW." whispers ".$LTB.": ".$WHT.$pmsg."\n";
       close (out);
       last;
    }
  }
  if ($found ne "1") {
    writeline($LTB.$pguser.$PPL." is not online",1);
  }
}

sub telescan {
  iamat($info{'handle'},"Who's online");
  @whosonline=`cat $config{'home'}$config{'messages'}/teleconf/TELEPUB_/* 2>/dev/null`;
  @whosonline=sort @whosonline;
  ### Add a header/footer later
  writeline("\n");

format whosonline =
@<<< @<<<<<<<<<<<<<<<   .....   @<<<<<<<<<<<<<<<<<<<<<<<<
$whonode,$whouser,$whowhere
.
  $whonode="Node"; $whouser="User-ID"; $whowhere="Channel";
  writeline($YLW);
  $~="whosonline";
  write;
  $~="stdout";
  writeline($LTB);
  foreach $node(@whosonline) {
    chomp ($node);
    ($whonode,$whouser,$whowhere)=split(/\|/,$node);
    if (length($whonode) lt 3) {
      $whonode="00".$whonode;
    } elsif (length($whonode) lt 2) {
      $whonode="0".$whonode;
    }
    $~="whosonline";
    write;
    $~="stdout";
  }
  writeline($RST."\n");
}


return 1;
