#!/usr/bin/perl
#
#  Foton BBS Framework
#

Defs: {
  $sysinfo{'servername'}="Proton BBS";
  $sysinfo{'version'}=".1";
  $sysinfo{'copyright'}="(C) 2002 FEWT Software";  

  #### Some defaults to add to a config file later..
  $config{'home'}="/home/bbs";				## Main BBS Path
  $config{'bin'}="/bin";				## BBS Bin path (Currently unused)
  $config{'data'}="/data";				## BBS Data path
  $config{'files'}="/data/files";			## BBS Files path (Unused)
  $config{'mail'}="/data/mail";				## BBS Main path (Unused)
  $config{'menus'}="/data/menus";			## BBS Menus
  $config{'messages'}="/data/messages";			## Pager / Teleconference message path
  $config{'nodes'}="/data/nodes";			## Node information path
  $config{'text'}="/data/text";				## Ansi & BBS text files
  $config{'themes'}="/data/themes";			## BBS Skin file
  $config{'users'}="/data/users";			## User information path
  $config{'doors'}="/home/bbs/doors";			## Node info -> Drop files etc
  $config{'sbin'}="/sbin";				## Script bin -> External script/bin path for menus
  $config{'passchr'}="*";				## Passchr to echo at password prompt
  $config{'theme'}="mbbs";				## Default Skin
  $config{'defmenu'}="main";				## Default Menu
  $config{'public'}="1";				## Public/Private BBS
  $config{'usefullname'}="1";				## Force Full Name
  $config{'usephonenum'}="1";				## Force User's phone number
  $config{'forcebulls'}="0";				## Force User bulletins
  $config{'systemname'}="FEWT Software BBS";		## BBS's Name
  $config{'sysop'}="Aitvo";				## Sysop's Name
  $config{'defsecurity'}="10";				## Default Sec level
  $config{'defmflags'}="-------------------";		## Message flags (Unused)
  $config{'deffflags'}="--------------------";		## File flags (Unused)
  $config{'defuflags'}="--------------------";		## User flags (Unused)
  $config{'defcredits'}="1000";				## Default Credits (Unused)
  $config{'deftlimit'}="90";				## Default Time Limit (Unused)
  $config{'defchannel'}="MAIN";				## Default Teleconference Channel
  $config{'deftheme'}="mbbs";				## Default User selected skin (Unused)
  colorize();
}

sub doevents {
  if ($atmenu eq "1") {
    getpages();
  }
}

sub iamat {
  $who=$_[0];
  $location=$_[1];
  $whofile=$config{'home'}.$config{'nodes'}."/".$info{'node'};
  open (who,">$whofile");
   print who $info{'node'}."|".$who."|".$location."\n";
  close (who);
}

sub whosonline {
  writeline($LGN."\nWho's Online:");
  iamat($info{'handle'},"Who's online");
  @whosonline=`cat $config{'home'}$config{'nodes'}/*`;
  @whosonline=sort @whosonline;
  ### Add a header/footer later
  writeline("\n");

format whosonline =
@<<< @<<<<<<<<<<<<<<<   .....   @<<<<<<<<<<<<<<<<<<<<<<<<
$whonode,$whouser,$whowhere
.
  $whonode="Node"; $whouser="User-ID"; $whowhere="Option selected";
  writeline($YLW);
  $~="whosonline";
  write;
  $~="stdout";
  writeline($LTB);
  foreach $node(@whosonline) {
    chomp ($node);
    ($whonode,$whouser,$whowhere)=split(/\|/,$node);
    if (length($whonode) lt 3) {
      $whonode="00".$whonode;
    } elsif (length($whonode) lt 2) {
      $whonode="0".$whonode;
    }
    $~="whosonline";
    write;
    $~="stdout";
  }
  writeline($RST."\n");
  unless ($_[0] =~/nopause/) {
    pause();
  }
}

sub errorout {
  cbreak(off);
  logger ("ERROR: ".$_[0]." ".$info{'handle'}." on node ".$info{'node'}." Exiting..");
  writeline("\n".$RED."ERROR: ".$LTB.$_[0]."\nExiting..",1);
  bye();
}

sub quit {
  writeline($theme{'exita'}.$theme{'exitb'});
  $choice=waitkey("N");
  if ($choice =~/[Yy]/) {
    bye();
  } elsif ($choice =~/[Nn]/) {
    return;
  } elsif ($choice =~/[Rr]/) {
    writeline("\n\n");
    goto begin;
  }
}

sub bye {
  iamat($info{'handle'},"Logging off!");
  cbreak(off);
  if (defined($info{'handle'})) {
    pageall("just logged off!");           ### Put in theme!
  }
  writeline($theme{'goodbyemsg'}.$RST,1);
  #system ("rm -rf $config{'home'}$config{'nodes'}/$info{'node'} 2>/dev/null");
  #system ("rm -rf $config{'home'}$config{'messages'}/public/$info{'node'}.page 2>/dev/null");
  #system ("rm -rf $config{'home'}$config{'messages'}/$info{'node'}.page 2>/dev/null");
  @list=`find $config{'home'} -name $info{'node'} -print`;
  foreach $item(@list) {
    chomp $item;
    system ("rm -rf $item 2>/dev/null");
  }
  exit(0);
}

sub colorize {
  if ($info{'ansi'} eq "1") {
    $RST="\e[0m"; $BLK="\e[0;30m"; $RED="\e[0;31m"; $GRN="\e[0;32m"; $BRN="\e[0;33m"; $BLU="\e[0;34m";
    $PPL="\e[0;35m"; $LGR="\e[0;37m"; $GRY="\e[1;30m"; $PNK="\e[1;31m"; $LGN="\e[1;32m"; $YLW="\e[1;33m";
    $ALB="\e[1;34m"; $VLT="\e[1;35m"; $LTB="\e[1;36m"; $WHT="\e[1;37m"; $PBLK="\e[0;30m"; $PRED="\e[0;31m";
    $PGRN="\e[0;32m"; $PBRN="\e[0;33m"; $PBLU="\e[0;34m"; $PPPL="\e[0;35m"; $PLGR="\e[0;37m"; $PGRY="\e[1;30m";
    $PPNK="\e[1;31m"; $PLGN="\e[1;32m"; $PYLW="\e[1;33m"; $PALB="\e[1;34m"; $PVLT="\e[1;35m";
    $PBLU="\e[1;36m"; $PWHT="\e[1;37m";
  } else {
    $RST=""; $BLK=""; $RED=""; $GRN=""; $BRN=""; $BLU="";
    $PPL=""; $LGR=""; $GRY=""; $PNK=""; $LGN=""; $YLW="";
    $ALB=""; $VLT=""; $LTB=""; $WHT=""; $PBLK=""; $PRED="";
    $PGRN=""; $PBRN=""; $PBLU=""; $PPPL=""; $PLGR=""; $PGRY="";
    $PPNK=""; $PLGN=""; $PYLW=""; $PALB=""; $PVLT="";
    $PBLU=""; $PWHT="";
    print "";
  }
}

sub applytheme {
  $thmfile=$config{'home'}.$config{'themes'}."/".$_[0];
  if (-e $thmfile) {
    open (atheme,"<$thmfile");
     @themein=<atheme>;
    close (atheme);
  } else {
    errorout ("Could not load theme file [".$thmfile."] , exiting..".$RST);
  }
  chomp ($ctime=`date +\%H:\%M`);
  chomp ($cdate=`date +\%Y-\%h-\%d`);
  $menu=uc($menuname);
  foreach (@themein) {
    ($key,$value) = split(/\=/);
    chomp $value;
    unless ($value eq "") {
      $$key = $value;
      $$key =~s/\@LGN/$LGN/g; $$key =~s/\@BLK/$BLK/g; $$key =~s/\@RED/$RED/g; $$key =~s/\@GRN/$GRN/g;
      $$key =~s/\@BRN/$BRN/g; $$key =~s/\@BLU/$BLU/g; $$key =~s/\@PPL/$PPL/g; $$key =~s/\@LGR/$ltgrey/g;
      $$key =~s/\@GRY/$GRY/g; $$key =~s/\@PNK/$PNK/g; $$key =~s/\@YLW/$YLW/g; $$key =~s/\@ALB/$ALB/g;
      $$key =~s/\@VLT/$VLT/g; $$key =~s/\@WHT/$WHT/g; $$key =~s/\@LTB/$LTB/g;
      $$key =~s/\@USRNM/$info{'username'}/g; $$key =~s/\@SVRNM/$sysinfo{'servername'}/g;
      $$key =~s/\@SYSNM/$config{'systemname'}/g; $$key =~s/\@MENU/$menu/g;
      $$key =~s/\@NODE/$info{'node'}/g; $$key =~s/\@CONNECT/$info{'connect'}/g;
      $$key =~s/\@USER/$info{'handle'}/g; $$key =~s/\@EMAIL/$info{'email'}/g;
      $$key =~s/\@TIME/$ctime/g; $$key =~s/\@DATE/$cdate/g;
      $$key =~s/\\n/\n/g; $$key =~s/\\t/\t/g; $$key =~ s/(\$\w+)/$1/eeg;
      $theme{$key}=$$key;
      $$key="";
    }
  }
}

sub readconfig {
  $rfile=$config{'home'}.$config{'data'}."/".$_[0];
  open (config,"<$rfile");
  while (<config>) {
    $line=$_;
    chomp $line;
    unless ($line =~/^#/) {
      if ($line =~/#/i) {
        ($newline,$junk)=split(/#/,$line);
        while ($newline =~/\s$/) {
          chop $newline;
        }
        $line=$newline;
      }
      ($key,$value)=split(/=/,$line);
      $config{$key}=$value;
    }
  }
  close (config);
}

sub cbreak {
  if ($_[0] eq "on") {
    if ($BSD_STYLE) {
      system "stty -echo cbreak </dev/tty >/dev/tty 2>&1";
    } else {
      system "stty -echo raw opost </dev/tty >/dev/tty 2>&1";
    }
  }
  if ($_[0] eq "off") {
    if ($BSD_STYLE) {
      system "stty echo -cbreak </dev/tty >/dev/tty 2>&1";
    } else {
      system "stty echo -raw </dev/tty >/dev/tty 2>&1";
    }
  }
}

sub waitkey {
  $default=$_[0];
  $key="";
  cbreak(on);
  for (;;) {
    $key=getc(STDIN);
    if ($key ne "") {
      unless ($key eq "\n") {
        print $key;			### Colorize
      } else {
        $key=$default;
        print $key;
      }
      last;
    } else {
      next;
    }
  } 
  return $key;
}

sub writeline {
  print "\eD\e[1A\e[K".$_[0];
  if ($_[1] eq "1") {
    print "\n";
  }
}

sub getline {
  cbreak("on");
  $input{'type'}=$_[0];
  $input{'length'}=$_[1];
  $input{'text'}=$_[2];
  $result="";
  if ($_[3]) {
    $result=$input{'text'};
    for (1..$input{'length'}) {
      print "\e[0;47;30m ";   ### Add to theme file!
    }
    print "\e[".$input{'length'}."D";
  }
  print $input{'text'};
  for (;;) {
    eval {
      local $SIG{ALRM}=sub{$key="";doevents();};
      alarm 2;
      $key=getc(STDIN);
      doevents();
      alarm 0;
    };
    if ($key =~/\n/ || $key =~/\r/) {
      chomp $result;
      $retmsg=$result;
      $result="";
      print $RST;
      unless ($retmsg ne "") {
        print $RST;
      }
      if ($input{'type'} =~/phone/ && length($retmsg) ne $input{'length'}) {
        next;
      }
      if ($input{'type'} =~/dob/ && length($retmsg) ne $input{'length'}) {
        next;
      }
      cbreak(off);
      if ($input{'type'} =~/chat/) {
        print "\e[80D\e[2K";
      } else {
        writeline("\n");
      }
      return ($retmsg);
    }
    if ($key =~/\c?/ || $key =~/\ch/) {
      unless ($result eq "") {
        @parts=split(//,$result);
        $junk=pop(@parts);
        $result=join('',@parts);
        print "\e[1D \e[1D";
      }
      next;
    }
    if ($input{'type'} eq "dob") {
      $input{'length'}=10;
      unless ($key =~/[0-9]/) {
        $key="";
        next;
      }
      if (length($result) eq 1) {
        $key=$key."/";
      }
      if (length($result) eq 2) {
        $key="/".$key;
      }
      if (length($result) eq 4) {
        $key=$key."/";
      }
      if (length($result) eq 5) {
        $key="/".$key;
      }
    }
    if ($input{'type'} eq "phone") {
      $input{'length'}=14;
      unless ($key =~/[0-9]/) {
        $key="";
        next;
      }
      if (length($result) lt 1) {
        $key="(".$key;
      }
      if (length($result) eq 3) {
        $key=$key.")";
      }
      if (length($result) eq 4) {
        $key=")".$key;
      }
      if (length($result) eq 5) {
        $key=" ".$key;
      }
      if (length($result) eq 8) {
        $key=$key."-";
      }
      if (length($result) eq 9) {
        $key="-".$key;
      }
    }
    unless (length($result) eq $input{'length'}) {
      unless ($input{'type'} =~/password/) {
        print $key;
      } elsif ($key ne "") {
        print $config{'passchr'};
      }
      $result=$result.$key;
    }
  }
}

sub readfile {
  $filename=$config{'home'}.$config{'text'}."/".$_[0];
  $pause=$_[1];
  open (file,"<$filename") || errorout ("Unable to open $filename");
  $linecount=1;
  $menu=uc($menuname);
  chomp ($ctime=`date +\%H:\%M`);
  chomp ($cdate=`date +\%Y-\%h-\%d`);
  while (<file>) {
    s/\@LGN/$LGN/g;	s/\@BLK/$BLK/g;	s/\@RED/$RED/g;	s/\@GRN/$GRN/g;	s/\@BRN/$BRN/g;
    s/\@BLU/$BLU/g;	s/\@PPL/$PPL/g;	s/\@LGR/$LGN/g;	s/\@GRY/$GRY/g;	s/\@PNK/$PNK/g;
    s/\@YLW/$YLW/g;	s/\@ALB/$ALB/g;	s/\@VLT/$VLT/g;	s/\@WHT/$WHT/g;	s/\@LTB/$LTB/g;  
    s/\@RST/$RST/g;	s/~AT/\@/g;

    s/\@SVRNM/$sysinfo{'servername'}/g;
    s/\@SYSNM/$config{'systemname'}/g;
    s/\@MENU/$menu/g;
    s/\@NODE/$info{'node'}/g;
    s/\@CONNECT/$info{'connect'}/g;

    s/\@OS/$sysinfo{'os'}/g;		### Sysinfo
    s/\@CPU/$sysinfo{'cputype'}/g;
    s/\@HOST/$sysinfo{'host'}/g;
    s/\@SYSTEM/$sysinfo{'system'}/g;
    s/\@SPEED/$sysinfo{'cpuspeed'}/g;
    s/\@TIME/$ctime/g;	s/\@DATE/$cdate/g;

    s/\@USER/$info{'handle'}/g;		### Userinfo
    s/\@RNAME/$info{'rname'}/g;
    s/\@DOB/$info{'dob'}/g;
    s/\@PHONE/$info{'phonenumber'}/g;
    s/\@LOCAL/$info{'location'}/g;
    s/\@CREDITS/$info{'credits'}/g;	
    s/\@TLEFT/$info{'tlimit'}/g;
    s/\@ID/$info{'id'}/g;
    s/\@SEX/$info{'sex'}/g;
    s/\@EMAIL/$info{'email'}/g;
    s/\@DND/$info{'dnd'}/g;
    if ($info{'ansi'} eq 0) {
      $ansi="Y";
    } else {
      $ansi="N";
    }
    s/\@ANSI/$ansi/g;
    s/\\n/\n/g;
    s/\\t/\t/g;
    print;
    unless ($pause eq "1") {
      ++$linecount;
      if ($linecount eq 24) {	### $linecount to user config
        unless ($wait eq "C") {
          $wait=pause();
        }
        if ($wait eq "Q") {
          last;
        }
        if ($wait eq "N") {
          $linecount=1;
        }
      }
    }
  }
  close (file);
}

sub pause {
  writeline ($theme{'pause'}.$RST);
  $noevents=1;
  $key=waitkey();
  $noevents="";
  $key=uc($key);
  print "\e[2K\e[80D";
  unless ($key =~/C/ || $key =~/N/ || $key =~/Q/) {
    $key="N";
  }
  return $key;
}

sub hi {
  cbreak(on);
  eval {
    local $SIG{ALRM} = sub {$response="\c[6c";next;};
    print "\n\nAuto-sensing";
    print "\e[c";
    alarm 1;
    while ($tchr=getc(STDIN)){
      $termmode=$termmode.getc(STDIN);
      if ($termmode =~/\cx/i) {
        $termmode="1c";
        last;
      } elsif ($termmode =~/[0-9]c/i) {
       last;
      }
    }
    alarm 0;
  };
  print ".";
  if ($termmode =~/[0-1]c/gi) {
    $info{'ext'}="asc";
    $info{'ansi'}="0";
  } else {
    $info{'ext'}="ans";
    $info{'ansi'}="1";
  }
  eval {
    alarm 1;
    local $SIG{ALRM} = sub {$tchr="c";next;};
    while ($tchr=$tchr.getc(STDIN)) {
      if ($tchr =~/c$/i) {
        last;
      }
    }
    alarm 0;
  };
  print ".";
  eval {
    alarm 1;
      local $SIG{ALRM} = sub {$tchr="";next;};
      while ($tchr=$tchr.getc(STDIN)) {
        last;
      }
    alarm 0;
  };
  print ".";
  if ($ARGV[1] ne "") {
    $info{'connect'}=$ARGV[1];
  } else {
    $info{'connect'}="TELNET";
  }
  iamat("CONNECT","Logging on");
  chomp ($info{'tty'}=`tty | sed -e s#/[A-z][A-z][A-z]##g -e s#/##g`);
  $info{'node'}=$info{'tty'}+1;		### Determine node user is connected to from tty
  unless ($info{'tty'} =~/[0-9]/i) {
    @parts=split(//,$info{'tty'});
    $tty=pop(@parts);
    $node=ord($tty);
    $node=$node-96;
    $info{'node'}=$node;
  }
}

sub logger {
  system ("logger -p daemon.notice -t \"$config{'servername'}\" \"$_[0]\"");
}

return 1;
