#!/usr/bin/perl

#    Photon BBS, Simple BBS system for Unix
#    Copyright (C) 2002, Andrew Wyatt - FEWT Software
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


chomp($os=`uname`);
if ($os =~/Linux/) {
  $BSD_STYLE=1;
} elsif ($os =~/HP-UX/) {
  $BSD_STYLE=0;
} else {
  $BSD_STYLE=1;			### If all else fails, assume it's a BSD, if you find that
				### your keyboard entry, or event's don't work toggle this to zero.
}

$|=1;					### Disable output caching
require ("/home/bbs/framework.pl");	### BBS function defs
require ("/home/bbs/usertools.pl");	### User account interface
require ("/home/bbs/sysinfo.pl");	### System information defs
require ("/home/bbs/main.pl");		### Main BBS menuing functions


sysinfo();

main: {
  $SIG{KILL}=sub {errorout ("SIGKILL..");};
  $SIG{HUP}=sub {errorout ("SIGHUP..");};
  $SIG{TERM}=sub {errorout ("SIGTERM..");};
  $SIG{QUIT}=sub {errorout ("SIGQUIT..");};

  $debug=1;
  hi();
  logger("Connect on Node ".$info{'tty'}." via ".$info{'connect'});
  colorize();
  applytheme($config{'theme'});
  cbreak(on);					### Turn on character break
  begin: {
   if (-e "$config{'home'}$config{'text'}/welcome.txt") {
      readfile("welcome.txt");
      $readit=1;
    }
    if (-e "$config{'home'}$config{'text'}/welcome.$info{'ext'}" && $readit ne "1") {
      readfile("welcome.$info{'ext'}");
      $readit=1;
    }  
    authenticate();
  }
  iamat($info{'handle'},"Welcome Screen");
  readfile("login.txt");
  setupdoors();
  bulletins();
  whosonline();
  $current=$config{'defmenu'};
  for (;;) {
    menu($current);
  }
  bye();
}

