#include "daydream.h"
#include <stdio.h>
#include <termios.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <errno.h>
#include <pwd.h>
#include <stdlib.h>
#include <ctype.h>
#include <sys/stat.h>

struct dayfilestat {
	unsigned long long tbytes;
        int tfiles;
	unsigned long long ybytes;
	int yfiles;
	unsigned long long tgbytes;
	int tgfiles;
	unsigned long long ygbytes;
	int ygfiles;
};

static char initstring[512];
static char ringstring[512];
static char okstring[512];
static char connectstring[512];
static char answerstring[512];
char hangupstring[512];
int hupmode=0;
extern int lmode;
extern int forcebps;
static char lockfile[512];

int checklock();
int lockserial();
int initmodem(void);
int readmodem(char *, int);
int listlast();


void getfstats(struct dayfilestat *, int);

#define LOCKPATH "/var/spool/uucp/"

static struct   speedtab {
#ifdef POSIX_TERMIOS
	speed_t     cbaud;
#else
	unsigned short cbaud;       /* baud rate, e.g. B9600 */
#endif
	int  nspeed;                /* speed in numeric format */
	char *speed;                /* speed in display format */
} speedtab[] = {
	{ B50,    50,    "50"    },
	{ B75,    75,    "75"    },
	{ B110,   110,   "110"   },
	{ B134,   134,   "134"   },
	{ B150,   150,   "150"   },
	{ B200,   200,   "200"   },
	{ B300,   300,   "300"   },
	{ B600,   600,   "600"   },
#ifdef  B900
	{ B900,   900,   "900"  },
#endif
	{ B1200,  1200,  "1200"  },
	{ B1800,  1800,  "1800"  },
	{ B2400,  2400,  "2400"  },
#ifdef  B3600
	{ B3600,  3600,  "3600" },
#endif
	{ B4800,  4800,  "4800"  },
#ifdef  B7200
	{ B7200,  7200,  "7200" },
#endif
	{ B9600,  9600,  "9600"  },
#ifdef  B14400
	{ B14400, 14400, "14400" },
#endif
#ifdef  B19200
	{ B19200, 19200, "19200" },
#endif  /* B19200 */
#ifdef  B28800
	{ B28800, 28800, "28800" },
#endif
#ifdef  B38400
	{ B38400, 38400, "38400" },
#endif  /* B38400 */
#ifdef  EXTA
	{ EXTA,   19200, "EXTA"  },
#endif
#ifdef  EXTB
	{ EXTB,   38400, "EXTB"  },
#endif
#ifdef  B57600
	{ B57600, 57600, "57600" },
#endif
#ifdef  B115200
	{ B115200,115200,"115200"},
#endif
#ifdef B230400
	{ B230400,230400,"230400"},
#endif
#ifdef B460800
	{ B460800,460800,"460800"},
#endif
	{ 0,      0,     ""      }
};

#ifdef OS2
struct sioc {
	unsigned char onm;
	unsigned char offm;
};
#endif
int wquit=0;

void wqcb(int);

void wqcb(int sig)
{
	wquit=1;
}

int waitforcall(int mode)
{
	FILE *modfd;
	char wbuf[1024];
	char hbuf[256];
	int succbits=0;
	int i;
	struct winsize ws;
	userinput=0;
	sprintf(wbuf,"configs/modem%d.cfg",fnode);
	
	modfd=fopen(wbuf,"r");
	if (!modfd) {
	  printf("Can't open %s. Exiting.\n",wbuf);
	  return 0;
	}
	
	ioctl(STDIN_FILENO,TIOCGWINSZ,&ws);
	
	maincfg.CFG_LOCALSCREEN=ws.ws_row;

	signal(SIGTERM,wqcb);
	signal(SIGINT,wqcb);
	
	if (!mode) {
		struct termios tty;
		
		if (!checklock()) return 0;
		serhandle=open(currnode->MULTI_TTYNAME,O_RDWR);
		if (serhandle < 0) {
			printf("Can't open serial. Exiting.\n");
			return 0;
		}

		tcgetattr(serhandle,&tty); 
	
		tty.c_iflag &= ~(IGNBRK | IGNCR | INLCR | ICRNL | IUCLC | 
				 IXANY | IXON | IXOFF | INPCK | ISTRIP);
		tty.c_iflag |= (BRKINT | IGNPAR);
		tty.c_oflag &= ~OPOST;
		tty.c_lflag &= ~(XCASE|ECHONL|NOFLSH);
		tty.c_lflag &= ~(ICANON | ISIG | ECHO);
		tty.c_cflag |= CREAD|CRTSCTS;
		tty.c_cflag &= ~(HUPCL);
		tty.c_cc[VTIME] = 5;
       		tty.c_cc[VMIN] = 1;

		for ( i=0; speedtab[i].cbaud != 0; i++ )
		{
			if ( speedtab[i].nspeed == currnode->MULTI_TTYSPEED) {
				cfsetispeed(&tty,speedtab[i].cbaud);
				cfsetospeed(&tty,speedtab[i].cbaud);
			}
		}
		
		tcsetattr(serhandle,TCSANOW,&tty);
#ifdef OS2
			{
				struct sioc si;
				int foo,foo2,foo3;
				si.onm=0x03;
				si.offm=0;
					
				DosDevIOCtl(serhandle,1,0x46,&si,sizeof(struct sioc),&foo,&foo3,sizeof(int),&foo3);
			}
		
#endif
		if (!forcebps) lockserial();
      	}
	while(fgetsnolf(wbuf,1024,modfd)) {
		if (!strncasecmp(wbuf,"INIT ",5)) {
			strcpy(initstring,&wbuf[5]);
			succbits |= (1L<<0);
		} else if (!strncasecmp(wbuf,"OK ",3)) {
			strcpy(okstring,&wbuf[3]);
			succbits |= (1L<<1);
		} else if (!strncasecmp(wbuf,"RING ",5)) {
			strcpy(ringstring,&wbuf[5]);
			succbits |= (1L<<2);
		} else if (!strncasecmp(wbuf,"CONNECT ",8)) {
			strcpy(connectstring,&wbuf[8]);
			succbits |= (1L<<3);
		} else if (!strncasecmp(wbuf,"ANSWER ",7)) {
			strcpy(answerstring,&wbuf[7]);
			succbits |= (1L<<4);
		} else if (!strncasecmp(wbuf,"HANGUP ",7)) {
			strcpy(hangupstring,&wbuf[7]);
			hupmode=1;
		}
	}
	fclose(modfd);
	if (forcebps) {
		bpsrate=forcebps;
		userinput=1;
		return 1;
	}
	ans:
	
	sprintf(wbuf,"DayDream BBS %s written by Antti Hyrynen",versionstring); 
	sprintf(hbuf,"\e[2J\e[H\e[0;44;36m%-78s\e[0m\n\n",wbuf);
	ansi=1;
	DDPut(hbuf);
	DDPut("              \e[0;44;36m L \e[0m - \e[35mLocal logon        \e[44;36m U \e[0m - \e[35mUser Editor \n");
	DDPut("              \e[0;44;36m S \e[0m - \e[35mSysOp logon        \e[44;36m I \e[0m - \e[35mRe-initialize modem\n");
	DDPut("              \e[0;44;36m A \e[0m - \e[35mImmediate answer   \e[44;36m Q \e[0m - \e[35mQuit\n\n");

	DDPut("                  \e[0;44;36m Control-B + H \e[0m - \e[35mhelp while user online\n\n");

	sprintf(hbuf,"\e[0;44;36m%-78s\e[0m\n","  Bps Name                Organization            Logon    On Upkb:Dnkb Flags ");
	DDPut(hbuf);
	listlast();
	
	changenodestatus("Waiting for a call...");

	if (succbits & (1L<<0)) {
		if (initmodem()) return 0;
	}
	
	while( (i=readmodem(wbuf,0)) ) 
	{
		char *s;
	    
		if (i==-1) {
			unlink(lockfile);
			DDPut("Exiting..\n\e[0m");
			return 0;
		} else if (i==-2) {
			lmode=1;
			usered();
			lmode=0;
			goto ans;
       		} else if (i==-3) {
			lmode=1;
			visitbbs(0);
			lmode=0;
			goto ans;
		} else if (i==-4) {
			lmode++;
			visitbbs(1);
			lmode=0;
			goto ans;
		} else if (i==-6) {
			goto ans;
		}
		if (i==-5 || strstr(wbuf,ringstring)) {
			DDPut("[36mRinging.. ");
			writetomodem(answerstring);
			DDPut("[35mAnswering.. ");
			readmodem(wbuf,2);
			s=strstr(wbuf,connectstring);
			if (s) {
				s+=strlen(connectstring);
				while(*s==' ') s++;
				bpsrate=atoi(s);
				if (bpsrate==0) bpsrate=300;
				DDPut("[0mCONNECT ");
				DDPut(s);
				sleep(2);
				break;  
			}
			DDPut("[31mNO CARRIER!");
			sleep(1);
			DDPut("\r                                              \r");
		}
	}
	userinput=1;
	return 1;
}

int listlast()
{
	int listnum;
	char buf1[512];
	char fbuf[512];
	int userbfd;
	int logfd;
	struct callerslog clg;
	struct stat st;
	struct dayfilestat dls;
	struct dayfilestat uls;

	listnum=maincfg.CFG_LOCALSCREEN-13;

	sprintf(buf1,"%s/logfiles/callerslog%d.dat",origdir,node);
	logfd=open(buf1,O_RDONLY);
	if (logfd==-1) {
		return 0;
	}
	fstat(logfd,&st);
	if (st.st_size/sizeof(struct callerslog) < listnum)
	  listnum=st.st_size/sizeof(struct callerslog);
	lseek(logfd,-(sizeof(struct callerslog)),SEEK_END);

	while(listnum--) {
		char bpsr[128];
		char upb[10];
		char dnb[10];
		struct userbase usr;
		struct tm *tm;
		struct tm tem1;
		time_t tk;
		
		read(logfd,&clg,sizeof(struct callerslog));
		lseek(logfd,-(2*sizeof(struct callerslog)),SEEK_CUR);

		sprintf(fbuf,"%s/data/userbase.dat",origdir);
		userbfd=open(fbuf,O_RDONLY);
		if (userbfd==-1) {
			return 0;
		}
		lseek(userbfd,clg.cl_userid*sizeof(struct userbase),SEEK_SET);
		read(userbfd,&usr,sizeof(struct userbase));
		close(userbfd);
		tm=localtime(&clg.cl_logon);
		memcpy(&tem1,tm,sizeof(struct tm));
		tk=clg.cl_logoff-clg.cl_logon;
		tm=gmtime(&tk);
		
		if ((clg.cl_ulbytes/1024) > 9999) {
			sprintf(upb,"%3.3dM",clg.cl_ulbytes/(1024*1024));
		} else if (clg.cl_ulbytes) {
			sprintf(upb,"%4.4d",clg.cl_ulbytes/1024);
		} else {
			strcpy(upb,"----");
		}
		
		if ((clg.cl_dlbytes/1024) > 9999) {
			sprintf(dnb,"%3.3dM",clg.cl_dlbytes/(1024*1024));
		} else if (clg.cl_dlbytes) {
			sprintf(dnb,"%4.4d",clg.cl_dlbytes/1024);
		} else {
			strcpy(dnb,"----");
		}
		
		sprintf(&bpsr[100],"%-5d",clg.cl_bpsrate);
		if (strlen(&bpsr[100]) > 5) {
			bpsr[0]=bpsr[100];
			bpsr[1]=bpsr[101];
			bpsr[2]=bpsr[102];
			bpsr[3]='k';
			bpsr[4]=bpsr[103];
			bpsr[5]=0;
		} else strcpy(bpsr,&bpsr[100]);
		
		sprintf(buf1,"%s %-19.19s %-23.23s %2.2d:%2.2d %2.2d:%2.2d %s:%s %c%c%c%c%c%c\n",
			bpsr,
			(maincfg.CFG_FLAGS & (1L<<1)) ? usr.user_handle : usr.user_realname,
			(maincfg.CFG_FLAGS & (1L<<2)) ? usr.user_organization : usr.user_zipcity,
			tem1.tm_hour,tem1.tm_min,tm->tm_hour,tm->tm_min,
			upb, dnb,
			clg.cl_ulbytes ? 'U' : '-' ,
			clg.cl_dlbytes ? 'D' : '-' ,
			(clg.cl_flags & CL_CARRIERLOST) ? 'C' : '-',
			(clg.cl_flags & CL_NEWUSER) ? 'N' : '-',
			(clg.cl_flags & CL_PAGEDSYSOP) ? 'P' : '-',
			(clg.cl_flags & CL_PASSWDFAIL) ? 'H' : '-');
		DDPut(buf1);
	}
	close(logfd);
	getfstats(&uls,1);
	getfstats(&dls,2);
	sprintf(buf1,"\e[44;36mT: ULs [ %4.4d/%4.4d ] ULMB [ %4.4Lu/%4.4Lu ]   DLs [ %4.4d/%4.4d ] DLMB [ %4.4Lu/%4.4Lu ]\n",
		uls.tfiles,uls.tgfiles,uls.tbytes/(1024*1024),
		uls.tgbytes/(1024*1024),dls.tfiles,dls.tgfiles,
		dls.tbytes/(1024*1024),dls.tgbytes/(1024*1024));
	DDPut(buf1);
	sprintf(buf1,"Y: ULs [ %4.4d/%4.4d ] ULMB [ %4.4Lu/%4.4Lu ]   DLs [ %4.4d/%4.4d ] DLMB [ %4.4Lu/%4.4Lu ]\n\e[0m",
		uls.yfiles,uls.ygfiles,uls.ybytes/(1024*1024),
		uls.ygbytes/(1024*1024),dls.yfiles,dls.ygfiles,
		dls.ybytes/(1024*1024),dls.ygbytes/(1024*1024));
	DDPut(buf1);
	
	return 1;
}
int initmodem(void)
{
	int i;
	char buf[1024];
	
	for (i=1;i<6;i++) {
		sprintf(buf,"\r\e[0mInitializing modem - try %d - ",i);
		DDPut(buf);
		tcflush(serhandle,TCIFLUSH);
		writetomodem(initstring);
		if (readmodem(buf,1) && strstr(buf,okstring)) {
			DDPut("\e[36mOK!\n");
			return 0;
		}
		sleep(1);	
       	}
	DDPut("[31mERROR!\n[0m");
	return 0;
	
}

int readmodem(char *s, int mode)
{
	fd_set readset;
	struct timeval tv;
	int havestuff=0;
	int tcount=0;
	char *t=s;
	char *u;
	char k;
	*s=0;
	
	while(1) {
		FD_ZERO(&readset);
		FD_SET(serhandle,&readset);
		if (!mode) FD_SET(STDIN_FILENO,&readset);
		tv.tv_sec=1;
		tv.tv_usec=0;
		select(serhandle+1,&readset,0,0,&tv);
		if (wquit) return -1;
		
		if (FD_ISSET(serhandle,&readset)) {
			if (havestuff < 1000) read(serhandle,s,1);
			s++;
			*s=0;
			havestuff++;
		} else {
			if (mode==2) {
				if (tcount > 30) return 0;
				u=strstr(t,connectstring);
				if (u) {
					while (*u++) if (*u=='\r') {
						return havestuff;
					}
				}
			} else if (!mode && FD_ISSET(STDIN_FILENO,&readset)) {
				read(STDIN_FILENO,&k,1);
				switch(toupper(k)) {
				 case 'Q':
					return -1;
					break;
				 case 'U':
					return -2;
					break;
				 case 'L':
					return -3;
					break;
				 case 'S':
					return -4;
					break;
				 case 'A':
					return -5;
					break;
				 case 'I':
					return -6;
					break;
				}
			} else if (havestuff || mode==1) {
				return havestuff;
			} else if (mode==0 && tcount > 600) {
				DDPut("\e[A                                                               ");
				initmodem();
				tcount=0;
			}
			tcount++;
		}
	}
}

int writetomodem(char *s)
{
	for(;*s;s++)
	{
		if (*s=='\\') {
			s++;
			switch(*s) {
			 case 'r':
				write(serhandle,"\r",1);
				break;
			 case 'n':
				write(serhandle,"\n",1);
				break;
			 default:
				write(serhandle,s,1);
				break;
			}
			
		} else if (*s=='~') {
			usleep(50000);
		} else {
			write(serhandle,s,1);
		}
	}
	return 1;
}

int lockserial()
{
	int mask, fd;
	struct passwd *pwd;
	char buf[512];
	
	mask = umask(022);
	
	if ((pwd = getpwuid(getuid())) == (struct passwd *)0) {
		fprintf(stderr, "You don't exist. Go away.\n");
		return 0;
	}
	
	if ((fd = open(lockfile, O_WRONLY | O_CREAT | O_EXCL, 0666)) < 0) {
		return 0;
	}
	
	(void) umask(mask);
	sprintf(buf, "%10ld daydream %.20s\n", (long)getpid(), pwd->pw_name);
	write(fd, buf, strlen(buf));
	close(fd);
	return 1;
}

int checklock()
{
	char buf[128];
	int fd;
	pid_t pid;
	int n;
	
	sprintf(lockfile,"%sLCK..%s",LOCKPATH,filepart(currnode->MULTI_TTYNAME));
	fd=open(lockfile,O_RDONLY);
	if (fd>-1) {
		n = read(fd, buf, 127);
		close(fd);
		if (n > 0) {
			pid = -1;
			if (n == 4)
			  /* Kermit-style lockfile. */
			  pid = *(int *)buf;
			else {
				/* Ascii lockfile. */
				buf[n] = 0;
				sscanf(buf, "%d", &pid);
			}
			if (pid > 0 && kill((pid_t)pid, 0) < 0 &&
			    errno == ESRCH) {
				sleep(1);
				unlink(lockfile);
			} else
			  n = 0;
		}
		if (n == 0) {
			fprintf(stderr, "Device %s is locked.\r\n", currnode->MULTI_TTYNAME);
			return 0;
		}
	}
	return 1;
}

void getfstats(struct dayfilestat *dfs, int mode)
{
	char buf[1024];
	int fd;
	int lentries;
	struct stat st;
	struct DD_UploadLog lok;

	int day=time(0)/(60*60*24);
	
	memset(dfs,0,sizeof(struct dayfilestat));

	if (mode==1) {
		sprintf(buf,"%s/logfiles/uploadlog.dat",origdir);
	} else {
		sprintf(buf,"%s/logfiles/downloadlog.dat",origdir);
	}
	fd=open(buf,O_RDONLY);
	if (fd<0) return;
	fstat(fd,&st);
	lentries=st.st_size/sizeof(struct DD_UploadLog);
	lseek(fd,-sizeof(struct DD_UploadLog),SEEK_END);
	while(lentries--) {
		read(fd,&lok,sizeof(struct DD_UploadLog));
		lseek(fd,-2*sizeof(struct DD_UploadLog),SEEK_CUR);
		if ( (lok.UL_TIME/(60*60*24)) < (day-1)) break;
		if ((lok.UL_TIME/(60*60*24)) == day) {
			dfs->tgbytes+=lok.UL_FILESIZE;
			dfs->tgfiles++;
			if (lok.UL_NODE==node) {
				dfs->tbytes+=lok.UL_FILESIZE;
				dfs->tfiles++;
			}
		} else {
			dfs->ygbytes+=lok.UL_FILESIZE;
			dfs->ygfiles++;
			if (lok.UL_NODE==node) {
				dfs->ybytes+=lok.UL_FILESIZE;
				dfs->yfiles++;
			}
		}
	}
	close(fd);
}





