/*
	DayDream stdio-handler
	
 */

 
#include <daydream.h>
#include <fcntl.h>
#ifndef _WINDOWS
#include <termios.h>
#include <unistd.h>
#endif
#include <signal.h>
#include <stdio.h>
#ifndef _WINDOWS
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/ioctl.h>
#endif
#include <sys/types.h>

static int childon;
static int readpty;

void childhan(int);
void readhan(int);
int getpty(char *);
static pid_t kid;

int runstdio(char *command, char *outfile, int inp)
{
	int ptyfd=0;
	int pipefd[2];
	
	char dcmd[400];
	char *s;
	char *args[100];
	int i=1;		
	char ptyname[20];
	int highfd;
	int outfd=-1;
	time_t huptime=0;
	
	strcpy(dcmd,command);
	
	s=dcmd;
	args[0]=s;

	while (*s)
	{
		if (*s==' ') {
			*s=0;
			s++;
			args[i]=s;
			i++;
		} else s++;
	}
	args[i]=0;

	if (inp !=2) if ((ptyfd=getpty(ptyname)) < 0) {
		DDPut("*AAAARGH* fatal error: Tell Sysop to make more accessable pty's!\n");
		return 0;
	}
	childon=1;
	readpty=0;
	
	if (inp==2) {
		pipe(pipefd);
	} else {
#ifdef UNIX
	   struct winsize ws;

		ws.ws_col = 80;
		if (inp==4) {
			ws.ws_row = maincfg.CFG_LOCALSCREEN;
		} else {
			ws.ws_row = user.user_screenlength;
		}
		ws.ws_xpixel=ws.ws_ypixel=0;
		ioctl(ptyfd,TIOCSWINSZ,&ws);
#endif
	}
	if (outfile && inp != 3) {
		outfd=open(outfile,O_WRONLY|O_CREAT,0644);
	}
		

	signal(SIGUSR2,readhan);
	kid=fork();

	switch(kid)
	{
	 case 0:
		if (inp != 2) close(ptyfd); 
#ifdef UNIX
//		if (setsid() < 0) exit();
#endif
		if (inp==2) {
			kill(getppid(),SIGUSR2);
//			dup2(serhandle, 0);
//			dup2(serhandle, 1);
			fcntl(serhandle,F_SETFD,0);
			dup2(pipefd[1], 2);
			setbuf(stderr,0);
			close(pipefd[0]);
		} else if (inp==3 && outfile) {
			outfd=open(outfile,O_WRONLY|O_CREAT,0644);
			if ((ptyfd=open(ptyname,O_RDWR|O_NONBLOCK)) < 0) exit();
			kill(getppid(),SIGUSR2);
			dup2(ptyfd,STDIN_FILENO);
			dup2(outfd,STDOUT_FILENO);
			dup2(outfd,STDERR_FILENO);
		} else {
			if ((ptyfd=open(ptyname,O_RDWR|O_NONBLOCK)) < 0) exit();
			kill(getppid(),SIGUSR2);
			dup2(ptyfd,STDIN_FILENO);
			dup2(ptyfd,STDOUT_FILENO);
			dup2(ptyfd,STDERR_FILENO);
		}
		execvp(args[0],&args[0]);
		kill(getpid(),SIGKILL);
		exit(0);
		break;
	 default:
		
		if (inp==2) close(pipefd[1]);
		
		signal(SIGCHLD,childhan);
		
#ifdef UNIX
		while(!readpty) usleep(4000);
#endif
		while (1) 
		{
			unsigned char pala=0;
			fd_set setti;
			struct timeval tv;
			
			char stbuf[1024];
			
			highfd=0;
			FD_ZERO(&setti);
			if (inp) { 
				if (inp!=4 && inp!=2) {
					FD_SET(serhandle, &setti);
					highfd=serhandle;
				}
				FD_SET(conin, &setti);
				if (conin > highfd) highfd=conin;
			}
			if (inp==2) {
				FD_SET(pipefd[0], &setti);
				if (pipefd[0] > highfd) highfd=pipefd[0];
			} else {
				FD_SET(ptyfd,&setti);
				if (ptyfd > highfd) highfd=ptyfd;
			}
			
			tv.tv_sec=0;
			tv.tv_usec=50000;
			select(highfd+1,&setti,0,0,&tv);
			
			if (inp==2) {
				if (!checkcarrier()) kill(kid,SIGKILL);
			} else if (inp==4) {
				if (!checkcarrier()) {
					if (!huptime) {
						kill(kid,SIGHUP);
						huptime=time(0);
					} else {
						if (huptime < (time(0)-20) ) {
							kill(kid,SIGKILL);
							break;
						}
					}
				}
			} else if (inp == 1 && !checkcarrier()) break;

			if (!childon) break;
			
			if (inp !=2 && inp !=4 && FD_ISSET(serhandle, &setti)) {
				read(serhandle,&pala,1);
				if (inp!=3) write(ptyfd,&pala,1);
				keysrc=1;
			}
			if (inp == 2 && FD_ISSET(pipefd[0], &setti)) {
				read(pipefd[0],&pala,1);
				if (conon) {
					if (pala==10) {
						write(conout,"\r",1);
					}
					write(conout,&pala,1);
				}
			}
			if (FD_ISSET(conin, &setti)) {
				read(conin,&pala,1);
				if (inp!=2 && inp!=3) write(ptyfd,&pala,1);
				keysrc=2;
				if (pala==2) {
					handlectrl(0);
				}
			}
			if (inp != 2 && FD_ISSET(ptyfd,&setti)) {
				stbuf[read(ptyfd,&stbuf,1023)]=0;
				if (*stbuf) {
					if (inp!=2) {
						if (inp==4) {
							int t;
							int ans;
							ans=ansi;
							ansi=1;
							t=userinput;
							userinput=0;
							DDPut(stbuf);
							userinput=t;
							ansi=ans;
						} else if (inp!=3) DDPut(stbuf);
					} else {
						if (*stbuf==10) {
							write(ptyfd,"\r",1);
						}
						write(ptyfd,&stbuf,strlen(stbuf));
					}
					if (outfd!=-1 && inp!=3) {
						write(outfd,&stbuf,strlen(stbuf));
					}
				}
			}
			if (!childon) break;
		}
		
		
		
		waitpid(-1,0,WNOHANG);
		break;
	}
	if (outfd!=-1) close(outfd);
	if (inp !=2) {
		close(ptyfd);
	} else {
		close(pipefd[0]);
	}
	return 0;
	
}

void childhan(int kelas)
{
	while ((waitpid(-1, NULL, WNOHANG)) > 0);
	if (!ispid(kid)) childon=0;
}

void readhan(int kelas)
{
	readpty=1;
}

int
getpty(name)
  char *name;
{
    register int pty, tty;
    char *pty_dev = "/dev/ptc", *tt;
    extern char *ttyname();

    /* first look for a SYSV-type pseudo device */

    if((pty = open(pty_dev, O_RDWR|O_NONBLOCK)) >= 0)
    {
	if((tt = ttyname(pty)) != NULL)
	{
	    strcpy(name, tt);
	    return pty;
	}
	close(pty);
    }

    /* scan Berkeley-style */

    strcpy(name, "/dev/ptyp0");
    while(access(name, 0) == 0)
    {
	if((pty = open(name, O_RDWR|O_NONBLOCK)) >= 0)
	{
	    name[5] = 't';
	    if((tty = open(name, O_RDWR|O_NONBLOCK)) >= 0)
	    {
		close(tty);
		return pty;
	    }
	    name[5] = 'p';
	    close(pty);
	}

	/* get next pty name */

	if(name[9] == 'f')
	{
	    name[8]++;
	    name[9] = '0';
	}
	else if(name[9] == '9')
	    name[9] = 'a';
	else
	    name[9]++;
    }
    return -1;
}

