#include <sys/types.h>
#ifdef UNIX
#include <sys/socket.h>
#include <unistd.h>
#endif
#include <daydream.h>
#include <time.h>
#include <fcntl.h>
#ifdef UNIX
#include <sys/time.h>
#include <sys/un.h>
#include <sys/wait.h>
#endif
#include <string.h>
#include <stdlib.h>
#ifdef OS2
#include <os2emx.h>
#endif
#ifdef _WINDOWS
#include <winsock.h>
#endif
/* run an external program.. Initialize socket and communicate with external
   program via that socket. */

void initdoorcmd(char *, char *);

char extstatus[50];

static int doorcnt=0;

extern int dsockfd;
extern int flagerror;

int rundoor (char *command, char *params)
{
	int sockfd, newsock;
	char sockname[80];
	char *args[10];
	char dcmd[250];         
#ifdef UNIX
	struct sockaddr_un doorsock;
#elif defined(OS2)
	PHPIPE doorsock;
#endif
	int i=1;
	int go=1;
	char *s;
	struct DayDream_DoorMsg msg;
	int fval;
	char doom[10];
	
#ifdef OS2
	return 0;
#endif
	changenodestatus("Running a door...");

	if (command) strspa(command,dcmd);
	if ((sockfd=open(dcmd,O_RDONLY)) < 0) {
		DDPut("Specified door does not exist\n\n");
		return 0;
	}
	close(sockfd);

#ifdef UNIX
       
	
	if ((sockfd=socket(AF_UNIX,SOCK_STREAM,0)) < 0) {
		DDPut("Can't create socket...\n\n");
		return 0;
	}
	if (!doorcnt) {
		sprintf(sockname,"%sdd_door%d",DDTMP,node);
		sprintf(doom,"%d",node);
	} else {
		sprintf(sockname,"%sdd_door%d_%d",DDTMP,node,doorcnt);
		sprintf(doom,"%d_%d",node,doorcnt);
	}
	unlink(sockname);
	strcpy(doorsock.sun_path,sockname);
	doorsock.sun_family=AF_UNIX;
	if (bind(sockfd,(struct sockaddr *)&doorsock,sizeof(doorsock)) < 0) {
		DDPut("Can't bind socket...\n\n");
		close(sockfd);
		return 0;
	}
	listen(sockfd,2);
	
#else
	sprintf(sockname,"%sdd_door%d",DDTMP,node);
	unlink(sockname);
	DosCreateNPipe(sockname,&doorsock,(1L<<1),255|(1L<<8)|(1L<<10),sizeof(struct DayDream_DoorMsg),sizeof(struct DayDream_DoorMsg),0);
#endif
	genstdiocmdline(dcmd,command,0,doom);
	
	s=dcmd;
/*      while (*s!=' ') s++;
	*s=0;
	s++; */

	args[0]=s;

	while (*s)
	{
		if (*s==' ') {
			*s=0;
			s++;
			args[i]=s;
			i++;
		} else s++;
	}
	args[i]=0;

	fval=fork();
	
	if (fval==0) {
		execvp(args[0],&args[0]);       
		DDPut("exec failed!\n\n");
		kill(getpid(),SIGKILL);
	} else if (fval==-1) {
		DDPut("Fork failed!");
	} else {
	
#ifdef UNIX
		newsock=accept(sockfd,0,0);
		sockfd=newsock;
#endif
		doorcnt++;
		
		while (go)
		{
			fd_set setti;
			int re;
			int maxfd;
			struct timeval tv;

			while ((waitpid(-1, NULL, WNOHANG)) > 0);
			
			FD_ZERO(&setti);
			FD_SET(sockfd,&setti);
			maxfd=sockfd;
			if (!bgmode) {
				FD_SET(dsockfd,&setti);
				if (dsockfd > sockfd) maxfd=dsockfd;
			}
			
			tv.tv_usec=0;
			tv.tv_sec=2;
			
			select(maxfd+1,&setti,0,0,&tv);
			
			if (!bgmode && FD_ISSET(dsockfd,&setti)) {
				struct dd_nodemessage ddn;
				read(dsockfd,&ddn,sizeof(struct dd_nodemessage));
				processmsg(&ddn);
			} else if (FD_ISSET(sockfd,&setti)) {
				re=read(sockfd,&msg,sizeof(struct DayDream_DoorMsg));
				if (!re) break;
				switch(msg.ddm_command)
				{
				case 1:
					go = 0;
					break;
				case 2:
					DDPut(msg.ddm_string);
					break;
				case 3:
					msg.ddm_data1=Prompt(msg.ddm_string,msg.ddm_data1,msg.ddm_data2);
					break;
				case 4:
					(int)msg.ddm_data1=HotKey(msg.ddm_data1);
					break;
				case 5:
					msg.ddm_data1=TypeFile(msg.ddm_string,msg.ddm_data1);
					break;
				 case 6:
					msg.ddm_data1=flagsingle(msg.ddm_string,msg.ddm_data1);
					break;
				 case 7:
					msg.ddm_data1=findusername(msg.ddm_string,1);
					break;
				 case 8:
					runstdio(msg.ddm_string,0,msg.ddm_data1);
					break;
				 case 9:
					docmd(msg.ddm_string,0);
					break;
				 case 10:
					writelog(msg.ddm_string);
					break;
				 case 11:
					strcpy(extstatus,msg.ddm_string);
					changenodestatus(extstatus);
					break;
				 case 12:
						dpause();
					break;
				 case 13:
					msg.ddm_data1=joinconf(msg.ddm_data1,msg.ddm_data2);
					break;
				 case 14:
						msg.ddm_data1=isfreedl(msg.ddm_string);
					break;
				 case 15:
					msg.ddm_data1=flagfile(msg.ddm_string,msg.ddm_data1);
					break;
				 case 16:
					msg.ddm_data1=lrp;
					msg.ddm_data2=lsp;
					break;
				 case 17:
					lrp=msg.ddm_data1;
					lsp=msg.ddm_data2;
					break;
				 case 18:
					msg.ddm_data1=checkconfaccess(msg.ddm_data1,&user);
					break;
				 case 19:
					msg.ddm_data1=isanybasestagged(msg.ddm_data1);
					break;
				 case 20:
					msg.ddm_data1=isconftagged(msg.ddm_data1);
					break;
				 case 21:
					msg.ddm_data1=isbasetagged(msg.ddm_data1,msg.ddm_data2);
					break;
				 case 22:
					getmsgptrs();
					msg.ddm_data1=highest;
					msg.ddm_data2=lowest;
					break;
				 case 23:
					highest=msg.ddm_data1;
					lowest=msg.ddm_data2;
					setmsgptrs();
					break;
				 case 24:
						msg.ddm_data1=changemsgbase(msg.ddm_data1,msg.ddm_data2);
					break;
				 case 25:
					sendfiles(msg.ddm_string,0);
					break;
					case 26:
					recfiles(msg.ddm_string,0);
					break;
				 case 27:
					fileattach();
					break;
				 case 28:
					msg.ddm_data1=unflagfile(msg.ddm_string);
					break;
				 case 29:
					msg.ddm_data1=findfilestolist(msg.ddm_string,&msg.ddm_string[50]);
					break;
				 case 30:
					msg.ddm_data1=isfiletagged(msg.ddm_string);
					break;
				case 31:
					msg.ddm_data1=dumpfilestofile(msg.ddm_string);
					break;
				case 100:
					strcpy(msg.ddm_string,maincfg.CFG_BOARDNAME);
					break;
					
				 case 101:
					strcpy(msg.ddm_string,maincfg.CFG_SYSOPNAME);
					break;
					
				 case 102:
					if (msg.ddm_data1) {
						strcpy(user.user_realname,msg.ddm_string);
					} else {
						strcpy(msg.ddm_string,user.user_realname);
					}
					break;
					
				 case 103:
					if (msg.ddm_data1) {
						strcpy(user.user_handle,msg.ddm_string);
					} else {
						strcpy(msg.ddm_string,user.user_handle);
					}
					break;
					
				 case 104:
					if (msg.ddm_data1) {
						strcpy(user.user_organization,msg.ddm_string);
					} else {
						strcpy(msg.ddm_string,user.user_organization);
					}
					break;
				 case 105:
					if (msg.ddm_data1) {
						strcpy(user.user_zipcity,msg.ddm_string);
					} else {
						strcpy(msg.ddm_string,user.user_zipcity);
					}
					break;
				 case 106:
						if (msg.ddm_data1) {
							strcpy(user.user_voicephone,msg.ddm_string);
						} else {
							strcpy(msg.ddm_string,user.user_voicephone);
						}
					break;
					case 107:
					if (msg.ddm_data1) {
						strcpy(user.user_computermodel,msg.ddm_string);
						} else {
							strcpy(msg.ddm_string,user.user_computermodel);
						}
					break;
				 case 108:
					if (msg.ddm_data1) {
						strcpy(user.user_signature,msg.ddm_string);
					} else {
						strcpy(msg.ddm_string,user.user_signature);
					}
					break;
				 case 109:
					if (msg.ddm_data1) {
						user.user_screenlength=msg.ddm_data2;
					} else {
						msg.ddm_data1=user.user_screenlength;
					}
					break;
					
				 case 110:
					if (msg.ddm_data1) {
						user.user_toggles=msg.ddm_data2;
					} else {
						msg.ddm_data1=user.user_toggles;
					}
					break;
					
				 case 111:
					/*                                              
					 if (msg.ddm_data1) {
						 user.user_ulbytes=msg.ddm_data2;
					 } else {
						 msg.ddm_data1=user.user_ulbytes;
					 } Disabled */
					
					break;
				 case 112:
					/*                                              if (msg.ddm_data1) {
						user.user_dlbytes=msg.ddm_data2;
					} else {
						msg.ddm_data1=user.user_dlbytes;
					} Disabled */
					break;
				 case 113:
					if (msg.ddm_data1) {
						user.user_ulfiles=msg.ddm_data2;
					} else {
						msg.ddm_data1=user.user_ulfiles;
					}
					break;
				 case 114:
					if (msg.ddm_data1) {
						user.user_dlfiles=msg.ddm_data2;
					} else {
						msg.ddm_data1=user.user_dlfiles;
					}
					break;
				 case 115:
					if (msg.ddm_data1) {
						user.user_pubmessages=msg.ddm_data2;
					} else {
						msg.ddm_data1=user.user_pubmessages;
					}
					break;
				 case 116:
					if (msg.ddm_data1) {
						user.user_pvtmessages=msg.ddm_data2;
					} else {
						msg.ddm_data1=user.user_pvtmessages;
					}
					break;
				 case 117:
					if (msg.ddm_data1) {
						user.user_connections=msg.ddm_data2;
					} else {
						msg.ddm_data1=user.user_connections;
					}
					break;
				 case 118:
					if (msg.ddm_data1) {
						user.user_fileratio=msg.ddm_data2;
					} else {
						msg.ddm_data1=user.user_fileratio;
					}
					break;
				 case 119:
					if (msg.ddm_data1) {
						user.user_byteratio=msg.ddm_data2;
					} else {
						msg.ddm_data1=user.user_byteratio;
					}
					break;
				 case 120:
					if (msg.ddm_data1) {
						user.user_freedlbytes=msg.ddm_data2;
					} else {
						msg.ddm_data1=user.user_freedlbytes;
					}
					break;
				 case 121:
					if (msg.ddm_data1) {
						user.user_freedlfiles=msg.ddm_data2;
					} else {
						msg.ddm_data1=user.user_freedlfiles;
					}
					break;
				 case 122:
					if (msg.ddm_data1) {
						user.user_securitylevel=msg.ddm_data2;
					} else {
						msg.ddm_data1=user.user_securitylevel;
					}
					break;
				 case 123:
					if (msg.ddm_data1) {
						user.user_joinconference=msg.ddm_data2;
					} else {
						msg.ddm_data1=user.user_joinconference;
					}
					break;
				 case 124:
					if (msg.ddm_data1) {
						user.user_conferenceacc1=msg.ddm_data2;
					} else {
						msg.ddm_data1=user.user_conferenceacc1;
					}
					break;
				 case 125:
					if (msg.ddm_data1) {
						user.user_conferenceacc2=msg.ddm_data2;
					} else {
						msg.ddm_data1=user.user_conferenceacc2;
					}
					break;
				 case 126:
					if (msg.ddm_data1) {
						user.user_dailytimelimit=msg.ddm_data2;
					} else {
						msg.ddm_data1=user.user_dailytimelimit;
					}
					break;
				 case 127:
					msg.ddm_data1=user.user_account_id;
					break;
				 case 128:
					if (msg.ddm_data1) {
						time_t curr;
						timeleft=msg.ddm_data2;
						curr=time(0);
						endtime=curr+timeleft;
						user.user_timeremaining=timeleft/60;
					} else {
						msg.ddm_data1=timeleft;
					}
					break;
				 case 129:
					if (params) {
						strncpy(msg.ddm_string,params,300);
					} else {
						msg.ddm_string[0]=0;
					}
					break;
				 case 130:
					strcpy(msg.ddm_string,origdir);
					break;
				 case 131:
					msg.ddm_data1=conf->CONF_NUMBER;
					break;
				 case 132:
					if (msg.ddm_data1) {
						user.user_ulbytes=msg.ddm_ldata;
					} else {
						msg.ddm_ldata=user.user_ulbytes;
					}
					
					break;
				 case 133:
					if (msg.ddm_data1) {
						user.user_dlbytes=msg.ddm_ldata;
					} else {
						msg.ddm_ldata=user.user_dlbytes;
					} 
					break;
				 case 134:
					if (msg.ddm_data1) {
						user.user_firstcall=msg.ddm_data2;
 					} else {
						msg.ddm_data1=user.user_firstcall;
					}
					break;
				 case 135:
					if (msg.ddm_data1) {
						user.user_flines=msg.ddm_data2;
					} else {
						msg.ddm_data1=user.user_flines;
					}
					break;
				 case 136:
					if (msg.ddm_data1) {
						user.user_lastcall=msg.ddm_data2;
					} else {
						msg.ddm_data1=last;
					}
					break;
				 case 137:
					if (msg.ddm_data1) {
						user.user_protocol=msg.ddm_data2;
					} else {
						msg.ddm_data1=user.user_protocol;
					}
					break;
				 case 138:
					if (msg.ddm_data1) {
						user.user_fakedfiles=msg.ddm_data2;
					} else {
						msg.ddm_data1=user.user_fakedfiles;
					}
					break;
				 case 139:
					if (msg.ddm_data1) {
						user.user_fakedbytes=msg.ddm_data2;
					} else {
						msg.ddm_data1=user.user_fakedbytes;
					}
					break;
				case 140:
					recountfiles();
					msg.ddm_data1=filestagged;
					break;
				case 141:
					recountfiles();
					msg.ddm_data1=bytestagged;
					break;
				case 142:
					recountfiles();
					msg.ddm_data1=flagerror;
					break;

				
				}
				write(sockfd,&msg,sizeof(struct DayDream_DoorMsg));
			}
			if (!ispid(fval)) break;
		}
		wait(0);
	}
	--doorcnt; 
	close(sockfd);
	unlink(sockname);
	
	return 1;
}

void initdoorcmd(char *dacmd, char *destcmd)
{
	char buff[30];
	char *s;
	
	while (*dacmd)
	{
		if (*dacmd=='%') {
			if (dacmd[1]=='N' || dacmd[1]=='n') {
				sprintf(buff,"%d",node);
				s=buff;
				while (*s) *destcmd++=*s++;
				dacmd=dacmd+2; 
			} 
		} else {
			*destcmd++=*dacmd++;
		}
	}
	*destcmd=0;
}

