/* 
Filename: usertools.c
Description: citadel usersupp routines
   read_user          prompt for name; calls print_user_stats     
   edituser           change user levels                          
   biotools           enter biography
   getusinfo          aka enter configuration, moved from routines
   print_user_stats   does the read-user dirty work
Source: routines pulled out of Cit dist for neatness purposes
        all modified locally, pirmann@klinzhai.rutgers.edu

Change History:
01/08/93: added first login info, cleaned up variables and open/closes
10/30/93: this header added
12/4/93: commented out "setbit"
*/

#include <fcntl.h>
#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "citadel.h"

extern char *axdefs[8];
extern char *logmsg[];

void read_user (user_type *usersupp)
{
  char aaa[100];
  user_type structure;
  int file;
  long aa;

  enter_btmp ("[Read User]");

  printf("User name: ");
  getline(aaa,29);
  if (strlen (aaa) != 0)
    {
      file=open("usersupp",O_RDONLY); 
      if (file<0) 
	interr(90);
      aa=finduser(file,aaa);
      if (aa!=(-1))
	{
	  read(file,&structure,sizeof(user_type));
	  print_user_stats (usersupp, &structure);
	}
      else 
	printf ("No such user.\n");
      close (file);
    }
}

edituser (user_type usersupp)
{
  int a,b,file;
  long aa;
  int tmpax;
  char aaa[100];
  struct tm *tmstruct;
  user_type structure;

  enter_btmp ("[Edit User]");
  printf("User name: ");
  getline(aaa,29);
  file=open("usersupp",O_RDWR);
  if (file<0)
    interr(90);
  if (strlen (aaa) == 0)
    {
      close(file);
      return(0);
    }

  aa=finduser(file,aaa);
  if (aa ==(-1))
    {
      close(file);
      printf("No such user.\n");
      return(0);
    }
  
  read(file,&structure,sizeof(user_type));
  if (usersupp.axlevel == 6)
      if (structure.axlevel >= 6)
	{
	  printf ("Cannot edit an aide.\n");
	  close (file);
	  return (0);
	}

  tmpax = structure.axlevel;

  do 
    {
      tmstruct = localtime (&structure.lastcall);
      sprintf (aaa, "%s", asctime (tmstruct));
      aaa[strlen(aaa)-1]=0;
      printf ("\nUser #%d, %s\nLast login: %s %s from %-16.16s\n",
	      structure.eternal, structure.fullname,
	      aaa, tmstruct->tm_zone, structure.lasthost);

      if (structure.timescalled != 0)
	printf ("Calls: %d         Posts: %d      Ratio: %d\n",
		structure.timescalled, structure.posted,
		structure.posted/structure.timescalled);

      printf ("On today: %2.2d:%2.2d     Total: %2.2d:%2.2d      Lim/day: %2.2d:%2.2d\n",
	      structure.today/60, structure.today%60,
	      structure.online/60, structure.online%60,
	      structure.timelimit/60, structure.timelimit%60);

      dis_regis(structure);

      printf("Current access level: %d [%s]\n",structure.axlevel,
	     axdefs[structure.axlevel]);
      printf("New level (? to list them, n for no change): ");
      a=inkey();
      if (a=='n')
	{
	  printf ("No change\n");
	  close (file);
	  return (0);
	}

      if (a=='?') 
	{
	  printf("list\n");
	  for (b=0; b<6; ++b) 
	    printf("%d %s\n",b,axdefs[b]);
	}
      a=a-48;
    } 
  while((a<-1)||(a>5));

  printf("%d\n",a);
  switch(a) 
    {
    case 0:
      structure.timelimit = LIM0;
      printf ("Setting time limit to %d minutes.\n", LIM0);
      break;
    case 1:
      structure.timelimit = LIM1;
      printf ("Setting time limit to %d minutes.\n", LIM1);
      break;
    case 2:
      structure.timelimit = LIM2;      
      printf ("Setting time limit to %d minutes.\n", LIM2);
      break;
    default:
      if ((structure.timelimit < TIMELIM) && (structure.axlevel < 3))
	{
	  structure.timelimit = TIMELIM;
	  printf ("Setting time limit to %d minutes.\n", TIMELIM);
	}	    
      else
	printf ("Not changing time limit.\n");
      break;
    }
  structure.axlevel=a;
  lseek(file,aa,0);
  write(file,&structure,sizeof(user_type));
  close (file);
  sprintf (logmsg, "USEREDIT:%s:%s was: %d now: %d",
	   usersupp.fullname, structure.fullname, tmpax,
	   structure.axlevel);
  intlog (logmsg);
  return(0);
}

biotools(user_type *usersupp)
{
  char tfile [50], bfile[50], syscmd [50];
  int a,b,d,e;
  bool done=FALSE;

  enter_btmp("[Edit Biography]");
  sprintf (bfile, "bios/bio.%d", usersupp->eternal);
  sprintf (tfile, "tmp/bio.%d", usersupp->eternal);

  while (!done)
    {
     printf ("\n<S>ee current bio, <E>dit/Enter bio, <D>elete bio, <X>exit? ");
     b = inkey (); b = (b & 127); b = ctolower (b);
      switch (b)
	{
	case 's':
	  printf ("See bio\n");
	  if (usersupp->flags & US_PROFILE)
	    {
	      printf ("\nYour bio currently reads:\n----------------------------------------------------------------------\n");
	      formout (bfile);
	      printf ("----------------------------------------------------------------------\n");
	    }
	  else
	    printf ("The system does not have a bio for you.\n");
	  break;
	case 'e':
	  printf ("Enter/edit bio\n");
	  printf ("Bios are restricted to %d lines!!!!  If your bio is longer,\nit will be TRUNCATED at %d lines!!!\n\n",BIOMAX, BIOMAX);
	  sprintf (syscmd,"cp %s %s", bfile, tfile);
	  system (syscmd);
	  a=fork();
	  if (a==0)
	    {
	      setsane();
	      execl (EDITOR, EDITOR, tfile, NULL);
	      exit(1);
	    }
	  if (a>0)
	    do
	      {
		e=0;
		b=wait(&e);
	      }
	  while ((b!=a)&&(b>=0));
	  sttybbs(0);
	  if (e==0) /* exit status of editor */
	    {
	      printf ("Installing new Bio, truncating if necessary...\n");
	      readyerself();
	      usersupp->flags  = ((usersupp->flags)|US_PROFILE);
	      writeyerself();
	      sprintf (logmsg, "BIO:%s entered a new bio", usersupp->fullname);
	      intlog (logmsg);
	      done=TRUE;
	      sprintf (syscmd, "head -10 %s > %s", tfile, bfile);
	      system (syscmd);
	    }
	  else
	    printf ("Bio unchanged.\n");
	  unlink (tfile);
	  break;
	case 'd':
	  printf ("Delete bio\n");
	  sprintf (logmsg, "BIO:%s erased bio", usersupp->fullname);
	  printf ("\nYour bio is now blank.\n");
	  unlink (bfile);
	  readyerself();
	  usersupp->flags  = ((usersupp->flags)^US_PROFILE);
	  writeyerself();
	  intlog (logmsg);
	  done=TRUE;
	  break;
	case 'x':
	  printf ("Exit\n");
	  done=TRUE;
	  break;
	default:
	  break;
	}
    }
}

/* Displays "prompt", and sets bit offset "bit" in "item" appropriately
*/
/*
int setbit(prompt,item,bit)
char *prompt;
int *item,bit;
{
  int a, def;
  def = ((*item) & bit);
  printf("%s [%s] ",prompt,(def) ? "Yes" : "No");
  while (1) 
    {
      a=tolower(inkey());
      if (a == 13)
        a = (def != 0);
      if ((a=='y') || (a==1))
	{ 
	  printf("Yes\n"); 
	  *item = *item | bit;
	  return(1); 
	}
      if ((a=='n') || (a==0))
	{ 
	  printf("No\n"); 
	  *item = (*item | bit) ^ bit;
	  return(0); 
	}
    }
}
*/

getusinfo (user_type *structure)  /* configure user account */
{
  int a; 
  char aaa[100];
  int tmp;
  do 
    {
      a=structure->screenwidth;
      printf("Enter your screen width [%d]: ",a);
      getline(aaa,3);
      if (aaa[0]!=0)
	a=atoi(aaa);
      if ((a<20)||(a>132))
	printf("...must be between 20 and 132.\n");
    } 
  while((a<20)||(a>132));
  structure->screenwidth=a;

  printf("Enter your screen length [%d]: ", structure->screenlength);
  getline(aaa,3);
  if (aaa[0]!=0)
    {
      a=atoi(aaa);
      structure->screenlength=a;
    }

  printf("Are you an experienced Citadel user? ");
  structure->flags=((structure->flags)|US_EXPERT);
  if (yesno()==0) 
    structure->flags=((structure->flags)^US_EXPERT);

  printf("Print last old message on New message request? ");
  structure->flags=((structure->flags)|US_LASTOLD);
  if (yesno()==0) 
    structure->flags=((structure->flags)^US_LASTOLD);

  printf("Prompt after each message? ");
  structure->flags=((structure->flags)|US_NOPROMPT);
  if (yesno()==1) 
    structure->flags=((structure->flags)^US_NOPROMPT);

  printf ("Pause each screenful of message output? ");
  structure->flags=((structure->flags)|US_PAUSE);
  if (yesno()==0) 
    structure->flags=((structure->flags)^US_PAUSE);

  if (structure->timescalled != 0)
    {
      printf ("Use the message editor by default? ");
      structure->flags=((structure->flags)|US_EDITOR);
      if (yesno()==0) 
	structure->flags=((structure->flags)^US_EDITOR);

      /* kluge alert !!! */
      structure->flags = (structure->flags)^US_NOHIDE;
      tmp = structure->flags & US_NOHIDE;
      if (tmp == US_NOHIDE)
	structure->flags = (structure->flags)^US_NOHIDE;

      printf ("Hide your registration info from other users? ");
      if (yesno()==0) 
	structure->flags=((structure->flags)|US_NOHIDE);   

      if (structure->flags & US_NOHIDE)
	printf ("Registration info will be PUBLIC.\n");
      else
	printf ("Registration info will be HIDDEN.\n");
    }

/* ^US_FLAG masks it out   |US_FLAG turns it on */

  return(0);
}



print_user_stats(user_type *usersupp, user_type *structure)
{
  char bfile [50], aaa[50];
  struct tm *tmstruct;
  int control = 0;
  long remaining, atime;

  if (usersupp->eternal == structure->eternal)
    control = RU_SELF;

  printf ("\nUser %s (#%d)", structure->fullname, structure->eternal);
  if ((usersupp->axlevel >= 6) || (structure->axlevel >= 6))
    printf (", Access level: %s", axdefs[structure->axlevel]);

  tmstruct = (struct tm *)localtime (&structure->lastcall);
  sprintf (aaa, "%s", asctime(tmstruct));
  aaa[strlen(aaa)-1]=0; /* nuke the \n */
  printf ("\nLast login:   %s %s from %-16.16s\n", aaa, tmstruct->tm_zone,
	  structure->lasthost);

  tmstruct = (struct tm *)localtime (&structure->firstcall);
    {
      sprintf (aaa, "%s", asctime(tmstruct));
      aaa[strlen(aaa)-1]=0; /* nuke the \n */
      printf ("First login:  %s %s\n", aaa, tmstruct->tm_zone);
    }

  printf ("\nCalls: %d         Posts: %d       ", structure->timescalled,
	  structure->posted);

  if ((usersupp->axlevel >= 6) || (control)) 
    if (structure->timescalled != 0)
      printf ("P/C Ratio: %d", structure->posted/structure->timescalled);

  printf ("\n");

  time (&atime);
  tmstruct = localtime (&atime);
  remaining = structure->timelimit - structure->today;
  if (usersupp->axlevel >= 6)
    {
      printf ("Today: %2.2dh %2.2dm      Remaining: ", structure->today/60,
	      structure->today%60);
      if ((structure->timelimit == 0) || (structure->axlevel >= 6))
	printf ("Unlimited\n");
      else
	printf ("%2.2dh %2.2dm\n", remaining/60, remaining%60);
      printf ("Total Online: %2.2dh %2.2dm      Timelimit: %2.2dh %2.2dm\n",
	      structure->online/60, structure->online%60,
	      structure->timelimit/60, structure->timelimit%60);
    }
  else if (control)
    {
      printf ("You have been on %2.2dh %2.2dm today, with ",
	      structure->today/60, structure->today%60); 
      printf ("%dh %dm remaining.\n", remaining/60, remaining % 60);
      printf ("Total Online: %2.2dh %2.2dm      Timelimit: %2.2dh %2.2dm\n",
	      structure->online/60, structure->online%60,
	      structure->timelimit/60, structure->timelimit%60);
    }

  /* hide on means to print it -- NOHIDE is off by default, i.e. private */

  if (structure->flags & US_NOHIDE)
    {
      printf ("----------------------------Registration Info (Public)----------------------\n");
      dis_regis(structure);
    }
  else 
    if ((usersupp->axlevel >= 6) || (control))
      {
	printf ("\n----------------------------Registration Info (Private)----------------------\n");
	dis_regis(structure);
      }
  
  if (structure->flags & US_PROFILE)
    {
      printf ("---------------------------------Biography (Public)--------------------------\n");
      sprintf (bfile, "bios/bio.%d", structure->eternal);
      formout (bfile);
    }
}


