/* 
Filename: userlist.c
Desc: userlist routine-- list out users
Source: local (pirmann@klinzhai.rutgers.edu)

Change History:
10/24/92: modified for Sunset
10/30/93: this header added
*/

#include <stdio.h>
#include <fcntl.h>
#include <ctype.h>
#include <time.h>
#include "citadel.h"

struct tm *localtime();

main()
{
  int file;
  char aaa[100];
  long aa,cc,nrecs;
  user_type usersupp;
  struct tm *tmstruct;
  
  chdir (BBSDIR);
  
  file=open("usersupp",O_RDONLY);
  if (file<0)
    {
      printf("No usersupp file available.\n");
      exit(1);
    }

printf("   ## USER NAME            LAST CALL      #CALLS #POSTS LEVEL LAST HOST\n");
printf("-----------------------------------------------------------------------------\n");

  aa=lseek(file,0L,2);
  nrecs=(aa/sizeof(user_type));
  lseek (file, 0L, 0);
  for (cc=0; cc<nrecs; ++cc)
    {
      read(file,&usersupp,sizeof(user_type));
      aa=usersupp.lastcall;
      tmstruct=localtime(&aa);
      sprintf(aaa,"%2.2d/%2.2d/%2.2d %2.2d:%2.2d",
	      (tmstruct->tm_mon+1), tmstruct->tm_mday, tmstruct->tm_year,
	      tmstruct->tm_hour, tmstruct->tm_min);
      
      printf("%5ld %-20.20s %-14.14s %6d %6d ",
		usersupp.eternal,
		usersupp.fullname,
		aaa,
		usersupp.timescalled,
		usersupp.posted
		);

      switch (usersupp.axlevel)
	{
	case 1:
	  printf ("new   ");	  
	  break;
	case 2:
	  printf ("prob  ");
	  break;
	case 3:
	  printf ("      ");
	  break;
	case 4:
	  printf ("net   ");
	  break;
	case 5:
	  printf ("pref  ");
	  break;
	case 6:
	  printf ("aide  ");
	  break;
	case 7:
	  printf ("sysop ");
	  break;
	}
      printf ("%-16.16s\n", usersupp.lasthost);
    }

  close(file);
  exit(0);

}

