/* 
Filename: updown.c
Desc: upload/download routines 
Source: pulled from Cit/UX dist files for neatness
Change History:
<all routines match the distribution code>
*/

#include <fcntl.h>
#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <setjmp.h>
#include <signal.h>
#include "citadel.h"
#include "defs.h"

extern struct quickroom quickroom;


download(c)
     int c;
{
  int a;
  char aaa[100],bbb[100];

  enter_btmp ("[Download]");
  if ((quickroom.QRflags&QR_DIRECTORY)
      &&(quickroom.QRflags&QR_DOWNLOAD)) 
    {
      printf("Enter filename: ");
      getline(aaa,15);
      for (a=0; a<strlen(aaa); ++a) 
	{
	  if (aaa[a]=='/')
	    aaa[a]='_';
	  if (aaa[a]==';')
	    aaa[a]=0;
	  if (aaa[a]=='&')
	    aaa[a]=0;
	}
      switch(c)
	{
	case 0:
	  formout(bbb);
	  break;
	case 1:	
	  sprintf(bbb,"cd files/%s; sx %s", quickroom.QRdirname,aaa);
	  system(bbb);
	  break;
	case 2:	
	  signal(SIGQUIT,SIG_DFL);
	  sttybbs(1);
	  sprintf(bbb,"cd files/%s; cat <%s", quickroom.QRdirname,aaa);
	  system(bbb);
	  sttybbs(0);
	  unlink("core");	/* just in case the core was dumped */
	  break;
	case 3:	
	  sprintf(bbb,"cd files/%s; sb %s", quickroom.QRdirname,aaa);
	  system(bbb);
	  break;
	case 4:	
	  sprintf(bbb,"cd files/%s; sz %s", quickroom.QRdirname,aaa);
	  system(bbb);
	  break;
	}
      putc(7,stdout);
    }
  else
    printf("Not in this room.\n");
  return(0);
}

roomdir() 
{
  char aaa[100];

  if ((quickroom.QRflags&QR_DIRECTORY) &&(quickroom.QRflags&QR_VISDIR)) 
    {
      sprintf(aaa,"./files/%s",quickroom.QRdirname);
      printf("Directory of %s!%s/%s\n",NODENAME,BBSDIR,&aaa[2]);
      directory(aaa);
    }
  else
    printf("Not in this room.\n");
  return(0);
}


directory (path)
     char *path;
{
  char flnm[16];
  char comment[151];
  char tname[100];
  struct stat statbuf; 
  long aa;
  FILE *fp, *ls;

  sprintf(tname,"ls %s",path);
  ls=(FILE *)popen(tname,"r"); 
  if (ls==NULL) 
    return(1);
  printf("-----------------------------------------------------------\n");
  while (fgets(flnm,16,ls)!=NULL) 
    {
      flnm[strlen(flnm)-1]=0;
      sprintf(tname,"%s/%s",path,flnm);
      stat(tname,&statbuf);
      aa=(long)statbuf.st_size;
      sprintf(tname,"%s/filedir",path);
      fp=fopen(tname,"r");
      comment[0]=0;
      if (fp!=NULL) 
	{
	  do 
	    {
	      fgets(comment,151,fp);
	      comment[strlen(comment)-1]=0;
	      if (!strncmp(comment,flnm,strlen(flnm))) 
		goto FND;
	    } 
	  while(!feof(fp));
	FND:		
	  fclose(fp);
	}
      if (strncmp(flnm,comment,strlen(flnm)))
	comment[strlen(flnm)+1]=0;
      if (strcmp(flnm,"filedir"))
	printf("%-14s %8ld %s\n",flnm,aa,&comment[strlen(flnm)+1]);
    }
  fclose(ls);
  return(0);
}


upload(c)	/* c = upload mode */
     int c; 
{
  char buf[151],aaa[100],bbb[60],ccc[60];
  int a,b,file;
  long cc;
  FILE *fp;

  enter_btmp ("[Upload]");
  if (((quickroom.QRflags&QR_DIRECTORY)==0) || 
      ((quickroom.QRflags&QR_UPLOAD)==0) ) 
    {
      printf("Not in this room.\n");
      return(1);
    }
  if (usersupp.axlevel < 3) 
    {
      printf("Need higher access to upload.\n");
      return(1);
    }
  printf("Enter filename: ");
  getline(aaa,15);
  for (a=0; a<strlen(aaa); ++a) 
    {
      if (aaa[a]=='/') aaa[a]='_';
      if (aaa[a]==';') aaa[a]=0;
      if (aaa[a]=='&') aaa[a]=0;
    }
  sprintf(bbb,"./files/%s/%s",quickroom.QRdirname,aaa);
  file=open(bbb,O_RDONLY);
  if (file>(-1)) 
    {
      printf("'%s' already exists.\n",aaa);
      close(file);
      return(1);
    }
  printf("Enter a short description of the file:\n: ");
  getline(buf,150);
  file=creat(bbb,0666);
  if (file<0) 
    {
      printf("Can't create that file?\n");
      return(1); 
    }
  if (c>0) 
    {
      close(file);
      unlink(bbb);
    }
  switch(c) 
    {
    case 0:
      a=0;
      printf("Receiving %s - press Ctrl-D to end.\n",bbb);
      do 
	{
	  b=inkey(); 
	  if (b==13) 
	    {
	      b=10; 
	      printf("\r"); 
	    }
	  if (b!=4)
	    { 
	      printf("%c",b); 
	      write(file,&b,1); 
	    }
	} 
      while(b!=4);
      close(file);
      a=0;
      break;
    case 1:
      sprintf(bbb,"cd ./files/%s; rx %s", quickroom.QRdirname,aaa);
      a=system(bbb);
      break;
    case 2:
      sprintf(bbb,"cd ./files/%s; rb", quickroom.QRdirname);
      a=system(bbb);
      break;
    case 3:
      sprintf(bbb,"cd ./files/%s; rz", quickroom.QRdirname);
      a=system(bbb);
      break;
    }
  if (a==0) 
    printf("*** Transfer successful.\n");
  else
    {
      printf("*** Transfer unsuccessful.\n");
      return(a);
    }
  sprintf(ccc,"./files/%s/filedir",quickroom.QRdirname);
  fp=fopen(ccc,"r+");
  if (fp==NULL) fp=fopen(ccc,"w");
  fseek(fp,0L,2);
  fprintf(fp,"%s %s\n",aaa,buf);
  fclose(fp);
  time(&cc);			/* put together an upload notice */
  fp=fopen(temp,"wb");
  if (fp==NULL) 
    interr(22);
  putc(255,fp);
  putc(MES_NORMAL,fp);
  putc(0,fp);
  fprintf(fp,"Psysop"); putc(0,fp);
  fprintf(fp,"T%ld",cc); putc(0,fp);
  fprintf(fp,"A%s",usersupp.fullname); putc(0,fp);
  fprintf(fp,"O%s",quickroom.QRname); putc(0,fp);
  fprintf(fp,"N%s",NODENAME); putc(0,fp); putc('M',fp);
  fprintf(fp,"NEW UPLOAD: '%s'\r %s\n",aaa,buf);
  putc(0,fp);
  fclose(fp);
  save_message(temp,buf,0,M_LOCAL);
  return(0);
}


