/* 
File: ulog.c 
Desc: user log routines
   ulog    -- log calls to the bbs 
   badpw   -- log bad password attempts
Source: local, pirmann@demigod.rutgers.edu 
Change History:
01/05/93: Cleaned up all routines (pirmann)
10/30/93: This header added
*/
   

#include <fcntl.h>
#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "citadel.h"

extern long logintime, timetoday;
extern char *mytty, *fullname, *hname;
extern user_type usersupp;
extern int offstat;

/* log calls to the bbs */
ulog ()
{
  FILE *logf;
  char logline[80], whichlog[20], login[15], logout[6], outmsg[8];
  struct tm *tmstruct;

  long atime, thiscall, timeon;

  /* set up login date & time */
  if (offstat != ULOG_OFF)   /* user has a logintime */
    {
      tmstruct = localtime(&logintime);
      sprintf (login,"%2.2d/%2.2d/%2.2d %2.2d:%2.2d", (tmstruct->tm_mon+1),
	       tmstruct->tm_mday, tmstruct->tm_year, tmstruct->tm_hour,
	       tmstruct->tm_min);
      login[14] = '\0';
    }
  else                   /* user does not have a logintime */
    {
      time (&atime);
      tmstruct = localtime (&atime);
      sprintf (login,"%2.2d/%2.2d/%2.2d %2.2d:%2.2d", (tmstruct->tm_mon+1),
	       tmstruct->tm_mday, tmstruct->tm_year, tmstruct->tm_hour,
	       tmstruct->tm_min);
      login[14] = '\0';
    }

  time(&atime);
  tmstruct = localtime (&atime);

  /* which log file to use */
  sprintf (whichlog, "%s.%2.2d%2.2d%2.2d", LOGFILE, (tmstruct->tm_mon+1),
	   tmstruct->tm_mday, tmstruct->tm_year);
  whichlog[19] = '\0';

  /* set up logout time */
  sprintf (logout,"%2.2d:%2.2d", tmstruct->tm_hour, tmstruct->tm_min);
  logout[5] = '\0';

  /* how are they terminating? */
  switch (offstat) 
    {
    case ULOG_NORMAL: sprintf (outmsg, ""); break;
    case ULOG_DROP: sprintf (outmsg, "DROP"); break;
    case ULOG_SLEEP: sprintf (outmsg, "SLEEP"); break;
    case ULOG_OFF: sprintf (outmsg, "OFF"); break;
    case ULOG_TL: sprintf (outmsg, "LIMIT"); break;
    case ULOG_NEW: sprintf (outmsg, "NEW"); break;
    }

  if (offstat != ULOG_OFF) 
    {
      thiscall = ((long) atime - (long) logintime) / 60;
      sprintf (logline, "%-20.20s %5.5s %-16.16s %14.14s - %5.5s (%d) %s\n",
	       usersupp.fullname, &mytty, usersupp.lasthost,
	       login, logout, thiscall, outmsg);
    }
  else
    {
      thiscall = 0; 
      sprintf (logline, "%-20.20s %5.5s %-16.16s %14.14s - %5.5s (%d) %s\n",
	       outmsg, &mytty, usersupp.lasthost,
	       login, logout, thiscall, outmsg);
    }

  if ((logf = fopen (whichlog, "a"))!= NULL) 
    {
      fprintf (logf, "%s", logline);
      fclose (logf);
    }
  if (offstat != ULOG_OFF) 
    {

      readyerself();
      timeon = (((long)atime - (long)logintime) / 60 );
      usersupp.today=timeon+timetoday;            /* update today */
      usersupp.online = usersupp.online + timeon; /* update total */
      writeyerself();

      if (! (((usersupp.timelimit - usersupp.today) % 60 < 0) && 
	     ((usersupp.timelimit - usersupp.today) / 60 <= 0)))
	printf ("\nYou have %dh %dm remaining today.\n", 
		(usersupp.timelimit-usersupp.today)/60,
		(usersupp.timelimit-usersupp.today)%60);
    }
  return (0);
}

/* log bad password attempts */
badpw ()
{
  FILE *logf;
  long atime;
  struct tm *tmstruct;
  char datein[15], whichlog[20], logline[80];
  
  time(&atime);
  tmstruct = localtime(&atime);

  sprintf (datein, "%2.2d/%2.2d/%2.2d %2.2d:%2.2d", (tmstruct->tm_mon+1), 
	   tmstruct->tm_mday, tmstruct->tm_year, tmstruct->tm_hour,
	   tmstruct->tm_min);
  sprintf (whichlog, "%s.%2.2d%2.2d%2.2d", LOGFAIL, (tmstruct->tm_mon+1), 
	   tmstruct->tm_mday, tmstruct->tm_year);

  datein[14] = '\0';
  whichlog[19] = '\0';

  sprintf (logline, "Badpw: %-18.18s %5.5s %-16.16s %15.15s\n",
	   &fullname, &mytty, &hname, datein);
  
  if ((logf = fopen (whichlog, "a")) != NULL) 
    {
      fprintf (logf, "%s", logline);
      fclose (logf);
    }

  return(0);
}

