/*
File: ubrowse.c
Desc: external user browser
Source: local, pirmann@rutgers.edu 
Change History
06/17/92 Created
10/30/93 this header added
*/

#include <stdio.h>
#include <fcntl.h>
#include <ctype.h>
#include <time.h>
#include <termio.h>
#include "citadel.h"

int need_rewrite = 0;

pwcrypt(text,code)
     char text[];
     int code; 
{
  int a;
  for (a=0; a<strlen(text); ++a) 
    text[a]=(text[a]^(((code|128)^a)&0xFF));
  return(0);
}

char *months[12]=
{
  "Jan","Feb","Mar","Apr","May","Jun",
  "Jul","Aug","Sep","Oct","Nov","Dec" 
};

char *days[7] = 
{ 
  "Sun","Mon","Tue","Wed","Thu","Fri","Sat"  
  };

char *axdefs[8]=
{
  "Marked for deletion",
  "New User",
  "Read-Only User",
  "Normal User",
  "Subsystem User",
  "Preferred User",
  "Aide",
  "Sysop"
  };

main()
{
  user_type usersupp;
  struct tm *tmstruct;
  int file;
  long aa, nrecs, cc;
  int ch;

  sttybbs();

  file = open ("usersupp", O_RDONLY);
  if (file < 0) 
    {
      printf ("can't open usersupp!!!\n");
      exit (-1);
    }

  aa=lseek(file,0L,2); 
  nrecs=(aa/sizeof(user_type));
  lseek (file, 0L, 0);

  for (cc=0; cc<nrecs; ++cc) 
    {
      system ("clear");
      read(file,&usersupp,sizeof(user_type));
      pwcrypt (usersupp.password, PWCRYPT);
      printf ("1. User name      : %s\n", usersupp.fullname);
      printf ("2. User number    : %d\n", usersupp.eternal);
      printf ("3. Last host      : %s\n", usersupp.lasthost);
      printf ("4. Password       : %s\n", usersupp.password);
      printf ("5. Time limit     : %2.2d:%2.2d\n", usersupp.timelimit/60,
	      usersupp.timelimit%60);
      printf ("6. Times called   : %d\n", usersupp.timescalled);
      printf ("7. Messages posted: %d\n", usersupp.posted);
      printf ("8. Time online    : %2.2d:%2.2d\n", usersupp.online/60,
	      usersupp.online%60);
      printf ("9. Access level   : %d (%s)\n", usersupp.axlevel, 
	      axdefs[usersupp.axlevel]);
      
      tmstruct=localtime(&usersupp.lastcall);
      printf ("10. Last login    : %s %s %d %2.2d:%2.2d\n",
	      days[tmstruct->tm_wday], months[tmstruct->tm_mon], 
	      tmstruct->tm_mday, tmstruct->tm_hour, 
	      tmstruct->tm_min);

      printf ("11. Real name     : %s\n", usersupp.RGname);
      printf ("12. Address       : %s\n", usersupp.RGaddr);
      printf ("13. City          : %s\n", usersupp.RGcity);
      printf ("14. State         : %s\n", usersupp.RGstate);
      printf ("15. Zip           : %s\n", usersupp.RGzip);
      printf ("16. Phone         : %s\n", usersupp.RGphone);
      printf ("17. Email         : %s\n", usersupp.RGemail);
      if (usersupp.flags & US_PERM)
	printf ("18. Permanent?    : Yes\n");
      else
	printf ("18. Permanent?    : No\n");
      if (usersupp.flags & US_REGIS)
	printf ("19. Registered?   : Yes\n");
      else
	printf ("19. Registered?   : No\n");

      
      printf ("\nN)ext, Q)uit\n");

      ch = getchar();
      if (ch == 'q') exit (0);
    }

  close(file);
  exit (0);
}

sttybbs() 
{
  struct termio live;

  ioctl(0,TCGETA,&live);
  live.c_iflag=ISTRIP|IXON|IXANY|ICRNL;
  live.c_oflag=OPOST|ONLCR;
  live.c_lflag=NOFLSH;
  live.c_line=0;
  live.c_cc[0]=15;
  live.c_cc[1]=3;
  live.c_cc[2]=8;
  live.c_cc[3]=24;
  live.c_cc[4]=1;
  live.c_cc[5]=255;
  live.c_cc[6]=0;
  live.c_cc[7]=0;
  ioctl(0,TCSETA,&live);
  return(0);
}
