/* 
File: uadmin.c (dependent part of citadel)
Desc: internal uadmin routine
Source: (local) pirmann@rutgers.edu 
Change History:
07/08/91 created
01/05/93 removed curses -- text based only now
*/

#include <stdio.h>
#include <fcntl.h>
#include <ctype.h>
#include <time.h>
#include "citadel.h"

extern char *axdefs[8];
extern char *days[7];
extern char *months[12];
int need_rewrite;
int need_rehash;

useradmin ()
{
  char aaa[100], oldname[26], commandstr[10];
  long aa, bb, remaining;
  int file, command, a;
  user_type usersupp;
  struct tm *tmstruct;
  bool done=FALSE;
  
  enter_btmp ("[Useradmin]");

  /* if these were initalized up there, it doesn't work.. */
  need_rewrite=0; need_rehash=0;

  printf ("Enter user name: ");
  getline (aaa, 26);
  file = open ("usersupp", O_RDONLY);
  if (file < 0)
    interr (26);
  aa = finduser (file, aaa);
  if (aa != (-1))
    {
      read (file, &usersupp, sizeof (user_type));
      pwcrypt (usersupp.password, PWCRYPT);
      close (file);

      strcpy (oldname, usersupp.fullname);

      while (!done)
	{
	  /* display user information */
	  system ("clear");
	  printf ("(1) #%d %-26.26s    Access: (2) %d-%s\n", usersupp.eternal,
		  usersupp.fullname, usersupp.axlevel,
		  axdefs[usersupp.axlevel]);
	  line();

	  tmstruct = (struct tm*)localtime (&usersupp.lastcall);
	  sprintf (aaa, "%s", asctime(tmstruct));
	  aaa[strlen(aaa)-1]=0; /* remove the pesky \n */
	  printf ("Last login:   %s %s from (3) %-16.16s\n", aaa,
		  tmstruct->tm_zone, usersupp.lasthost);

	  tmstruct = (struct tm*)localtime (&usersupp.firstcall);
	  sprintf (aaa, "%s", asctime(tmstruct));
	  aaa[strlen(aaa)-1]=0; /* remove the pesky \n */
	  printf ("First login:  %s %s\n", aaa, tmstruct->tm_zone);
	  line();

	  printf("(4) PASSWORD           (5) CALLS    (6) POSTS    (7) WIDTH    (8) LENGTH\n%-20.20s       %-12d %-12d %-12d %-12d\n", 
		 usersupp.password, usersupp.timescalled, usersupp.posted,
		 usersupp.screenwidth, usersupp.screenlength);
	  line();

	  remaining = usersupp.timelimit - usersupp.today;
	  printf ("(9) Time today:  %2.2dh %2.2dm       ", usersupp.today/60,
		  usersupp.today%60);
	  printf ("Remaining: %2.2dh %2.2dm\n", remaining/60, remaining%60);
	  printf ("(10) Total time:  %2.2dh %2.2dm\n", usersupp.online/60,
		  usersupp.online%60);
	  printf ("(11) Time limit:  %2.2dh %2.2dm\n", usersupp.timelimit/60,
		  usersupp.timelimit%60);
	  line();

	  printf ("(12) %s\n", usersupp.RGname);
	  printf ("(13) %s\n", usersupp.RGaddr);
	  printf ("(14) %s (15) %s (16) %s\n", usersupp.RGcity,
		  usersupp.RGstate, usersupp.RGzip);
	  printf ("(17) (%c%c%c) %c%c%c-%c%c%c%c\n",
		  usersupp.RGphone[0], usersupp.RGphone[1],
		  usersupp.RGphone[2], usersupp.RGphone[3],
		  usersupp.RGphone[4], usersupp.RGphone[5],
		  usersupp.RGphone[6], usersupp.RGphone[7],
		  usersupp.RGphone[8], usersupp.RGphone[9]);
	  printf ("(18) %s\n", usersupp.RGemail);
	  line();

	  if (usersupp.flags & US_NEEDVALID)
	    printf ("(19) NEEDVALID   ");
	  else
	    printf ("(19) VALIDATED   ");

	  if (usersupp.flags & US_SUBSYSTEM)
	    printf ("(20) SUBSYSTEM   ");
	  else
	    printf ("(20) NO-SUBSYS   ");
	  
	  if (usersupp.flags & US_PERM)
	    printf ("(21) PERMANENT   ");
	  else
	    printf ("(21) NOT-PERM    ");

	  if (usersupp.flags & US_NOHIDE)
	    printf ("(22) PUB-INFO\n");
	  else
	    printf ("(22) PRV-INFO\n");

	  if (usersupp.flags & US_REGIS)
	    printf ("(23) REGISTERED  ");
	  else
	    printf ("(23) UNREGISTERD ");

	  if (usersupp.flags & US_PROFILE)
	    printf ("(24) YES-BIO     ");
	  else
	    printf ("(24) NO-BIO      ");

	  if (usersupp.flags & US_LASTOLD)
	    printf ("(25) LASTOLD     ");
	  else
	    printf ("(25) JUST NEW    ");

	  if (usersupp.flags & US_EXPERT)
	    printf ("(26) EXPERT\n");
	  else
	    printf ("(26) NOVICE\n");

	  if (usersupp.flags & US_PAUSE)
	    printf ("(27) PAUSE ON    ");
	  else
	    printf ("(27) PAUSE OFF   ");

	  if (usersupp.flags & US_NOPROMPT)
	    printf ("(28) NO PROMPT   ");
	  else
	    printf ("(28) PROMPT      ");

	  if (usersupp.flags & US_EDITOR)
	    printf ("(29) EDITOR      ");
	  else
	    printf ("(29) NO EDITOR   ");

	  printf ("\n");
	  line();
	  printf ("Enter field number to change (0 to exit): ");
	  getline (commandstr, 3);
	  command = atoi (commandstr);

	  if (command == 0)
	    done = TRUE;
	  else 
	    edit_field (&usersupp, command);

	}  /* end while */
       
      if (need_rewrite==1) 
	{
	  printf ("Save changes (y/n)? ");
	  if (yesno()) 
	    {
	      file=open("usersupp",O_RDWR);
	      if (file < 0)
		interr (48);
	      bb = finduser (file, oldname);
	      pwcrypt(usersupp.password,PWCRYPT);
	      if (bb>= 0L)
		{
		  a=write(file,&usersupp,sizeof(user_type));
		  if (a < 0)
		    interr (23);
		}
	      close(file);
	      if (need_rehash)
		{
		  /* the only reason to rehash would be if
		     you changed the user's name.  Just make sure
		     you don't change the name of a logged in user--
		     I think that would be bad ... */
		  printf("useradmin: rewriting user hash table\n");
		  write_hashtab();
		}
	    }
	  /* else nothing gets saved and we exit */
	}
      system ("clear");
      return (0);
    }  

  else
    {
      printf ("No such user.\n");
      close (file);
      return (1);
    }
}

edit_field (user_type *userdata, int fieldnum)
{
  char new[100];
  int file;
  long aa; 
 
  switch (fieldnum)
    {
    case 1:
      printf ("Enter new user name: ");
      getline (new, 26);
      file = open ("usersupp", O_RDONLY);
      if (file < 0)
	interr (26);
      aa = finduser (file, new);
      if (aa != (-1))
	printf ("Name already in use!\n");
      else
	{
	  strcpy (userdata->fullname, new);
	  need_rewrite=1;
	  need_rehash=1;
	}
      break;
    case 2:
      printf ("Enter new access level (0-7): ");
      gets (new);
      userdata->axlevel = atoi (new);
      need_rewrite=1;
      break;
    case 3:
      printf ("Enter new hostname: ");
      getline (userdata->lasthost, 16);
      need_rewrite=1;
      break;
    case 4:
      printf ("Enter new password: ");
      getline (userdata->password, 19);
      need_rewrite=1;
      break;
    case 5:
      printf ("Enter new timescalled (int): ");
      gets (new);
      userdata->timescalled = atoi (new);
      need_rewrite=1;
      break;
    case 6:
      printf ("Enter new posts (int): ");
      gets (new);
      userdata->posted = atoi (new);
      need_rewrite=1;
      break;
    case 7:
      printf ("Enter new screenwidth (int): ");
      gets (new);
      userdata->screenwidth = atoi (new);
      need_rewrite=1;
      break;
    case 8:
      printf ("Enter new screenlength (int): ");
      gets (new);
      userdata->screenlength = atoi (new);
      need_rewrite=1;
      break;
    case 9:
      printf ("Do you want to reset this users timetoday? ");
      if (yesno())
	{
	  userdata->today = 0;
	  need_rewrite=1;
	}
      break;
    case 10:
      printf ("Do you want to reset this user's total time? ");
      if (yesno())
	{
	  printf ("Enter new time in minutes (int): ");
	  gets (new);
	  userdata->online = (long)atoi(new);
	  need_rewrite=1;
	}
      break;
    case 11:
      printf ("Enter new time limit in hours (int): ");
      gets (new);
      userdata->timelimit = 60 * atoi (new);
      need_rewrite=1;
      break;
    case 12:
      printf ("Enter new real name: ");
      getline (userdata->RGname, 30);
      need_rewrite=1;
      break;
    case 13:
      printf ("Enter new address: ");
      getline (userdata->RGaddr, 25);
      need_rewrite=1;
      break;
    case 14:
      printf ("Enter new city: ");
      getline (userdata->RGcity, 15);
      need_rewrite=1;
      break;
    case 15:
      printf ("Enter new state: ");
      getline (userdata->RGstate, 2);
      need_rewrite=1;
      break;
    case 16:
      printf ("Enter new zip: ");
      getline (userdata->RGzip, 11);
      need_rewrite=1;
      break;
    case 17:
      printf ("Enter new phone: ");
      getline (userdata->RGphone, 10);
      need_rewrite=1;
      break;
    case 18:      
      printf ("Enter new email: ");
      getline (userdata->RGemail, 40);
      need_rewrite=1;
      break;
    case 19:
      userdata->flags = (userdata->flags ^ US_NEEDVALID);
      need_rewrite=1;
      break;
    case 20:
      userdata->flags = (userdata->flags ^ US_SUBSYSTEM);
      need_rewrite=1;
      break;
    case 21:
      userdata->flags = (userdata->flags ^ US_PERM);
      need_rewrite=1;
      break;
    case 22:
      userdata->flags = (userdata->flags ^ US_NOHIDE);
      need_rewrite=1;
      break;
    case 23:
      userdata->flags = (userdata->flags ^ US_REGIS);
      need_rewrite=1;
      break;
    case 24:
      userdata->flags = (userdata->flags ^ US_PROFILE);
      need_rewrite=1;
      break;
    case 25:
      userdata->flags = (userdata->flags ^ US_LASTOLD);
      need_rewrite=1;
      break;
    case 26:
      userdata->flags = (userdata->flags ^ US_EXPERT);
      need_rewrite=1;
      break;
    case 27:
      userdata->flags = (userdata->flags ^ US_PAUSE);
      need_rewrite=1;
      break;
    case 28:
      userdata->flags = (userdata->flags ^ US_NOPROMPT);
      need_rewrite=1;
      break;
    case 29:
      userdata->flags = (userdata->flags ^ US_EDITOR);
      need_rewrite=1;
      break;
    default:
      break;
    }
  return (0);
}

write_hashtab() 
{
  user_type u;
  int h;
  int in,out;

  in=open("usersupp",O_RDONLY);
  if (in < 0)
    interr (24);
  out=creat("hashtab",0600);
  if (out < 0)
    interr (25);
  while(read(in,&u,sizeof(user_type))) 
    {
      h=hash(u.fullname);
      write(out,&h,sizeof(int));
    }
  close(in);
  close(out);
  return(0);
}

line()
{
printf ("---------------------------------------------------------------------------\n");
}
