/* 
File: front.c (external)
Desc: BBS front end. 
Change History:
00/00/89 Originally by Hobbit
01/21/93 Rewritten by pirmann -- cut down for internal testing

   files:
   front.ALLOW     max allow (defaults to 10 if nonexistant)
   front.DOWN      bbs is down if exists
   front.PROHIBE   list of blacklisted hosts
   
   see also front.h

*/

#include <stdio.h>
#include <fcntl.h>
#include <utmp.h>
#include <string.h>
#include "front.h"
char *index();		/* for strings.h */

struct utmp entry;
/* contains:	ut_line		tty name	8
		ut_name		user		8
		ut_host		4n host		16
		ut_time		when logged in	long
*/
#define REC sizeof (struct utmp)

main()
{
  int ucount = 0, uid, maxallow, *fakearg = 0, file;
  static char thistty[9];
  FILE *fp;
  char hname[16], host[16], tmpallow[2], *foo;

  printf ("This is tfront running tcitadel! TEST ONLY!\n\n");

  /* do this first, so we can hook later */
  uid = getuid();

  /* Hook for taking the thing down -- do this first!!! */
  if ((file = open("front.DOWN", O_RDONLY)) > 0)
    {
      close (file);
      if ((uid == SYSOP)||(uid == 0))
	printf ("(The bbs is down.)\n");
      else
	{
	  printfile ("front.DOWN");
	  sleep (2);
	  return (0);
	}
    }

  /* find out which tty we're on */
  strcpy (thistty, (char *)(strrchr (ttyname(0), '/') + 1));

  /* find out what hostname we're coming in from and put it in hname */
  /* and while utmp is open, determine how many bbs users are already on */
  file = open ("/etc/utmp", O_RDONLY);
  if (file < 0)
    {
      printf ("Can't read UTMP file, please notify sysop!\n");
      return (-1);
    }
  while ((read (file, &entry, REC)) != 0) 
    {
      if ((strcmp (entry.ut_line, thistty)) == 0) 
	strncpy (hname, entry.ut_host, 16);
      if (!strncmp (entry.ut_name, "bbs", 3)) 
	{
	  ucount++;
	  if ((ucount > maxallow) && (uid == BBSUID))
	    {
	      printfile ("messages/full");
	      close (file);
	      sleep (1);
	      exit (0);      
	    }
	}
    }
  close(file);

  /* we're all clear-- open slots and not prohibited-- lets go */

  /* If we're chrooted, we can't see the real utmp.  What a pain in the tail */
  system ("/bin/cp -p /etc/utmp /Cit/bbs/etc/utmp");

  chroot ("/Cit/bbs"); /* stay root until we're done with this */
  umask (02);			/* so group rw is preserved */
  setgid (BBSGID);		/* this too, or it comes up trashed */
  setuid (BBSUID);		/* now become the real user and shift */

/* Hobbit wrote: the gid *still* comes up trashed, even though I explicitly 
   set it.  Go figure.  I don't know why yet.  _H*

   DP wrote: changed these around because you can't setgid if you're not 
   root -DP
*/

  execl ("tcitadel", "tcitadel", thistty, fakearg);
  /* if we can't find citadel just quietly die */
  exit(0);
  }


/* check for character matches from blacklist strings */
static int
match (sub, str)
char *sub, *str;
{
  if ((str = (index (str, *sub))) == NULL) return (0);
  while (*sub != '\0')
    if (*sub++ != *str++) return (0);
  return (1);
}


printfile (name)
char name[];
{
  int a=0;
  FILE *fp;

  if ((fp=fopen (name, "r")) != NULL)
    {
      while ((a=getc(fp)) != EOF)
	putc (a, stdout);
      fclose (fp);
    }
}
