/****************************************************************************/
/*                  YOUR SYSTEM CONFIGURATION                               */
/* Set all the values in this file appropriately BEFORE compiling any of the*/
/* C programs. If you are upgrading from an older version of Citadel/UX, it */
/* is vitally important that the #defines which are labelled "structure size*/
/* variables" are EXACTLY the same as they were in your old system,         */
/* otherwise your files will be munged beyond repair.                       */
/****************************************************************************/

/****************************************************************************/
/* Networking stuff
 * set NODENAME to your UUCP node name. Set HUMANNODE to the human-readable
 * name of your system.
 */

#define NODENAME	"quartz"	/* Your system's uucp nodename      */
#define HUMANNODE	"QuartzBBS"
#define NETWORKED       1               /* 1 for yes 0 for no */
/****************************************************************************/

#define BBSDIR		"/u1/bbs"
/* This is the directory Citadel will reside in. */
/* referred to only by programs run outside of the front chroot */

#define NEWS_FILE       "info/bbs_menu/news"
#define REV_FILE        "info/Revision-History"
/* names of files for .read revision history and .read news */

#define EDITOR    "simped"
/* executable name of editor relative to BBSDIR */

#define PWCRYPT		142
/* Set PWCRYPT to any value between 0 and 255 for password encryption. DO
 * NOT CHANGE IT ONCE IT IS SET or your users will all be locked out.
 */

/* #define ALLOWNEW        1 */
/* old: set to 1 to allow new users, 0 to not allow new users */
/* new: touch file .nonew to not allow new users in BBSDIR */

#define MAKEROOM        6
/* minimum axlevel to create a new room */

#define LOBBYPOST       6
/* minimum axlevel to post in the lobby */

#define CREATAIDE	0
/* If CREATAIDE is set to 1, anyone who creates a class 3 (passworded) or
 * class 4 (invitation-only) room automatically becomes the room-aide for
 * that room. */

#define SLEEPING	900
/* If the program is waiting for input more than SLEEPING number of seconds,
 * Citadel will print the contents of messages/sleeping and hang up. To 
 * disable the feature, set SLEEPING to 0. 900 seconds = 15 minutes */

#define TIMELIM         180
/* time limit for a normal user in minutes */
/* set to 0 to disable time limits */

#define LIM0 10         /* time limit for a level 0 user */
#define LIM1 180        /* time limit for a level 1 user */
#define LIM2 30         /* time limit for a level 2 user */

#define PURGEDAY        90  
/* time in days to purge inactive users */

/* #define ENABLE_FEEDBACK /* */
/* define this if you want users to be prompted to leave feedback */
/* also change the leave_feedback routine in citadel.c if you want */
/* it's currently set to ask everyone on a 10x call and all lev. 1 users */

#define INITAX		1
#define VALIDAX         3
/* New users are assigned the access level of INITAX,
 * Validated users are assigned the level of VALIDAX:
 * 0 = Marked for deletion, 1 = New User, 2 = Problem User, 3 = Local User,
 * 4 = Network User, 5 = Preferred User, 6 = Aide, 7 = Sysop */

#define REGISCALL	1
/* If a user has called REGISCALL times, he/she will be required to register.
 * Set this value to 0 to disable required registration. */

#define USE_EDITOR 1
/* Set to 1 to allow use of editor, 0 to disallow -- UNUSED */
/* need to set up so that this controls editor-related functions */

/* maximum number of lines for certain buffers -- 0 means unlimited */
#define BIOMAX         10       /* for biographies */
#define DESCMAX        10        /* for room descriptions */


/*--------------------------------------------------------------------------*/

/*** STRUCTURE SIZE VARIABLES ***/
/* You may NOT change these six values once you set up your system.	    */
/* Do not set MAILSLOTS higher than MSGSPERRM 				    */

#define MAXROOMS	100		/* Number of rooms in system        */
#define MAILSLOTS	50		/* Number of mail slots             */
#define MSGSPERRM	200		/* Messages per room                */
#define MM_FILELEN      (50000L)        /* default size per setup.c         */
#define MM_MAIL       (5000000L)        /* this size reserved for mail only */

/*** END OF STRUCTURE SIZE VARIABLES ***/

#define SAVEDELETE      1               /* saves deleted messages */
#define TWITROOM	"Twitshit"	/* room to send deleted msgs to*/

