/* 
File: subsystem.c
Desc: BBS SubSystem-- Simply execs a number of different things
Source: local (hobbit, pirmann)
00/00/00 originally by hobbit
00/00/00 "Mud authorization" put in after seeing zillions of people 
         just jump through the bbs to play mud. (hobbit)
00/00/00 New wrinkle: Link with bbutmp so btmp code works.(hobbit)
00/00/00 fixed mudauth to use usersupp.axlevel (pirmann)
*/

#include <stdio.h>
#include <ctype.h>
#include <string.h>

#define TNARG "TN"	/* "type q" for regular telnet */
struct {
  int cmd;		/* what you type to get it */
  char *desc;		/* what it gets you */
  char *w1;		/* how it does it */
  char *w2;
  char *w3;
  char *w4;
  unsigned short auth;
} things[] = {
/* In this case, for the moment, TinyTalk [with all file code removed] seems
   like a win. */
  {'n', "Notable Events in History", "/bin/history", 0, 0, 0, 0 },
  {'h', "Look up host name", "/bin/findhost", 0, 0, 0, 0},
  {'r', "Query the Rutgers student directory", "/bin/wpwhois", 0, 0, 0, 0},
  {'d', "Look up a word in Oxford Concise Dictionary", "/bin/dict", 0, 0, 0, 0},
  {'t', "Look up a word in Oxford Thesaurus", "/bin/dict", "-t", 0, 0, 0},
  {'q', "Look up a keyword in Oxford Quotation Dictionary", "/bin/dict", "-q", 0, 0, 0},
/*  {'w', "Weather Reporter", "/bin/wxmap", "-file", "/.wxrc", 0},*/
  {'w', "Weather Reporter", "/bin/getw", 0, 0, 0, 0},
  {'g', "Connect to Quartz Gopher", "/bin/gopher", "-s", "quartz.rutgers.edu", 0, 0},
  {'e', "Experimental Quartz Info System", "/bin/gopher", "-s", "quartz.rutgers.edu", "6969"},
/*  {'n', "Use NetFind person finder", "/bin/netfind/nsh", 0, 0, 0, 0},*/
/*  {'c', "Chat", "/chat.ext", 0, 0, 0, 0},*/
  {'1', "finger PrismBBS", "/bin/telnet", "bbs.fdu.edu", "11", 0, 0},
  {'2', "finger SunsetBBS", "/bin/telnet", "paladine.hacks.arizona.edu", "11", 0, 0},
/* Muds.  These are now numeric, since they seem to arbitrarily change
   so often and at random. */
/*  {'9', "QuartzPARADISE", "/bin/telnet", "quartz", "9999", 1, 0},*/
  {'x',	"Exit subsystem", "/bin/true", 0, 0, 0, 0},
  {0}
};


short canlose;

main(argc, argv)
int argc; 
char **argv;
{
int typed, i;
/* A better way to limit pinhead count */
canlose = 0;
if ((strcmp (argv[1], "4") == 0)
  ||(strcmp (argv[1], "5") == 0)
  ||(strcmp (argv[1], "6") == 0)
  ||(strcmp (argv[1], "7") == 0)) canlose = 1;

printf ("Type ? for a menu.  Control-C will get you out of most things.\n");
GET:
printf ("*");
typed = getchar();
if (typed == -1) exit (0);		/* eof?! */
if (isupper (typed)) typed = tolower(typed);  /* ensure lc */
if (typed == '?') {
  for (i = 0; things[i].cmd != 0; i++) {
    if ((! things[i].auth) || canlose)
      printf ("%c -- %s\n", things[i].cmd, things[i].desc);
    }
  goto GET;
  }
for (i = 0; things[i].cmd != 0; i++) {
  if (things[i].cmd == typed) {
    if (things[i].auth && (! canlose)) {
      printf ("Unavailable to you -- see a sysop.\n");
      exit (0);
    }
/*    init_btmp (0);		/* null arg is magic; saves current name */
/*    enter_btmp ("Subsystem");*/
/* I don't FUCKING believe this.  You need to supply a fake argv[0].  */
    execl (things[i].w1, TNARG, things[i].w2, things[i].w3, things[i].w4, (char *)0);
  }
}
goto GET;
}
