/* 
File: routines2.c (dependent)
Desc: random global routines
  eopen        - funky file opener 
  pwcrypt      - Crypt those passwords
  room_prompt  - Return proper EOP char
  getline      - Gets a line from stdin
  aide_message - Post a message in Aide
  strcase      - lowercase the string
  daycheck     - is today the same as the day of last call (local)
  print_system_config - print out values of defines for interest value (local)
Source:  from Cit/UX dist unless (local) pirmann@demigod.rutgers.edu
Change History:
01/08/93 checked all opens/closes
01/08/93 getline: ^U now acts as a kill-line char
*/

#include <fcntl.h>
#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/signal.h>
#ifdef SUNOS
#include <termio.h>
#else
#include <sgtty.h>
#endif
#include "citadel.h"

extern int curr_rm;
extern long timetoday;
extern user_type usersupp;
extern char temp[];
extern char *axdefs[8];

int eopen(name,mode)
     char *name;
     int mode; 
{
  int ret;
  ret=open(name,mode);
  if (ret<0) 
    {
      fprintf(stderr,"Cannot open file '%s', mode=%d\n",name,mode);
      interr(1);
    }
  return(ret);
}

int pwcrypt(text,code)
     char text[];
     int code; 
{
  int a;
  for (a=0; a<strlen(text); ++a) 
    text[a]=(text[a]^(((code|128)^a)&0xFF));
  return(0);
}

int room_prompt(qrptr)	/* return proper room prompt character */
     struct quickroom *qrptr; 
{
  int a;
  a='>'; 
  if ((qrptr->QRflags)&QR_DIRECTORY) 
    a=']';
  if ((a==']')&&((qrptr->QRflags)&QR_NETWORK)) 
    a='}';
  if ((a=='>')&&((qrptr->QRflags)&QR_NETWORK)) 
    a=')';
  return(a);
}

getline(string,lim)	/* Gets a line from the terminal */
     char string[];	/* Pointer to string buffer */
     int lim;		/* Maximum length - if negative, no-show */
{
  int a,b; 
  char flag;
  flag=0;
  
  if (lim<0) 
    { 
      lim=(0-lim); 
      flag=1; 
    }
  strcpy(string,"");
 GLA:
  a=inkey();
  a=(a&127);
  if (a==27)
    {
      a = 32; goto GLA;
    }
  if ((a==8)&&(strlen(string)==0))  /* backspace at beginning of line */
    goto GLA;
  if ((a==21) && (strlen(string)==0)) /* ^U at beginning of line */
    goto GLA;
  if (a==21)  /* ^U someplace else on line */
    {
      back (strlen(string));
      strcpy (string, "");    /* clear the string buffer */
      goto GLA;
    }
  if ((a!=13)&&(a!=8)&&(strlen(string)==lim))  
    goto GLA;
  if ((a==8)&&(string[0]!=0)) 
    {
      string[strlen(string)-1]=0;
      putc(8,stdout); 
      putc(32,stdout); 
      putc(8,stdout); 
      goto GLA; 
    }
  if ((a==13)||(a==10)) 
    {
      putc(13,stdout);
      putc(10,stdout); 
      return(0); 
    }
  b=strlen(string);
  string[b]=a;
  string[b+1]=0;
  if (flag==0)
    putc(a,stdout);
  if (flag==1)
    putc('*',stdout);
  goto GLA;
}

aide_message(text) 			/* post a message in Aide> */
     char *text; 
{
  long now;
  FILE *fp;
  int hold_rm;

  hold_rm=curr_rm;
  curr_rm=2; 
  gotocurr();
  time(&now);
  fp=fopen(temp,"wb"); 
  {
    if (fp==NULL) 
      interr(92);
    putc(255,fp);
    putc(MES_NORMAL,fp);
    putc(0,fp);
    fprintf(fp,"Psysop"); putc(0,fp);
    fprintf(fp,"T%ld",now); putc(0,fp);
    fprintf(fp,"APhantom Citadel"); putc(0,fp);
    fprintf(fp,"OAide"); putc(0,fp);
    fprintf(fp,"N%s",NODENAME); 
    putc(0,fp);
    putc('M',fp);
    fprintf(fp,"%s\n",text);
    putc(0,fp);
  }
  fclose(fp);
  save_message(temp,"",1,M_LOCAL);
  curr_rm=hold_rm; 
  gotocurr();
  return(0);
}

strcase(string) /* Case-converts a string */
     char string[]; 
{
  int a,b,c;
  b=0; c=0;

  for (a=0; a<strlen(string); ++a) 
    {
      if (islower(string[a])) 
	++b;
      if (isupper(string[a])) 
	++c; 
    }
  if ((b!=0)&&(c!=0)) 
    return(0);
  for (a=0; a<strlen(string); ++a) 
    {
      string[a]=toascii(string[a]);
      string[a]=ctolower(string[a]); 
    }
  string[0]=ctoupper(string[0]);
  for (a=1; a<strlen(string); ++a) 
      if (isspace(string[a-1])) 
	string[a]=ctoupper(string[a]);
  return(0);
}



daycheck(lastday)
     int lastday;
{
  long current;
  struct tm *thiscall;

  readyerself();
  time (&current); 
  thiscall = localtime (&current);

  if (lastday != thiscall->tm_yday) {
    timetoday = 0;
    usersupp.today = 0;
  }

  if (usersupp.today < 0) {
    timetoday = 0;
    usersupp.today = 0;
  }

  writeyerself();

  return(0);
}

print_system_config()
{
  version();
  printf ("This system's nodename is        :     %s\n", NODENAME);
  printf ("This system's human name is      :     %s\n", HUMANNODE);
  printf ("Part of a Cit/UX net?            :     ");
  if (NETWORKED)
    printf ("Yes.\n");
  else
    printf ("No.\n");

  printf ("The UNIX pathname of the bbs is  :     %s\n\n", BBSDIR);
  printf ("Minimum axlevel to make rooms    :     %d (%s)\n",
	  MAKEROOM, axdefs[MAKEROOM]);
  printf ("Minimum axlevel to post in lobby :     %d (%s)\n",
	  LOBBYPOST, axdefs[LOBBYPOST]);
  printf ("Automatic roomaide assignment?   :     ");
  if (CREATAIDE) 
    printf ("Yes\n");
  else
    printf ("No\n");
  
  printf ("\nSleeping timeout                 :     %d min.\n", SLEEPING/60);
  printf ("Default user timelimit           :     %d min.\n", TIMELIM);
  printf ("Initial new user access level    :     %d (%s)\n", INITAX,
	  axdefs[INITAX]);
  printf ("Users are validated to level     :     %d (%s)\n", VALIDAX,
	  axdefs[VALIDAX]);
  if (REGISCALL)
    printf ("Users must register on call #    :     %d\n", REGISCALL);
  else
    printf ("Users are not required to register.\n");
  printf ("Unused accounts purge after      :     %d days.\n", PURGEDAY);

  printf ("\nMaximum rooms in system          :     %d\n", MAXROOMS);
  printf ("Maximum messages per room        :     %d\n", MSGSPERRM);
  printf ("Maximum mail messages per user   :     %d\n", MAILSLOTS);

  return(0);
}



