/* 
File: routines.c dependent
Desc: various routines
Source: from Cit/UX dist unless (local) pirmann@demigod.rutgers.edu
  strucmp    Compares two strings without case sensitivity 
  back       Destructive backspace
  yesno      Returns 1 for yes, 0 for no 
  get_field   Break out next null-terminated string (int files)
  getstring  Get a line of text from a file UNUSED!!!
  pattern    Searches for patn in string
  fpgetfield Break out next null-terminated string (fp files)
  increment  Used in aborting message-- counts lines printed for more (local)
  fmout2     used if more is on? (local)
  fmout      used if more is off?
  strproc    Remove bad characters from string
  externstty Set stty params for external processes (local)
  sttybbs    Set stty params for bbs
  finduser   Find a user's pos in usersupp
  alias      process alias and routing info for network-bound mail
  taboo      Tabooname routine for new user login (local)
  timecheck  Check time remaining  belongs elsewhere (local)
  timeprint  Print time remaining  belongs elsewhere (local)
  get_buffer Read input into a file buffer (local)
Change History
10/30/93 header created
*/


#include <fcntl.h>
#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/signal.h>
#include <setjmp.h>
#ifdef SUNOS
#include <termio.h>
#else
#include <sgtty.h>
#endif
#include "citadel.h"
#include "defs.h"
#include "hash.h"
#include "cctype.h"

long atol();
long lseek();
extern char *days[7];
extern char *months[12];
extern char *axdefs[8];
extern char structfile[50];
extern int curr_rm;
extern int curr_line;
extern int abort_read;
extern long timetoday, logintime;
extern user_type usersupp;

#define MORE_MSG "-- more (q:quit, any:more) --"

strucmp (st1,st2) /* Compares two strings without case sensitivity */
     char st1[],st2[]; 
{
  char aaa[100],bbb[100];
  int a;
  
  for (a=0; a<=strlen(st1); ++a)
    aaa[a]=ctolower(st1[a]);
  for (a=0; a<=strlen(st2); ++a) 
    bbb[a]=ctolower(st2[a]);
  return(strcmp(aaa,bbb));
}

back (spaces) /* Destructive backspace */
     int spaces; 
{
  int a;

  for (a=1; a<=spaces; ++a) 
    {
      putc(8,stdout);
      putc(32,stdout);
      putc(8,stdout);
    }
}

yesno()  /* Returns 1 for yes, 0 for no */
{
  int a;
  while (1) 
    {
      a=inkey(); 
      a=ctolower(a);
      if (a=='y') 
	{ 
	  printf("Yes\n"); 
	  return(1); 
	}
      if (a=='n') 
	{ 
	  printf("No\n"); 
	  return(0); 
	}
    }
}



getfield (file,string)		/* Break out next null-terminated string */
     int file; 
     char string[]; 
{
  int a,b,c;

  strcpy(string,"");
  a=0;
  do 
    {
      c=0; 
      b=read(file,&c,1);
      if (b<1) 
	{ 
	  string[a]=0; 
	  return(0); 
	}
      string[a]=c;
      ++a;
    } 
  while(c!=0); 
  return(0);
}

getstring (file,string)		/* get a line of text from a file */
     int file;                  /* ignores lines beginning with # */
     char string[]; 
{	
  int a,b,c;

  do 
    {
      strcpy(string,"");
      a=0;
      do
	{
	  c=0;
	  b=read(file,&c,1);
	  if (b<1)
	    {
	      string[a]=0; 
	      return(-1); 
	    }
	  string[a]=c;
	  ++a;
	}
      while(c!=10);
      string[a-1]=0;
    } 
  while(string[0]=='#');
  return(strlen(string));
}

pattern (search,patn)	/* Searches for patn in search string */
     char search[];
     char patn[];
{
  int a,b;

  for (a=0; a<strlen(search); ++a)
    {	
      b=strncmp(&search[a],patn,strlen(patn));
      if (b==0) 
	return(b);
    }
  return(1);
}

fpgetfield (fp,string)	/* level-2 break out next null-terminated string */
     FILE *fp;
     char string[];
{
  int a,b;

  strcpy(string,"");
  a=0;
  do 
    {
      b=getc(fp);
      if (b<1) 
	{ 
	  string[a]=0;
	  return(0); 
	}
      string[a]=b;
      ++a;
    } 
  while(b!=0);
  return(0);
}


/* increment():  Returns 1 and sets abort_read to true
                 if the reader wants to abort this message
                 returns 0 otherwise. */


int increment(l)
     int *l;
{
  int c;
  
  if (usersupp.flags&US_PAUSE && (++curr_line >= usersupp.screenlength-2) 
      && (usersupp.screenlength > 5)) /* set minimum length */
    { 
      printf(MORE_MSG);
      c = ctolower(getchar());
      back (strlen(MORE_MSG));
      if ( (c == 'q') || (c == 's') )
	{
	  curr_line = 1;
	  if (usersupp.flags&US_NOPROMPT)
	    abort_read=1;
	  return(1);
	}
      else
	if (c != 10)
	  curr_line = 1;
    }
  return(0);
}

fmout2(width,fp)
     int width;
     FILE *fp;
{
  int a,b,c,real,old=0,l;
  char aaa[140];
	
  l = 1;
  strcpy(aaa,""); 
  old=255;
  c=1;            /* c is the current pos */
 FMTA2:	
  old=real; 
  a=getc(fp); 
  real=a;
  if (a<=0) 
    goto FMTEND2;
	
  if ( ((a==13)||(a==10)) && (old!=13) && (old!=10) ) 
    a=32;
  if ( ((old==13)||(old==10)) && (isspace(real)) ) 
    {
      printf("\n"); 
      if (increment()) 
	goto FMTEND2;
      c=1; 
    }
  if (a>126) 
    goto FMTA2;
  if (a>32) 
    {
      if ( ((strlen(aaa)+c)>(width-5)) && (strlen(aaa)>(width-5)) )
	{ 
	  printf("\n%s",aaa); 
	  if (increment()) 
	    goto FMTEND2;
	  c=strlen(aaa); 
	  aaa[0]=0; 
	}
      b=strlen(aaa); 
      aaa[b]=a; 
      aaa[b+1]=0; 
    }
  if (a==32)
    {
      if ((strlen(aaa)+c)>(width-5)) 
	{
	  printf("\n");
	  if (increment()) 
	    goto FMTEND2;
	  c=1;
	}
      printf("%s ",aaa); 
      ++c; 
      c=c+strlen(aaa);
      strcpy(aaa,""); 
      goto FMTA2; 
    }
  if ((a==13)||(a==10)) 
    {
      printf("%s\n",aaa);
      if (increment()) 
	goto FMTEND2;
      c=1;
      strcpy(aaa,""); 
      goto FMTA2; 
    }
  goto FMTA2;

 FMTEND2: 
  printf("\n");
  increment ();
  return(0);
}


fmout (width,fp)
     int width;
     FILE *fp;
{
  int a,b,c,real,old;
  char aaa[140];
	
  strcpy(aaa,"");
  old=255;
  c=1; /* c is the current pos */
 FMTA:	
  old=real;
  a=getc(fp); 
  real=a;
  if (a<=0) goto FMTEND;
  
  if ( ((a==13)||(a==10)) && (old!=13) && (old!=10) ) a=32;
  if ( ((old==13)||(old==10)) && (isspace(real)) ) 
    {
      printf("\n");
      c=1; 
    }
  if (a>126) 
    goto FMTA;
  if (a>32) 
    {
      if ( ((strlen(aaa)+c)>(width-5)) && (strlen(aaa)>(width-5)) )
	{
	  printf("\n%s",aaa); 
	  c=strlen(aaa); 
	  aaa[0]=0; 
	}
      b=strlen(aaa);
      aaa[b]=a;
      aaa[b+1]=0; 
    }
  if (a==32) 
    {
      if ((strlen(aaa)+c)>(width-5)) 
	{ 
	  printf("\n");
	  c=1;
	}
      printf("%s ",aaa); 
      ++c; 
      c=c+strlen(aaa);
      strcpy(aaa,"");
      goto FMTA; 
    }
  if ((a==13)||(a==10)) 
    {
      printf("%s\n",aaa);
      c=1;
      strcpy(aaa,""); 
      goto FMTA; 
    }
  goto FMTA;
  
 FMTEND:	
  printf("\n");
  return(0);
}

strproc(string)
     char string[];
{
  int a;
  char aaa[100];
  char bbb[5];

  strcpy(aaa,string);
  if (string[0]==0) 
    return(0);

  /* Convert non-printable characters to blanks */
  for (a=0; a<strlen(aaa); ++a) 
    {
      if (aaa[a]<32) 
	aaa[a]=32;
      if (aaa[a]>126) 
	aaa[a]=32; 
    }

/* Remove leading and trailing blanks */
  /* while(aaa[0]<33) */
  while(isspace(aaa[0]))
    strcpy(aaa,&aaa[1]);
  /* while(aaa[strlen(aaa)-1]<33)  */
  while(isspace(aaa[strlen(aaa)-1]))
    aaa[strlen(aaa)-1]=0;

  /* Remove double blanks */
  bbb[1]=0;
  strcpy(string,"");
  for (a=0; a<strlen(aaa); ++a) 
    {
      if ((aaa[a]==32)&&(aaa[a+1]==32)) 
	goto PSSKP;
      bbb[0]=aaa[a];
      strcat(string,bbb);
    PSSKP:
      bbb[1]=0;
    }

  /* remove characters which would interfere with the network */
  for (a=0; a<strlen(aaa); ++a) 
    {
      if (aaa[a]=='!') 
	strcpy(&aaa[a],&aaa[a+1]);
      if (aaa[a]=='@')
	strcpy(&aaa[a],&aaa[a+1]);
      if (aaa[a]=='_') 
	strcpy(&aaa[a],&aaa[a+1]);
      if (aaa[a]==',') 
	strcpy(&aaa[a],&aaa[a+1]);
    }
  return(0);
}

/* needed to set terminal parameters for things not controlled by
   citadel, like shell, subsystem, info system, etc */

externstty()        
{

#ifdef SUNOS
  struct termio live;

  ioctl(0, TCGETA, &live);
  live.c_iflag=live.c_iflag|ICRNL;
  ioctl(0, TCSETA, &live);
#endif

  return(0);
}

sttybbs(sflag) 
     int sflag;
{
#ifdef SUNOS
  struct termio live;

  ioctl(0,TCGETA,&live);
  live.c_iflag=ISTRIP|IXON|IXANY|ICRNL;
  live.c_oflag=OPOST|ONLCR;
  live.c_lflag=NOFLSH;
  if (sflag==1) live.c_lflag=ISIG|NOFLSH;
  live.c_line=0;
  live.c_cc[0]=15;
  live.c_cc[1]=3;
  live.c_cc[2]=8;
  live.c_cc[3]=24;
  live.c_cc[4]=1;
  live.c_cc[5]=255;
  live.c_cc[6]=0;
  live.c_cc[7]=0;
  ioctl(0,TCSETA,&live);
#else
  struct sgttyb live;

  gtty (0, &live);
  live.sg_flags |= CBREAK;
  live.sg_flags |= CRMOD;
  live.sg_flags |= NL1;
  live.sg_flags &= ~ECHO;
  if (sflag==1) live.sg_flags |= NOFLSH;
  stty (0, &live);
#endif

  return(0);
}

long finduser(file,name)
     int file;
     char *name; 
{
  FILE *fp;
  int uh,fh;
  long pp=0L;

  uh=hash(name);
  fp=fopen("hashtab","r");
  if (fp==NULL)
    interr(96);
  while(fread(&fh,sizeof(int),1,fp)>0) 
    {
      if (uh==fh) 
	{
	  lseek(file,pp,0);
	  fclose (fp); 
	  return(pp);
	} 
      pp = pp + (long)sizeof(user_type);
    }
  fclose(fp);
  return(-1L);
}

alias(name)		/* process alias and routing info for mail */
     char name[]; 
{
  FILE *fp;
  int a,b,file;
  char aaa[300],bbb[300];
	
  fp=fopen("network/mail.aliases","r");
  if (fp==NULL) 
    return(2);
 GNA:	
  strcpy(aaa,""); 
  strcpy(bbb,"");
  do 
    {
      a=getc(fp);
      if (a==',') a=0;
      if (a>0) 
	{ 
	  b=strlen(aaa); 
	  aaa[b]=a;
	  aaa[b+1]=0; 
	}
    }
  while(a>0);
  do
    {
      a=getc(fp);
      if (a==10) 
	a=0;
      if (a>0) 
	{ 
	  b=strlen(bbb); 
	  bbb[b]=a; 
	  bbb[b+1]=0; 
	}
    }
  while(a>0);
  if (a<0) 
    {
      fclose(fp);
      goto DETYPE;
    }
  if (strucmp(name,aaa)) 
    goto GNA;
  fclose(fp);
  strcpy(name,bbb);
  printf("*** Mail is being forwarded to %s\n",name);

 DETYPE:	/* determine local or remote type, see citadel.h */
  for (a=0; a<strlen(name); ++a) 
    if (name[a]=='!') 
      return(M_UUCP);
  for (a=0; a<strlen(name); ++a)
    if (name[a]=='@')
      for (b=a; b<strlen(name); ++b)
	if (name[b]=='.') 
	  return(M_UUCP);
  b=0;
  for (a=0; a<strlen(name); ++a) 
    if (name[a]=='@') 
      ++b;
  if (b>1) 
    {
      printf("Too many @'s in address\n");
      return(M_ERROR);
    }
  if (b==1) 
    {
      for (a=0; a<strlen(name); ++a)
	if (name[a]=='@') 
	  strcpy(bbb,&name[a+1]);
      while (bbb[0]==32) 
	strcpy(bbb,&bbb[1]);
      file=open("network/mail.sysinfo",O_RDONLY);
    GETSN:
      do 
	{
	  a=getstring(file,aaa);
	}
      while ((a>=0)&&(strucmp(aaa,bbb)));
      a=getstring(file,aaa);
      if (!strncmp(aaa,"use ",4)) 
	{
	  strcpy(bbb,&aaa[4]);
	  goto GETSN;
	}
      close(file);
      if (!strncmp(aaa,"uum",3)) 
	{
	  strcpy(bbb,name);
	  for (a=0; a<strlen(bbb); ++a) 
	    {
	      if (bbb[a]=='@') 
		bbb[a]=0;
	      if (bbb[a]==' ') 
		bbb[a]='_';
	    }
	  while(bbb[strlen(bbb)-1]=='_') 
	    bbb[strlen(bbb)-1]=0;
	  sprintf(name,&aaa[4],bbb);
	  return(M_UUCP);
	}
      if (!strncmp(aaa,"bin",3)) 
	{
	  strcpy(aaa,name);
	  strcpy(bbb,name);
	  while (aaa[strlen(aaa)-1]!='@')
	    aaa[strlen(aaa)-1]=0;
	  aaa[strlen(aaa)-1]=0;
	  while (aaa[strlen(aaa)-1]==' ') 
	    aaa[strlen(aaa)-1]=0;
	  while (bbb[0]!='@')
	    strcpy(bbb,&bbb[1]);
	  strcpy(bbb,&bbb[1]);
	  while (bbb[0]==' ')
	    strcpy(bbb,&bbb[1]);
	  sprintf(name,"%s @%s",aaa,bbb);
	  return(M_BINARY);
	}
      printf("Error in network/mail.sysinfo file\n");
      return(M_ERROR);
    }
  return(M_LOCAL);
}


/* tabooname routine added locally */
taboo(iname)
     char iname[];
{
  FILE *fopen(),*fp;
  char aaa[30],bbb[30];
  int a,taboo;

  if ((fp = fopen("tabooname","r")) == NULL) 
    return(0);
  taboo=0;
  for (a=0; a<=strlen(iname); ++a) 
    aaa[a]=ctolower(iname[a]);
  while (fscanf(fp,"%s",bbb) != EOF) 
    {
      if (bbb[0]=='@') break;
      if (pattern(aaa,bbb)==0) taboo++;
    }
  fclose(fp);
  return(taboo);
}


int timecheck () 
{ 
  long curtime; 
  long timeon;

  readyerself ();
  if ((usersupp.timelimit == 0)||(usersupp.axlevel >= 6)) 
    return (0);

  time (&curtime);
  timeon = (((long)curtime - (long)logintime) / 60 ) + timetoday;
  
  usersupp.today=timeon;
  writeyerself();
  
  if ((int) timeon > usersupp.timelimit)     /* exceeded timelimit */
    {
      printf ("\nYou have exceeded your daily time limit.\n");
      printf ("Call back tomorrow.\n");
      return (1);
    }
  if (usersupp.timelimit - (int) timeon < 15)   /* < 15 minutes left */
    {
      printf ("\nYou have %d minutes left.\n\n", 
	      usersupp.timelimit - (int) timeon);
      return (0);
    }
  return(0);
}

int timeprint () 
{ 
  long curtime; 
  long timecall, timeon;
  struct tm *ft, *ct;
  readyerself ();

  time (&curtime);
  timecall = (( (long) curtime - (long) logintime) / 60 );
  timeon = timecall + timetoday; 

  ft = localtime (&curtime);
  printf ("The current time is: %2.2d/%2.2d/%2.2d %2.2d:%2.2d:%2.2d.\n", 
	  ft->tm_mon+1, ft->tm_mday, ft->tm_year, 
	  ft->tm_hour, ft->tm_min, ft->tm_sec);

  ct = localtime (&logintime);
  printf ("You logged in at   : %2.2d/%2.2d/%2.2d %2.2d:%2.2d:%2.2d.\n\n", 
	  ct->tm_mon+1, ct->tm_mday, ct->tm_year, 
	  ct->tm_hour, ct->tm_min, ct->tm_sec);

  printf ("You have been on   : %dh %dm this call\n", timecall/60, 
	  timecall % 60);
  printf ("You have been on   : %dh %dm total today\n\n", timeon/60, 
	  timeon % 60);

  if (usersupp.timelimit == 0)
    printf ("You have no time limit.\n");
  else 
    if (usersupp.axlevel >= 6)
      printf ("Time limits are not enforced for aides.\n");
    else 
      printf ("\nTime remaining     : %dh %dm\n",
	      (usersupp.timelimit - timeon)/60, 
	      (usersupp.timelimit - timeon)%60);
  return (0);
}

/* returns -1 for empty buffer, 0 otherwise */
get_buffer(buf, limit)
char buf[];
int limit;
{
  FILE *fp;
  int counter=1;
  char descline[78];

  fp = fopen(buf,"w");
  if (fp == NULL)
    interr (68);
  else
    do
      {
	printf ("%2.2d> ", counter);
	getline (descline, 75);
	fprintf (fp,"%s\n", descline);
	counter++;
	if ((limit > 0) && (counter == limit))
	  printf ("One more line!\n");
      } while ((strlen(descline) != 0) && (counter <= limit));
  fclose (fp);

  if ((counter == 2) && (strlen(descline)==0))
    return (-1);   /* blank buffer */
  else 
    return (0);
}
  

