/* 
File: rooms.c
Desc: room routines
   knrooms:        list known rooms
   listzrooms:     list zapped rooms
   ungoto          back up to last room visited
   invite          invite a user to a private room
   kickout         remove a user from a private room
   killroom        remove a room from the system
   forget          zap a room
   create_room     create a room
   gotocurr        go to current room
   whoknows        who knows room
   room_desc:      enter room description (local)
   print_desc:     print room description (local)
   print_type:     show room type info (local)
   show_room_flags Read quickroom.QRflags and explain
Source: from Cit/UX dist unless (local) by pirmann@demigod.rutgers.edu

Change History:
12/29/92 moved download and roomdir to updown.c
12/29/93 updated interrs
01/09/93 checked all opens/closes
10/30/93 moved editroom to eroom.c; removed sysopedit and ask_edit_q's
*/

#include "cunistd.h"
#include <fcntl.h>
#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include <sys/file.h>
#include <setjmp.h>
#include "citadel.h"
#include "defs.h"

extern int curr_rm;
extern int ugnum;
extern long uglsn;
extern struct quickroom quickroom;
extern user_type usersupp;
extern struct fullroom fullroom;
extern char logmsg[];
extern char skipping[];

storeug() 	/* store <u>ngoto information */
{
  ugnum=curr_rm;
  uglsn=usersupp.lastseen[curr_rm];
  return(0);
}

/* this cannot handle zapped rooms unless you do some fancy
special-case handling! Blah!  Doesn't look like this is any better
than the old way, really...*/

knrooms(user_type *USgiven, int function) 
{
  int a=0, b=1, c=0, d=0, file=0, axl=0;
  struct quickroom QRscratch;

  axl = USgiven->axlevel;

  file=open("./quickroom",O_RDONLY); 
  if (file<0) 
    interr (57);

  switch (function)
    {
    case RM_KNOWN:  printf("\n   Rooms with unread messages:\n");break;
    case RM_NOUNR:  printf("\n   No unseen messages in:\n"); break;
    default: break;
    }

  for (a=0; a<MAXROOMS; ++a) 
    {
      c=read(file,&QRscratch,sizeof(struct quickroom));
      if (c<1) 
	interr(58);

      if (a==1) 
	QRscratch.QRhighest=USgiven->mailnum[MAILSLOTS-1];

      if (function == RM_KNOWN)
	d=b+strlen(QRscratch.QRname)+3;

      /* match all these conditions no matter what function */
      if ((QRscratch.QRflags & QR_INUSE) 
	  && ((a!=2) || (axl>=AX_AIDE))
	  && (QRscratch.QRgen != (USgiven->forget[a]))
	  && ((!(QRscratch.QRflags&QR_PREFONLY)) || (axl >= AX_PREF))
	  && ((!(QRscratch.QRflags&QR_PRIVATE)) || (axl>=AX_AIDE)
	      || (QRscratch.QRgen==(USgiven->generation[a]))))

	/* we're good to go */
	switch (function)
	  {
	  case RM_KNOWN:
	    if (QRscratch.QRhighest> (USgiven->lastseen[a]))
	      {
		if (d>=(USgiven->screenwidth)) 
		  {
		    printf("\n"); 
		    b=1; 
		  }
		c=room_prompt(&QRscratch);
		printf("%s%c  ",QRscratch.QRname,c);
		b=b+strlen(QRscratch.QRname)+3;
	      }
	    break;
	  case RM_NOUNR:
	    if (QRscratch.QRhighest<=USgiven->lastseen[a])
	      {
		d=strlen(QRscratch.QRname)+3+b;
		if (d>=(USgiven->screenwidth)) 
		  {
		    printf("\n");
		    b=1; 
		  }
		c=room_prompt(&QRscratch);
		printf("%s%c  ",QRscratch.QRname,c);
		b=b+strlen(QRscratch.QRname)+3;
	      }
	    break;
	  } /* end switch */
    } /* end for */

  if (b!=1) printf("\n");
    close(file);
  return(0);
}

listzrooms(user_type *USgiven)		/* list public forgotten rooms */
{
  int a,b,c,d,file;
  struct quickroom QRscratch;

  b=1;
  printf("\n   Forgotten public rooms:\n");
  file=open("./quickroom",O_RDONLY); 
  if (file<0) 
    interr (60);
  for (a=0; a<MAXROOMS; ++a) 
    {
      c=read(file,&QRscratch,sizeof(struct quickroom));
      if (c<1)
	interr(61);
      if (a==1)
	QRscratch.QRhighest=USgiven->mailnum[MAILSLOTS-1];

      if ((QRscratch.QRflags & QR_INUSE)
	  && ( (a!=2) || ((USgiven->axlevel)>=AX_AIDE))
	  && (QRscratch.QRgen == (USgiven->forget[a]) )
	  && (	((QRscratch.QRflags&QR_PRIVATE)==0)
	      ||	((USgiven->axlevel)>=AX_AIDE)
	      ||	(QRscratch.QRgen==(USgiven->generation[a])))) 
	{
	  d=b+strlen(QRscratch.QRname)+3;
	  if (d>=(USgiven->screenwidth)) 
	    {
	      printf("\n");
	      b=1; 
	    }
	  c=room_prompt(&QRscratch);
	  printf("%s%c  ",QRscratch.QRname,c);
	  b=b+strlen(QRscratch.QRname)+3;
	}
    } 
  if (b!=1) 
    printf("\n");
  close(file);
  return(0);
}

ungoto() 
{
  if (ugnum==(-1)) 
    return(0);
  readyerself();
  curr_rm=ugnum;
  gotocurr();
  usersupp.lastseen[curr_rm]=uglsn;
  writeyerself();
  return(0);
}

invite() 	/* add a user to a private room */
{
  char aaa[31];
  int file,a;
  long aa;
  user_type USscratch;

  if ((quickroom.QRflags&QR_PRIVATE)==0) 
    {
      printf("Not a private room.\n");
      return(0);
    }
  printf("Name of user? ");
  getline(aaa,30);
  if (aaa[0]==0) 
    return(0);

  file=open("usersupp",O_RDWR);
  if (file<0)
    interr(38);

  aa=finduser(file,aaa);

  if (aa!=(-1L)) 
    {
      read(file,&USscratch,sizeof(user_type));
      /* must lseek before locking! */
      lseek(file,aa, SEEK_SET);
      /* check to see if the file is locked by someone else */
      while (lockf (file, F_TEST, sizeof (user_type)) == -1)
	sleep (1);
      /* keep trying till we get a lock */
      while (lockf (file, F_LOCK, sizeof (user_type)) < 0)
	sleep (1);
      USscratch.generation[curr_rm]=quickroom.QRgen;
      USscratch.forget[curr_rm]=(-1);
      a=write(file,&USscratch,sizeof(user_type));
      if (a < 0)
	interr (39);
      sprintf (logmsg, "INVITE:%s invited %s to %s", usersupp.fullname,
	       USscratch.fullname, quickroom.QRname);
      intlog (logmsg);
      lseek (file, aa, SEEK_SET); /* seek back */
      lockf (file, F_ULOCK, sizeof (user_type)); /* unlock it */
    }
  else	
    printf("No such user.\n");
  close(file);
  return(0);
}

kickout(char *user, int room) 	/* kick a user out of a private room */
{
  int file,a;
  char aaa[100];
  long aa;
  user_type USscratch;
  struct quickroom Quickscratch;

  loadqroom (room, &Quickscratch);

  if ((Quickscratch.QRflags&QR_PRIVATE)==0) 
    {
      printf("Not a private room.\n");
      return(0);
    }
  if (user[0] == 0)   /* passed a null name */
    {
      printf("Name of user? ");
      getline(aaa,30);
    }
  else
    strcpy(aaa,user);
  file=open("usersupp",O_RDWR);
  if (file<0) 
    interr(40);

  aa=finduser(file,aaa);

  if (aa!=(-1L)) 
    {
      read(file,&USscratch,sizeof(user_type));
      /* lseek first */
      lseek(file,aa,SEEK_SET);
      /* check to see if the file is locked by someone else */
      while (lockf (file, F_TEST, sizeof (user_type)) == -1)
	sleep (1);
      while (lockf (file, F_LOCK, sizeof (user_type)) < 0)
	sleep (1);

      USscratch.generation[room]=(-1);
      a=write(file,&USscratch,sizeof(user_type));
      if (a < 0)
	interr (41);
      sprintf (logmsg, "KICKOUT: %s kicked %s out of %s", usersupp.fullname,
	       USscratch.fullname, Quickscratch.QRname);
      intlog (logmsg);
      lseek (file, aa, SEEK_SET);
      lockf (file, F_ULOCK, sizeof (user_type));
    }
  else
    printf("No such user.\n");
  close(file);
  return(0);
}

killroom() 	/* aide command: kill the current room */
{
  int file,a;
  long aa;
  char aaa[100];
  char killrm [50];     /* for removing room desc */
  char temprmname[50];
  struct msgmain mmain;
  FILE *fp;
  
  if (curr_rm<3) 
    { 
      printf("Can't kill this room.\n"); 
      return(0); 
    }

  printf("Are you sure you want to kill this room? ");
  if (yesno()==0) 
    return(0);
  file=open("quickroom",O_RDWR); 
  if (file<0)
    interr(42);
  while (flock (file, LOCK_EX|LOCK_NB) < 0)
    sleep (1);/* get a lock */
  
  printf ("Resetting quickroom... ");

  aa=(long)curr_rm*sizeof(struct quickroom);
  lseek(file,aa,0);
  quickroom.QRflags=0;
  strcpy (temprmname, quickroom.QRname);
  strcpy (quickroom.QRname, "");
  strcpy (quickroom.QRpasswd, "");
  strcpy (quickroom.QRaidename, "");
  quickroom.QRroomaide=0L;
  a=write(file,&quickroom,sizeof(struct quickroom));
  if (a < 0)
    interr (43);

  flock (file, LOCK_UN);
  close(file);

  sprintf (killrm, "msgmains/msgmain.%d", curr_rm);
  fp=fopen (killrm, "wb");
  printf ("Killing msgmain...");
  if (curr_rm != 1)
    for (aa=0; aa<=(MM_FILELEN+100); ++aa) 
      putc(0,fp);	
  else 
    for (aa=0;aa<=(MM_MAIL+100);++aa) putc(0,fp);
  fclose(fp);

  mmain.MMlowest=1L;
  mmain.MMhighest=1L;
  mmain.MMcurpos=0L;
  mmain.MMflags=0;

  sprintf (killrm, "structures/MMstructure.%d", curr_rm);
  printf ("\nKilling MMstructure...");
  fp = fopen (killrm, "wb");
  fwrite (&mmain, sizeof (struct msgmain), 1, fp);
  fclose (fp);

  printf ("Killing room desc...\n");
  sprintf(killrm,"/descs/rm%d",curr_rm);
  unlink (killrm);
  printf("Room description for this room has been removed.\n");
  sprintf(aaa,"%s%c killed by %s",
	  temprmname,room_prompt(&quickroom),usersupp.fullname);
  aide_message(aaa); intlog (aaa);
  curr_rm=0;		/* then goto the lobby */
  gotocurr();
  return(0);
}

forget() 	/* forget the current room */
{
  if (curr_rm<3) 
    {
      printf("Cannot forget this room.\n");
      return(0);
    }
  if (usersupp.axlevel == AX_AIDE)
    {
      printf("Aides cannot forget rooms.\n"); 
      return(0); 
    }
  printf("Are you sure you want to forget this room? ");
  if (yesno()==0) 
    return(0);
  readyerself();
  usersupp.forget[curr_rm]=quickroom.QRgen;
  usersupp.generation[curr_rm]=(-1);
  writeyerself();
  curr_rm=0;		/* then goto the lobby */
  gotocurr();
  return(0);
}

create_room() 
{
  int a,b,c,d,file;
  char aaa[100];
  long bb,cc;
  struct quickroom QRscratch;
  bool newroom = TRUE;

  enter_btmp ("[Create Room]");
  if (usersupp.axlevel < MAKEROOM) 
    {
      printf("You need higher access to create rooms.\n");
      return(0);
    }

  /* must do name stuff here */
  printf("Name for new room? ");
  getline(aaa,19);
  if (strlen(aaa)==0) 
    return(0);

  aaa[19]=0;
  file=open("quickroom",O_RDONLY);
  if (file<0)
    interr(62);
  b=0;
  for (a=0; a<MAXROOMS; ++a) 
    {
      c=read(file,&QRscratch,sizeof(struct quickroom));
      if (c<1) 
	interr(63);
      if ( (QRscratch.QRflags & QR_INUSE)
	  && (!strucmp(QRscratch.QRname,aaa)) ) 
	b=1; 
    }
  close(file);
  if (b==1) 
    {
      printf("'%s' already exists.\n",aaa);
      return(0); 
    }
  bb=(-1L);	
  file=open("quickroom",O_RDONLY);
  if (file<0)
    interr(64);
  for (a=0; a<MAXROOMS; ++a) 
    {
      cc=lseek(file,0L,1);
      c=read(file,&QRscratch,sizeof(struct quickroom));
      if (c<1)
	interr(65);
      if (((QRscratch.QRflags&QR_INUSE)==0)&&(bb==(-1L)))
	bb=cc;
    }
  close(file);
  if (bb==(-1L)) 
    {
      printf("No space for additional rooms.\n");
      return(0);
    }

  /* name is good, there's space, lets go */
/*  ask_edit_questions(&QRscratch, &newroom, &usersupp);*/

  printf("\nInstall it? (y/n) : ");
  a=yesno();
  if (a==0)
    return(0);

  curr_rm=(int)(bb/sizeof(struct quickroom)); 
  file=open("quickroom",O_RDWR);
  if (file<0)
    interr(66);
  while (flock (file, LOCK_EX|LOCK_NB) < 0)
    sleep (1);

  strcpy(quickroom.QRname,aaa);

  lseek(file,bb,0);
  d=write(file,&quickroom,sizeof(struct quickroom));
  if (d < 0)
    interr (69);
  flock (file, LOCK_UN);
  close(file);

  /* Initialize a blank fullroom structure */
  for (a=0; a<MSGSPERRM; ++a) 
    {
      fullroom.FRnum[a]=0L;
      fullroom.FRpos[a]=0L;
    }

  sprintf(aaa,"./rooms/fullrm%d",curr_rm);
  file=open(aaa,O_RDWR);
  if (file<0)
    interr(70);
  while (flock (file, LOCK_EX|LOCK_NB) < 0)
    sleep (1);
  write(file,&fullroom,sizeof(struct fullroom));
  if (d < 0)
    interr (71);
  flock (file, LOCK_UN);
  close(file);
  gotocurr();

  strcpy(aaa,quickroom.QRname); 
  strcat(aaa,"> created by ");
  strcat(aaa,usersupp.fullname);
  if (quickroom.QRflags&QR_PRIVATE)
    strcat(aaa," [private]");
  if (quickroom.QRflags&QR_GUESSNAME)
    strcat(aaa,"[guessname] ");
  aide_message(aaa); intlog (aaa);
  editroom(&usersupp, curr_rm);
  room_desc ();
  return(0);
}

gotocurr() /* goto room currently in global variable curr_rm */
{
  int file,d; 
  char aaa[100];

  file=open("quickroom",O_RDONLY);
  if (file<0)
    interr(74);
  lseek(file,(long)(curr_rm*sizeof(struct quickroom)),0);
  d=read(file,&quickroom,sizeof(struct quickroom));
  if (d<1)
    interr(75);
  close(file);
  if (curr_rm==1)
    {
      readmail();
      return(0);
    }
  sprintf(aaa,"./rooms/fullrm%d",curr_rm);
  file=open(aaa,O_RDONLY);
  if (file<0)
    interr(76);
  d=read(file,&fullroom,sizeof(struct fullroom));
  if (d<1)
    interr(77);
  close(file);
  return(0);
}

whoknows() 
{
  user_type temp;
  int file;
  
  file=open("usersupp",O_RDONLY);
  if (file<0)
    interr (99);
  while(read(file,&temp,sizeof(user_type))>0)
    if ((quickroom.QRflags & QR_INUSE)
	&& ( (curr_rm!=2) || (temp.axlevel>=AX_AIDE) )
	&& (quickroom.QRgen != (temp.forget[curr_rm]) )
	&& (	((quickroom.QRflags&QR_PREFONLY)==0)
	    ||	(temp.axlevel>=AX_PREF))
	&& (	((quickroom.QRflags&QR_PRIVATE)==0)
	    ||	(temp.axlevel>=AX_AIDE)
	    ||	(quickroom.QRgen==(temp.generation[curr_rm]))	))
      printf("%s\n",temp.fullname);
  close(file);
  return(0);
}


room_desc ()
{
  char rmdesc[50];
  int a, file;

  enter_btmp("[Enter Roomdesc]");

  if (quickroom.QRflags & QR_DESCRIBED)
    print_desc();
  else
    printf ("This room has no description.\n\n");

  printf ("Are you sure you want to modify this room's description? ");
  if (!yesno())
    {
      printf ("Room description not modified.\n");
      return (-1);
    }

  printf ("\nEnter room description text [75 character lines].\n");
  printf ("There is no editing functionality so type carefully!\n");
  printf ("Press return on a blank line to end.\n\n");

  sprintf (rmdesc, "descs/rm%d", curr_rm);
  a=get_buffer (rmdesc, DESCMAX);

  if (a == (-1))
    {
      printf ("This description is now blank.\n");
      sprintf (logmsg, "%s removed description for %s", usersupp.fullname,
	   quickroom.QRname);
      unlink (rmdesc);
      quickroom.QRflags = (quickroom.QRflags ^QR_DESCRIBED);
    }
  else
    {
      quickroom.QRflags= (quickroom.QRflags | QR_DESCRIBED);
      sprintf (logmsg, "%s entered a description for %s", usersupp.fullname,
	   quickroom.QRname);
    }

  intlog (logmsg);
  file = open ("quickroom", O_RDWR);
  if (file<0)
    interr(15);
  while (flock (file, LOCK_EX|LOCK_NB) < 0)
    sleep (1);
  lseek(file,(long)(curr_rm*sizeof(struct quickroom)),0);
  a=write(file,&quickroom,sizeof(struct quickroom));
  if (a<1) 
    interr(35);
  flock (file, LOCK_UN);
  close (file);

  return (0);
}

show_room_aide()
{
  if ((quickroom.QRroomaide >= 0L) && (strlen (quickroom.QRaidename) > 0))
    printf ("Room aide is currently: %s\n", quickroom.QRaidename);
}

print_desc ()
{
  char rmdesc [50];
  int file, a;

  if (curr_rm >= 5)
    show_room_aide();
/* too slow on quartz */

  printf ("Room Description for %s.\n\n", quickroom.QRname);
  sprintf(rmdesc,"descs/rm%d", curr_rm);
  if ((quickroom.QRflags & QR_DESCRIBED)==0)
    {
      printf ("There is no room description for this room.\n");
      return (-1);
    }
  if ((file = open(rmdesc, O_RDONLY)) > 0) 
    {
      close (file);
      sprintf(rmdesc, "descs/rm%d", curr_rm);
      formout (rmdesc);
      printf ("\n");
      return (0);
    }
  else 
    {
      printf ("There is no room description for this room.\n");
      return (-1);
    }
}

print_type ()
{
   int file, a;
   file = open ("quickroom", O_RDONLY);
   if (file < 0)
     interr (34);
   lseek (file, (long) (curr_rm * sizeof (struct quickroom)), 0);
   a = read (file, &quickroom, sizeof (struct quickroom));
   if (a < 1)
     interr (35);
   close (file);
   printf ("Room #%d, %s\n",curr_rm, quickroom.QRname);
   show_room_flags();
   show_room_aide();
   return(0);
 }


int loadqroom(n,scratch)                                      
int n;                                                        
struct quickroom *scratch;                                    
{                                                             
  int file;                                                   
  int d;                                                      
                                                              
  file=open("quickroom",O_RDONLY);                            
  if (file<0)                                                 
    interr (55);                                              
                                                              
  lseek(file,(long)(n * sizeof (struct quickroom)), 0);
  d=read(file,scratch,sizeof(struct quickroom));              
  close(file);                                                
  if (d<1)                                                    
    return(0);                                                
  return(1);                                                  
}                                                             


show_room_flags()
{
  printf("  This is currently a");
  if ((quickroom.QRflags&QR_PRIVATE)==0) 
    printf(" public");
  if (quickroom.QRflags&QR_PRIVATE) 
    printf(" private");
  if (quickroom.QRflags&QR_GUESSNAME) 
    printf(", guessname");
  printf(" room");
  if (quickroom.QRflags&QR_PREFONLY) 
    printf(", preferred users only");
  printf(".\n");
  if (quickroom.QRflags & QR_READONLY)
    printf ("  Read only room.\n");
  if ((quickroom.QRflags & QR_NOEDITOR)==0)
    printf ("  Editor is allowed.\n");
  if (quickroom.QRflags & QR_DESCRIBED)
    printf ("  Room described status set\n");
  else
    printf ("  Room description status not set\n");
  if (quickroom.QRflags&QR_DIRECTORY) 
    {
      printf("Directory room");
      if (quickroom.QRflags&QR_UPLOAD) 
	printf(", uploading allowed");
      if (quickroom.QRflags&QR_DOWNLOAD) 
	printf(", downloading allowed");
      if (quickroom.QRflags&QR_VISDIR) 
	printf(", visible directory");
      printf(".\nDirectory name: %s\n",quickroom.QRdirname); 
    }
  if (quickroom.QRflags&QR_ANONONLY)
    printf("Anonymous-only room.\n");
}


unread_room(user_type *usersupp)
{
  int curr_rm=0, a=0, d=0, file;
  struct quickroom QRscratch;

  /* mail comes first */
  if (usersupp->mailnum[MAILSLOTS-1]>usersupp->lastseen[1])
    return (1); /* mail is room 1 */

  file=open("quickroom",O_RDONLY);
  if (file<0) 
    interr (55);

  for (a=0; a<2; ++a) 
    /* discard the first two records */
    {
      d=read(file,&QRscratch,sizeof(struct quickroom));
      if (d<1) 
	interr(56);
    }

  for (curr_rm=2; curr_rm < MAXROOMS; curr_rm++)
    {
      /* fetch a quickroom record */
      d=read(file,&QRscratch,sizeof(struct quickroom));
      if (d<1) 
	interr(56);

      /* if the user is allowed in the room */
      if ((AllowInRoom(&QRscratch, usersupp, curr_rm))
	  /* and they didn't skip it */
	  && (skipping[curr_rm]==0)
	  /* and they didn't zap it */
	  && (QRscratch.QRgen != usersupp->forget[curr_rm]))
	{      
	  /* see if there are new messages to read */
	  if (check_messages(&QRscratch,usersupp,curr_rm))
	    /* if so, we got one */
	    { 
	      close (file);
	      return (curr_rm);
	    }
	  /* if there are no messages or if we aren't allowed, repeat */
	}
    }
  close (file);
  /* if we got here there are no rooms with new messages, go to Lobby> */
  return (0);
}

/*----------------------------------------------------------------------*/

bool check_messages(struct quickroom *room, user_type *user, int a)
{
  printf ("QRhigh: %d, LAST: %d, QRgen: %d, gen: %d\n\n",
	  room->QRhighest, user->lastseen[a],
	  room->QRgen, user->generation[a]);

  if (room->QRhighest > user->lastseen[a])
    return (TRUE);
  else
    return (FALSE);
}

/* determimes whether a user is allowed or wants to be in a certain room */
int AllowInRoom(struct quickroom *room, user_type *user, int a, int match)
{
  if ((a==2) && (user->axlevel<AX_AIDE))
    return (0);
  else
    return (
	    /* only bother if the room is in use */
	    (room->QRflags & QR_INUSE)              

	    /* if the room is not guessname */
	    && ((!(room->QRflags & QR_GUESSNAME))
		 
		/* or user is an aide */
		|| (user->axlevel>=6)

		/* or the user typed an exact match */
		|| (match==0) 

		/* or user already knows the room */
		|| (room->QRgen==user->generation[a]))

	    /* is not a private room */
	    && ((!(room->QRflags&QR_PRIVATE))

		/* or user is an aide */
		|| (user->axlevel>=6)

		/* or if the room is also guessname and match exact */
		|| ((room->QRflags & QR_GUESSNAME) 
		    && (match==0))

		/* or user already knows the room */
		|| (room->QRgen==user->generation[a]))

	    /* room is not preferred only */
	    && ((!(room->QRflags&QR_PREFONLY))

		/* or is the user preferred? */
		|| (user->axlevel>=5))

	    ); /* end of complex return */
}


reset_lastseen()
{
  readyerself();
  printf ("Room #%d, Lastseen Message %d\n", curr_rm,
	  usersupp.lastseen[curr_rm]);
  printf ("Do you want to reset this value? ");
  if (yesno())
    {
      usersupp.lastseen[curr_rm] = 0;
      writeyerself();
    }
}
