/* 
File: register.c (dependent)
Desc: registration routines 
  entregis        - register a user with name and address
  validate        - validate new users
  dis_regis       - display registration data
Source: moved out of routines2.c, from Cit/UX distribution unless
        (local) by pirmann@demigod.rutgers.edu

Change History
01/08/93 opens/closes checked
01/26/93 removed gotos from entregis and validate
*/

#include <fcntl.h>
#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "citadel.h"
#include "cunistd.h" /* for lockf */
void dis_regis();

extern long yourpos;
extern char *axdefs[8];
extern char logmsg[];
long finduser(), find_unvalidated();
void reset_unvalidated();

entregis(user_type usersupp)	/* register a user with name and address */
{
  int file,a,b;
  char pbuf[15];
  user_type tempus,tempfoo;
  bool done = FALSE;
  FILE *fp;

  enter_btmp ("[Registration]");

  if ((usersupp.flags & US_REGIS)==0) 
    {
      fp=fopen(".register","w");
      fclose(fp);
      while (!done) 
      {
	do
	  {
	    printf("\nFULL REAL name: ");
	    getline(usersupp.RGname,29);
	    if (strlen(usersupp.RGname) == 0)
	    printf ("You don't have a real name?! Please enter your name.\n");
	  } while (strlen(usersupp.RGname) == 0);
	printf("       Address: ");
	getline(usersupp.RGaddr,24);
	printf("     City/town: ");
	getline(usersupp.RGcity,14);
	printf ("Foreign users enter Internet country code for state.\n");
	printf("         State: ");
	getline(usersupp.RGstate,2);
	printf("      ZIP code: ");
	getline(usersupp.RGzip,10);
	printf ("U.S.A. users enter phone number in form: ");
	printf ("\"908-555-1212\".\n");
	printf("  Phone number: ");
	getline(pbuf,14);
	usersupp.RGphone[0]=0;
	for (a=0; a<strlen(pbuf); ++a) 
	  if ((pbuf[a]>='0')&&(pbuf[a]<='9')) 
	    {
	      b=strlen(usersupp.RGphone);
	      usersupp.RGphone[b]=pbuf[a]; 
	      usersupp.RGphone[b+1]=0;
	    }
	printf ("Please supply email address in form ");
	printf ("user@machine.site.edu,\nif you have one.\n");
	printf (" Email address: ");
	getline (usersupp.RGemail, 40);
	printf("\n");

	printf ("*** You have entered the following:\n");
	dis_regis(&usersupp);

	printf ("\nIs this correct (y/n)? ");
	if (yesno()==1) 
	  {
	    unlink (".register");
	    done = TRUE;
	  }
      }
    }
  else
    while (!done)
      {
	printf ("\nPress enter to accept values in brackets.\n");
	printf("\nREAL name [%s]: ", usersupp.RGname);
	getline(tempus.RGname,29);
	if (strlen(tempus.RGname) !=0)
	  strcpy (usersupp.RGname, tempus.RGname);

	printf("Address [%s]: ", usersupp.RGaddr);
	getline(tempus.RGaddr,24);
	if (strlen(tempus.RGaddr) !=0)
	  strcpy (usersupp.RGaddr, tempus.RGaddr);

	printf("City/town [%s]: ", usersupp.RGcity);
	getline(tempus.RGcity,14);
	if (strlen(tempus.RGcity) !=0)      
	  strcpy (usersupp.RGcity, tempus.RGcity);

	printf("State [%s]: ", usersupp.RGstate);
	getline(tempus.RGstate,2);
	if (strlen(tempus.RGstate) !=0)
	  strcpy (usersupp.RGstate, tempus.RGstate);

	printf("ZIP code [%s]: ", usersupp.RGzip);
	getline(tempus.RGzip,10);
	if (strlen(tempus.RGzip) !=0)
	  strcpy (usersupp.RGzip, tempus.RGzip);

	printf("Phone number [%c%c%c-%c%c%c-%c%c%c%c]: ",
	       usersupp.RGphone[0],usersupp.RGphone[1],
	       usersupp.RGphone[2],usersupp.RGphone[3],
	       usersupp.RGphone[4],usersupp.RGphone[5],
	       usersupp.RGphone[6],usersupp.RGphone[7],
	       usersupp.RGphone[8],usersupp.RGphone[9]);
	getline(pbuf,14);
	if (strlen(pbuf) !=0)
	  {
	    usersupp.RGphone[0]=0;
	    for (a=0; a<strlen(pbuf); ++a) 
	      if ((pbuf[a]>='0')&&(pbuf[a]<='9')) 
		{
		  b=strlen(usersupp.RGphone);
		  usersupp.RGphone[b]=pbuf[a]; 
		  usersupp.RGphone[b+1]=0;
		}
	  }
	printf ("Email address [%s]: ", usersupp.RGemail);
	getline (tempus.RGemail, 40);
	if (strlen(tempus.RGemail) !=0)
	  strcpy (usersupp.RGemail, tempus.RGemail);
	printf("\n");

	printf ("*** You have entered the following:\n");
	dis_regis(&usersupp);

	printf ("\nIs this correct (y/n)? ");
	if (yesno()) 
	  done = TRUE;
      }

  file=open("usersupp",O_RDWR);
  if (file < 0)
    interr (91);

  lockf (file, F_LOCK, (long) sizeof (user_type));

  lseek (file, yourpos, 0);
  read (file, &tempfoo, sizeof (user_type));
  if (tempfoo.eternal != usersupp.eternal)
    yourpos = finduser (file, usersupp.fullname);
  lseek (file, yourpos, 0);
  write (file, &usersupp, sizeof (user_type));
  close(file);
  lseek (file, yourpos, 0);
  lockf (file, F_ULOCK, (long) sizeof (user_type));
  return(0);
}


validate(usersupp) 	/* validate new users */
     user_type usersupp;
{
  struct msgmain MMtemp;
  user_type UStemp;
  int file,b,skipped=0;
  bool done = FALSE;
  FILE *fp;

  enter_btmp ("[Validate]");
  if ((fp = fopen (".register","r")) != NULL)
    {
      fclose (fp);
      printf ("A user is in the process of registering. Please wait.\n");
      return (-1);
    }

  if ((fp=fopen (".validate","r")) != NULL)
    {
      fclose (fp);
      printf ("Another aide is already validating.\n");
      return (-1);
    }
  else
    {
      fp=fopen (".validate","w");
      fclose (fp);
    }
  file=open("structures/MMstructure.0",O_RDONLY);
  if (file < 0)
    interr (94);
  read(file,&MMtemp,sizeof(struct msgmain));
  close(file);
  if ((MMtemp.MMflags&MM_VALID)==0)
    {
      printf("There are no unvalidated users.\n");
      return(0);
    }

      file=open("structures/MMstructure.0",O_RDONLY);
      if (file < 0)
	interr (94);
      read(file,&MMtemp,sizeof(struct msgmain));
      close(file);

  file=open("usersupp",O_RDWR);
  if ( file < 0 )
    interr (93);

  lseek(file, find_unvalidated(), 0);

  while(read(file,&UStemp,sizeof(user_type))>0) 
    {
      if ((UStemp.flags & US_NEEDVALID) || ((usersupp.axlevel==7) &&
					    (UStemp.axlevel==1)))
	{
	  printf("\n\n\nUser #%-5ld \"%s\", from %-16.16s\n",
		 UStemp.eternal,UStemp.fullname,UStemp.lasthost);
	  dis_regis(&UStemp);

	  /* give the aides who do the validating limited choices as to the
	     levels they can assign people.  Validate sets people to the value
	     of VALIDAX defined in sysconfig.h */

	  done = FALSE;
	  printf ("\n(V)alidate, (D)elete, (S)kip? ");
	  while (!done)
	    {
	      b = inkey (); b = (b & 127); b = ctolower (b);
	      switch (b)
		{
		case 'v':
		  printf ("Validate\n");
		  UStemp.axlevel = VALIDAX;
		  UStemp.timelimit = TIMELIM;
		  sprintf (logmsg, "VALIDATE:%s validated %s (%s)",
			   usersupp.fullname, UStemp.fullname,
			   UStemp.lasthost);
		  intlog (logmsg);
		  done = TRUE;
		  break;
		case 's':
		  printf ("Skip\n");
		  UStemp.axlevel = AX_NEW;
		  UStemp.timelimit = UStemp.timelimit;
/*		  skipped++;*/
		  sprintf (logmsg, "VALIDATE: %s skipped %s (%s)",
			   usersupp.fullname,UStemp.fullname,
			   UStemp.lasthost);
		  intlog (logmsg);
		  done = TRUE;
		  break;
		case 'd':
		  printf ("Delete\n");
		  UStemp.axlevel = AX_DEL;
		  UStemp.timelimit = LIM0;
		  sprintf (logmsg, "VALIDATE: %s deleted %s (%s)",
			   usersupp.fullname, UStemp.fullname,
			   UStemp.lasthost);
		  intlog (logmsg);
		  done = TRUE;
		  break;
		}
	    }

	  UStemp.flags = (UStemp.flags & ~US_NEEDVALID);
	  printf ("Access level is now: %d (%s), Time Limit is: %d\n", 
		  UStemp.axlevel, axdefs[UStemp.axlevel], UStemp.timelimit);
	  lseek (file, (0L - sizeof (user_type)), 1);
/*	  lockf (file, F_LOCK, (long) sizeof (user_type));*/
	  write (file, &UStemp, sizeof (user_type));
/*	  lseek (file, (0L - sizeof (user_type)), 1);*/
/*	  lockf (file, F_ULOCK, (long) sizeof (user_type));*/
	}
    }
  close (file);

  printf("\n*** End of registration.\n");
  file=open("structures/MMstructure.0",O_WRONLY);
  if (file < 0)
    interr (94);
  MMtemp.MMflags=MMtemp.MMflags&(~MM_VALID);
  write(file,&MMtemp,sizeof(struct msgmain));
  close(file);
  unlink (".validate");

/*  if (!skipped)*/
    reset_unvalidated();

  return(0);
}

void reset_unvalidated() 
{	
  FILE *fp;

  /* Clear the file to an empty one */
  fp=fopen("unvalidated","w");
    fclose(fp);
  return;
}

long find_unvalidated() 
{	
  FILE *fp;
  int file;
  char aaa[50];
  long answer;

  strcpy(aaa,"");
  fp=fopen("unvalidated","r");
  if (fp != NULL)
  if (fgets(aaa,50,fp) != NULL)
  {
    /* Fix the silly newline at the end */
    aaa[strlen(aaa)-1] = 0;
    printf("\nFAST VALIDATE IS IN EFFECT. (Lowest = %s)\n",aaa);
    fclose(fp);
  }

  if (aaa[0] == 0)
    return 0;
  else
  {
    file=open("usersupp",O_RDONLY); 
    if (file<0)
      interr(4);
    answer =  finduser(file,aaa);
    close(file);
    return (answer);
  }
}

void dis_regis(user_type *userdata)
{
  int a,b;
  char pbuf[20];

  printf("%-29s\n",userdata->RGname);
  printf("%-29s\n",userdata->RGaddr);
  printf("%-14s %2s %6s\n",
	 userdata->RGcity,userdata->RGstate,userdata->RGzip);
  strcpy(pbuf,userdata->RGphone);
  userdata->RGphone[0]=0;
  for (a=0; a<strlen(pbuf); ++a) 
    {
    if ((pbuf[a]>='0')&&(pbuf[a]<='9')) 
      {
	b=strlen(userdata->RGphone);
	userdata->RGphone[b]=pbuf[a];
	userdata->RGphone[b+1]=0;
      }
  }
  while(strlen(userdata->RGphone)<10) 
    {
      strcpy(pbuf,userdata->RGphone);
      strcpy(userdata->RGphone," ");
      strcat(userdata->RGphone,pbuf);
    }
  printf("(%c%c%c) %c%c%c-%c%c%c%c\n",
	 userdata->RGphone[0],userdata->RGphone[1],
	 userdata->RGphone[2],userdata->RGphone[3],
	 userdata->RGphone[4],userdata->RGphone[5],
	 userdata->RGphone[6],userdata->RGphone[7],
	 userdata->RGphone[8],userdata->RGphone[9]);
  printf ("%-41s\n", userdata->RGemail);
}

