/* 
File: qrlook.c
Desc: Quickroom Look -- dump out quickroom inf
Source: pirmann@klinzhai.rutgers.edu
10/24/92 modified for Sunset, pirmann
10/30/93 removed PASSWORDED references
*/

#include <fcntl.h>
#include <stdio.h>
#include "citadel.h"

main ()
{
   int a,flarp,tot,file2;
   struct quickroom quickroom;
   user_type usersupp;
   FILE *fp;

   chdir (BBSDIR);

   fp = fopen ("quickroom", "r");


printf ("\n## ROOM NAME                #POSTS   TYPE   ANON       ROOMAIDE\n");
printf ("------------------------------------------------------------------------\n");

   for (flarp = 0; flarp<MAXROOMS; flarp++)
     {
       fread (&quickroom, sizeof (struct quickroom), 1, fp);
       if (quickroom.QRhighest != 0)
	 {
	   printf ("%2.2d %-20.20s     %5ld    ", flarp, quickroom.QRname,
		   quickroom.QRhighest);
	   tot = tot+quickroom.QRhighest;

	   if ((quickroom.QRflags&QR_PRIVATE)==0)
	     printf("Pub    ");
	   if ((quickroom.QRflags&QR_PRIVATE) 
	       && !(quickroom.QRflags&QR_GUESSNAME))
	     printf("Inv    ");
	   if (quickroom.QRflags&QR_GUESSNAME)
	     printf("Guess  ");
	   
	   if (quickroom.QRflags&QR_ANONONLY)
	     printf("Anon       ");
	   else 
	     if (quickroom.QRflags & QR_ANON2)
	       printf ("Anon Opt   ");
	   else 
	     printf   ("           ");
	   printf("%d %s\n",quickroom.QRroomaide, quickroom.QRaidename);

	 }
     }

   fclose (fp);
   printf ("\n%d messages have been posted to Citadel.\n", tot);
   exit(0);
}


