/* 
File: qrconvert.c (external)
Desc: convert a quickroom struct
Source: pirmann
Change History
11-28-92 created 
*/


#include <fcntl.h>
#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "citadel.h"

main ()
{
  int file,file2,a,c;
  char aaa[50]; long aa;

  struct quickroom QRnew, QRold;
  user_type usersupp;
  FILE *old, *new;

/*  chdir (BBSDIR);*/

  old = fopen ("quickroom","r");
  if (old == NULL)
    exit (-1);
  unlink ("newqroom");
  new = fopen ("newqroom", "w+");
  if (new == NULL)
    exit (-1);

  printf ("maxrooms: %d \n", MAXROOMS);
  for (a=0; a<MAXROOMS; ++a) 
    {
      c=fread(&QRold, sizeof (struct quickroom), 1, old);
      if (c == 0)
	{printf ("READ OOPS\n"); exit (-1);}
      printf ("ROOM %d %s...", a, QRold.QRname);
      
      if (strlen(QRold.QRaidename) > 0)
	{
	  printf("checking...");
	  file2=open("usersupp",O_RDONLY);
	  do
	    c=read(file2,&usersupp,sizeof(user_type));
	  while((c>0)&&(strncasecmp (QRold.QRaidename, usersupp.fullname)));
	  close(file2);
	  printf("%s %s\n",QRold.QRaidename,usersupp.fullname);
	  strcpy (QRnew.QRaidename, QRold.QRaidename);
	  QRnew.QRroomaide=usersupp.eternal;
	}
      else 
	{
	  printf ("No room aide.\n");
	  strcpy (QRnew.QRaidename, "");
	  QRnew.QRroomaide=0L;
	}

      strcpy (QRnew.QRname, QRold.QRname);
      strcpy (QRnew.QRpasswd, QRold.QRpasswd);
      QRnew.QRhighest=QRold.QRhighest;
      QRnew.QRgen=QRold.QRgen;
      QRnew.QRflags=QRold.QRflags;
      strcpy (QRnew.QRdirname, QRold.QRdirname);

      printf ("\n");
      c=fwrite (&QRnew, sizeof (struct quickroom), 1, new);
      if (c == 0)
	{printf ("READ OOPS\n"); exit (-1);}    
    }
  fclose (old); fclose (new);
  

}
