/* 
File: purge.c
Desc: usersupp purge utility -  purge old users
Source: rewritten from Cit dist, pirmann@rutgers.edu
Change History:
10/24/92: fixed for Sunset, by pirmann
09/15/93: added purgerc and printonly things, pirmann
09/16/93: fixed printmsg up
10/31/93: fixed to compile under normal cc

set PURGEDAY in sysconfig.h before compiling this, OR use purgerc
and make sure the BBSUID/GID is set in front.h 
*/

#include <fcntl.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <ctype.h>
#include "citadel.h"
#include "cctype.h"
#include "uid.h" /* contains UID info */
#include "purge.h" /* contains day of week assignments */
#include "hash.h"  /* contains hash function */

char tmpmsg[100];

main(argc, argv)
int argc; char *argv[];
{
  FILE *F;
  char item[80], option[10];
  long curtime;
  struct tm *ft;
  int today, dopurge=0, flag, timeout=0, i, PFLAG=0, NDFP=0, DEBUG=0;

  time (&curtime);
  ft=localtime (&curtime);
  today = ft->tm_wday;

  chdir (BBSDIR);

  printmsg("Purge run starting.");

  /* first determine arguments */
  for (i=1; i<argc; i++)
    {
      strcpy (option, argv[i]);
      flag = option[1];

      switch (flag) 
	{
	case 'p':
	  printmsg("Will only print actions, not do them.");
	  PFLAG = 1;
	  break;
	case 'd':
	  printmsg ("Running in debug mode.");
	  DEBUG=1;
	  break;
	default:
	  printf ("Unknown option: %s\n", argv[i]);
	  break;
	}
    }

  if (DEBUG)
    printf ("today is %d %s\n", today, days[today]);

  /* now deal with purgerc */
  F=fopen("purgerc","r");
  if (F==NULL) 
    {
      printmsg("Cannot find purgerc file, exiting.");
      exit (-1);
    }
  while (readtoken(F,item))
    {
      /* set up dayweek tokens */
      if (!strncasecmp (item, "dayweek"))
	{
	  readtoken (F, item);
	  for (i=0;i<7;i++)
	    if (!strncasecmp (item, days[i]))
	      if (i==today)
		{
		  dopurge=1;
		  if (DEBUG) 
		    {
		      sprintf (tmpmsg, "Found day %s %d", item, today);
		      printmsg (tmpmsg);
		    }
		}
	}
      if (!strncasecmp (item, "timeout"))
	{
	  readtoken (F, item);
	  timeout = atoi(item);
	}
      if (!strncasecmp (item, "print"))
	{
	  readtoken (F, item);
	  if (!strncasecmp (item, "yes"))
	    {
	      printmsg("Will only print actions, not do them.");
	      PFLAG = 1;
	    }
	}
      if (!strncasecmp (item, "nodayfound"))
	{
	  readtoken (F, item);
	  if (!strncasecmp (item, "yes"))
	    NDFP = 1;
	}
    }
  fclose(F);


  if (timeout == 0)   /* in case there is no timeout setting in purgerc */
    timeout = PURGEDAY;  /* get the info from the header file */

  /* now check for dopurge/nopurge files */
  if (dopurge == 0)  /* only need to check if we didn't already set this */
    {
      F=fopen (".dopurge", "r");
      if (F != NULL)
	{
	  printmsg("Dopurge exists, overriding purgerc.");
	  dopurge = 1;
	  fclose (F);
	  unlink (".dopurge"); /* remove it now that we're done */
	}
    }
  
 /* by this point we should either have found
    a day or found dopurge */

  if ((dopurge == 0) && (NDFP))
    {
      printmsg("No day found, running in condom (safe) mode.");
      dopurge = 1;
      PFLAG = 1;
    }
    
  if ((dopurge == 0) && (PFLAG))   /* set dopurge on due to pflag */
    dopurge = 1;

  if (dopurge == 0)/* otherwise there is no day found, no pflag, no ndfp */
    {
      printmsg("Nothing to do.");
      dopurge = 0;   /* just in case */
    }

  if (dopurge != 0)   /* check to see if we're going to purge */
    {
      F=fopen (".nopurge", "r");
      if (F != NULL)
	{
	  /* only override if pflag not already set */
	  if (!PFLAG)
	    {
	      printmsg("Nopurge exists, overriding purgerc.");
	      dopurge = 0;
	    }
	  fclose (F);
	  /* don't unlink it as a safety precaution */
	}
    }

  F = fopen ("usersupp", "r");
  if (F == NULL)
    {
      printmsg("No usersupp!!.");
      dopurge=0;
    }
  else
    fclose (F);

  if (dopurge)
    {
      sprintf (tmpmsg, "Initiating purge: DP=%d, PF=%d, LIM=%d.", dopurge,
	       PFLAG, timeout);
      printmsg(tmpmsg);
      i=userpurge(PFLAG, timeout);
      sprintf (tmpmsg, "Purge finished. Status=%d.", i);
      printmsg(tmpmsg);
      if (i != 0)
	{ 
	  printmsg ("Purge failed! Cleaning up...");
	  unlink ("usersupp.new");
	}
      if (!PFLAG)
	{
	  printmsg("Rewriting hash table.");
	  write_hashtab();
	  printmsg("Hashing finished.");
	}
      else 
	{
	  printmsg("Skipping hash run.");
	}
    }
  printmsg("All done! Exiting.");
  return (0);
}

write_hashtab() 
{
  user_type u;
  int h, in, out;
	
  in=open("usersupp",O_RDONLY);
  out=creat("hashtab",0644);
  while(read(in,&u,sizeof(user_type)))
    {
      h=hash(u.fullname);
      write(out,&h,sizeof(int));
    }
  close(in);
  close(out);
  chown ("hashtab", BBSUID, BBSGID);
  chmod ("hashtab", 0644);
  return(0);
}

userpurge(pflag, timeout) 
int pflag, timeout;
{	
  int b,file,file2, spared=0, purged=0, CLN;
  user_type usersupp;
  long now,call,aa;
  char ldate[9], aaa[50]; /* used for bio path name */
  struct tm *tmstruct;

  time(&now);

  /* CLN contains the number of "idle" seconds */
  CLN = (timeout * 24 * 60 * 60);  /* days * hours * minutes * seconds */

  file=open("usersupp",O_RDONLY);
  if (file<0)
    {
      printf("     Error! No usersupp file available.\n");
      return(-1);
    }
  
  if (!pflag)  /* we're only printing, not doing */
    {
      file2=creat("usersupp.new",0644);
      if (file2<0)
	{
	  printf("     Error! Can't open the new file.\n");
	  close(file);  /* this is the old file */
	  return(-1);
	}
    }

  /* preserve the first record */
  read(file,&usersupp,sizeof(user_type));

  if (!pflag)
    write(file2,&usersupp,sizeof(user_type));


  while (read(file,&usersupp,sizeof(user_type))>0)
    {
      /* call contains number of seconds elapsed since last call */
      call=now-(usersupp.lastcall);

      /* push these users "over the edge" in order to purge them */
      if (usersupp.timescalled == 0) call = CLN+2L;
      if (usersupp.axlevel==0) call=CLN+2L;

      if ((call <= CLN) /* they have not exceeded the limit */
	||(usersupp.flags&US_PERM)) /* or they have a perm flag */
	{
	  spared++;             /* spare this user */
	  if (!pflag)
	    {
	      b=write(file2,&usersupp,sizeof(user_type));
	      if (b<1) 
		{
		  printf("     Error! Can't write the new file.\n");
		  close (file);
		  return (-1);
		}
	    }
	}
      else    /* they've exceeded the limit */
	{
	  purged++;       /* purge this user, generate a report */
	  aa=usersupp.lastcall;
	  tmstruct = localtime(&aa);
	  sprintf (ldate, "%2.2d/%2.2d/%2.2d", tmstruct->tm_mon+1, 
		   tmstruct->tm_mday, tmstruct->tm_year);
	  printf ("%5ld %-20.20s %-9.9s  %5.5d  %5.5d  %-16.16s\n", 
		  usersupp.eternal, usersupp.fullname, ldate, 
		  usersupp.timescalled, usersupp.posted, usersupp.lasthost);
	  if (!pflag)
	    {
	      sprintf (aaa, "./bios/%d", usersupp.eternal);
	      unlink (aaa);
	    }
	}
    }

  close(file);
  if (!pflag)
    {
      close(file2);
      system("mv usersupp.new usersupp");
      chown ("usersupp", BBSUID, BBSGID);
      chmod("usersupp",0644);
    }
  printf ("\n\n");
  if (pflag)
    printf ("If this had been a real purge run, this would have happened:\n");
  printf ("    Spared users: %-5d       Bytes: %d\n", spared, 
	  spared * (int) sizeof (user_type));
  printf ("    Purged users: %-5d       Bytes: %d\n\n", purged,
	  purged * (int) sizeof (user_type));
  return(0);
}

int readtoken(file, token)
FILE *file;
char *token;
{
  static char line[161];
  int i,j;

  if ((line[0]==0) && !feof(file))
    while (line[0]==0 && !feof(file))
    {
      fgets(line,160,file);
      line[strlen(line)-1]=0;
      while (line[0]==' ')
	strcpy(line,&line[1]);
      if ((line[0]==';') || (line[0]=='#')) line[0]=0;
    }

  if (line[0]!=0)
  {
    j=0;
    while (j<strlen(line) && ((line[j]==' ')||(line[j]=='=')))
      ++j;

    i = j;
    while ((i<strlen(line)) && !((line[i]==' ')||(line[i]=='=')))
      ++i;

    strncpy(token,&line[j],i);
    token[i]=0;

    while (i<strlen(line) && ((line[i]==' ')||(line[i]=='=')))
      ++i;
    strcpy(line,&line[i]);
    return(1);
  }
  return(0);
}

printmsg(message)  /* prepend date & time to message */
char *message;
{
  char prtime [30];
  struct tm *ft;
  long curtime;

  time (&curtime);
  ft=localtime (&curtime);

  sprintf (prtime, "%s", asctime(ft));
  prtime[strlen(prtime)-1]=0;
  printf ("%s: %s\n", prtime, message);
}
