/*
File: netproc.c
Desc: Citadel/UX Network Processor v1.53
Source: designed and written by Art Cancro @ Uncensored Communications Group
See copyright.doc for copyright information
*/

#include <fcntl.h>
#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include "citadel.h"
#include "cctype.h"
#include "netproc.h"
#include "hash.h"

long atol();
long lseek();
char *malloc();
FILE *logfile;

long finduser(file,name)
     int file;
     char *name;
{
  FILE *fp;
  int uh,fh;
  long pp=0L;
	
  uh=hash(name);
  fp=fopen("hashtab","r");
  while(fread(&fh,sizeof(int),1,fp)>0)
    {
      if (uh==fh)
	{
	  lseek(file,pp,0);
	  fclose (fp);
	  return(pp);
	}
      pp = pp + (long)sizeof(user_type);
    }
  fclose(fp);
  return(-1L);
}

main(argc,argv)
     int argc;
     char *argv[];
{
  chdir (BBSDIR);

  logfile=fopen(NLOGFILE,LOGMODE);
  if (logfile==NULL)
    logfile=stdout;
  fprintf(logfile,"netproc: started.  pid=%d\n",getpid());
  if (argc==2)
    outprocess(argv[1]);
  inprocess();
  fprintf(logfile,"netproc: processing ended.\n");
  fclose(logfile);
  exit(0);
}

inprocess() 	/* Process incoming files in ./network/spoolin */
{
  FILE *fp,*message;
  struct minfo minfo;
  struct recentmsg recentmsg;
  struct smreturn smreturn;
  char tname[50],aaa[100],iname[50];
  int a;

  sprintf(tname,"/tmp/net.t%d",getpid());	/* temp file name */
  sprintf(iname,"/tmp/net.i%d",getpid());	/* temp file name */

  /* Let the shell do the dirty work. Get all data from spoolin */
  sprintf(aaa,"cat network/spoolin/* 2>/dev/null");
  fp=(FILE *)popen(aaa,"r");

 NXMSG:	/* Break out the next message */
  do
    a=getc(fp);
  while((a!=255)&&(a>=0));

  if (a<0)
    goto ENDSTR;
  message=fopen(tname,"w");
  putc(255,message);

 ZFLD:
  do
    {
      a=getc(fp);
      putc(a,message);
    }
  while(a!=0);

  a=getc(fp);
  putc(a,message);
  if (a!='M')
    goto ZFLD;

  do
    {
      a=getc(fp);
      putc(a,message);
    }
  while(a>0);

  fclose(message);

  /* process the individual mesage */
  minfo.D[0]=0;
  msgfind(tname,&minfo);
  strncpy(recentmsg.RMnodename,minfo.N,9);
  recentmsg.RMnodename[9]=0;
  recentmsg.RMnum=minfo.I;
  fprintf(logfile,"netproc: accept #%ld from <%s> in <%s> @ <%s>\n",
	  minfo.I,minfo.A,minfo.O,minfo.N);
  if ((strucmp(minfo.D,NODENAME))&&(minfo.D[0]!=0))
    { 
      sysinfo(minfo.D);
      ship_to(tname,minfo.D);
    }
  else
    {
      send_message(tname,&smreturn,minfo.O);
      if (minfo.R[0]!=0)
	{
	  a=mail_to(minfo.R,&smreturn);
	  if (a<0)
	    file_message(TWITROOM,&smreturn);
	}
      else
	file_message(minfo.O,&smreturn);
    }

 SKMSG:
  unlink(tname);
  goto NXMSG;

 ENDSTR:
  fclose(fp);
  unlink(iname);
  system ("rm network/spoolin/*");

  return(0);

}

msgfind(msgfile,buffer)
     char *msgfile;
     struct minfo *buffer;
{
  struct tm *tm;
  int a,b,c,d,e,real,old,mtype,aflag;
  char aaa[100],bbb[100],ttm[3];
  FILE *fp;
		
  fp=fopen(msgfile,"rb");
  if (fp==NULL)
    {
      fprintf(stderr,"Can't open message file\n");
      return(1); 
    }
  e=getc(fp);
  if (e!=255)
    {
      fprintf(stderr,"Incorrect message format\n");
      goto END;
    }
  mtype=getc(fp);
  aflag=getc(fp);
  buffer->I=0L;
  buffer->R[0]=0;

 BONFGM:
  b=getc(fp);
  if (b<0)
    goto END;
  if (b=='M')
    goto END;
  fpgetfield(fp,bbb);
  while ((bbb[0]==' ')&&(strlen(bbb)>1))
    strcpy(bbb,&bbb[1]);
  if (b=='A') strcpy(buffer->A,bbb);
  if (b=='O') strcpy(buffer->O,bbb);
  if (b=='N') strcpy(buffer->N,bbb);
  if (b=='R') strcpy(buffer->R,bbb);
  if (b=='D') strcpy(buffer->D,bbb);
  if (b=='T') buffer->T=atol(bbb);
  if (b=='I') buffer->I=atol(bbb);
  goto BONFGM;

 END:
  if (buffer->I==0L)
    buffer->I=buffer->T;
  fclose(fp);
  return(0);
}

fpgetfield(fp,string)
     FILE *fp;
     char string[];
{
  int a,b,c;

  strcpy(string,"");
  a=0;

 GFXYZAF:
  b=getc(fp);
  if (b<1)
    {
      string[a]=0;
      return(0);
    }
  string[a]=b;
  ++a;
  if (b!=0)
    goto GFXYZAF;
}

send_message(filename,retbuf,room)/* send a message to the master file */
     char filename[];		/* tempfilename of proper message */
     struct smreturn *retbuf;	/* return information */
     char room[];
{
  int file,a,b,c,d,e,file2;
  long aa,bb,cc,dd,ee,templen,hibytes,origpos,ffsource;
  char aaa[100];
  struct msgmain msgmain;
  int currm;
  char structfile [50], msgmainfile[50];
  char sbuf [BUFSIZ];

  currm=get_rmnum(room);
  sprintf (structfile,"structures/MMstructure.%d",currm);
  sprintf (msgmainfile, "msgmains/msgmain.%d", currm);

  file=open(structfile,O_RDWR);

  do
    {
      lseek (file, 0L, 0);
      a=read(file,&msgmain,sizeof(struct msgmain));
      if (msgmain.MMflags & MM_BUSY)
	sleep (1);
    }
  while (msgmain.MMflags & MM_BUSY);
  
  lseek (file, 0L, 0);
  msgmain.MMflags=(msgmain.MMflags|MM_BUSY);
  a=write(file,&msgmain,sizeof(struct msgmain));
  close(file);
  origpos=msgmain.MMcurpos;
  ++msgmain.MMhighest;

  /* measure the message and count FF bytes */
  ffsource=0L;
  file=open(filename,O_RDONLY);
  templen=0L;
  do
    {
      a=0;
      b=read(file,&a,1);
      if (a==255)
	++ffsource;
      templen=templen+(long)b;
    } while (b!=0);
  close(file);

  /* check for FF bytes */
  hibytes=0L;
  file=open(msgmainfile,O_RDWR);
  bb=lseek(file,msgmain.MMcurpos,0);

  cc=lseek(file,0L,1);
  for (bb=0L; bb<templen; ++bb)
    {
      if (currm != 1)
	if (cc>=MM_FILELEN)
	  cc=lseek(file,0L,0);
      else
	if (cc >= MM_MAIL)
	  cc=lseek(file,0L,0);
      c=0;
      read(file,&c,1);
      ++cc;
      if (c>127)
	++hibytes;		/* bump count if hi bit set */
    }

  msgmain.MMlowest=msgmain.MMlowest+hibytes;
/*  msgmain.MMhighest=msgmain.MMhighest+ffsource; /* done up there */

  cc=lseek(file,msgmain.MMcurpos,0);
  file2=open(filename,O_RDONLY);
  cc=lseek(file,0L,1);
  for (bb=0L; bb<templen; ++bb)
    {
      if (((long)cc)>=((long)MM_FILELEN))
	cc=lseek(file,0L,0);
      read(file2,&b,1); 
      write(file,&b,1);
      ++cc;
    }

  msgmain.MMcurpos=lseek(file,0L,1);
  close(file2);	/* done with temp file */
  close(file);	/* done with master file */

  /* now update the message structure */
  msgmain.MMflags=msgmain.MMflags & ~MM_BUSY;
  file=open(structfile,O_RDWR);
  a=write(file,&msgmain,sizeof(struct msgmain));
  close(file);

  retbuf->smnumber=msgmain.MMhighest;
  retbuf->smpos=origpos;
  return(0);
}

strucmp(st1,st2)
     char *st1, *st2;
{
  char aaa[100],bbb[100];
  int a;
  
  strcpy(aaa,st1); strcpy(bbb,st2);
  for (a=0; a<strlen(aaa); ++a) aaa[a]=tolower(aaa[a]);
  for (a=0; a<strlen(bbb); ++a) bbb[a]=tolower(bbb[a]);
  a=strcmp(aaa,bbb);
  return(a);
}

getline(buffer,file)
     char buffer[];
     int file;
{
  int a,b,c;
  c=0; b=0;
  do
    {
      a=read(file,&b,1);
      if ((b==10) || (a<1))
	b=0;
      buffer[c]=b;
      ++c;
    } while(b!=0);
  return(c-1);
}

outprocess(sysname) /* send new room messages to sysname */
     char *sysname;
{
  char sysflnm[64];
  char srmname[32];
  char shiptocmd[128];
  char lbuf[64];
  char tempflnm[64];
  struct quickroom cquickrm;
  struct fullroom cfullrm;
  struct msglist *cmlist = NULL;
  struct rmlist *crmlist = NULL;
  struct rmlist *rmptr;
  struct msglist *cmptr,*cmptr2;
  FILE *sysflfp,*qrfp,*frfp,*tempflfp;
  int a,b;

  sprintf(tempflnm,"/tmp/%s.%d",NODENAME,getpid());
  tempflfp=fopen(tempflnm,"w");
  if (tempflfp==NULL)
    return(1);

  /* Read system file for node in question and put together room list */
  sprintf(sysflnm,"./network/systems/%s",sysname);
  sysflfp=fopen(sysflnm,"r");
  if (sysflfp==NULL)
    return(2);
  fgets(shiptocmd,128,sysflfp);
  shiptocmd[strlen(shiptocmd)-1]=0;
  while(!feof(sysflfp))
    {
      if (fgets(srmname,32,sysflfp)==NULL)
	break;
      srmname[strlen(srmname)-1]=0;
      fgets(lbuf,32,sysflfp);
      rmptr=(struct rmlist *)malloc(sizeof(struct rmlist));
      rmptr->next = crmlist;
      crmlist=rmptr;
      strcpy(rmptr->rm_name,srmname);
      rmptr->rm_lastsent = atol(lbuf);
    }
  fclose(sysflfp);

  /*Assemble list of messages to be spooled */
  for (rmptr=crmlist; rmptr!=NULL; rmptr=rmptr->next)
    {
      qrfp=fopen("quickroom","r");
      b=(-1);
      for (a=0; a<MAXROOMS; ++a)
	{
	  fread(&cquickrm,sizeof(struct quickroom),1,qrfp);
	  if (!strucmp(cquickrm.QRname,rmptr->rm_name))
	    b=a;
	  if (!strucmp(cquickrm.QRname,rmptr->rm_name))
	    break;
	}
      fclose(qrfp);

/*      fprintf(stderr,"netproc: room #%02d <%s>\n",  b,rmptr->rm_name);*/
      
      if (b<0)
	break;
      sprintf(lbuf,"./rooms/fullrm%d",b);
      frfp=fopen(lbuf,"r");
      fread(&cfullrm,sizeof(struct fullroom),1,frfp);
      fclose(frfp);
      for (a=0; a<MSGSPERRM; ++a)
	{
	  if ( cfullrm.FRnum[a] > (rmptr->rm_lastsent) )
	    {
	      rmptr->rm_lastsent = cfullrm.FRnum[a];
	      cmptr=(struct msglist *)malloc(sizeof(struct msglist));
	      cmptr->next = NULL;
	      cmptr->m_num = cfullrm.FRnum[a];
	      cmptr->m_pos = cfullrm.FRpos[a];
	      if (cmlist == NULL)
		cmlist = cmptr;
	      else
		{
		  cmptr2 = cmlist;
		  while (cmptr2->next != NULL)
		    cmptr2 = cmptr2->next;
		  cmptr2->next = cmptr;
		}
	    }
	}
    }

  spool_out(cmlist,tempflfp,sysname,b);

  /* Deallocate list of spooled messages */
  while(cmlist!=NULL)
    {
      cmptr=cmlist->next;
      free(cmlist);
      cmlist=cmptr;
    }

  /* Rewrite system file and deallocate room list */
  sysflfp=fopen(sysflnm,"w");
  fprintf(sysflfp,"%s\n",shiptocmd);
  for (rmptr=crmlist; rmptr!=NULL; rmptr=rmptr->next)  
    fprintf(sysflfp,"%s\n%ld\n",rmptr->rm_name,rmptr->rm_lastsent);
  fclose(sysflfp);
  while(crmlist!=NULL)
    {
      rmptr=crmlist->next;
      free(crmlist);
      crmlist=rmptr;
    }

  /* Close temporary file, ship it out, and return */
  fclose(tempflfp);
  ship_to(tempflnm,sysname);
  unlink(tempflnm);
  return(0);
}


ship_to(filenm,sysnm)	/* send spool file filenm to system sysnm */
     char *filenm;
     char *sysnm;
{
  char sysflnm[100];
  char commbuf1[100];
  char commbuf2[100];
  FILE *sysflfp;

  fprintf(stderr,"netproc: shipping %s to %s\n",filenm,sysnm);

  sprintf(sysflnm,"./network/systems/%s",sysnm);
  sysflfp=fopen(sysflnm,"r");
  fgets (commbuf1, 128, sysflfp);
  fclose(sysflfp);
  sprintf(commbuf2,commbuf1,filenm);
  return(system(commbuf2));
}

spool_out(cmlist,destfp,sysname,currm)	/* spool list of messages to a file */
     struct msglist *cmlist;
     FILE *destfp; 
     char sysname[];
     int currm;
{
  struct msglist *cmptr;
  FILE *mmfp;
  char fbuf[128];
  int a;
  char msgmainfile[50];

  mmfp=fopen(msgmainfile,"r");
  if (mmfp==NULL)
    return(1);

  for (cmptr=cmlist; cmptr!=NULL; cmptr=cmptr->next)
    {
      if (ismsgok(cmptr->m_pos,mmfp,sysname))
	{
	  fseek(mmfp,cmptr->m_pos,0);
	  fread(fbuf,3,1,mmfp);
	  fwrite(fbuf,3,1,destfp);
	  while (a=getc(mmfp),((a!=0)&&(a!='M')))
	    {
	      putc(a,destfp);
	      fpgetfield(mmfp,fbuf);
	      if (a=='P')
		fprintf(destfp,"%s!",NODENAME);
	      fwrite(fbuf,strlen(fbuf)+1,1,destfp);
	    }
	  if (a=='M')
	    {
	      putc('M',destfp);
	      do
		{
		  if (ftell(mmfp)>MM_FILELEN)
		    fseek(mmfp,0L,0);
		  a=getc(mmfp);
		  putc(a,destfp);
		} while(a>0);
	    }
	}
    }

  fclose(mmfp);
  return(0);
}

int ismsgok(mpos,mmfp,sysname)
long mpos;
FILE *mmfp;
{
  int a;
  char fbuf[128];

  fseek(mmfp,mpos,0);
  if (getc(mmfp)!=255)
    return(0);
  getc(mmfp);
  getc(mmfp);

  while (a=getc(mmfp),((a!='M')&&(a!=0)))
    {
      fpgetfield(mmfp,fbuf);
      if ((a=='P')&&(checkpath(fbuf,sysname)==0))
	return(0);
    }
  return(1);
}

int mail_to(user,where)
char user[];
struct smreturn *where;
{
  struct usersupp usersupp;
  long uspos;
  int file,a;

  file=open("usersupp",O_RDWR);
  if (file<0)
    return(-1);
  uspos=finduser(file,user);
  if (uspos<0L)
    {
      close(file);
      return(-1);
    }
  read(file,&usersupp,sizeof(struct usersupp));
  for (a=0; a<(MAILSLOTS-1); ++a)
    {
      usersupp.mailnum[a]=usersupp.mailnum[a+1];
      usersupp.mailpos[a]=usersupp.mailpos[a+1];
    }
  usersupp.mailnum[MAILSLOTS-1]=where->smnumber;
  usersupp.mailpos[MAILSLOTS-1]=where->smpos;
  lseek(file,uspos,0);
  write(file,&usersupp,sizeof(struct usersupp));
  close(file);
  return(0);
}

file_message(room,where)
     char room[];
     struct smreturn *where;
{
  struct quickroom quickroom;
  struct fullroom fullroom;
  int rmnum,a,file;
  char frname[50];

  rmnum=2;
  file=open("quickroom",O_RDWR);
  for (a=0; a<MAXROOMS; ++a)
    {
      read(file,&quickroom,sizeof(struct quickroom));
      if (!strucmp(quickroom.QRname,room))
	rmnum=a;
    }
  lseek(file,(long)(rmnum*sizeof(struct quickroom)),0);
  read(file,&quickroom,sizeof(struct quickroom));
  quickroom.QRhighest=where->smnumber;
  lseek(file,(long)(rmnum*sizeof(struct quickroom)),0);
  write(file,&quickroom,sizeof(struct quickroom));
  close(file);
  sprintf(frname,"./rooms/fullrm%d",rmnum);
  file=open(frname,O_RDWR);
  read(file,&fullroom,sizeof(struct fullroom));
  for (a=0; a<(MSGSPERRM-1); ++a)
    {
      fullroom.FRnum[a]=fullroom.FRnum[a+1];
      fullroom.FRpos[a]=fullroom.FRpos[a+1];
    }
  fullroom.FRnum[MSGSPERRM-1]=where->smnumber;
  fullroom.FRpos[MSGSPERRM-1]=where->smpos;
  lseek(file,0L,0);
  write(file,&fullroom,sizeof(struct fullroom));
  close(file);
  return(0);
}

checkpath(path,sys)	/* Checks to see whether its ok to send */
     char path[];		/* Returns 1 for ok, send message	*/
     char sys[]; 		/* Returns 0 if message already there	*/
{
  int a;
  char sys2[512];
  strcpy(sys2,sys);
  strcat(sys2,"!");
  
  for (a=0; a<strlen(path); ++a) 
    if (!strncmp(&path[a],sys2,strlen(sys2)))
      return(0);
  return(1);
}

sysinfo(name)	/* determine routing from sysinfo file */
     char name[];
{
  int file,a;
  char aaa[100];
  file=open("network/mail.sysinfo",O_RDONLY);
 GETSN:
  do
    {
      a=getstring(file,aaa);
    } while ((a>=0)&&(strucmp(aaa,name)));
  a=getstring(file,aaa);
  if (!strncmp(aaa,"use ",4))
    {
      strcpy(name,&aaa[4]);
      goto GETSN;
    }
  close(file);
  if (!strncmp(aaa,"bin",3)) 
    return(0);
  printf("Error in network/mail.sysinfo file\n");
  return(-1);
}

getstring(file,string)		/* get a line of text from a file */
     int file; char string[]; 	/* ignores lines beginning with # */
{
  int a,b,c;
  do
    {
      strcpy(string,"");
      a=0;
      do
	{
	  c=0;
	  b=read(file,&c,1);
	  if (b<1)
	    {
	      string[a]=0;
	      return(-1);
	    }
	  string[a]=c;
	  ++a;
	} while(c!=10);
      string[a-1]=0;
    } while(string[0]=='#');
  return(strlen(string));
}

int get_rmnum(room)
     char room[];
{
  int file,a;
  struct quickroom quickroom;

  file=open("quickroom",O_RDWR);
  for (a=0; a<MAXROOMS; ++a)
    {
      read(file,&quickroom,sizeof(struct quickroom));
      if (!strucmp(quickroom.QRname,room))
	return (a);
    }
}

/*
 *
 * History:
 * 08/01/88 AJC - Wrote v1.0
 *   /  /88 AJC - Rewrote inbound processor
 *              - Added shell command to do the dirty work of looking in
 *                the spoolin directory for inbound network files
 *   /  /88 AJC - Moved use table check into a function call
 *              - Changed usetable code to use originating message ID ("I"
 *                field) in table rather than message time. Time is still used
 *                if no I field is present.
 *   /  /88 AJC - Modified outbound side to not send a system its own messages
 * 10/28/88 AJC - Fixed bug that would screw up the use table if the
 *                originating system's name exceeded 19 characters.
 *              - Increased size of minfo buffers to handle big Henge names.
 *              - Annoying error messages from empty spoolin diverted to null
 * 11/25/88 AJC - Added software to look at P (path) field and not send a
 *		  message to a system if it's already been there
 * 05/30/89 AJC - Added mail routing based on D (destination system) field
 *              - Added routines to accept binary mail
 * 06/11/89 AJC - Oops! Fixed bug that caused mail arriving in rooms other than
 *                mail to be posted publicly AND privately. (One Nasty Bug)
 * 08/15/89 AJC - Read entire use table into memory during inbound processing,
 *                which writes it back to disk when finished.
 * 01/10/91 AJC - Rewrote outbound side completely.  No more temporary files
 *                for each individual message.  Used level 2 I/O calls for
 *                all disk accesses.  Held lists of rooms and messages in
 *                dynamic linked lists.  This thing _flies_ now!
 * 05/28/91 AJC - Fixed bug which caused some of the incoming mail to be
 *                rejected if there were multiple messages.
 * 06/02/91 AJC - Changed finduser() to use the hash tables in Citadel 3.10
 * 06/10/91 AJC - Killed the use table completely, since path routing works
 *                much better and doesn't require a use table.
 * 04/17/92 AJC - Increased size of minfo buffers to 512 bytes to prevent
 * 		  fields from getting chopped in incoming network messages.
 * 06/07/92 AJC - Fixed bug which caused messages to spool in reverse order.
 *
 */

