/* 
File: messages.c f
Desc: message routines
 read_message() - called by Read routines to print messages
 send_message() - read message in temp file & store in msgmain
 make_message() - assemble temp message file - msg editor
 msgform()      - msg formatter / called by read_message() and others
 pull_message() - pull message out of msgmain into temp file
 entmsg()       - enter a message
 readmsgs()     - read messages in a room
 save_message() - file a message into the current room
 delete_message - remove a message from current room
 move_message   - move a message from current to another room
 move_delete    - replacement for delete (local)
 updatels       - make all messages old in current room
 updatepartial  - make some messages old in current room
 islocked       - is msgmain file locked? (local)
 unlock         - unlocks locked msgmain files (local)
Source: from Cit/UX dist unless (local) pirmann@demigod.rutgers.edu

Change History
01/08/93 checked opens/closes
10/12/93 checked locks
12/08/93 added eternal field to message header, removed "path" field
*/

#include "messages.h"  

#include <sys/file.h> /* for flock */
#include "cunistd.h" /* for lockf */
#include <fcntl.h>
#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/signal.h>
#include <setjmp.h>
#include "citadel.h"
#include "defs.h"
#include "paths.h"

long atol();
long lseek();
long finduser();

extern char *days[7];
extern char structfile[50], msgfile[50];
extern int curr_rm, twitroom,feedback_flag;
extern struct smreturn smreturn;
extern user_type usersupp;
extern struct quickroom quickroom;
extern struct fullroom fullroom;
extern jmp_buf nextbuf;
extern int (*backnext())();
extern int (*backstop())();
extern char *months[];
extern char temp[];
extern int curr_line;
extern int abort_read;
extern long lastpos;
extern int unseen;

int replying;                  /* replying yes/no */
char who_from[50];             /* who is this msg from, for replying */
long msgnum;                   /* message byte position? */
int abort_read;               /* used to abort reading messages      */
int curr_line;                /* current screen line (for pauses)    */
     
     
read_message(long pos)	        /* Read a message from the master file */
{
  int a;
  a=setjmp(nextbuf);
  sttybbs(0);
  if ((a==1)||(a==2)) 
    {
      printf("\n\n");
      increment(); increment();
      return(a);
    }
  signal(SIGINT,(*backnext));
  signal(SIGQUIT,(*backstop));
  sttybbs(1);
  sprintf (msgfile,"msgmains/msgmain.%d", curr_rm);
  msgform(usersupp.screenwidth,pos,msgfile);
  sttybbs(0);
  return(0);
}

send_message(filename,retbuf)	/* send a message to the master file */
     char filename[];		/* tempfilename of proper message */
     struct smreturn *retbuf;	/* return information */
{
  int a,c,d, ctrlfile, file, file2;
  long bb,cc,templen,ffbytes,hibytes,origpos;
  char sbuf[BUFSIZ], mid[30], intmsg[100];
  FILE *fp;
  struct msgmain msgmain;
  
  sprintf (structfile,"structures/MMstructure.%d",curr_rm);
  
  ctrlfile=open(structfile,O_RDWR);
  if (ctrlfile<0)
    interr(13);
  while (flock (ctrlfile, LOCK_EX|LOCK_NB) <0)
    sleep (1);
  lseek(ctrlfile,0L,0);
  a=read(ctrlfile,&msgmain,sizeof(struct msgmain));
  if (a<1)
    interr(14);

  lseek(ctrlfile,0L,0);
  a=write(ctrlfile,&msgmain,sizeof(struct msgmain)); 
  if (a<1)
    interr(16);

  origpos=msgmain.MMcurpos;
  ++msgmain.MMhighest;
  sprintf(mid,"I%ld",msgmain.MMhighest);

  /* measure the message */
  file=open(filename,O_RDONLY);
  if (file<0)
    interr(17);
  templen=lseek(file,0L,2);
  close(file);
  templen=templen+(long)strlen(mid);
  ++templen;

  /* check for FF bytes */
  hibytes=0L;
  ffbytes=0L;
  sprintf (msgfile, "msgmains/msgmain.%d", curr_rm);
  fp=fopen(msgfile,"rb"); /* read only */
  if (fp==NULL)
    interr(18);
  bb=fseek(fp,msgmain.MMcurpos,0);
  cc=ftell(fp);
  for (bb=0L; bb<templen; ++bb) 
    {
      if (curr_rm != 1) 
	{
	  if (cc>=MM_FILELEN)
	    cc=fseek(fp,0L,0);
	}
      else
	{
	  if (cc>=MM_MAIL) 
	    cc=fseek(fp, 0L, 0);
	}
      c=getc(fp);
      ++cc;
      if (c>127)
	++hibytes;		/* bump count if hi bit set */
      if (c==255)
	++ffbytes;
    }
  fclose(fp);
  msgmain.MMlowest=msgmain.MMlowest+hibytes;
  if (hibytes >= 10)
    {
      sprintf(intmsg,"Abnormal hibytes (%ld) FF=%ld in room #%d, msg=%d, size=%d",
	      hibytes, ffbytes, curr_rm, msgmain.MMhighest, templen);
      intlog(intmsg);
    }


  if ((file=open(msgfile,O_RDWR)) < 0)
    interr (91);
  while (flock (file, LOCK_EX|LOCK_NB) < 0)
    sleep (1); /* obtain lock */
  cc=lseek(file,msgmain.MMcurpos,0); 
  if ((file2=open(filename,O_RDONLY)) < 0)
    interr(19);
  cc=lseek(file,0L,1);
  d=read(file2,sbuf,3); 
  write(file,sbuf,d);
  write(file,mid,strlen(mid));
  d=0;
  write(file,&d,1);
  do
    {
      d=read(file2,sbuf,BUFSIZ);
      write(file,sbuf,d);
      cc=cc+(long)d;
      if (curr_rm != 1) 
	if (((long)cc)>=((long)MM_FILELEN))
	  cc=lseek(file,0L,0);
      if (curr_rm == 1) 
	if (((long)cc)>=((long)MM_MAIL))
	  cc=lseek(file,0L,0);
    }
  while(d>0);

  msgmain.MMcurpos=lseek(file,0L,1);
  flock (file, LOCK_UN);
  close(file2);	/* done with temp file */
  close(file);	/* done with master file */
  
  /* now update the message structure */
  lseek (ctrlfile, 0L, 0);
  a=write(ctrlfile,&msgmain,sizeof(struct msgmain));
  if (a<1)
    interr(21);
  flock (ctrlfile, LOCK_UN);
  close(ctrlfile);
  
  retbuf->smnumber=msgmain.MMhighest;
  retbuf->smpos=origpos;
  
  return(0);
}

make_message(filename,author,recipient,type,mode)
     char filename[];	       /* temporary file name */
     user_type *author;        /* author's usersupp structure */
     char recipient[];	       /* NULL if it's not mail */
     int type;		       /* see MES_ types in header file */
     int mode;		       /* 0 for normal, 1 for ASCII, 2 for editor */
{ 
  FILE *fp, *fp2;
  int a,b,old;
  int editor_exit;
  long aa,beg,now;
  char aaa[100], editorfile[16];
  bool done;

  time(&now);
  fp=fopen(filename,"wb");
  if (fp==NULL)
    interr(22);
  putc(255,fp);
  putc(type,fp);	/* Normal or anonymous, see MES_ flags */
  putc(((mode!=0)?1:0),fp);	/* Formatted or unformatted */
/*
  strcpy(aaa,author->fullname);
  for (a=0; a<strlen(aaa); ++a) 
    {
      aaa[a]=ctolower(aaa[a]);
      if (aaa[a]==32)
	aaa[a]='_';
      if (aaa[a]=='!')
	strcpy(&aaa[a],&aaa[a+1]);
    } 
*/
/* the path is a stripped version of fullname used for network processing.
   It's probably safe nowadays to not bother with this, depending on how
   your files are transmitted. If you pull everything into one small
   msgmain then you need not worry about strange characters in the
   file itself. besides, it saves disk space */

/*  fprintf(fp,"P%s",aaa); putc(0,fp);		        /* path */

  fprintf(fp,"T%ld",now); putc(0,fp);		        /* date/time */
  fprintf(fp,"A%s",author->fullname); putc(0,fp);	/* author */

/* will eventually want to put the eternal number of the author
   in the post for kill file matching */
  fprintf(fp,"E%d",author->eternal); putc (0, fp);      /* author's eternal*/

  fprintf(fp,"O%s",quickroom.QRname); putc(0,fp);	/* room */
  fprintf(fp,"N%s",NODENAME); putc(0,fp);	        /* nodename */
  fprintf(fp,"H%s",HUMANNODE); putc(0,fp);              /* human nodename */

  if (recipient[0]!=0)
    {
      fprintf(fp,"R%s",recipient); putc(0,fp);
    }
  fflush(fp);

  msgform(usersupp.screenwidth,0L,filename);
  putc('M',fp);
  if (mode==1)
    printf("(Press ctrl-d when finished)\n");
  if (mode==2) 
    {
      sprintf (editorfile, "/tmp/ced%d", getpid());
      unlink (editorfile); /* remove it if it exists */
    }
  beg=ftell(fp);
  old=1;
  

 ME1: 
  switch (mode)
    {
    case 0:
      a=inkey(); a=(a&127);
      aa=ftell(fp);
      if ((a==8)&&(aa>beg)) 
	{
	  back(1);
	  fseek(fp,-1L,1);
	  goto ME1;
	}
      if ((a<32)&&(a!=13))
	goto ME1;
      putc(a,stdout);
      if ((old==13)&&(a==13))
	goto MECR;
      putc(a,fp);
      if (a==13)
	putc(10,stdout);
      old=a;
      goto ME1;
      break;
   case 1:
     do 
       {
	 a=inkey();
	 if (a==27)
	   a=32;
	 if (a==255)
	   a=32;
	 if (a==13)
	   a=10;
	 if (a!=4) 
	   {
	     putc(a,fp);
	     putc(a,stdout);
	   }
	 if (a==10)
	   putc(13,stdout);
       } 
     while(a!=4);
     break;
   case 2:
     a=fork();
     if (a==0)
       {
	 setsane();
	 execl (EDITOR, EDITOR, editorfile, NULL);
	 exit(1);
       }
     if (a>0)
       do
	 {
	   editor_exit = 0;
	   /* b will contain the PID of the editor process */
	   /* editor_exit will contain exit status of editor */
	   b=wait(&editor_exit);
	 } while((b!=a)&&(b>=0));
     sttybbs(0);
     break;
   }
  
 MECR:
  if (mode==2)
    {
      fseek(fp,beg,0);
      fp2 = fopen(editorfile,"r");
      if (fp2!=NULL)
	{
	  while(b=getc(fp2),b>0)
	    putc(b,fp);
	  fclose(fp2);
	}
    }
  
  putc(0,fp);
  fseek(fp,-1L,1);
  fflush(fp);
  if (mode==2)
    {
      if ((editor_exit)==0)
	goto MEFIN;
      else
	goto MEABT2;
    }
  else
    printf("<A>bort <C>ontinue <P>rint <S>ave -> ");
  
 MECR2:
  b=inkey();
  b=(b&127);
  b=ctolower(b);
  if (b=='a') 
    { 
      printf ("Abort\n");
      goto MEABT;
    }
  if (b=='c')
    {
      printf ("Continue\n");
      goto ME1;
    }
  if (b=='s')
    {
      printf("Save buffer\n");
      goto MEFIN;
    } 
  if (b=='p')
    {
      printf("Print formatted\n");
      curr_line=1;
      msgform(usersupp.screenwidth,0L,filename);
      goto MECR;
    }
  goto MECR2;
  
 MEFIN:
  putc(0,fp);
  fclose(fp);
  if (mode==2)
    unlink(editorfile);
  return(0);
  
 MEABT:
  printf("Are you sure? ");
  if (yesno()==0)
    goto ME1;
 MEABT2:
  fseek(fp,0L,0);
  putc(0,fp);
  putc(0,fp);
  fclose(fp);
  unlink (filename);
  if (mode==2) unlink(editorfile);
  return(2);
}

msgform(int width, long spos,char *mfile)
{
  struct tm *tm;
  int a,b,e,mtype,aflag;
  char ccc[50],bbb[100];
  
  FILE *fp;
  long now;
  char *strchr();
  
  fp=fopen(mfile,"rb");
  if (fp==NULL)
    return(1);
  fseek(fp,spos,0);
  e=getc(fp);
  if (e!=255) 
    {
      printf("*** CANNOT LOCATE MESSAGE / pos=%ld\n",spos);
      return(1);
    }
  mtype=getc(fp);
  aflag=getc(fp);
  printf("\n   ");
  increment();
  if (mtype==MES_ANON)
    printf("***** "); 
  if (mtype==MES_AN2)
    printf("<anonymous> ");
  do
    {
      b=getc(fp);
      if (b=='M')
	{
	  printf("\n");
	  increment();
	  if (aflag!=1)
	    fmout2(width,fp);
	  else
	    while(a=getc(fp), (a>0 && !abort_read))
	      {
		if ((a==13)||(a==10))
		  {
		    putc(a,stdout);
		    if (increment())
		      break;
		  }
		else
		  putc(a,stdout);
	      }
	}
      if ((b!='M')&&(b>0))
	fpgetfield(fp,bbb);
      
#ifdef SEEMID
      if (b=='I') 
	{
	  printf("(#%d-%s) ",curr_rm,bbb);
	  msgnum = atoi (bbb);
	}
#endif
      
      if ( (mtype!=MES_ANON && mtype!=MES_AN2)
	  || (usersupp.axlevel >= 6)
	  || (usersupp.eternal == quickroom.QRroomaide) ) 
	{
	  if (b=='A') 
	    {
	      printf("from %s ",bbb);
	      strcpy (who_from,bbb);
	    }
	  if ((b=='N')&&(strucmp(bbb,NODENAME))&&(curr_rm==1))
	    printf("@%s ",bbb);
	  if ((b=='H')&&(strucmp(bbb,HUMANNODE)))
	    printf("(%s) ",bbb);
	  if ((b=='O')&&(strucmp(bbb,quickroom.QRname)))
	    printf("in %s> ",bbb);
	  if ((b=='N')&&(quickroom.QRflags&QR_NETWORK))
	    printf("@%s ",bbb);
	  if (b=='R')
	    printf("to %s ",bbb);
	  if (b=='T') 
	    {
	      now=atol(bbb);
	      tm=(struct tm *)localtime(&now);
	      sprintf (ccc, "%s", asctime(tm));
	      ccc[strlen(ccc)-1]=0;
#ifdef SUNOS
	      sprintf(bbb,"%s %s %s", days[tm->tm_wday], ccc,
		      tm->tm_zone);
#else  /* bsd doesn't have tm->tm_zone! */
	      sprintf(bbb,"%s %s", days[tm->tm_wday], ccc);
#endif
	      printf("%s ",&bbb[4]);
	    }
	}
    }
  while ((b!='M')&&(b>0));
  printf("\n");
  increment();
  fclose(fp);
  return(0);
}

pull_message(spos,flnm)		/* Pull a message out of the master file */
     long spos;			/* position in master file */
     char *flnm;		/* file to write to */
{
  int a,b,c;
  FILE *file, *file2;
  long cc;
  char field[512];
  
  file2=fopen (flnm, "w+");
  sprintf (msgfile, "msgmains/msgmain.%d", curr_rm);
  file=fopen(msgfile, "rb");
  fseek(file,spos,0);
  
  for (a=0; a<3; ++a) 
    {
      b = getc (file);
      putc (b, file2);
    }
 PI:	
  b=0; 
  b = getc (file);
  if (b=='M') 
    {
      putc (b, file2);
      goto B;
    }
  fpgetfield(file,field);
  if (b!='I') 
    {
      putc (b, file2);
      fprintf (file2, "%s", field);
      putc (0, file2);
    }
  goto PI;
  
 B:
  cc = fseek(file,0L,1);
 C:
  if (curr_rm != 1)
    if (cc>=MM_FILELEN)
      cc=fseek(file,0L,0);
  if (curr_rm == 1) 
    if (cc>=MM_MAIL)
      cc=fseek(file,0L,0);
  c = getc (file);
  ++cc;
  putc (c, file2);
  if (c!=0)
    goto C;
  fclose(file); 	
  fclose(file2);
  return(0);
}

entmsg(e,c,replying)
     int e,c,replying; 
{
  char buf[300];
  int file,a,b,hold_rm;
  char mtsflag;
  user_type tempUS;
  long aa;

  /* first, check posting privledges and other conditions for posting */

  /* if we are in the lobby, the user must be axlevel LOBBYPOST */
  if ((curr_rm==0) && (usersupp.axlevel < LOBBYPOST)) 
    {
      printf (LOBBYMSG);
      return (0);
    }

  if ((quickroom.QRflags&QR_READONLY) &&
      /* both of these must be true to and with the above */
      ((usersupp.axlevel <= AX_AIDE) &&
       (usersupp.eternal != quickroom.QRroomaide)))
    {
      /* this room is read only */
      printf ("This room is read-only. You can read but not post here.\n");
      return (0);
    }

  /* hack to disable mail room for whatever reason*/
#ifdef DISABLE_MAIL
  if (curr_rm==1)
    { 
      printf (MAILMSG);
      return(0);
    }
#endif

  /* twits, deleted users, and new users can only send mail to sysop -- 
     for now. eventually new users will only be able to post to new users */

  if ((usersupp.axlevel<=2)&&(curr_rm!=1)) 
    {
      printf(TWITMSG);
      return(0);
    }

#ifdef NETWORKED
  /* if the system is networked and we are in a networked room... */
  if ((usersupp.axlevel<3)&&(quickroom.QRflags&QR_NETWORK)) 
    {
      printf(NETPRIV);
      return(0);
    }
#endif

  /* okay, lets go... */

  curr_line=1;

  enter_btmp ("Enter msg"); /* this must always be "Enter msg" ! */
  mtsflag=0;
  hold_rm=curr_rm;
  if (((usersupp.flags&US_EXPERT)==0) && ((usersupp.flags & US_EDITOR) == 0))
    formout(ENTERMESSAGE);
  buf[0]=0;
  if ((curr_rm==1)&&(feedback_flag))
    {
      strcpy(buf,"sysop");
      mtsflag=1;
      goto SKFALL;
    }
  if (curr_rm==1)
    {
      if (usersupp.axlevel>=2)
	{
	  if (!replying) 
	    {
	      printf("Enter recipient: ");
	      getline(buf,299);
	    }
	  else 
	    { 
	      strcpy(buf,who_from);  
	      replying = 0;
	    }
	}
      else
	{
	  strcpy(buf,"sysop");
	  mtsflag=0;
	}

      e=alias(buf); /* alias and mail type */
      if (buf[0]==0)
	return(0);
      if ((e!= M_LOCAL) && (usersupp.axlevel < 3))
	{
	  printf (NETMAIL);
	  return (1);
	}
      if (!strucmp(buf,"sysop"))
	{
	  mtsflag=1;
	  goto SKFALL;
	}

      if (e != M_LOCAL) goto SKFALL; /* don't search local file if remote */

      if (!strucmp(buf,usersupp.fullname)) 
	{
	  printf(SELFMAIL);
	  return(0);
	}
      file=eopen("usersupp",O_RDONLY);	/* check to make sure the */
      aa=finduser(file,buf);		/* user exists; also get  */
	if (aa==(-1)) 
	  {				/* the right upper/lower  */
	    printf("No such user.\n");	/* casing of the name     */
	    close(file);
	    return(0);
	  }
      read(file,&tempUS,sizeof(user_type));
      strcpy(buf,tempUS.fullname);
      close(file);
    }

  /* hardcode mail ignore for now until we think of a nice way to do it */
#ifdef HARDCODE_IGNORE
  if (((usersupp.eternal == 9003) && (tempUS.eternal ==18736))
      ||((usersupp.eternal==18736) && (tempUS.eternal==9003))
      ||((usersupp.eternal==2) && (tempUS.eternal ==12198)))
    {
      printf ("You are not allowed to mail user %s, and s/he is not\nallowed to mail you.\n", tempUS.fullname);
      return(0);
    }
#endif
	
 SKFALL:
  b=MES_NORMAL;
  if (quickroom.QRflags&QR_ANONONLY)
    b=MES_ANON;
  if (quickroom.QRflags&QR_ANON2)
    {
      printf("Anonymous (Y/N)? ");
      if (yesno()==1)
	b=MES_AN2;
    }
  if (curr_rm!=1)
    buf[0]=0;

  /* mtsflag indicates mail to sysop */
  if (mtsflag==1)
    {
      curr_rm=2;
      hold_rm=curr_rm;
      gotocurr();
    }
  a=make_message(temp,&usersupp,buf,b,c);
  if (a==2) 
    {         /* user aborted message */
      if ((curr_rm==2) && (usersupp.axlevel < 6))
	{
	  curr_rm=1;
	  gotocurr();
	}
      return(0);    /* changed from return(1) */
    }
  save_message(temp,buf,mtsflag,e);
  if ((curr_rm==2) && (usersupp.axlevel<6))
    {
      curr_rm = 1;
      gotocurr();
    }
  return(1);    /* changed from return(0) */
}

readmsgs(b,c,odir)	/* read contents of a room */
     int b;		/* starting point in room to read */
     int c;		/* 0=Read all  1=Read new  2=Read old */
     int odir;	        /* 1=Forward (-1)=Reverse */
{
  int a, d, e, file, rdir;
  long aa, cc;
  struct msgmain msgmain;
  
  signal(SIGINT,SIG_IGN);
  signal(SIGQUIT,SIG_IGN);
  rdir = odir; /* start us off in the right direction */
  cc=usersupp.lastseen[curr_rm]+1L;
  if ((usersupp.flags & US_LASTOLD) && (curr_rm != 0)) --cc;
  sprintf (structfile, "structures/MMstructure.%d", curr_rm);
  file=eopen(structfile,O_RDONLY);
  a=read(file,&msgmain,sizeof(struct msgmain));
  if (a<1)
    interr(45);
  close(file);
  abort_read = 0;
  curr_line=1;
  for (a=b; ((a<MSGSPERRM)&&(a>=0)); a=a+rdir) 
    {
      while ( (fullroom.FRnum[a]==0L)
	     ||  (fullroom.FRnum[a]<msgmain.MMlowest)
	     || ((c==1)&&(fullroom.FRnum[a]<cc))
	     || ((c==2)&&(fullroom.FRnum[a]>=cc)))
	{
	  a=a+rdir;
	  if ((a==MSGSPERRM)||(a==(-1)))
	    return(0);
	}
      c = 0;

      e=read_message(fullroom.FRpos[a]);
      unseen = a + 1;
      if ((e==2) || abort_read)  
	return(0);
      if (((usersupp.flags&US_NOPROMPT)||(e==1))&&(curr_rm!=1))
	e='n';
      else
	{
	  curr_line=1;
	  if (((usersupp.axlevel >= 6) 
	       || (usersupp.eternal ==quickroom.QRroomaide))
	      && (curr_rm != 1))
	    printf ("<D>elete, <M>ove, ");
	  if (curr_rm==1)
	    printf ("<R>eply, <B>ack, <N>ext, <S>top (%d) -> ", MSGSPERRM-a-1);
	  else
	    printf ("<B>ack, <N>ext, <S>top (%d) -> ", MSGSPERRM-a-1);
	  do
	    {
	      e=(inkey()&127);
	      e=ctolower(e);
	      if((usersupp.axlevel<6)
		 &&(usersupp.eternal!=quickroom.QRroomaide))
		if ((e=='d')||(e=='m'))
		  e=0;
	      if ((e=='r')&&(curr_rm!=1))
		e=0;
	    }
	  while((e!='b')&&(e!='n')&&(e!='s')&&(e!='r')&&(e!='d')&&(e!='m'));
	  switch(e)
	    {
	    case 'd':
	      printf("Delete\n");
	      break;
	    case 'm':
	      printf("Move\n");
	      break;
	    case 'b':
	      printf("Back\n");
	      break;
	    case 'n':
	      printf("Next\n");
	      break;
	    case 's':
	      printf("Stop\n");
	      break;
	    case 'r':
	      printf("Reply\n");
	      break;
	    }
	}
      switch(e)
	{
	case 's':
	  return(0);
	case 'b':
	  rdir = (-odir);
	  break ;
	case 'n':
	  rdir = odir;
	  break;
	case 'd':
	  printf("---> Delete this message? ");
	  if (yesno()==1)
	    {
#ifdef SAVEDELETE
              if (move_message(fullroom.FRpos[a],TWITROOM))
              {
                delete_message(fullroom.FRnum[a]);
                loadtroom();
                IFNAIDE kickout(usersupp.fullname,twitroom);
              }
#else
                delete_message(fullroom.FRnum[a]);
#endif
	    }
	  break;
	case 'm':
	  if (move_message(fullroom.FRpos[a],""))
	    delete_message(fullroom.FRnum[a]);
	  else 
	    printf ("Move cancelled.\n");
	  break;
	case 'r':
          lastpos = fullroom.FRnum[MSGSPERRM-1];
	  aa = fullroom.FRnum[a];
	  if (usersupp.flags & US_EDITOR)
	    d=entmsg(0,2,1);
	  else
	    d=entmsg(0,0,1);
          if (lastpos != fullroom.FRnum[MSGSPERRM-1-d])
            printf("New mail arrived for you while you were entering.\n\n");
	  if (d)
	    while (aa != fullroom.FRnum[a])
	      a--;
          break;
	}
    } /* end for loop */
  return(0);
} /* end read routine */

save_message(mtmp,rec,mtsflag,mailtype)
     char mtmp[];		/* file containing proper message */
     char rec[];		/* Recipient (if mail) */
     char mtsflag;		/* 0 for normal, 1 to force Aide> room */
     int mailtype;              /* local or remote type, see citadel.h */
{			
  int a,d,e,file,hold_rm;
  long aa,ee;
  user_type tempUS;
  char aaa[100];
  int atroom=-1;
  send_message(mtmp,&smreturn);
  hold_rm=(-1);

  if (mtsflag==1)
    {
      hold_rm=curr_rm;
      curr_rm=2;
      gotocurr();
    }
  sprintf(aaa,"./rooms/fullrm%d",curr_rm);
  file=open(aaa,O_RDWR);
  if (file<0)
    interr(28);
  while (flock (file, LOCK_EX | LOCK_NB) < 0)
    sleep (1);
  a=read(file,&fullroom,sizeof(struct fullroom));
  if (a<1)
    interr(49);
  if (curr_rm==1)
    readmail();
  for (a=0; a<(MSGSPERRM-1); ++a) 
    {
      fullroom.FRnum[a]=fullroom.FRnum[a+1];
      fullroom.FRpos[a]=fullroom.FRpos[a+1];
    }
  fullroom.FRnum[MSGSPERRM-1]=smreturn.smnumber;
  fullroom.FRpos[MSGSPERRM-1]=smreturn.smpos;
  lseek(file,0L,0);
  a=write(file,&fullroom,sizeof(struct fullroom));
  if (a<1)
    interr(50);
  flock (file, LOCK_UN);
  close(file);

  file=open("quickroom",O_RDWR);
  if (file<0) 
    interr(29);
  while (flock (file, LOCK_EX | LOCK_NB) < 0)
    sleep (1);
  aa=(long)(curr_rm * sizeof(struct quickroom));
  lseek(file,aa,0);
  a=read(file,&quickroom,sizeof(struct quickroom));
  if (a<1)
    interr(52);
  quickroom.QRhighest=fullroom.FRnum[MSGSPERRM-1];
  lseek(file,aa,0);
  a=write(file,&quickroom,sizeof(struct quickroom));
  if (a<1)
    interr(53);
  flock (file, LOCK_UN);
  close(file);
  readyerself();
  ++usersupp.posted;
  if (curr_rm==twitroom)
    usersupp.generation[twitroom]=quickroom.QRgen;
  writeyerself();
  if (curr_rm!=1)
    goto ENTFIN;	/* if mail, there's still more to do */
  writemail();			/* keep a copy for yourself */
  if (mtsflag)
    goto ENTFIN;

  if (mailtype!=M_LOCAL) 
    {
      printf("Filing network mail...\n");
      if ((a=fork())==0) 
	{
	  execlp("netmailer","netmailer",mtmp,&mailtype,NULL);
	  printf("*** Netmailer not installed.\n");
	  exit(0);
	}
      do 
	d=wait();
      while((d!=a)&&(d!=(-1)));
    }
  if (mailtype==M_LOCAL) 
    {
      if ((file=open("usersupp",O_RDWR)) < 0)
	interr (29);

      ee=finduser(file,rec);
      if (ee!=(-1L)) 
	{
	  lockf (file, F_LOCK, (long) sizeof (user_type));
	  d=read(file,&tempUS,sizeof(user_type));
	  if (d<0) printf ("no data!\n");
	  for (e=0; e<(MAILSLOTS-1); ++e) 
	    {
	      tempUS.mailnum[e]=tempUS.mailnum[e+1];
	      tempUS.mailpos[e]=tempUS.mailpos[e+1];
	    }
	  tempUS.mailnum[MAILSLOTS-1]=smreturn.smnumber;
	  tempUS.mailpos[MAILSLOTS-1]=smreturn.smpos;
	  lseek(file,ee,0);
	  write(file,&tempUS,sizeof(user_type)); 
	  lseek (file, ee, 0); /* gotta go back to unlock */
	  lockf (file, F_ULOCK, (long) sizeof (user_type));
	}
      close(file);
    }
  
 ENTFIN:	
  if (mtsflag) 
    { 
      curr_rm=hold_rm;
      gotocurr();
    }
  unlink(mtmp);
  return(0);
}

delete_message(delnum) /* Delete message from current room */
     long delnum; 
{
  int file,a,b;
  char aaa[100];

  if (curr_rm==1) 
    {
      printf("Can't delete mail.\n");
      return(1); 
    }
  sprintf(aaa,"./rooms/fullrm%d",curr_rm);
  file=open(aaa,O_RDWR);
  if (file < 0)
    interr (28);
  while (flock (file, LOCK_EX | LOCK_NB) < 0)
    sleep (1);
  a=read(file,&fullroom,sizeof(struct fullroom));
  if (a<1) 
    interr(79); 
  for (a=0; a<MSGSPERRM; ++a)
    if (fullroom.FRnum[a]==delnum) 
      {
	fullroom.FRnum[a]=0L;
	fullroom.FRpos[a]=0L;
      }
  lseek(file,0L,0);
  a=write(file,&fullroom,sizeof(struct fullroom));
  if (a<1)
    interr(80);
  flock (file, LOCK_UN);
  close(file);
  file=open("quickroom",O_RDWR);
  if (file < 0)
    interr (29);
  while (flock (file, LOCK_EX | LOCK_NB) < 0)
    sleep (1);
  lseek(file,(long)(curr_rm*sizeof(struct quickroom)),0);
  b=read(file,&quickroom,sizeof(struct quickroom));
  if (b<1)
    interr(82);
  quickroom.QRhighest=0L;
  for (a=0; a<MSGSPERRM; ++a)
    if (fullroom.FRnum[a]>quickroom.QRhighest)
      quickroom.QRhighest=fullroom.FRnum[a];
  lseek(file,(long)(curr_rm*sizeof(struct quickroom)),0);
  b=write(file,&quickroom,sizeof(struct quickroom));
  if (b<1) 
    interr(83);
  flock (file, LOCK_UN);
  close(file);
  printf("Message deleted.\n");
  sprintf(aaa,"DELETE:%s: Msg %d-%d in %s>", usersupp.fullname,
	  curr_rm, msgnum, quickroom.QRname);
  intlog(aaa);
  return(0);
}

move_message(long pos, char *destination)
{
  char targ[20];
  int file,a,h;
  struct quickroom qtemp;

  h=curr_rm;
  pull_message(pos,temp);

  strcpy (targ,destination);
  do 
    {
      curr_rm=(-1);
      if (!targ[0])/* if we don't have a destination room already*/
                   /* then ask for one */
	{
	  printf("Enter target room: ");
	  getline(targ,19);
	}
      if (targ[0]==0)
	{
	  curr_rm = h;
	  return(0);
	}
      file=open("quickroom",O_RDONLY);
      for (a=0; a<MAXROOMS; ++a) 
	{
	  read(file,&qtemp,sizeof(struct quickroom));
	  if ((!strucmp(qtemp.QRname,targ))&&(qtemp.QRflags&QR_INUSE)) 
	    curr_rm=a;
	}
      close(file);
      strcpy (targ, "");
    } 
  while(curr_rm<0);

  gotocurr();
  save_message(temp,"",0,M_LOCAL);
  curr_rm=h;
  gotocurr();
  return(1);
}


void updatels() 	/* make all messages old in current room */
{
  int a;

  readyerself();
  storeug();
  for (a=0; a<MSGSPERRM; ++a)
    if (fullroom.FRnum[a]>usersupp.lastseen[curr_rm])
      usersupp.lastseen[curr_rm]=fullroom.FRnum[a];
  if (curr_rm==1)         /* if mail room, do it a little differently... */
    usersupp.lastseen[1]=usersupp.mailnum[MAILSLOTS-1];
  writeyerself();
}

updatepartial() 	/* make SOME messages old in current room */
{
  int a;

  readyerself();
  storeug();
  for (a=0; a<unseen; ++a)
    if (fullroom.FRnum[a]>usersupp.lastseen[curr_rm])
      usersupp.lastseen[curr_rm]=fullroom.FRnum[a];
  if (curr_rm==1)         /* if mail room, do it a little differently... */
    usersupp.lastseen[1]=usersupp.mailnum[MAILSLOTS-1];
  writeyerself();
}


