/* 
File: intlog.c (dependent)
Desc: internal logging routine
Source: (local) pirmann@demigod.rutgers.edu 
*/


#include <fcntl.h>
#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "citadel.h"

intlog (char *message)   /* record message to a FOTD */
{
  struct tm *tmstruct;
  FILE *logfile;
  long atime;
  char logline[256], whichlog[50], date[15], logdate[7];

  time (&atime);
  tmstruct = localtime (&atime);
  sprintf (date, "%2.2d/%2.2d/%2.2d %2.2d:%2.2d", tmstruct->tm_mon+1,
	   tmstruct->tm_mday, tmstruct->tm_year, tmstruct->tm_hour,
	   tmstruct->tm_min);
  sprintf (logdate, "%2.2d%2.2d%2.2d", tmstruct->tm_mon+1,
	   tmstruct->tm_mday, tmstruct->tm_year);
  date[15]='\0'; logdate[7]='\0';

  sprintf (logline, "%s %s", date, message);
  sprintf (whichlog, "%s.%s", LOGINT, logdate);

  if ((logfile = fopen (whichlog, "a"))!= NULL) 
    {
      fprintf (logfile, "%s\n", logline);
      fclose (logfile);
    }

  return (0);
}

