/* 
File: eroom.c
Desc: better roomedit
Source:  (local) pirmann@rutgers.edu 
Change History
06/21/93 created
10/30/93 put into production
12/04/93 fixed bug concerning guessname/private status
*/

#include <stdio.h>
#include <fcntl.h>
#include <ctype.h>
#include <time.h>
#include "citadel.h"

bool need_rewrite;
extern int curr_rm;
extern struct quickroom quickroom;

editroom(user_type *person)    
{
  char aaa[100], oldname[26], commandstr[10], rmnm[3];
  long aa, bb, remaining;
  int file, command, a;
  user_type tempUS;
  bool done=FALSE;

  if (person->axlevel > AX_AIDE)
    {
      printf ("Enter # of room to edit, or <return> for current: ");
      getline (rmnm, 3);
      if (rmnm[0] != 0)
	curr_rm = atoi (rmnm);
      
    }
  /* else curr_rm is the current room and we want to edit it */

  /* don't mung lobby mail or aide */
  if (curr_rm<2) 
    {
      printf("Can't edit this room.\n");
      return(0);
    }

  enter_btmp ("[Edit Room]");

  /* read in current settings */
  file=open("quickroom",O_RDONLY);
  if (file<0) 
    interr(34);
  lseek(file,(long)(curr_rm*sizeof(struct quickroom)),0);
  a=read(file,&quickroom,sizeof(struct quickroom));
  if (a<1) 
    interr(35);
  close (file);

  printf ("Room #%d, %s\n", curr_rm, quickroom.QRname);
  printf ("Are you sure you want to edit this room (y/n)? ");
  if (yesno()==0) 
    return (0);

  need_rewrite=FALSE; 

  system ("clear");

  while (!done)
    {
      /* display room information */
      printf ("------------------------------------------------------------------\n");

      printf ("Room #%d: %-20.20s\n", curr_rm, quickroom.QRname);

      show_room_flags();

      printf ("1. Edit room name.\n");
      printf ("2. Edit room type (public/private/postable).\n");
      printf ("3. Edit anon type (none/only/option).\n");
      printf ("4. Toggle described status.\n");
      printf ("5. Toggle use of editor in rooms -- AIDE ONLY\n");
      printf ("6. Edit room aide -- AIDE ONLY\n");
      printf ("7. Edit network/directory status -- SYSOP ONLY\n");
      printf ("8. Zeroroom -- SYSOP ONLY\n");

      printf ("\n0. Exit (will prompt for saving or aborting)\n");

      printf ("\nEnter field number to change (0 to exit): ");
      getline (commandstr, 3);
      command = atoi (commandstr);

      if (command == 0)
	done = TRUE;
      else
	edit_room_field (&quickroom, command, person);
    }  /* end while */
       
  if (need_rewrite==TRUE) 
    {
      printf ("Save changes (y/n)? ");
      if (yesno()==0) 
	{
	  /* reload old quickroom and return */
	  file = open ("quickroom", O_RDONLY);
	  if (file < 0)
	    interr (47);
	  lseek(file,(long)(curr_rm*sizeof(struct quickroom)),0);
	  a=read(file,&quickroom,sizeof(struct quickroom));
	  if (a<1) 
	    interr(36);
	  close(file); 
	}
      else
	{
	  file=open("quickroom",O_RDWR);
	  if (file < 0)
	    interr (46);
	  lseek(file,(long)(curr_rm*sizeof(struct quickroom)),0);
	  a=write(file,&quickroom,sizeof(struct quickroom));
	  if (a < 0)
	    interr (37);
	  close(file);
	}
    }  
  return (0);
}

edit_room_field (struct quickroom *QRedit, int fieldnum, user_type *person)
{
  char new[100];
  int file2,loop;
  FILE *fp;
  long aa; 
  bool match=FALSE, done=FALSE;
  char aaa[50];
  user_type tempUS;
  struct quickroom QRtmp;

  switch (fieldnum)
    {
      /*--------------------------------------------------------------------*/
    case 1:
      printf ("Enter new room name: ");
      getline (new, 20);
      fp = fopen ("quickroom", "r");

      /* look to see if name being used */
      for (loop=0;loop < MAXROOMS; loop++)
	{
	  fread (&QRtmp, sizeof (struct quickroom), 1, fp);
	  if ((strcasecmp (new, QRtmp.QRname)) == 0)
	    match=TRUE;
	}
      fclose (fp);
      if (match)
	printf ("Name already in use!\n");
      else
	{
	  strcpy (QRedit->QRname, new);
	  need_rewrite=TRUE;
	}
      break;

      /*--------------------------------------------------------------------*/

    case 2:   /* room type */

      printf("Room type? <1> public (all users) <2>guessname <3> invite only : ");
      do 
	loop=inkey()-48;
      while ((loop<1)||(loop>3));
      printf("%d\n",loop);

      if (loop == 1)  /* public room */
	{ /* we want neither private flag */
	  printf ("Room will be PUBLIC.\n\n");
	  QRedit->QRflags &= ~QR_PRIVATE;
	  QRedit->QRflags &= ~QR_GUESSNAME;
	}
      if (loop == 2) /* guessname room */
	{ /* we need both flags on */
	  printf ("Room will be GUESSNAME.\n\n");
	  QRedit->QRflags |= QR_PRIVATE;
	  QRedit->QRflags |= QR_GUESSNAME;
	}
      if (loop == 3) 
	{  /* invite -- just private flag, guessname off */
	  printf ("Room will be INVITE ONLY.\n\n");
	  QRedit->QRflags |= QR_PRIVATE;
	  QRedit->QRflags &= ~QR_GUESSNAME;
	}

      if ((QRedit->QRflags&QR_PRIVATE)==QR_PRIVATE)
	{
	  printf("Kick out all users? ");
	  if (yesno()==1) 
	    {
	      ++QRedit->QRgen;
	      if (QRedit->QRgen==100) QRedit->QRgen=10; 
	    }
	}

      if (person->axlevel >= AX_AIDE) 
	{ 	
	  printf("Preferred users only? "); 
	  if (yesno()==1) 
	    /* turn it on */
	    QRedit->QRflags |= QR_PREFONLY;
	  else 
	    /* turn it off */
	    QRedit->QRflags &= ~QR_PREFONLY;
	}

      printf ("Restrict posting to (room)aides? ");
      /* off by default */
      if (yesno()==1)
	/* turn it on */
	QRedit->QRflags |= QR_READONLY;
      else
	QRedit->QRflags &= ~QR_READONLY;

      need_rewrite=TRUE;
      break;

      /*--------------------------------------------------------------------*/

    case 3:
      printf("<1>Normal <2>Anon-only <3>Anon-option ? ");
      do 
	loop=inkey()-48;
      while((loop<1)||(loop>3));
      printf("%d\n",loop);

      if (loop==1)  /* normal room, remove flags */
	{ 
	  QRedit->QRflags &= ~QR_ANONONLY;
	  QRedit->QRflags &= ~QR_ANON2;
	}
      if (loop==2) /* anononly room, set proper flag */
	QRedit->QRflags |= QR_ANONONLY;
      if (loop==3) /* anonopt room */
	QRedit->QRflags |= QR_ANON2;

      need_rewrite=TRUE;
      break;

      /*--------------------------------------------------------------------*/

    case 4:
      printf ("Current described status is: ");
      if (QRedit->QRflags & QR_DESCRIBED)
	printf ("Room has a description file.\n");
      else
	printf ("Room has NO description file.\n");
      printf ("Toggle? ");
      if (yesno())
	QRedit->QRflags = (QRedit->QRflags | QR_DESCRIBED);
      printf ("New described status is: ");
      if (QRedit->QRflags & QR_DESCRIBED)
	printf ("Room has a description file.\n");
      else
	printf ("Room has NO description file.\n");

      need_rewrite=TRUE;
      break;
       
      /*--------------------------------------------------------------------*/

    case 5:
      if (person->axlevel <= AX_AIDE)
	{
	  printf ("Must be a system aide to select editor option.\n\n");
	  break;
	}
      if (!USE_EDITOR)
	{
	  printf ("The editor option is not installed on this system.\n\n");
	  break;
	}
      printf ("Allow use of editor? ");
      if (yesno()==1) /* if yes, REMOVE this flag */
	QRedit->QRflags &= ~QR_NOEDITOR;
      else
	QRedit->QRflags |= QR_NOEDITOR;


      need_rewrite=TRUE;
      break;

      /*--------------------------------------------------------------------*/

    case 6:
      if (person->axlevel <= AX_AIDE)
	{
	  printf ("Must be a system aide to set/change room aide.\n\n");
	  break;
	}
      if (QRedit->QRroomaide>=0L) 
	{
	  /*      file2=open("usersupp",O_RDONLY);
		  if (file2 < 0)
		  interr (54);
		  do 
		  a=read(file2,&tempUS,sizeof(user_type));
		  while((a>0)&&(QRedit->QRroomaide!=tempUS.eternal));
		  if (a>0) 
		  printf("Room aide is currently: %s\n", tempUS.fullname);
		  close(file2);
		  */
	  printf ("Main room aide is currently: %s\n", QRedit->QRaidename);
	}
      else 
	printf("No room aide.\n");
      
      while (!done)
	{
	  printf("Room aide (return for NONE): ");
	  getline(aaa,29);
	  if (aaa[0] == 0) 
	    {
	      QRedit->QRroomaide = 0L;
	      done = TRUE;
	    }
	  else
	    {
	      file2=open("usersupp",O_RDONLY);
	      if (file2 < 0)
		interr (54);
	      aa=finduser(file2,aaa);
	      loop=read(file2,&tempUS,sizeof(user_type));
	      if (loop < 0)
		interr (51);
	      close(file2);
	      if (aa==(-1L)) 
		printf("No such user.\n"); 
	      else
		{
		  QRedit->QRroomaide=tempUS.eternal;
		  strcpy (QRedit->QRaidename, tempUS.fullname);
		  done = TRUE;
		}
	    } /* end else */
	} /* end while */
      need_rewrite=TRUE;
      break;

      /*-------------------------------------------------------------------*/

    case 7:
      if (person->axlevel == AX_SYSOP) 
	{
	  if (NETWORKED)
	    {
	      printf("Network Room? ");
	      if (yesno()==1) 
		QRedit->QRflags |= QR_NETWORK;
	      else
		QRedit->QRflags &= ~QR_NETWORK;
	    }
	  printf("Directory room? ");
	  if (yesno()==1) 
	    {
	      QRedit->QRflags |= QR_DIRECTORY;

	      printf("     Directory name? ");
	      getline(QRedit->QRdirname,14);

	      printf("  Uploading allowed? ");
	      if (yesno()==1) 
		QRedit->QRflags |= QR_UPLOAD;
	      else
		QRedit->QRflags &= ~QR_UPLOAD;

	      printf("Downloading allowed? ");
	      if (yesno()==1) 
		QRedit->QRflags |= QR_DOWNLOAD;
	      else
		QRedit->QRflags &= ~QR_DOWNLOAD;

	      printf("  Visible Directory? ");
	      if (yesno()==1) 
		QRedit->QRflags |= QR_VISDIR; 
	      else
		QRedit->QRflags &= ~QR_VISDIR; 
	    }
	  else /* not a network room, unset all the flags */
	    {
	      QRedit->QRflags &= ~QR_DIRECTORY; 
	      QRedit->QRflags &= ~QR_UPLOAD; 
	      QRedit->QRflags &= ~QR_DOWNLOAD; 
	      QRedit->QRflags &= ~QR_VISDIR; 
	    }
	}
      need_rewrite=TRUE;
      break;

    case 8:
      printf ("Under construction...\n\n");
/*      need_rewrite=TRUE;*/
      break;

    default:
      break;
    } /* end switch */
} /* end edit routine */

