/* 
File: diagnose.c
Desc: diagnose problems in citadel structures
Source: knapp@sun490.fdu.edu
*/

#include <fcntl.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <unistd.h>
#include "citadel.h"
#include "cctype.h"

#undef _toupper
toupper(c)
int c; {return(islower(c)?c-'a'+'A':c);}
#undef _tolower
tolower(c)
int c; {return(isupper(c)?c-'A'+'a':c);}

long atol();
long lseek();
char *malloc();

#include "hash.h"
#define NOPRINT 0
#define PRINT 1

int WRITE=0;
int numaides;
char aidelist[10][50];
int warnings,		/* Not a problem, but unusual. */
    fixes,		/* Number of items fixed during a given verify */
    errors;		/* Number not fixable *by this program* (yet?) */
struct quickroom QRarray[MAXROOMS];
struct msgmain MMarray[MAXROOMS];
struct fullroom fullroom;

main(argc,argv)
int argc;
char *argv[];
{
  chdir(BBSDIR);

  if ((argc == 2) && (strcmp(argv[1],"WRITE")==0))
    WRITE = 1;
  if (WRITE) printf("Changes will be saved to file.\n");

  readaidelist();

  loadQR();
  loadMM();

  verifyroomstructs();
  /*verifyusersupp(); */
}


/* Reads the aide list from a text file.  The file must have one aide
   per line, spelled exactly like his/her handle appears.  No extraneous
   info. This is used to make sure no bugs let a user be an aide for
   long, however unlikely. */
readaidelist() 
{	
	FILE *file;

	file=fopen("aidelist","r");

	numaides = 0;
	while (fgets(aidelist[numaides],30,file) != NULL)
	{
	  /* Fix the silly newline at the end */
	  aidelist[numaides][strlen(aidelist[numaides])-1] = 0;
	  numaides++;
	}

	fclose(file);
}


/* Returns zero if the passed name is not an aide, non-zero otherwise */
int aide(name)
char *name;
{
	int i,found=0;

	for (i=0;i<numaides;i++)
	  if (strucmp(name,aidelist[i])==0)
	    found++;
	return(found);
}


/* The main loop which verifies each user in turn. */
verifyusersupp() 
{	
int b,file,file2;
user_type usersupp;
char ldate[9];

	file=open("usersupp",O_RDWR);
	lseek(file,0L,0);
	if (file<0)
	{
	  printf("No usersupp file available.\n");
	  return(1);
	}
	/* read and skip the first user (!) no matter what. */
	read(file,&usersupp,sizeof(user_type));

	while (read(file,&usersupp,sizeof(user_type))>0)
	{
	  warnings = fixes = errors = 0;
	  verifyuser(&usersupp,PRINT);
	  if (warnings+fixes+errors)
	  {
	    printf("\n%5d %-s: %d warnings, %d fixes, %d errors.",
		  usersupp.eternal,usersupp.fullname,warnings,fixes,errors);
	    /* If there were fixes, verify the fix, then write the changes */
            if (fixes)
	    {
	      warnings = fixes = errors = 0;
	      verifyuser(&usersupp,NOPRINT);
	      if (!fixes) /* no fixes, so they worked the first time (?) */
	      {
	        printf("\n%5d %-s: %d warnings, %d fixes, %d errors.",
		    usersupp.eternal,usersupp.fullname,warnings,fixes,errors);
	        if (WRITE)
	        {
	          lseek(file,(-1L)*(sizeof(user_type)),1);
	          write(file,&usersupp,sizeof(struct usersupp));
	        }
	      }
	      else printf("   Not repaired\n");
	    }
	    printf("\n");
	  }
	}
    	close(file);
	return(0);
}


int verifyuser (structure,print)
user_type *structure;
int print;
{
  int i, j, found;

  if (!strlen(structure->fullname))
  {
    errors++;
    if (print) printf("\n Invalid handle");
  }

  if (!strlen(structure->password))
  {
    warnings++;
    if (print) printf("\n NULL password");
  }

  if (structure->eternal < 0)
  {
    errors++;
    if (print) printf("\n Invalid eternal #");
  }

#ifdef MAXFLOORS
  for (i=0; i<MAXFLOORS; i++)
  {
    found = 0;
    for (j=0; j<MAXFLOORS; j++)
      if (structure->floors[j] == i) found++;
    if (!found)
    {
      warnings++;
      if (print) printf("\n Missing floor %d",i);
      for (j=1; j<MAXFLOORS; j++)   /* Attempt a fix */
        if (structure->floors[j] == 0)  /* find a 0 after the ground floor */
	{
	  if (print) printf("  patched in slot %d",j);
          structure->floors[j] = i;     /* fill it in */
          warnings--;
          fixes++;
	  j = MAXFLOORS;                /* and quit */
	}
    }
  }
#endif

  for (i=0; i<MAXROOMS; i++)
  {
    /* I use 100 in the next line as a threshhold, because the lastseen
       value may not match the highest value if messages were deleted.
       So 100 should be enough to find unusual things without tripping
       on massive deletes. */
    if ( (roomisknown(structure,QRarray[i],i)) && (i != 2) &&
         (structure->lastseen[i] - QRarray[i].QRhighest) > 100 )
    {
      warnings++;
      if (print)
        printf("\n  Lastseen (%d) greater than highest (%d) in %s",
	structure->lastseen[i],QRarray[i].QRhighest,QRarray[i].QRname);
    }
  }

  if ( (structure->axlevel >= AX_AIDE) && !aide(structure->fullname))
  {
    fixes++;
    if (print) printf("\n*Invalid access level (%d)",structure->axlevel);
    structure->axlevel = AX_TWIT;
  }

  if (structure->online > 1000000)
  {
    warnings++;
    if (print) printf("\n High online time");
  }

  return;
}


/* verify the quickroom structures in the QRarray array. */
verifyroomstructs() 
{	
  int b;
  int file;
  char s[100];

  for (b=0; b<MAXROOMS; b++)
  {
	warnings = fixes = errors = 0;
	verifyroom(&QRarray[b],&MMarray[b],b,PRINT);
	if (warnings+fixes+errors)
	{
	  printf("\n%5d %-s: %d warnings, %d fixes, %d errors.",
		 b,QRarray[b].QRname,warnings,fixes,errors);
	  /* If there were fixes, verify the fix, then write the changes */
          if (fixes)
	  {
	    warnings = fixes = errors = 0;
	    verifyroom(&QRarray[b],&MMarray[b],b,NOPRINT);
	    if (!fixes) /* no fixes, so they worked the first time (?) */
	    {
	      printf("\n%5d %-s: %d warnings, %d fixes, %d errors.",
		     b,QRarray[b].QRname,warnings,fixes,errors);
	      if (WRITE)
	      {
                file=open("quickroom",O_RDWR);
                if (file<0) 
                  interr (55);
                lseek(file,(long)(b * sizeof (struct quickroom)), SEEK_SET);
                write(file,&QRarray[b],sizeof(struct quickroom));
                close(file);

    		sprintf(s,"structures/MMstructure.%d",b);
    		file=open(s,O_RDWR);
    		if (file<0) 
      		  interr (55);
    		write(file,&MMarray[b],sizeof(struct msgmain));
    		close(file);
	      }
	    }
	    else printf("  Not repaired\n");
	  }
	  printf("\n");
	}
  }
  return(0);
}

/* Analyze a single room for problems. */
int verifyroom (QR,msgmain,rmnumber,print)
struct quickroom *QR;
struct msgmain *msgmain;
int rmnumber;
int print;
{
  int i,j,e;
  FILE *fp;
  char s[100];

  if (QR->QRflags & QR_INUSE)
  {
      if (!strlen(QR->QRname))
      {
        warnings++;
        if (print) printf("\n Empty room name");
      }
  
      /* I use 100 in the next line as a threshhold, because the lastseen
         value may not match the highest value if messages were deleted.
         So 100 should be enough to find unusual things without tripping
         on massive deletes. */
      if (msgmain->MMhighest - QR->QRhighest > 50)
      {
        warnings++;
        if (print) printf("\n MMhighest(%d) not QRhighest(%d)",
			  msgmain->MMhighest,QR->QRhighest);
      }

      /*
      if ( (rmnumber == 155) && print)
      */
      if (msgmain->MMlowest > msgmain->MMhighest)
      {
        if (print) printf("\n Black Hole: MMlowest(%d) vs. MMhighest(%d)",
			  msgmain->MMlowest, msgmain->MMhighest);
        loadFR(rmnumber);
	sprintf(s,"msgmains/msgmain.%d",rmnumber);
        fp=fopen(s,"rb");
	if (fp == NULL) interr(55);
	j=MSGSPERRM;
	do
	{
	  --j;
	  if (fullroom.FRnum[j] != 0)
	  {
            fseek(fp,fullroom.FRpos[j],0);
            e=getc(fp);
            if (e==255) 
              printf("+");
          }
        }
	while ( j && (e==255) );
	fclose(fp);
        msgmain->MMlowest = fullroom.FRnum[j+1];
        msgmain->MMhighest = fullroom.FRnum[MSGSPERRM-1];
	if (print) printf("  Patched to %d & %d",
		   msgmain->MMlowest, msgmain->MMhighest);
        fixes++;
      }

  }
}


/* Loads quickroom structs into memory array */
int loadQR()
{
  int file;
  int i,d;

  file=open("quickroom",O_RDONLY);
  if (file<0) 
    interr (55);

  /*lseek(file,(long)(n * sizeof (struct quickroom)), SEEK_SET);*/
  for (i=0; i<MAXROOMS; i++)
    read(file,&QRarray[i],sizeof(struct quickroom));
  close(file);
  return(0);
}


/* Loads msgmain structs into memory */
int loadMM()
{
  int file;
  int i,d;
  char s[100];

  for (i=0; i<MAXROOMS; i++)
  {
    sprintf(s,"structures/MMstructure.%d",i);
    file=open(s,O_RDONLY);
    if (file<0) 
      interr (55);

    read(file,&MMarray[i],sizeof(struct msgmain));
    close(file);
  }
  return(0);
}


/* Loads a single fullroom struct */
int loadFR(n)
int n;
{
  int file;
  char s[100];

  sprintf(s,"rooms/fullrm%d",n);
  file=open(s,O_RDONLY);
  if (file<0) 
    interr (55);

  read(file,&fullroom,sizeof(struct fullroom));
  close(file);
  return(0);
}


write_hashtab()
{
	user_type u;
	int h;
	int in,out;
	
	in=open("usersupp",O_RDONLY);
	out=creat("hashtab",0644);
	while(read(in,&u,sizeof(user_type)))
	{
		h=hash(u.fullname);
		write(out,&h,sizeof(int));
	}
	close(in);
	close(out);
	chown ("hashtab", 406, 22);
	return(0);
}

pwcrypt(text,code)
char text[];
int code; {
	int a;
	for (a=0; a<strlen(text); ++a) text[a]=(text[a]^(((code|128)^a)&0xFF));
	return(0);
	}

strucmp(st1,st2)
char *st1;
char *st2; {
	char aaa[100],bbb[100];
	int a;
	strcpy(aaa,st1);
	strcpy(bbb,st2);
	for (a=0; a<strlen(aaa); ++a) aaa[a]=tolower(aaa[a]);
	for (a=0; a<strlen(bbb); ++a) bbb[a]=tolower(bbb[a]);
	a=strcmp(aaa,bbb);
	return(a);
}

#include "interr.h"

interr(errnum)
int errnum;
{
	printf("\n*** An internal error has occured.\n");
        perror (errcode[errnum]);
	exit(1);
}

int roomisknown(user,room,a)
user_type *user;
struct quickroom *room;
int a;

{
  return (    (room->QRflags & QR_INUSE)              /* active */
	   && (room->QRgen != user->forget[a])     /* not zapped */
	   && (    (!(room->QRflags&QR_PRIVATE))      /* not private */
	        || (user->axlevel>=6)             /* or an aide */
	        || (room->QRgen==user->generation[a]) /* or known */
              )
	   && (   (!(room->QRflags&QR_PREFONLY))   /* not pref only */
	       || (user->axlevel>=5)           /* or I am preff'd */
	      )
	   && ( (a!=2) || (user->axlevel>=6) )   /* aide in aide */
         );
}
