/* 
File: commands.c
Desc: Command parser for room prompts
Source: knapp@bbs.fdu.edu --  NOT part of the Cit/UX distribution
Change History:
02/16/93 added conf commands pirmann@cs.rutgers.edu 
*/

#include <stdio.h>
#include <ctype.h>
#include "citadel.h"
#include "defs.h"
#define SIZEOF(x)  (sizeof((x))/sizeof(struct command) )

extern user_type usersupp;
extern struct quickroom quickroom;

struct command
{
  char letter;		/* the letter to invoke this function */
  char *text;		/* short name of key */
  int  code;		/* return code */
  char *help;		/* more helpful descriptive text */
} ;

/* each of the items below is the set of commands that is available
   at each level.  A positive code is returned to the main program
   automatically.  A negative code indicates a special case that
   is handled in specific code below */

/* for control character reference :-)
            1         2    
   12345678901234567890123456
   abcdefghijklmnopqrstuvwxyz
*/

static struct command commands[] = {
  { 4,   "Terminate\n",          100, "" }, /* ascii 4 is control-d */
  { 23,  "Alternate Who\n",       98, "" }, /* control-w */
/*  { 14,  "Network Spool Out\n",       75, "" }, /* control-n */
/*  { 13,  "Network Spool In\n",       76, "" }, /* control-m */
  { 12,  "",                      99, "" }, /* control-l */
  { 'a', "Abandon",              -25, "" }, /* Abandon */
/*  { 'c', "Chat\n",              71, "" }, /* just say no */
  { 'd', "Room's Description\n",  33, "" },
  { 'e', "Enter Message\n",        4, "" },
  { 'f', "Read Forward\n",        10, "" },
  { 'h', "Help\n",                96, "" },
  { 'g', "Goto\n",                21, "" },
  { 'i', "Information System\n",  70, "" },
  { 'j', "Jump/Goto Room: ",      20, "" },
  { 'k', "Known Rooms\n",         30, "" },
  { 'l', "Read last five messages\n",15, "" },
  { 'm', "Goto Mail\n",          22, "" },
  { 'n', "Read New\n",            13, "" },
  { 'o', "Read Old Reverse\n",    12, "" },
  { 'p', "Read last ten messages\n",16, "" },
  { 'r', "Read Reverse\n",        11, "" },
  { 's', "Skip",                 -26, "" },	/* special text req'd FIX */ 
  { 't', "Terminate\n",          100, "" },
  { 'u', "Ungoto\n",              23, "" },
  { 'w', "Who is on...\n",        92, "" },
  { 'y', "A quote for you...\n",  73, "" },
  { 'z', "Zap (forget) room\n",   24, "" },
  { '*', "SubSystem\n",           72, "" },
  { '?', "Help!\n",               90, "" },
  { '#', "Read last X\n",         14, "" },
  { '@', "Date\n",                93, "" },
  { '.', ".",                     -3, "" },	/* special code FIX */ 
  { '!', "! ",                   -52, "" }	/* special code FIX */
  };

static struct command dotcommands[] = {
  { '?', "Help!",                 -7, "" },
  { 'a', "Aide cmd: ",            -1, "" },
  { 'b', "Biography cmd:",       -11, "" },
  { 'c', "Configure",            -10, "" },
  { 'e', "Enter",                 -2, "" },
  { 'g', "Jump/Goto Room: ",      20, "" },
  { 'r', "Read ",                 -3, "" },
  { 's', "Sysop ",                -4, "" },
  { 'x', "Clear Lastseen\n",      97, "" },
  { 'z', "Zapped list\n",         31, "" },
  { 13,  "(abort)",                0, "" },
  {  8,  "backspace",             -5, "" }
  };

static struct command roomaidecommands[] = {
  { '?', "Help",                  -1, "" },
  { 'd', "Enter Room Desciption\n",  47, "" },
  { 'e', "Edit Room\n",           44, "" },
  { 'r', "Room cmd:",             -2, "" },
  { 't', "See Room Type\n",       32, "" },
  { 'w', "Who knows room\n",      46, "" },
/*  { 'x', "Who doesn't know room\n", 104, "" },*/
  { 13,  "(abort)",                0, "" },
  {  8,  "backspace\n",          -3, "" },
  };

static struct command aidecommands[] = {
  { '?', "Help",                  -1, "This help listing." },
  { 'c', "Create room\n",         40, "Create a new room on this floor." },
  { 'd', "Enter Room Description\n",  47, "Enter this room's description." },
  { 'e', "Edit Room\n",           44, "Edit this room's flags & aide." },
  { 'f', "Who's @localhost\n",    74, "Check system user list." },
  { 'g', "View Registration\n",   94, "View another's registration." },
  { 'k', "Kill this room\n",      41, "Remove this room." },
  { 'r', "Room cmd:",             -2, "Room command menu." },
  { 's', "Go to Sleep\n",         53, "Pause this session." },
  { 't', "See Room Type\n",       32, "View room stats." },
  { 'u', "User Edit\n",           54, "Change access levels." },
  { 'v', "Validate\n",            50, "Verify new user info." },
  { 'w', "Who knows room\n",      46, "See who knows this room." },
  { 'x', "Clear Register Flags\n", 55, "Clear registration flags" },
  { 13,  "(abort)",                0, "<CR>  Abort back to main prompt." },
  {  8,  "backspace\n",           -3, "<BS>  Back out of aide menu." }
/* 
  { 'm', "Send Message\n",        46, "(Unimplemented)" },
  { 'n', "New Floor\n",           93, "Create a new floor." },
  { 'p', "PollMgmnt\n",           -4, "View/Control voting boothes." },
  { 'x', "Who doesn't know room\n", 104, "See who doesn't know this room." },
*/
  };

static struct command roomcommands[] = {
  { 'i', "Invite User\n",         42, "" },
  { 'k', "Kick out user\n",       43, "" },
  { 13,  "(abort)",                0, "" },
  {  8,  "backspace\n",           -1, "" }
  };

static struct command biocommands[] = {
  { 13,  "(abort)",                0, "" },
  {  8,  "backspace\n",           -1, "" }
  };

static struct command confcommands[] = {
  { 'b', "Bio\n",                  83, "" },
  { 'c', "Configuration\n",        82, "" },
  { 'g', "Registration\n",         81, "" },
  { 'p', "Password\n",             80, "" },
  { 13,  "(abort)",                0, "" },
  {  8,  "backspace\n",           -1, "" },
  { '?', "Help\n",                 -2, "" }
  };

static struct command readcommands[] = {
/*  { 'h', "software History\n",     98, "" },*/  /* maybe news? */
  { 'r', "Reverse\n",              11, "" },
  { 'n', "New messages\n",         13, "" },
  { 'o', "Old messages reverse\n", 12, "" },
  { 'l', "Last five messages\n",   15, "" },
/*  { 'd', "Directory\n",            68, "" },*/
  { 'u', "User\n",                 94, "" },
  { 'y', "Yourself\n",             95, "" },
  { 's', "System Configuration\n", 91, "" },
  { 13,  "(abort)",                 0, "" },
  {  8,  "backspace\n",            -1, "" },
  { '?', "Help\n",                 -2, "" }
  };

static struct command entercommands[] = {
  { 'p', "Password\n",             80, "" },
  { 'm', "Message\n",               4, "" },
  { 'e', "Message with editor\n",   6, "" },
  { 'w', "Message without editor\n",7, "" },
  { 'b', "Biography\n",            83, "" },
  { 'c', "Configuration\n",        82, "" },
  { 'g', "Registration\n",         81, "" },
/*  { 'u', "Unformatted Message\n", 5, "" },*/
  { 13,  "(abort)",                0, "" },
  {  8,  "backspace\n",            -1, "" },
  { '?', "Help\n",                 -2, "" }
  };

static struct command sysopcommands[] = {
  { 'f', "Emergency edit Floor\n", 102, "" },
  { 'r', "Emergency edit Room\n", 45, "" },
  { 'u', "Useradmin\n",           51, "" },
  { 'c', "Clear Lastseen\n",      97, "" },
  { 'x', "Clear Register Flags\n", 55, "" },
/*  { 'v', "VoteMgmnt\n",           -2, "" },*/
  { 13,  "(abort)",                0, "" },
  {  8,  "backspace\n",           -1, "" }
  };

int helper(choices,size,header)
struct command choices[];
int size;
char *header;
{
  int i;

  printf("%s\n",header);
  for (i=0; i<size; i++)
  {
    if (isprint(choices[i].letter) )
      printf("   %c   %s\n", choices[i].letter, choices[i].help);
    else
      printf(" %s\n", choices[i].help);
  }
  return(0);
}


int onekey(choices,size)
struct command choices[];
int size;
{
  int i;
  int a;
  int returnval;
  int inkey();

  returnval = (-1);
  do
  {
    a = inkey();
    a = tolower(a);
    for (i=0; i<size; i++)
    {
      if (a == choices[i].letter)
        returnval = i;
    }
  }
  while (returnval<0);
  return(returnval);
}


int getcmd ()	   /* Parses an input command, also translates synonyms */
{
  int a;

  GCA:
    a = onekey(commands, SIZEOF(commands));
    if (commands[a].code >= 0)
    {
      printf("%s",commands[a].text);
      return(commands[a].code);
    }

    a = commands[a].code;

    if (a == (-26)) {
      printf ("Skip %s\n", quickroom.QRname); 
      return (26);}
  if (a == (-25)) {
      printf ("Abandon %s\n", quickroom.QRname); 
      return (25);}
    
  if (a == (-3)) {
       printf (".");
       goto DOT;   }

    IFAIDE
    if (a == (-52)) 
    {  printf ("! ");
       return (52);
    }
    goto GCA;

DOT:
    a = onekey(dotcommands, SIZEOF(dotcommands));
    if (dotcommands[a].code >= 0)
    {
      printf("%s",dotcommands[a].text);
      return(dotcommands[a].code);
    }
    a = dotcommands[a].code;
   if (a == (-5))
   {
      back (1);
      goto GCA;
   }
   if (a == (-3))
   {
      printf ("Read ");
      goto GCREAD;
   }
   if (a == (-2))
   {
      printf ("Enter ");
      goto GCENT;
   }
   if (a == (-10))
   {
      printf ("Configure ");
      goto GCONF;
   }
   if (usersupp.axlevel >= 6)
      if (a == (-1))
      {
	 printf ("Aide cmd: ");
	 goto GCAIDE;
      }
   if (usersupp.eternal == quickroom.QRroomaide)
      if (a == (-1))
      {
	 printf ("Roomaide cmd: ");
	 goto GCRMAIDE;
      }
   if (usersupp.axlevel == 7) 
      if (a == (-4))
      {
	 printf ("Sysop command: ");
	 goto GCSYSOP;
      }
   if (a == (-7))   {
      printf ("(Choices)\n");
      formout ("/messages/dothelp",1);
      printf ("%s> .", quickroom.QRname);
      goto DOT;   }
   goto DOT;

GCRMAIDE:
    a = onekey(roomaidecommands, SIZEOF(roomaidecommands) );
    if (roomaidecommands[a].code >= 0)
    {
      printf("%s",roomaidecommands[a].text);
      return(roomaidecommands[a].code);
    }
    a = roomaidecommands[a].code;
   if (a == (-1))   {
      printf ("(Room Aide Options)\n");
      formout ("/messages/rmaide",1);
      printf ("%s> .Roomaide cmd: ", quickroom.QRname);
      goto GCRMAIDE;   }
   if (a == (-3))   {
      back (14);
      goto DOT;   }
   if (a == (-2))   {
      printf ("Room cmd: ");
      goto ROOMCMD;   }
   goto GCRMAIDE;


GCAIDE:
    a = onekey(aidecommands, SIZEOF(aidecommands) );
    if (aidecommands[a].code >= 0)
    {
      printf("%s",aidecommands[a].text);
      return(aidecommands[a].code);
    }
    a = aidecommands[a].code;
/*
   if (a == (-1))   {
      printf ("(aide options)\n");
      formout ("/messages/aideopt",1);
      printf ("%s> .Aide cmd: ", quickroom.QRname);
      goto GCAIDE;   }
*/
   if (a == (-1))   {
      helper (aidecommands, SIZEOF(aidecommands),"(aide options)");
      printf ("%s> .Aide cmd: ", quickroom.QRname);
      goto GCAIDE;   }
   if (a == (-2))   {
      printf ("Room cmd: ");
      goto ROOMCMD;   }
   if (a == (-3))   {
      back (10);
      goto DOT;   }
   goto GCAIDE;

ROOMCMD:
    a = onekey(roomcommands, SIZEOF(roomcommands) );
    if (roomcommands[a].code >= 0)
    {
      printf("%s",roomcommands[a].text);
      return(roomcommands[a].code);
    }
    a = roomcommands[a].code;
    if (a == (-1))   {
       back (10);
       goto GCRMAIDE;   }
    goto ROOMCMD;

GCREAD:
    a = onekey(readcommands, SIZEOF(readcommands) );
    if (readcommands[a].code >= 0)
    {
      printf("%s",readcommands[a].text);
      return(readcommands[a].code);
    }
    a = readcommands[a].code;
   if (a == (-2))   {
      printf ("(options)\n");
      formout ("messages/readopt",1);
      printf ("%s> .Read ", quickroom.QRname);
      goto GCREAD;   }
   if (a == (-1))   {
      back (5);
      goto DOT;   }
   goto GCREAD;

 GCONF:
  a = onekey(confcommands, SIZEOF(confcommands) );
  if (confcommands[a].code >= 0)
    {
      printf("%s",confcommands[a].text);
      return(confcommands[a].code);
    }
  a = confcommands[a].code;
  if (a == (-2))
    {
      printf ("(options)\n");
      formout ("messages/confopt",1);
      printf ("%s> .Configure ", quickroom.QRname);
      goto GCONF;
    }
   if (a == (-1))
     {
       back (strlen("Configure "));
       goto DOT;   
     }
  goto GCONF;
  
GCENT:
    a = onekey(entercommands, SIZEOF(entercommands) );
    if (entercommands[a].code >= 0)
    {
      printf("%s",entercommands[a].text);
      return(entercommands[a].code);
    }
    a = entercommands[a].code;
   if (a == (-2))   {
      printf ("(options)\n");
      formout ("messages/entopt",1);
      printf ("%s> .Enter ", quickroom.QRname);
      goto GCENT;   }
   if (a == (-1))   {
      back (6);
      goto DOT;   }
   goto GCENT;


GCSYSOP:
    a = onekey(sysopcommands, SIZEOF(sysopcommands) );
    if (sysopcommands[a].code >= 0)
    {
      printf("%s",sysopcommands[a].text);
      return(sysopcommands[a].code);
    }
    a = sysopcommands[a].code;
   if (a == (-1))   {
     back (15);
     goto DOT;   }
   goto GCSYSOP;


 } /* end main */
