/* citadel.h 3.11 -- see copyright.doc for copyright information */

/* system customizations are in sysconfig.h */
#include "sysconfig.h"


typedef int bool;
#define TRUE 1
#define FALSE 0


typedef struct usersupp         /* User record                      */
{			
  char fullname[26];		/* Name for Citadel messages & mail */
  char password[20];		/* password (for BBS-only users)    */
  long eternal;			/* Eternal user number              */
  long lastseen[MAXROOMS];	/* Last message seen in each room   */
  char generation[MAXROOMS];	/* Generation # (for private rooms) */
  char forget[MAXROOMS];	/* Forgotten generation number      */
  long mailnum[MAILSLOTS];	/* Message #'s of each mail message */
  long mailpos[MAILSLOTS];	/* Disk positions of each mail      */
  unsigned flags;		/* See US_ flags below              */
  unsigned rflags[MAXROOMS];    /* See RF_ flags below              */
  int screenwidth;		/* For formatting messages          */
  int screenlength;             /* lines before MORE                */
  char axlevel;			/* Access level                     */
  long lastcall;		/* Last time the user called        */
  int timescalled;		/* Number of logins                 */
  int posted;                   /* Number of messages posted (ever) */
  long online;                  /* Number of seconds ever spent onl */
  long firstcall;               /* time of first call */
  long today;                   /* time spend online on day of lastcall*/
  int timelimit;                /* user's time limit in minutes */
  char lasthost[17];            /* utmp name of last host on from   */
  char RGname[30];              /* user's real full name */
  char RGaddr[25];              /* user's address */
  char RGcity[15];              /* user's address */
  char RGstate[3];              /* user's address */
  char RGzip[11];               /* user's address */
  char RGphone[13];             /* user's phone number */
  char RGemail[41];             /* user's email address */
} user_type;

#define US_NEEDVALID	1		/* User needs to be validated       */
#define US_SUBSYSTEM    2               /* user has subsystem access        */
#define US_PERM		4		/* Permanent user                   */
#define US_LASTOLD	16		/* Print last old message with new  */
#define US_EXPERT	32		/* Experienced user		    */
#define US_PAUSE	64		/* pause after screenlength lines   */
#define US_NOPROMPT	128		/* Don't prompt after each message  */
#define US_NOHIDE       256             /* hide reginfo from regular users  */
#define US_REGIS	1024		/* Registered user                  */
#define US_PROFILE      2048            /* has the user entered a profile?  */
#define US_EDITOR       4096            /* use editor by default ?          */

#define RF_ROOMAIDE     1               /* is the user granted privs in rm  */

/****************************************************************************/

struct msgmain 
{
  long MMlowest;		/* lowest message number in file    */
  long MMhighest;		/* highest message number in file   */
  long MMcurpos;		/* Current position in file         */
  unsigned MMflags;		/* Global system flags              */
};

#define MM_BUSY		1		/* Another process is using file    */
#define MM_CHAOS	2		/* Something is really messed up    */
#define MM_VALID	4		/* New users need validating        */
#define MM_USEINUSE	8		/* Use table is currently in use    */

/****************************************************************************/

struct smreturn {			/* Return from the send_message()   */
	long smnumber;			/* Message number (if sent)	    */
	long smpos;			/* Position in file (if sent)       */
	int smerror;			/* Error code                       */
		};

/****************************************************************************/

struct quickroom {
	char QRname[20];		/* Max. len is 19, plus null term   */
	char QRpasswd[10];		/* Only valid if it's a private rm  */
	char QRaidename[26];
	long QRroomaide;		/* User number of room aide         */
	long QRhighest;			/* Highest message NUMBER in room   */
	char QRgen;			/* Generation number of room        */
	unsigned QRflags;		/* See flag values below            */
	char QRdirname[15];		/* Directory name, if applicable    */
		};

#define QR_BUSY		1		/* This would be a nice addition :-)*/
#define QR_INUSE	2		/* Set if in use, clear if avail    */
#define QR_PRIVATE	4		/* Set for any type of private room */
#define QR_READONLY	8		/* Restrict posting to aides? No    */
#define QR_GUESSNAME	16		/* Set if it's a guessname room     */
#define QR_DIRECTORY	32		/* Directory room                   */
#define QR_UPLOAD	64		/* Allowed to upload                */
#define QR_DOWNLOAD	128		/* Allowed to download              */
#define QR_VISDIR	256		/* Visible directory                */
#define QR_ANONONLY	512		/* Anonymous-Only room              */
#define QR_ANON2	1024		/* Anonymous-Option room            */
#define QR_NETWORK	2048		/* Shared network room              */
#define QR_PREFONLY	4096		/* Preferred status needed to enter */
#define QR_DESCRIBED    8192            /* this room has a description file */
#define QR_NOEDITOR     16384           /* disallow use of editor?          */

/* Private rooms are always flagged with QR_PRIVATE. If neither QR_PASSWORDED
 * or QR_GUESSNAME is set, then it is invitation-only. Passworded rooms are
 * flagged with both QR_PRIVATE and QR_PASSWORDED while guess-name rooms are
 * flagged with both QR_PRIVATE and QR_GUESSNAME. DO NOT set all three flags.
 */
/****************************************************************************/

struct fullroom {
	long FRnum[MSGSPERRM];		/* Message NUMBERS		    */
	long FRpos[MSGSPERRM];		/* Message POSITIONS in master file */
		};

/* This structure is not 'circular'. When scrolling, each message moves
 * down a slot, and the oldest one falls off the bottom. A null message is 
 * represented by the value 0L in both fields.
 *
*****************************************************************************/



/* Miscellaneous                                                            */

#define MES_NORMAL	65		/* Normal message                   */
#define MES_ANON	66		/* "****" header                    */
#define MES_AN2		67		/* "Anonymous" header               */
/*#define BADSIG		(int(*)())-1	/* don't ask me - I have no idea!   */

#define M_ERROR		(-1)	/* Can't send message due to bad address   */
#define M_LOCAL		0	/* Local message, do no network processing */
#define M_UUCP		1	/* Translate to ASCII and use uucp main    */
#define M_BINARY	2	/* Process recipient and send through bin  */

/****************************************************************************/

struct recentmsg {
	char RMnodename[10];
	long RMnum;			/* Number or time of message        */
	};


/* ulog exit statuses */
#define ULOG_NORMAL  0   /* normal logout */
#define ULOG_DROP    1   /* drop carrier */
#define ULOG_SLEEP   2   /* sleeping */
#define ULOG_OFF     3   /* typed "off" */
#define ULOG_TL      4   /* reached timelimit */
#define ULOG_NEW     5   /* new user's first call */

/* read user controls */
#define RU_SELF      1

#define AX_DEL       0
#define AX_NEW       1
#define AX_TWIT      2
#define AX_NORM      3
#define AX_NET       4
#define AX_PREF      5
#define AX_AIDE      6
#define AX_SYSOP     7

#define RM_KNOWN 1
#define RM_NOUNR 2
#define RM_ZAPPED 3

#define LOGFILE         "logs/bbslog"
#define LOGFAIL         "logs/pwfail"
#define LOGINLOG        "logs/logins"
#define LOGINT          "logs/intlog"
/* names of log files relative to bbsdir */

