/* 
File: citadel.c
Desc: Citadel/UX 3.11 Main source file

Change History:
09/10/93: added code to selectively prohibit new users based on site
10/12/93: checked writeable opens for locking

GCC only on this puppy!
*/

#include <fcntl.h>
#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/signal.h>
#include <sys/file.h> /* for flock */
#include <errno.h>
#include <setjmp.h>
/*#include <unistd.h>*/
#include "cunistd.h" /* our own version */
#ifdef SUNOS
#include <termio.h>
#else
#include <sgtty.h>
#endif 

#include "citadel.h"
#include "defs.h"
#include "void.h"
#include "chardef.h"
#include "paths.h"

char fullname[26];                    /* name user enters at login           */
char hname[17];                       /* which host is user calling from?    */
char lhost[17];                       /* which host did user last call from? */
char msgfile[50], structfile[50];     /* which files to use for messages     */
char mytty[6];                        /* which tty is the user on?           */
char skipping[MAXROOMS];	      /* which rooms are skipped             */
char temp[20];			      /* Name of general temp file           */
char logmsg[80];                     /* for internal operations logging     */
int curr_rm;			      /* Room NUMBER of current room.        */
int feedback_flag=0;                  /* leaving feedback                    */
int intmany=-1;                       /* how many messages to read           */
int offstat=-1;                       /* for ulog - how did user terminate?  */
int twitroom;			      /* Room num of TWIT room (if enabled)  */
int ugnum; long uglsn;		      /* holds <u>ngoto info */
int unseen;
jmp_buf nextbuf;
long lastpos;                         /* previous max post in this room */
long logintime, timetoday;
long yourpos;			      /* position of your usersupp record    */
struct fullroom fullroom;	      /* Current room                        */
struct msgmain msgmain;		      /* Global message info                 */
struct quickroom quickroom,QRscratch; /* Current room and scratch            */
struct smreturn smreturn;	      /* For returning message numbers       */
user_type usersupp;	              /* Logged-in user's user supp          */

#ifdef SUNOS
struct termio stty0;                  /* SUN terminal settings */
#else
char ttyC;
struct sgttyb stty0,stty1;             /* pure BSD terminal settings */
#endif

/*---------------------------------------------------------------------------*/
int (*backnext () )     () 
{
  signal(SIGINT,SIG_IGN);
  signal(SIGQUIT,SIG_IGN);
  longjmp(nextbuf,1);
}
/*---------------------------------------------------------------------------*/
int (*backstop () )     () 
{
  signal(SIGQUIT,SIG_IGN);
  signal(SIGINT,SIG_IGN);
  longjmp(nextbuf,2);
}
/*---------------------------------------------------------------------------*/
int (*sleeping())() 
{
  IFAIDE
  {
    printf("Your session has fallen asleep.\n");
    enter_btmp("[Sleeping]");
    return(0);
  }
  printf ("\n\n");
  formout (SLEEPINGMSG);
  if (intmany != -1)
    {
      offstat=ULOG_SLEEP;
      ulog ();
    }
  else
    clear_btmp();   /* users who never log still need to be removed if nec. */
  logoff(1);       /* exit with the proper code */
}
/*---------------------------------------------------------------------------*/
int (*dropcarr())() 
{
  offstat=ULOG_DROP;
  ulog ();
  logoff(SIGHUP);
}
/*---------------------------------------------------------------------------*/
inkey() 
{
  int a;
  signal(SIGALRM,(*sleeping));
  IFAIDE
    alarm(SLEEPING/2);
  else
    alarm(SLEEPING);
  a=getc(stdin); 
  if (a==127) a=8; if (a==10) a=13;
  signal(SIGALRM,SIG_IGN);
  return(a);
}
/*---------------------------------------------------------------------------*/
setsane() 
{
#ifdef SUNOS
  ioctl(0, TCSETA, &stty0);
#else
  stty (0, &stty0);
#endif
}
/*---------------------------------------------------------------------------*/
formout(name) /* display a file NOT!!! using the formatter */
     char name[];
{
  char aaa[100];
  int a;
  FILE *fp;

  strcpy(aaa,name);
  if (setjmp(nextbuf)!=0) 
    {
      sttybbs(0);
      return(1);  
    }
  sttybbs(1);
  if ((fp=fopen(aaa,"r")) != NULL)
    {
      while ((a=getc(fp)) != EOF)
	putc (a,stdout);
      fclose (fp);
    }
  else 
    {
      sprintf (logmsg, "Formout: No such file: %s",aaa);
      intlog (logmsg);
    }
  sttybbs(0);
  return(0);
}
/*---------------------------------------------------------------------------*/
readmail()
{
  int a;
  readyerself();
  for (a=0; a<MSGSPERRM; ++a) 
    {
      fullroom.FRnum[a]=0L;
      fullroom.FRpos[a]=0L;
    }
  for (a=0; a<MAILSLOTS; ++a) 
    {
      fullroom.FRnum[a+(MSGSPERRM-MAILSLOTS)]=usersupp.mailnum[a];
      fullroom.FRpos[a+(MSGSPERRM-MAILSLOTS)]=usersupp.mailpos[a];
    }
  return(0);
}
/*---------------------------------------------------------------------------*/
writemail()
{
  int a;
  readyerself();
  for (a=0; a<MAILSLOTS; ++a) 
    {
      usersupp.mailnum[a]=fullroom.FRnum[a+(MSGSPERRM-MAILSLOTS)];
      usersupp.mailpos[a]=fullroom.FRpos[a+(MSGSPERRM-MAILSLOTS)];
    }
  writeyerself();
  return(0);
}

/*---------------------------------------------------------------------------*/

readyerself()
{
  int file;
  file=open("usersupp",O_RDONLY); 
  if (file<0)
    interr(4);

  if (yourpos < 0)
    yourpos = finduser (file, fullname);

  lseek(file,yourpos,0);

  do 
    {
      read(file,&usersupp,sizeof(user_type));
      if (strucmp(fullname,usersupp.fullname)) 
	finduser(file,fullname);
    } 
  while(strucmp(fullname,usersupp.fullname));
  close(file);
  return(0);
}

/*---------------------------------------------------------------------------*/

writeyerself()
{
  user_type me;
  int file;

  file=open("usersupp",O_RDWR);
  if (file<0)
    interr(6);
  lseek(file,yourpos,0);
  lockf (file, F_LOCK, (long) sizeof (user_type));
  /* read our record */
  read(file,&me,sizeof(user_type));
  if (me.eternal != usersupp.eternal) 
    yourpos = finduser (file,usersupp.fullname);
  /* seek back to our record */
  lseek(file,yourpos,0);
  /* write the record out in the same place */
  write(file,&usersupp,sizeof(user_type));
  /* seek back again so we unlock the proper bytes -- sigh */
  lseek(file,yourpos,0);
  lockf (file, F_ULOCK, (long) sizeof (user_type));
  close(file);
  return(0);
}

/*---------------------------------------------------------------------------*/

void enter_passwd(user_type *usersupp, bool *done, char *mytty, char *hname)
{
  char pwtest [20];
  int failures=0;                        /* counts login failures */
  
  printf("\rPlease enter your password: ");
  getline(pwtest,-19); 
  strproc(pwtest);

  if (strlen(pwtest) == 0) 
    {
      ++failures;
      *done = FALSE;
    }  
  else  
    {
      pwcrypt(usersupp->password,PWCRYPT);
      if (!strucmp(pwtest,usersupp->password)) 
	{
	  pwcrypt(usersupp->password,PWCRYPT);
	  *done = TRUE;
	}
      else 
	{  	
	  printf("Wrong password...\n");

	  /* record the failure */
	  badpw (usersupp->fullname, mytty, hname);
	  ++failures;  
	  if (failures >= 4) 
	    {
	      printf ("Too many failures.\n");
	      logoff(-1);
	    }
	}
    }
}  /* end enter_passwd */

/*--------------------------------------------------------------------------*/

void new_user(char *hname)
{
  int fd;
  FILE *fp;
  char *foo, host[17];
  
  printf ("\n");
  if ((fd = open(".nonew", O_RDONLY))>0) 
    {
      close (fd);
      formout (NONEWMSG);
      sleep (1); 
      clear_btmp();
      exit (0);
    }
  else  
    {

/* prohibnew section.  9/10/93 pirmann */

  fp = fopen (PROHIBNEW, "r");
  if (fp != NULL)
    {
      do
	{
	  foo = fgets(host,17,fp);
	  if (foo != NULL)
	    if (!strucmp (host, hname))
	      {
		fclose (fp);
		formout (PROHIBNEWMSG);
		sprintf (logmsg, "Failed new user login from %s", hname);
		intlog(logmsg);
		sleep (2);
		clear_btmp();
		exit (0);
	      }
	} while (foo != NULL);
    }   /* done with PROHIBNEW */
  fclose (fp); 

      formout(NEWUSERMSG);
      printf ("The handle you entered is '%s'.\n", fullname);
      printf ("If this is not the handle you wish to use on the system, press N now.\n");
      printf ("\nDo you still want to log in? ");
      if (yesno()==0) 
	logoff (0); /* should probably let them enter a new name... */
      printf("\n");


    }
} /* end new_user */ 

/*---------------------------------------------------------------------------
  --------------------------------------------------------------------------*/

void init_new_user(user_type *usersupp, char *fullname)
{     
  int a;
  long aa;
  FILE *logf;
  char aaa[80];

  enter_btmp ("[New User (1)]");	
  strcpy(usersupp->fullname, fullname);

  for (a=0; a<MAXROOMS; ++a) 
    {
      usersupp->lastseen[a]=0L;
      usersupp->generation[a]=(-1);
      usersupp->forget[a]=(-1);
      usersupp->rflags[a]=0;
    }
  for (a=0; a<MAILSLOTS; ++a) 
    {
      usersupp->mailnum[a]=0L;
      usersupp->mailpos[a]=0L;
    }
  usersupp->flags=US_NEEDVALID;
  usersupp->timescalled=0;
  usersupp->posted=0;
  usersupp->axlevel=INITAX;
  usersupp->online = 0L;
  usersupp->today = 0L;
  usersupp->screenwidth = 80;
  usersupp->screenlength = 24;
  usersupp->timelimit=LIM1;   /* default new user timelimit  */
  strcpy (usersupp->lasthost, "none");
  time(&aa);
  usersupp->lastcall=aa;
  usersupp->firstcall=aa;
  logintime=aa;
  timetoday = 0;

  printf ("The following are configuration options for your account.\n\n");
  enter_btmp ("[New User (2)]");	
  getusinfo(usersupp);

#ifdef _ABOUT_
  printf ("\n");
  printf ("How did you hear about QuartzBBS? ");
  getline (aaa,50);
  if (strlen(aaa) != 0)
    {
      if ((logf = fopen ("logs/about", "a"))!=NULL)
	{
	  fprintf (logf, "%26.26s: %s\n", usersupp->fullname, aaa);
	  fclose (aaa);
	}
    }
#endif /* _ABOUT_ */
}  /* end init_new_user */

/*-------------------------------------------------------------------------
  -------------------------------------------------------------------------*/

int get_passwd(user_type *usersupp)
{
  char pwread[20],pwtest [20];                /* for password validation */
  bool done=FALSE;

  formout (CHANGEPW);

  while(!done) 
    {
      printf("Please enter a password: ");
      getline(pwread,-19);
      if ((!strlen(pwread)) && (usersupp->timescalled > 0))
	return (-1);
      if (strlen(pwread))
	{
	  printf("Please enter it again: ");
	  getline (pwtest, -19);
    
	  if (strucmp (pwtest, pwread)) 
	    printf ("The passwords you typed didn't match.  Please try again.\n");
	  else
	    done = TRUE;
	}
    }
    
  strproc(pwread);
  pwcrypt(pwread,PWCRYPT);
  strcpy (usersupp->password, pwread);
  printf ("\n");

}  /* end get_passwd */    


/*-------------------------------------------------------------------------
  assign and increment eternal; add user to usersupp and hash table
  -------------------------------------------------------------------------*/

void add_user(user_type *usersupp)
{
  FILE *fp;
  int a,file;
  long aa;

  enter_btmp ("[New User (3)]");

  signal(SIGHUP,SIG_IGN);

  file=open("eternal",O_RDWR);	/* get a new user number */
  if (file<0)
    interr(2);
  while (lockf (file, F_TEST, sizeof (long)) == -1)
    sleep (1);
  while (lockf (file, F_LOCK, sizeof (long)) < 0)
    sleep (1);
  read(file,&aa,sizeof (long));
  usersupp->eternal=aa++;
  lseek(file,0L,0);
  a=write(file,&aa,sizeof (long));
  if (a < 0)
    interr (27);
  lseek(file,0L,0);
  lockf (file, F_ULOCK, sizeof (long));
  close(file);
  printf ("\n");

  fp=fopen("usersupp","a"); 
  /* should lock but it is only appending. possible problem with 
     simultaneous new users log in */
  if (fp==NULL)
    interr(3);
  fwrite(usersupp,sizeof(user_type),1,fp);
  fclose(fp);

  a=hash(usersupp->fullname);
  fp=fopen("hashtab","a"); 
  if (fp==NULL)
    interr (95);
  fwrite(&a,sizeof(int),1,fp);
  fclose(fp);

  signal(SIGHUP,(*dropcarr));
  signal(SIGQUIT,(*dropcarr));

  sleep (3);

}  /* end add_user */
  
/*---------------------------------------------------------------------------
  Opens usersupp and see if the username alreadys exists.  If it the name is
  not in the usersupp file, then the user is a newbie and a TRUE is returned.
-----------------------------------------------------------------------------*/

bool check_user()
{
  int file;

  file=open("usersupp",O_RDONLY);
  if (file < 0)
    interr (98);
  yourpos=finduser(file,fullname);
  close(file);  
  if (yourpos==(-1L)) 
    return (TRUE);
  else
    return (FALSE);

}  /* end check_user */


/*---------------------------------------------------------------------------
  enter_name prompts the user for their bbs user name then returns it.
  If the name entered is 'bbs', 'new user' or 'new' it prompts the
  user again for a valid name.  Typing 'off' will disconnect the 
  user from the bbs.     (cable@paladine 12/19/92)
-----------------------------------------------------------------------------*/

void enter_name(char *fullname, bool *newbie)
{
  bool done, reloop;
  int a;
  long offtime;

  done = FALSE;

  while ((!done) && (reloop))
    {
      reloop = FALSE;

      do
	{
	  printf ("\rEnter your handle: ");	
	  getline (fullname, 25);
	  strproc (fullname);
	  strcase(fullname);
	} while ( strlen(fullname) <= 0 );

      for (a=0; a<strlen(fullname); ++a) /* make sure there's no junk */
	if (fullname[a]==';') 
	  fullname[a]=0;

      if (strucmp(fullname, "bbs") == 0 || strucmp(fullname, "new") == 0 ||
	  strucmp(fullname, "new user") == 0)
	{
	  printf ("If you are a new user, simply enter a handle.\n\n");
	  done = FALSE;
	  reloop = TRUE;
	}
      else
	if (strucmp(fullname, "off") == 0 || strucmp (fullname, "logoff") == 0) 
	  {
	    time(&offtime);
	    offstat=ULOG_OFF; 
	    ulog();
	    printf ("Thank you for calling. Maybe you'll stay a while next time.\n\n");
	    logoff (0);
	  } 
	else
	  if (taboo(fullname)) 
	    {
	      printf("Sorry, but \"%s\" is not allowed as a username.\n\n",
		     fullname);
	      done = FALSE;
	      reloop = TRUE;
	    }
	  else
	    if (!strlen(fullname))
	      {
		done = FALSE;
		reloop = TRUE;
	      }
	    else
	      {
		*newbie = check_user();
		if (*newbie == TRUE)
		  { 
		    printf("No record. Enter as new user? ");
		    if (yesno()==0) 
		      {
			done = FALSE;
			reloop = TRUE;
		      }
		    else
		      done = TRUE;
		    printf("\n");
		  }
		else
		  done = TRUE;
	      }
    }  /* end while */
}   /* end enter_name */

/* update the lowest unvalidated user, if needed */
void update_unvalidated(char *username)
{
  FILE *fp;
  int file;
  char aaa[50];
  char *fgets();

  strcpy(aaa,"");
  fp=fopen("unvalidated","r");
  if (fp != NULL)      /* file successfully opened */
    if (fgets(aaa,50,fp) != NULL)  /* get first line to a <CR> */
      {
	/* Remove the newline at the end */
	aaa[strlen(aaa)-1] = 0;
	fclose(fp);
      }
  /* Now we either have a name or a null string in aaa. */
  file=open("usersupp",O_RDONLY); 
  if (file<0)
    interr(4);
  if ( (aaa[0] == 0) || (finduser(file,username) < finduser(file,aaa)) )
    {
      fp=fopen("unvalidated","w");
      fprintf(fp,"%s\n",username);
      fclose(fp);
    }
  close(file);
  return;
}

/*--------------------------------------------------------------------------*/

main(argc,argv) 
     int argc;
     char *argv[];
{
  char twit;                             /* is user a twit? */
  int a;                                 /* misc */
  int file;                              /* files */
  int mcmd;                              /* used in getcmd              */
  long aa;                               /* general purpose variables */
  long laston;                           /* time of last call */
  bool newbie;                           /* new user flag, TRUE if newuser */
  bool done=FALSE;                   /* True when finished succesfull login */

  if (argc < 2) 
    {
      printf ("Please run citadel using the \"front\" program.\n");
      exit (-1); 
    }
  else
    strcpy (mytty, argv[1]);               /* argv[1] contains tty name */

#ifdef SUNOS
  ioctl (0, TCGETA, &stty0);               /* Store old terminal parameters */
  signal(SIGINT,(*backnext));
#else
  gtty (0, &stty0);
  signal(SIGINT,SIG_IGN);
#endif

  sttybbs (0);			           /* and install the new ones  */
  signal(SIGQUIT,(*backstop));
  signal(SIGTERM,(*dropcarr));
  signal(SIGHUP,(*dropcarr));	/* Cleanup gracefully if carrier is dropped */

  twit=0;			/* By default, user is not a problem user */
  twitroom=(-1);                /* and there is no twit room at first */
  ugnum=(-1);                   /* no room to ungoto-to at first */
  sprintf (temp,"/tmp/cit%d",getpid()); /* make up a temp file name */
  unlink (temp); /* remove it if it exists */

  formout (HELLO);
  printf (""); /* for some weird reason this is necessary...?
		  otherwise it does not prompt for the username */

  done = newbie = FALSE;
  while (!done)
    {				        
      /* find out who the user is */
      enter_name(fullname, &newbie);
      /* add user to bbswho, and return us the host name from utmp */
      init_btmp(fullname, hname, mytty);

      /* get the usersupp data for guest account */
      if (newbie == TRUE)
	{ 
	  new_user(hname);
	  init_new_user(&usersupp, fullname);
	  get_passwd(&usersupp);
	  add_user(&usersupp);
	  done = TRUE;
	}
      else
	{
	  file = open("usersupp", O_RDONLY);
	  if (file < 0)
	    interr (99);
	  yourpos = finduser(file, fullname);
	  read(file,&usersupp,sizeof(user_type));
	  close(file);
	  enter_passwd(&usersupp, &done, mytty, hname);
	}
    } /* end while (!done) */

  enter_btmp("[Login]");

  if (!newbie)
    readyerself();

  strcpy(fullname,usersupp.fullname); 
  ++usersupp.timescalled;
  laston=usersupp.lastcall;

  /* set these here for old users */
  time(&aa); 
  usersupp.lastcall=aa;
  logintime=aa;
  timetoday = usersupp.today;

  strcpy (lhost, usersupp.lasthost);
  strncpy (usersupp.lasthost,hname,16);
  usersupp.lasthost[16]='\0';

  check_generation();

  if (usersupp.axlevel==2) 
    twit=1;
  if (twit==1) 
    usersupp.axlevel=2;

  writeyerself();

  if ((REGISCALL!=0) && ((usersupp.flags&US_REGIS)==0)
      &&(usersupp.timescalled>=REGISCALL)) 
    {
      printf("\n*** Registration is requested. ***\n\n");
      formout (REGISTER);
      a=entregis(usersupp);
      lock_valid();   /* mark this user as needing validation */
      update_unvalidated(usersupp.fullname);
      enter_btmp ("[Login]");
      if (a==0) 
	{
	  readyerself();
	  usersupp.flags=(usersupp.flags|US_REGIS|US_NEEDVALID);
	  writeyerself();
	}
    }

  print_login_banner(laston);
  mailcheck();

  intmany = 0;  /* now reset intmany to 0 -- see sleeping() */

  /* Enter the lobby */
  file=open("quickroom",O_RDONLY);
  if (file<0) 
    interr (30);
  a=read(file,&quickroom,sizeof(struct quickroom));
  if (a < 0)
    interr (31);
  close(file);
  file=open("./rooms/fullrm0",O_RDONLY);
  if (file<0) 
    interr (32);
  a=read(file,&fullroom,sizeof(struct fullroom));
  if (a < 0)
    interr (33);
  close(file);

  /* Main part of the system... user is logged in. */

  curr_rm = 0;     /* preload so people can't enter messages */
  for (a=0; a<MAXROOMS; ++a) 
    skipping[a]=0;
  if (usersupp.timescalled == 1)
    readmsgs(MSGSPERRM-5,0,1);
  else	
    readmsgs(0,1,1);

  /* MAIN LOOP OF PROGRAM (mainfake) */

  do 
    {	
      IFAIDE check_needvalid();

      if (usersupp.axlevel < 6)
	if (timecheck())
	  {
	    offstat = ULOG_TL;
	    do_terminate();
	  }

      signal(SIGINT,SIG_IGN);
      signal(SIGQUIT,SIG_IGN);
      printf("\n%s%c ",quickroom.QRname, room_prompt(&quickroom));
      if ( quickroom.QRflags & (QR_PRIVATE + QR_ANONONLY + QR_ANON2) )
	enter_btmp ("Citadel");
      else 
	enter_btmp (quickroom.QRname);
      
      mcmd=getcmd();

      switch(mcmd) {

	/* enter message commands  range 1-9*/
        case 4:   entermessage();      break;    /* enter -- default method */
/*	case 5:   enter_unformatted(); break;    /* enter unformatted */
	case 6:   entereditor();       break;    /* enter msg using editor*/
	case 7:   enternormal();       break;    /* enter without editor */

	  /* reading commands range 10-19 */
	case 10:  readmsgs(0,0,1);               break; /* read forward */
	case 11:  readmsgs(MSGSPERRM-1,0,(-1));  break; /* all reverse */
	case 12:  readmsgs(MSGSPERRM-1,2,(-1));  break; /* old reverse */
	case 13:  readmsgs(0,1,1);               break; /* read new */
	case 14:  lastxread();                   break; /* read last X */
	case 15:  readmsgs(MSGSPERRM-5,0,1);     break; /* read last 5 */
	case 16:  readmsgs(MSGSPERRM-10,0,1);    break; /* read last 10 */

	  /* room commands range 20-39*/
	case 20:  dot_goto();       break; /* dot goto */
	case 21:  updatels(); gotonext();   break; /* regular goto */
	case 22:  do_mailgoto();    break; /* go directly to mail */
	case 23:  ungoto();	    break; /* ungoto last room */
	case 24:  forget();         break; /* zap room */
 	case 25:  do_abandon();     break; /* abandon room */
	case 26:  skiproom();       break; /* skip room */

	case 30:  knrooms(&usersupp, RM_KNOWN);knrooms(&usersupp, RM_NOUNR);
	  break;       /* known rooms */
	case 31:  listzrooms(&usersupp);  break;       /* zapped rooms */
	case 32:  print_type ();          break;       /* info about room */
	case 33:  print_desc ();          break;       /* print desc */

	  /* aide commands  range 40-59*/
	case 40:  updatels(); create_room(); break;  /* create room */
	case 41:  killroom();            break;      /* kill room */
	case 42:  invite();              break;      /* invite user */
	case 43:  kickout("",curr_rm);   break;      /* kick out user */
	case 44:  editroom(&usersupp);   break;      /* regular roomedit */
/*      case 45:  sysopeditroom();       break;      /* brute force roomedit */
	case 46:  whoknows();	         break;      /* who knows room */
	case 47:  room_desc ();          break;      /* enter room desc */
	case 50:  validate(&usersupp);	 break;      /* validate new users */
	case 51:  useradmin();           break;      /* useradmin */
	case 52:  do_aideshell();        break;      /* aide shell */
	case 53:  do_sleep();            break;      /* .aide sleep */
	case 54:  edituser(&usersupp);   break;      /* edit user */
	case 55:  clear_register(); break; /* reset register files */

	  /* upload-download 60-69 - might someday be useful */
/*	case 60:  download(1);	  break;
	case 61:  download(2);	  break;
	case 62:  download(3);	  break;
	case 63:  download(4);	  break;
	case 64:  upload(0);	  break;
	case 65:  upload(1);	  break;
	case 66:  upload(2);	  break;
	case 67:  upload(3);	  break;
	case 68:  roomdir(); 	  break; 
*/

	  /* external commands 70-79*/
	case 70:  infosys();      break;      /* information system */
/*	case 71:  do_chat();      break;      /* chat bwahahaha */
	case 72:  subsystem(); break;         /* enter subsystem */
	case 73:  do_fortune(); break;        /* print us a fortune */
	case 74:  system ("/bin/finger @localhost");  break;
	case 75: IFAIDE system ("./network/sendout"); break;
	case 76: IFAIDE system ("./network/netproc"); break;

	  /* configure commands -- move to config menu eventually 80-89 */
	case 80:  do_changepw();         break;   /* change password */
	case 81:  enter_reginfo();       break;   /* registration */
	case 82:  readyerself();getusinfo (&usersupp);writeyerself();break;
	  /* configure */
	case 83:  biotools(&usersupp);  break;   /* enter user profile */

	  /* misc 90-99*/
	case 90:  formout (KEYHELP);            break;   /* key help */
	case 91:  print_system_config();        break;   /* print confg */
	case 92:  read_btmp();           	break;   /* who's online */
	case 93:  timeprint();	                break;   /* "Date" */
	case 94:  read_user(&usersupp);         break;   /* read user */
	case 95:  print_user_stats(&usersupp,&usersupp); break; /*readyerself*/
	case 96: printf ("Press ? for help.\n"); break;
	case 97: reset_lastseen(); break;
	case 98: alt_read_btmp();  break;
	case 99: system("clear"); break;

	  /* all done */
	case 100:  user_terminate();            break;   /* terminate */
	} /* end switch */
    } 
  while(0==0);

  /* statement should never be reached */
  do_terminate();  /* user must be done if this statement is reached */

} /* end main() */


/*--------------------------------------------------------------------------*/
/* gotonext: goto next room having unread messages */

gotonext() 
{
  int b,c;

  /* determine which room has unread messages and whether we're allowed
   to go to that particular room */

  curr_rm=unread_room(&usersupp); 

  b=0; 
  for (c=0; c<MAXROOMS; ++c) 
    if (skipping[c]==1) 
      ++b;

  if ( (curr_rm==0) && (b>0) ) 
    {
      for (c=0; c<MAXROOMS; ++c) 
	if (skipping[c]==1) 
	  skipping[c]=0;
      curr_rm=0; 
      printf("*** You have skipped rooms.\n");
    }

  usergoto(curr_rm);
  return(0);
}
  
/*--------------------------------------------------------------------------*/
dotgoto() 
{
  int a,b,d,f,file2;
  char aaa[20],bbb[20];
  f=0;	/* flag for dgfoundit */

  getline(aaa,19);
  if (strlen (aaa) == 0)
    return (0);
  for (a=0; a<strlen(aaa); ++a) 
    aaa[a]=ctolower(aaa[a]);

  file2=open("quickroom",O_RDONLY);
  if (file2 < 0)
    interr (72);

  for (a=0; a<MAXROOMS; ++a) 
    {
      d=read(file2,&QRscratch,sizeof(struct quickroom));
      if (d<1)
	interr(73);
      strcpy(bbb,QRscratch.QRname);
      for (b=0; b<strlen(bbb); ++b)
	bbb[b]=ctolower(bbb[b]);
      if (pattern(bbb,aaa)==0)
	{
	  /* we found a match lets see if they're allowed in it */
	  /* pass over the result of a strucmp to check for exact match */
	  if (AllowInRoom(&QRscratch, &usersupp, a, strucmp (aaa, bbb)))
	    {
	      close(file2);
	      usergoto(a); 
	      return(0);
	    }
	}
    }
  close(file2);
  printf("No room '%s'.\n",aaa);
  return(1);
}


/*--------------------------------------------------------------------------*/
usergoto(where)	/* used by <G>oto and .<G>oto-- actually does the work */
     int where; 
{
  int a,b,c;
  curr_rm=where;

  gotocurr();
  b=0; 
  c=0;
  for (a=0; a<MSGSPERRM; ++a) 
    {
      if (fullroom.FRnum[a]>0L)
	if (fullroom.FRnum[a]>=msgmain.MMlowest)
	  {
	    ++b;
	    if (fullroom.FRnum[a]>usersupp.lastseen[curr_rm]) 
	      ++c;
	  } 
    }
  printf("%s (%d messages, %d new)\n",quickroom.QRname,b,c);
  readyerself();
  usersupp.forget[curr_rm]=(-1);
  if (usersupp.generation[curr_rm] !=quickroom.QRgen)
    {
      /* print the desc if the room has regenerated.  Doesn't catch when 
	 someone edits the desc though... */
      print_desc(curr_rm, quickroom.QRname);
      usersupp.generation[curr_rm]=quickroom.QRgen;
    }
  writeyerself();
  skipping[curr_rm]=0;
  unseen = MSGSPERRM-c;
  return(curr_rm);
}

/*----------------------------------------------------------------------*/
void clear_register()
{
  unlink (".validate");
  unlink (".register");
}

/*--------------------------------------------------------------------------*/
void logoff(code) /* exit program */
     int code;
{
  unlink(temp);         /* remove temporary file, in case it's still around */
  clear_btmp();         /* remove user from bbswho */	
  exit(code);		/* exit with the proper exit code */
}


/*--------------------------------------------------------------------------*/
loadtroom() 
{
  int file,a,b;

  if (twitroom>=0) 
    return(0);
  twitroom=2; /* use the Aide> room if TWITROOM isn't found */
  file=open("quickroom",O_RDONLY);
  if (file < 0)
    interr (84);
  for (a=0; a<MAXROOMS; ++a) 
    {
      b=read(file,&QRscratch,sizeof(struct quickroom));
      if (b<1) 
	interr(85);
      if ((!strucmp(QRscratch.QRname,TWITROOM))
	  &&((QRscratch.QRflags&QR_INUSE)==QR_INUSE)) 
	twitroom=a;
    }
  close(file);
}


/*--------------------------------------------------------------------------*/
void lock_valid() 	/* set global flag calling for validation */
{
  int file;
  struct msgmain msgmain;

  file=eopen("structures/MMstructure.0",O_RDONLY);
  read(file,&msgmain,sizeof(struct msgmain));
  close(file);

  msgmain.MMflags=(msgmain.MMflags|MM_VALID);
  file=eopen("structures/MMstructure.0",O_WRONLY);
  while (flock (file, LOCK_EX|LOCK_NB) < 0)
    sleep (1);  
  write(file,&msgmain,sizeof(struct msgmain));
  flock (file, LOCK_UN);
  close(file);
}


/*--------------------------------------------------------------------------*/
#ifdef ENABLE_FEEDBACK
void leave_feedback()
{
  if ((usersupp.timescalled == 1) || (usersupp.timescalled % 10 == 0))
    {
      printf ("\nDo you wish to leave a message to the sysops? ");
      if (yesno()==1)
	{
	  printf ("\nPress return twice when finished.\n");
	  curr_rm=1;
	  feedback_flag=1;
	  gotocurr();
	  entmsg(0,0,0);
	}
    }
}
#endif ENABLE_FEEDBACK

/*--------------------------------------------------------------------------*/
void entermessage()
{
  lastpos = fullroom.FRnum[MSGSPERRM-1];
  if ((usersupp.flags & US_EDITOR) && ((quickroom.QRflags & QR_NOEDITOR)==0))
    {
      if (lastpos != fullroom.FRnum[MSGSPERRM-1-entmsg(0,2,0)])
	printf("There were messages posted while you were entering.\n\n");
    }
  else
    {
      if (lastpos != fullroom.FRnum[MSGSPERRM-1-entmsg(0,0,0)])
	printf("There were messages posted while you were entering.\n\n");
    }
}

void entereditor()
{
  if (((quickroom.QRflags & QR_NOEDITOR) == 0)||(usersupp.axlevel >= AX_AIDE))
    {
      lastpos = fullroom.FRnum[MSGSPERRM-1];
      if (lastpos != fullroom.FRnum[MSGSPERRM-1-entmsg(0,2,0)])
	printf("There were messages posted while you were entering.\n\n");
    }
  else
    printf ("Cannot use the editor in this room.\n");
}

void enternormal()
{
  lastpos = fullroom.FRnum[MSGSPERRM-1];
  if (lastpos != fullroom.FRnum[MSGSPERRM-1-entmsg(0,0,0)])
    printf("There were messages posted while you were entering.\n\n");
}


/*--------------------------------------------------------------------------*/
void do_abandon()
{
  updatepartial();  /* update/goto */
  storeug();
  skipping[curr_rm] = 1;
  gotonext();
}


/*--------------------------------------------------------------------------*/
void do_terminate()
{
#ifdef ENABLE_FEEDBACK
  leave_feedback();
#endif

  printf("\n*** Fortune of the day ***\n\n");
  do_fortune();
  printf("\n");
  formout (GOODBYE);
  if (offstat==ULOG_OFF) 
    ulog ();
  else
    {
      writeyerself();
      if (usersupp.timescalled == 1) 
	offstat = ULOG_NEW;
      else
	offstat=ULOG_NORMAL; 
      ulog ();
    }
  logoff(0);
}


/*--------------------------------------------------------------------------*/
void dot_goto()
{
  updatels();  
  if (timecheck()==1) 
    { 
      offstat = ULOG_TL; 
      do_terminate();
    }
  else
    dotgoto();
}


/*--------------------------------------------------------------------------*/
void do_mailgoto()
{
  updatels(); 
  usergoto(1);
}


/*--------------------------------------------------------------------------*/
void do_aideshell()
{
  char aaa[100];

  printf("\nShell cmd: ");
  getline (aaa, 99);
  enter_btmp ("[Shell]");
  setsane (); 
  externstty();
  sprintf (logmsg, "%s executed shell command %s", usersupp.fullname, aaa);
  intlog (logmsg);
  system (aaa);
  sttybbs (0);
}


/*--------------------------------------------------------------------------*/
void do_changepw()
{
  int a;
  char pwtest[20];

  readyerself ();

  printf("\rPlease enter your CURRENT password: "); 
  getline(pwtest,-19); 
  strproc(pwtest);

  if (strlen(pwtest) == 0) 
    return;			/* if they don't enter it don't change it */

  pwcrypt(usersupp.password,PWCRYPT);
  if (!strucmp (pwtest, usersupp.password))
    {
      pwcrypt(usersupp.password,PWCRYPT);
      a=get_passwd(&usersupp);
      if (a != (-1))
	{
	  writeyerself();
	  printf ("Password changed.\n");
	}
    }
  else
    printf ("Password unchanged.\n");
}


/*--------------------------------------------------------------------------*/
void infosys()
{
  int a;
  enter_btmp ("[Info System]");

  setsane(); 
  externstty();
  a=fork();
  if (a==0)
    {
      execlp ("/bin/lush", "", NULL);
      printf ("Info system unavailable.\n");
      exit(0);
    }
  (void) wait(0);
  printf ("\n*** Returning now to the BBS.\n");
  sttybbs(0);
}


/*--------------------------------------------------------------------------*/
void enter_reginfo()
{
  IFNEXPERT
    formout (REGISTER);
  printf ("This is what you have:\n\n");
  dis_regis(&usersupp);
  printf ("\nDo you wish to change it (y/n)? ");
  if (yesno())
    {
      sprintf (logmsg, "%s changed registration info", usersupp.fullname);
      intlog (logmsg);
      entregis(usersupp);
    }
  printf ("You can use .CC to make your info public or private.\n");
}


/*--------------------------------------------------------------------------*/
void user_terminate()
{
  printf("Are you sure (y/n)? ");
  if (yesno()==1) 
    {
      updatels();
      do_terminate();
    }
}


/*--------------------------------------------------------------------------*/
void skiproom()
{
  storeug();
  skipping[curr_rm] = 1;
  gotonext();
}


/*--------------------------------------------------------------------------*/
/* just say no
void do_chat()
{
  int a;
  enter_btmp("[Chat]");
  setsane(); 
  externstty();
  a=fork();
  if (a == 0)
    {
      execlp ("chat", "", usersupp.fullname, NULL);
      printf ("Chat program not available.\n");
      exit (0);
    }
  (void) wait(0);
  sttybbs(0);	     
}

*/ /* say no to chat */

/*--------------------------------------------------------------------------*/
/* # key-- how many old messages to read */

void lastxread()
{
  char readnum[10];                      /* input for how many messages */

  printf ("How many messages would you like to read? ");
  getline (readnum, 3);
  sscanf (readnum, "%d", &intmany);
  if (intmany < 0)
    printf ("You must select a positive number of messages!\n");
  else
    readmsgs (MSGSPERRM-intmany,0,1);
}


/*--------------------------------------------------------------------------*/
void do_fortune()
{
  int a;
  a=fork();
  if (a==0)
    {
      execlp ("/usr/games/fortune", "", NULL);
      printf ("No fortunes available.\n");
      exit(0);
    }
  (void) wait(0);
}

/*----------------------------------------------------------------------*/
/* call the subsystem */

void subsystem()
{
  int a;
  enter_btmp ("[Subsystem]");
  setsane();
  externstty();
  a=fork();
  if (a==0)
    {
      if ((usersupp.flags & US_SUBSYSTEM) || (usersupp.axlevel >= 6))
	execlp ("./subsystem", "", "4", NULL);
      else
	execlp("./subsystem", "", "3", NULL);
      printf ("Subsystem is unavailable.\n");
      exit (0);
    }
  (void)wait(0);
  sttybbs(0);
}


/*--------------------------------------------------------------------------*/
void do_sleep()
{
  printf ("Your session has fallen asleep.\n");
  printf ("Press any key to wake it back up.\n");
  enter_btmp("[Sleeping]");
  inkey();
}

/*--------------------------------------------------------------------------*/
/* A room's generation number changes each time it is recycled. Users are kept
 * out of private rooms or forget rooms by matching the generation numbers. To
 * avoid an accidental matchup, unmatched numbers are set to -1 here.
 */
void check_generation()
{

  int file,a;

  file=open("quickroom",O_RDONLY); 
  if (file<0) 
    interr(5);
  for (a=0; a<MAXROOMS; ++a) 
    {
      read(file,&quickroom,sizeof(struct quickroom));
      if (usersupp.generation[a] != quickroom.QRgen)
	usersupp.generation[a]=(-1);
      if (usersupp.forget[a] != quickroom.QRgen) 
	usersupp.forget[a]=(-1);
    }
  close(file);
}


/*--------------------------------------------------------------------------*/
/* print the login information */

void print_login_banner(long laston)
{
  struct tm *tmstruct;
  long remaining;
  char aaa[50];

  printf("\nUser %s (#%ld), Access level: %s, Call #%d", 
	 usersupp.fullname, usersupp.eternal, axdefs[usersupp.axlevel],
	 usersupp.timescalled);
  if (usersupp.axlevel >= 6)
    printf (", (%s), pid=%d", mytty, getpid());

  printf ("\n");

  tmstruct = (struct tm *)localtime(&laston);
  sprintf (aaa, "%s", asctime (tmstruct));
  aaa[strlen(aaa)-1]=0;

  if ((strncmp(lhost,"none",4)) == 0)
    printf ("No previous logins.\n");
  else
    printf ("Last login: %s from %-16.16s\n", aaa, lhost);

  if (usersupp.timescalled != 1) 
    {
      daycheck(tmstruct->tm_yday);
      printf ("You have been on %dh %dm today, with ", usersupp.today/60,
	      usersupp.today % 60);
      if ((usersupp.timelimit == 0) || (usersupp.axlevel >= 6))
	printf ("unlimited time remaining.\n");
      else
	{
	  remaining = usersupp.timelimit - usersupp.today;
	  printf ("%dh %dm remaining.\n", remaining/60, remaining % 60);
	}
    }
  else
    {
      printf ("\n");
      if (usersupp.axlevel < 3) 
	formout (NOTVALID);
      else
	formout (VALID);

      curr_rm=0;
      gotocurr();
      printf ("You are now entering the Lobby. ");
      print_desc(curr_rm, quickroom.QRname);
      sleep (3);
    }
}



/*--------------------------------------------------------------------------*/
/* initial login check for new mail */

void mailcheck()           
{
  int a,b=0;

  for (a=0; a<MAILSLOTS; ++a)
    if (usersupp.mailnum[a]>usersupp.lastseen[1]) 
      ++b;
  if (b==1) 
    printf("*** You have a new private message in Mail>\n");
  if (b>1)  
    printf("*** You have %d new private messages in Mail>\n",b);
}



/*--------------------------------------------------------------------------*/
/* check for new users needing validation */

void check_needvalid()
{
  int file;

  file=open("structures/MMstructure.0",O_RDONLY);
  if (file < 0)
    interr (94);
  read(file,&msgmain,sizeof(struct msgmain));
  close(file);

  if ((msgmain.MMflags&MM_VALID)&&(INITAX < 3))
    printf("*** New users need to be validated.\n");
}



