/* 
File: front.c
Desc: BBS front end
Source:  Originally by Hobbit
Change History
01/21/93 pirmann rewritten and cleaned up
10/31/93 pirmann changed strncmp to strcmp in matching bbs logins
10/31/93 pirmann changed "system (mesg n)" to a chmod system call

   files:
   front.ALLOW     max allow (defaults to 10 if nonexistant)
   front.DOWN      bbs is down if exists
   front.PROHIBE   list of blacklisted hosts
   
   see also front.h
*/

#include <stdio.h>
#include <fcntl.h>
#include <utmp.h>
#include <string.h>
#include "front.h"

char *index();		/* for strings.h */

struct utmp entry;
/* contains:	ut_line		tty name	8
		ut_name		user		8
		ut_host		4n host		16
		ut_time		when logged in	long
*/
#define REC sizeof (struct utmp)

main()
{
  int ucount = 0, uid, maxallow, *fakearg = 0, file;
  static char thistty[9];
  FILE *fp;
  char hname[16], host[16], tmpallow[2], *foo, syscmd[100];
  
  chdir (BBSDIR);

  /* do this first, so we can hook later */
  uid = getuid();

  /* Hook for taking the thing down -- do this first!!! 
   if the bbs is down no reason to do anything else */

  if ((file = open(DOWNFILE, O_RDONLY)) > 0)
    {
      close (file);
      if ((uid == SYSOP)||(uid == 0))
	printf ("(The bbs is down.)\n");
      else
	{
	  printfile (DOWNFILE);
	  sleep (2);
	  return (0);
	}
    }

  /* use ALLOWFILE to determine maximum number of users, else
   set a default (from front.h) */

  fp = fopen(ALLOWFILE,"r");
  if (fp != NULL)
    {
      fgets(tmpallow,3,fp);
      sscanf(tmpallow,"%d",&maxallow);
      fclose (fp);
    }
  else
    maxallow = DEFAULT_MAX;

  /* find out which tty we're on */
  strcpy (thistty, ttyname(0));  /* gives us /dev/ttyxx */

  /* so outside buttheads don't talk bbs and screw everyone */
  if (uid == BBSUID)
    chmod (thistty, 0600); /* nicer way to do mesg n */

  strcpy (thistty, (char *)(strrchr (thistty, '/') + 1)); /* gives us ttyxx */

  /* find out what hostname we're coming in from and put it in hname 
     and while utmp is open, determine how many bbs users are already on */

  file = open ("/etc/utmp", O_RDONLY);
  if (file < 0)
    {
      printf ("Can't read UTMP file, please notify sysop!\n");
      return (-1);
    }
  while ((read (file, &entry, REC)) != 0) 
    {
      if ((strcmp (entry.ut_line, thistty)) == 0) 
	strncpy (hname, entry.ut_host, 16);
      if (!strcmp (entry.ut_name, "bbs")) 
	{
	  ucount++;
	  if ((ucount > maxallow) && (uid == BBSUID))
	    {
	      printfile (FULLMSG);
	      close (file);
	      printf ("*** Current max # users is: %d\n", maxallow);
	      sleep (1);
	      exit (0);      
	    }
	}
    }
  close(file);

  /* check to see if we're coming from a blacklisted host */
  fp = fopen (PROHIBFILE, "r");
  if (fp != NULL)
    {
      do
	{
	  foo = fgets(host,16,fp);
	  if (foo != NULL)
	    if (match (host, hname))
	      {
		fclose (fp);
		printfile (PROHIBMSG);
		sleep (1);
		if (uid == BBSUID)
		  exit (0);	/* Fuck you... */
	      }
	} while (foo != NULL);
    }   /* done with front.PROHIBE */
  fclose (fp); 
  
  /* we're all clear-- open slots and not prohibited-- lets go */

  /* print out the message of the day */
  if ((file = open (MOTD,O_RDONLY)) != -1)
    {
      close (file);
      printfile (MOTD);
    }

  /* If we're chrooted, we can't see the real utmp.  What a pain in the tail */
  sprintf (syscmd, "/bin/cp -p %s %s", SYSUTMPFILE, UTMPFILE);
  system (syscmd);

  chroot (BBSDIR);              /* stay root until we're done with this */
  umask (02);			/* so group rw is preserved */
  setgid (BBSGID);		/* this too, or it comes up trashed */
  setuid (BBSUID);		/* now become the real user and shift */

  /* Hobbit wrote: the gid *still* comes up trashed, even though I
     explicitly set it.  Go figure.  I don't know why yet.  _H*

     DP wrote: changed these around because you can't setgid if you're not 
     root -DP */

  execl (EXECUTABLE, EXECUTABLE, thistty, fakearg);
  /* if we can't find citadel just quietly die */
  exit(0);
  }


/* check for character matches from blacklist strings */
static int
match (sub, str)
char *sub, *str;
{
  if ((str = (index (str, *sub))) == NULL) return (0);
  while (*sub != '\0')
    if (*sub++ != *str++) return (0);
  return (1);
}


printfile (name)
char name[];
{
  int a=0;
  FILE *fp;

  if ((fp=fopen (name, "r")) != NULL)
    {
      while ((a=getc(fp)) != EOF)
	putc (a, stdout);
      fclose (fp);
    }
}
