/* $Id: sysdep_decls.h,v 613.0 2003/12/15 16:37:04 ajc Exp $ */

#include <pthread.h>
#include "sysdep.h"
#include "server.h"

#ifdef __GNUC__
void lprintf (int loglevel, const char *format, ...) __attribute__((__format__(__printf__,2,3)));
void cprintf (const char *format, ...) __attribute__((__format__(__printf__,1,2)));
#else
void lprintf (int loglevel, const char *format, ...);
void cprintf (const char *format, ...);
#endif

void init_sysdep (void);
void begin_critical_section (int which_one);
void end_critical_section (int which_one);
int ig_tcp_server (int port_number, int queue_len);
int ig_uds_server(char *sockpath, int queue_len);
INLINE struct CitContext *MyContext (void);
struct CitContext *CreateNewContext (void);
void InitMyContext (struct CitContext *con);
void buffer_output(void);
void unbuffer_output(void);
void client_write (char *buf, int nbytes);
int client_read_to (char *buf, int bytes, int timeout);
int client_read (char *buf, int bytes);
int client_gets (char *buf);
void sysdep_master_cleanup (void);
void kill_session (int session_to_kill);
void *sd_context_loop (struct CitContext *con);
void start_daemon (int do_close_stdio);
void cmd_nset (char *cmdbuf);
int convert_login (char *NameToConvert);
void *worker_thread (void *arg);
void become_session(struct CitContext *which_con);
void CtdlRedirectOutput(FILE *fp, int sock);
void InitializeMasterCC(void);
void init_master_fdset(void);
void create_worker(void);

extern int num_sessions;
extern volatile int time_to_die;
extern int verbosity;
extern int rescan[];
extern pthread_t initial_thread;

extern struct worker_node {
        pthread_t tid;
        struct worker_node *next;
} *worker_list;
