/* $Id: serv_imap.h,v 613.0 2003/12/15 16:37:03 ajc Exp $ 
 */


void imap_cleanup_function(void);
void imap_greeting(void);
void imap_command_loop(void);
int imap_grabroom(char *returned_roomname, char *foldername);
void imap_free_transmitted_message(void);



struct citimap {
	int authstate;
	char authseq[SIZ];
	int selected;		/* set to 1 if in the SELECTED state */
	int readonly;		/* mailbox is open read only */
	int num_msgs;		/* Number of messages being mapped */
	long *msgids;
	unsigned int *flags;
	char *transmitted_message;	/* for APPEND command... */
	size_t transmitted_length;
};

/*
 * values of 'authstate'
 */
enum {
	imap_as_normal,
	imap_as_expecting_username,
	imap_as_expecting_password
};

/* Flags for the above struct.  Note that some of these are for internal use,
 * and are not to be reported to IMAP clients.
 */
#define IMAP_ANSWERED		1
#define IMAP_FLAGGED		2
#define IMAP_DELETED		4
#define IMAP_DRAFT		8
#define IMAP_SEEN		16

#define IMAP_MASK_SETABLE	0x1f
#define IMAP_MASK_SYSTEM	0xe0

#define IMAP_SELECTED		32	/* internal */


#define IMAP ((struct citimap *)CtdlGetUserData(SYM_IMAP))

/*
 * When loading arrays of message ID's into memory, increase the buffer to
 * hold this many additional messages instead of calling realloc() each time.
 */
#define REALLOC_INCREMENT 100
