#!/bin/bash

clear
cat <<!

Citadel/UX Database Cleanup
---------------------------

This script exports, deletes, and re-imports your database.  If you have
any data corruption issues, this program may be able to clean them up for you.
 
Please note that this program does a Berkeley DB dump/load, not a Citadel
export.  The export files are not generated by the Citadel export module.

MAKE A BACKUP OF YOUR DATA BEFORE ATTEMPTING THIS.  There is no guarantee
that this will work!

!

echo -n "Do you want to continue? "

read yesno
case "$yesno" in
	"y" | "Y" | "yes" | "YES" | "Yes" )
		echo 
		echo DO NOT INTERRUPT THIS PROCESS.
		echo
	;;
	* )
		exit
esac

for x in 00 01 02 03 04 05 06 07
do
	filename=cdb.$x
	echo Dumping $filename
	db_dump -h ./data $filename >/tmp/CitaDump.$x
	rm -f ./data/$filename
done

echo Removing log files
rm -f ./data/*

for x in 00 01 02 03 04 05 06 07
do
	filename=cdb.$x
	echo Loading $filename
	db_load -h ./data $filename </tmp/CitaDump.$x
	rm -f /tmp/CitaDump.$x
done

echo 
echo Dump/load operation complete.  Start your Citadel server now.
echo
