/*
 * userlist.c v1.3
 * for use with Citadel/UX
 * see copyright.doc for copyright information
 */

/* set PWGROUP to the group ID of people who can use the -p option */
#define PWGROUP 20

#include <stdio.h>
#include <fcntl.h>
#include <pwd.h>
#include <ctype.h>
#include <time.h>
#include <signal.h>
#include "citadel.h"

struct passwd *getpwnam();
struct tm *localtime();
long atol();
struct config config;

int (*sigexit())() {
	signal(SIGQUIT,SIG_IGN);
	signal(SIGINT,SIG_IGN);
	printf("\n\n");
	exit(0);
	}

main(argc,argv)
int argc;
char *argv[]; {
	int a,b,file,pass;
	char aaa[100];
	long aa,snum;
	struct usersupp usersupp;
	struct tm *tmstruct;

	signal(SIGQUIT,(*sigexit));
	signal(SIGINT,(*sigexit));
	get_config();
	pass=0; snum=(-1L);
	for (a=1; a<argc; ++a) {
		if (!strcmp(argv[a],"-p")) pass=1;
		if (!strcmp(argv[a],"-n")) snum=atol(argv[a+1]);
		}

	if (getgid()!=PWGROUP) pass=0;

	file=open("usersupp",O_RDONLY);
	if (file<0) {
		fprintf(stderr,"userlist: cannot open user file\n");
		exit(1);
		}

	printf("    User Name           L Number LastCall #Calls Posted ");
	if (pass) printf("Password");
	printf("\n");
	printf("----------------------- - ------ -------- ------ ------ ");
	if (pass) printf("-------------------");
	printf("\n");
A:	a=read(file,&usersupp,sizeof(struct usersupp));
	if (a<1) goto END;
	for (b=0; b<strlen(usersupp.fullname); ++b) {
		if (usersupp.fullname[b]<32) usersupp.fullname[b]='.';
		if (usersupp.fullname[b]>126) usersupp.fullname[b]='.';
		}
	if (snum!=(-1L)) {
		if ((pass==0)&&(((usersupp.flags&US_UNLISTED)==US_UNLISTED)))
			goto A;
		}
	if ((snum!=(-1L))&&(snum!=usersupp.eternal)) goto A;
		
	aa=usersupp.lastcall;
	tmstruct=localtime(&aa);
	sprintf(aaa,"%02d/%02d/%02d",
		(tmstruct->tm_mon+1),
		tmstruct->tm_mday,
		tmstruct->tm_year);
	usersupp.fullname[23]=0;

	a=48+usersupp.axlevel;
	printf("%-23s %c %6ld %6s %6d %6d ",
		usersupp.fullname,a,
		usersupp.eternal,
		aaa,
		usersupp.timescalled,
		usersupp.posted
		);
	pwcrypt(usersupp.password,PWCRYPT);
	if (pass) printf("%s",usersupp.password);
	printf("\n");
	goto A;

END:	close(file);
	exit(0);
	}

pwcrypt(text,code)
char text[];
int code; {
	int a;
	for (a=0; a<strlen(text); ++a) text[a]=(text[a]^(((code|128)^a)&0xFF));
	return(0);
	}
