/*
 * Citadel/UX setup program
 * v2.0 / by Art Cancro 05/25/1994
 * see copyright.doc for copyright information
 *
 * *** YOU MUST EDIT sysconfig.h >BEFORE< COMPILING SETUP ***
 */

#include <stdio.h>
#include <ctype.h>
#include <fcntl.h>
#include "citadel.h"
#include "axdefs.h"

long atol();
struct config config;

cre8user() {
	int fd;
	long lbuf;

	/* write null files */
	system("cp /dev/null usersupp; cp /dev/null hashtab");

	fd=creat("eternal",0666);
	lbuf = 0L;
	write(fd,&lbuf,sizeof(long));
	close(fd);

	}

cre8msg() {
	struct msgmain msgmain;
	FILE *fp;
	long aa;

	fp=fopen("msgmain","wb");
	for (aa=0; aa<=(MM_FILELEN+100); ++aa) {
		putc(0,fp);
		if ((aa%10000L)==0L)
			printf("setup: writing msgmain byte %15ld\r",aa);
		}
	fclose(fp);

	printf("setup: writing control structure and unlocking file\n");
	msgmain.MMlowest=1L;
	msgmain.MMhighest=1L;
	msgmain.MMcurpos=0L;
	msgmain.MMflags=0;

	fp=fopen("MMstructure","wb");
	fwrite((char *)&msgmain,sizeof(struct msgmain),1,fp);
	fclose(fp);
}

cre8room() {
	int a;
	FILE *fp;
	char aaa[50];
	struct quickroom quickroom;
	struct fullroom fullroom;

	printf("setup: creating and initializing room files\n");

	/* Load up a blank fullroom structure to be used for all rooms */
	for (a=0; a<MSGSPERRM; ++a) {
		fullroom.FRnum[a]=0L;
		fullroom.FRpos[a]=0L;
		}

	/* Open a new quickroom file */
	fp=fopen("quickroom","wb");
	strcpy(quickroom.QRpasswd,"");
	quickroom.QRroomaide=0L;
	quickroom.QRhighest=0L;
	quickroom.QRgen=1;
	quickroom.QRflags=QR_INUSE;

	/* Create Lobby> Mail> and Aide> */
	strcpy(quickroom.QRname,"Lobby");
	fwrite((char *)&quickroom,sizeof(struct quickroom),1,fp);

	strcpy(quickroom.QRname,"Mail");
	fwrite((char *)&quickroom,sizeof(struct quickroom),1,fp);
	
	strcpy(quickroom.QRname,"Aide");
	fwrite((char *)&quickroom,sizeof(struct quickroom),1,fp);

	/* make the remaining rooms blanks */
	strcpy(quickroom.QRname,"");
	quickroom.QRflags=0;
	for (a=3; a<MAXROOMS; ++a) {
		printf("setup: creating quickroom %-3d\r",a);
		fwrite((char *)&quickroom,sizeof(struct quickroom),1,fp);
		}
	fclose(fp);

	/* Create directories and fullroom files */
	system("mkdir rooms");
	for (a=0; a<MAXROOMS; ++a) {
		printf("setup: creating fullroom %-4d\n",a);
		sprintf(aaa,"./rooms/fullrm%d",a);
		fp=fopen(aaa,"wb");
		fwrite((char *)&fullroom,sizeof(struct fullroom),1,fp);
		fclose(fp);
		}
}

cre8clog() {
	int file,a;
	struct calllog calllog;

	calllog.CLfullname[0]=0;
	calllog.CLtime=0L;
	calllog.CLflags=0;
	a=0;

	file=creat("calllog.pos",0666);
	chmod("calllog.pos",0666);
	write(file,&a,sizeof(int));
	close(file);

	file=creat("calllog",0666);
	chmod("calllog",0666);
	for (a=0; a<CALLLOG; ++a) {
		printf("setup: creating call log #%-4d\r",a);
		write(file,&calllog,sizeof(struct calllog));
		}
	close(file);
	return(0);
}


set_str_val(str)
char *str; {
	char buf[128];
	
	printf("This is currently set to:\n%s\n",str);
	printf("Enter new value or press return to leave unchanged:\n");
	gets(buf);
	if (strlen(buf)!=0) strcpy(str,buf);
	}

set_int_val(ip)
int *ip; {
	char buf[16];
	sprintf(buf,"%d",(int)*ip);
	set_str_val(buf);
	*ip = atoi(buf);
	}


set_char_val(ip)
char *ip; {
	char buf[16];
	sprintf(buf,"%d",(int)*ip);
	set_str_val(buf);
	*ip = (char)atoi(buf);
	}


set_long_val(ip)
long *ip; {
	char buf[16];
	sprintf(buf,"%ld",*ip);
	set_str_val(buf);
	*ip = atol(buf);
	}


int yesno_s() {
	char buf[8];
	gets(buf);
	buf[0] = tolower(buf[0]);
	if (buf[0]!='y') return(0);
	printf("Are you SURE you want to reinitialize this file? ");
	gets(buf);
	buf[0] = tolower(buf[0]);
	if (buf[0]=='y') return(1);
	else return(0);
	}


main() {
	int a;
	char aaa[128];
	FILE *fp;
	int created_msgmain = 0;

	chdir(BBSDIR);
	system("sh -c clear 2>/dev/null");	/* clear the screen */
	printf("\n\n\n               *** Citadel/UX setup program ***\n\n");

	/*
 	 * what we're going to try to do here is append a whole bunch of
	 * nulls to the citadel.config file, so we can keep the old config
	 * values if they exist, but if the file is missing or from an
	 * earlier version with a shorter config structure, when setup tries
	 * to read the old config parameters, they'll all come up zero.
	 * The length of the config file will be set to what it's supposed
	 * to be when we rewrite it, because we replace the old file with a
	 * completely new copy.  (Neat, eh?)
	 */
	fp=fopen("citadel.config","a");
	if (fp==NULL) {
		fprintf(stderr,"setup: cannot open citadel.config\n");
		exit(1);
		}
	for (a=0; a<sizeof(struct config); ++a) putc(0,fp);
	fclose(fp);

	/* now we re-open it, and read the old or blank configuration */
	fp=fopen("citadel.config","r");
	if (fp==NULL) {
		fprintf(stderr,"setup: cannot open citadel.config\n");
		exit(1);
		}
	fread((char *)&config,sizeof(struct config),1,fp);
	fclose(fp);


	/* set some sample/default values in place of blanks... */
	if (strlen(config.c_nodename)==0)
		strcpy(config.c_nodename,"mysystem");
	if (strlen(config.c_fqdn)==0)
		sprintf(config.c_fqdn,"%s.UUCP",config.c_nodename);
	if (strlen(config.c_humannode)==0)
		strcpy(config.c_humannode,"My System");
	if (strlen(config.c_phonenum)==0)
		strcpy(config.c_phonenum,"US 800 555 1212");
	if (config.c_initax == 0)
		config.c_initax = 1;
	if (config.c_regiscall == 0)
		config.c_regiscall = 1;
	if (strlen(config.c_moreprompt)==0)
		strcpy(config.c_moreprompt,"<more>");
	if (strlen(config.c_twitroom)==0)
		strcpy(config.c_twitroom,"Trashcan");
	if (config.c_defent == 0)
		config.c_defent = 46;

	printf("\n\n<Citadel and UUCP node name>\n\n");
	printf("This is the name your system is known by on a Citadel/UX\n");
	printf("network.  It should be 8 characters or less, and you\n");
	printf("should set it to the same as your system's UUCP node name.\n");
	printf("In fact, the rules that apply when choosing a UUCP node\n");
	printf("name are the same rules that apply when choosing a Citadel\n");
	printf("node name - which shouldn't be a problem if they're\n");
	printf("one and the same.\n\n");
	set_str_val(config.c_nodename);


	printf("\n\n<Fully Qualified Domain Name (FQDN)>\n\n");
	printf("This is the name your system is known by on the Internet.\n");
	printf("If you're not on the Internet, simply set this to your\n");
	printf("node name followed by '.UUCP'.\n\n");
	set_str_val(config.c_fqdn);

	printf("\n\n<Human-readable node name>\n\n");
	printf("This is a longer description of your system, readable by\n");
	printf("us mere humans.  It can be up to 20 characters long and it\n");
	printf("can have spaces in it.  Note that if you are part of a\n");
	printf("Cit86Net, this is the name your system will be known by on\n");
	printf("that network.\n\n");
	set_str_val(config.c_humannode);

	printf("\n\n<Phone number>\n\n");
	printf("This is the main dialup number for your system.  If yours\n");
	printf("can not be dialed into, then make one up!  It should be in\n");
	printf("the format 'US 000 000 0000' - the US is your country code\n");
	printf("(look it up if you're not in the United States) and the\n");
	printf("rest is, of course, your area code and phone number.  \n");
	printf("This doesn't have any use in Citadel/UX, but gateways to\n");
	printf("other networks may require it, and someday we may use this\n");
	printf("to have the networker automatically build a BBS list.\n\n");
	set_str_val(config.c_phonenum);

	printf("\n\n<BBS City and State>\n\n");
	printf("Enter the city and state your system is located in.\n\n");
	set_str_val(config.c_bbs_city);

	printf("\n\n<System Administrator>\n\n");
	printf("Enter the name of the system administrator (which is\n");
	printf("probably you).\n\n");
	set_str_val(config.c_sysadm);

	printf("\n\n<BBS User ID>\n\n");
	printf("You should create a user called 'bbs', 'guest', 'citadel',\n");
	printf("or something similar, that will allow users a way into\n");
	printf("your BBS.  Citadel doesn't require that you put all of\n");
	printf("your users into /etc/passwd, although it will create\n");
	printf("accounts automatically for those users and link them to\n");
	printf("their /etc/passwd accounts, automatically logging them\n");
	printf("into their Citadel account when they run Citadel.  For\n");
	printf("everyone else, however, you can simply create one public\n");
	printf("login in /etc/passwd, and Citadel will maintain its own\n");
	printf("userlog for those people.  For this to work, you must set\n");
	printf("the BBS User ID parameter to the UID of that account.\n\n");
	set_int_val(&config.c_bbsuid);

	printf("\n\n<Password encryption seed>\n\n");
	printf("Citadel uses a (very) simple password encryption scheme\n");
	printf("to thwart breakins that could occur if someone snatched\n");
	printf("a copy of your userlog.  This parameter is part of the\n");
	printf("algorithm, so that the code can be different on each\n");
	printf("system.  Once it has been set, DO NOT change it --\n");
	printf("otherwise no one will be able to log in!\n\n");
	set_int_val(&config.c_pwcrypt);

	printf("\n\n<'Room Creator = Room Aide' flag>\n\n");
	printf("This is a boolean value.  If you set it to 1, anyone who\n");
	printf("creates a class 3 (passworded) or class 4 (invitation\n");
	printf("only) room will automatically become the Room Aide for\n");
	printf("that room, allowing them to edit it, delete/move messages,\n");
	printf("etc.  This is an administrative decision: it works well on\n");
	printf("some systems, and not so well on others.  Set this to 0 to\n");
	printf("disable this function.\n\n");
	set_char_val(&config.c_creataide);

	printf("\n\n<Watchdog timer setting>\n\n");
	printf("Citadel/UX can automatically log out users who sit idle,\n");
	printf("not typing anything, for a given amount of time.  If you\n");
	printf("wish to use this function, set this value to the number\n");
	printf("of seconds to wait before logging someone out.  For\n");
	printf("example, setting it to 180 (the recommended value) will\n");
	printf("log a user off if he/she doesn't type anything for three\n");
	printf("minutes.  To disable the watchdog timer, set it to 0.\n\n");
	set_int_val(&config.c_sleeping);

	printf("\n\n<Initial access level>\n\n");
	printf("This is the access level new users are assigned.  The\n");
	printf("access levels are:\n");
	for (a=0; a<7; ++a) printf("          %d - %s\n",a,axdefs[a]);
	printf("The most common settings for this will be either 1, for\n");
	printf("systems which require new user validation by the system\n");
	printf("administrator ('sysop' is a word for people who run DOS\n");
	printf("boards!), or 4, for systems which give instant access.\n\n");
	set_char_val(&config.c_initax);

	printf("\n\n<Registration requirements>\n\n");
	printf("'Registration' refers to the boring part of logging into\n");
	printf("a BBS for the first time: typing your name, address, and\n");
	printf("telephone number.  Set this value to 1 to automatically\n");
	printf("do registration for new users, or 0 to not auto-register.\n");
	printf("Optionally, you could set it to, say, 2, to auto-register\n");
	printf("on a user's second call, but since most sysadmins will use\n");
	printf("registration info when validating users, this isn't really\n");
	printf("desirable.  The recommended value is 1 if you've set your\n");
	printf("initial access level to 1, or 0 if you've set your initial\n");
	printf("access level to something higher.\n\n");
	set_char_val(&config.c_regiscall);

	printf("\n\n<Twit Detect!>\n\n");
	printf("Every BBS has its share of problem users.  This is one\n");
	printf("good way to deal with them: if you enable this option,\n");
	printf("anyone you flag as a 'problem user' (access level 2) can\n");
	printf("post anywhere they want, but their messages will all be\n");
	printf("automatically moved to a room of your choosing.  Set this\n");
	printf("value to 1 to enable Twit Detect, or 0 to disable it.\n\n");
	set_char_val(&config.c_twitdetect);

	printf("\n\n<Twit Detect target room>\n\n");
	printf("This is the name of the room that problem user messages\n");
	printf("get moved to if you have Twit Detect enabled.\n");
	printf("(Note: don't forget to *create* this room!)\n\n");
	set_str_val(config.c_twitroom);

  do {
	printf("\n\n<The <E>nter message command...>\n\n");
	printf("This is the command that gets executed when a user\n");
	printf("presses the <E>nter message key.  The possible values are:\n");
	printf("46 - .<E>nter message with <E>ditor\n");
	printf(" 4 - .<E>nter <M>essage\n");
	printf("36 - .<E>nter message with <A>scii\n\n");
	printf("If you have an external editor installed, set this to 46\n");
	printf("to make it use your editor by default.  If not, set it to\n");
	printf("4 to use Citadel's built-in editor.  You can also set\n");
	printf("it to 36 for raw input, but this is NOT recommended as\n");
	printf("it tends to generate very messy messages.   Use an\n");
	printf("external editor if at all possible.\n\n");
	set_int_val(&config.c_defent);
    	if ( (config.c_defent != 46) 
	   && (config.c_defent != 4)
	   && (config.c_defent != 36))
		printf("ERROR: you must set this to 46, 4, or 36.\n");
    } while ( (config.c_defent != 46) 
		&& (config.c_defent != 4)
		&& (config.c_defent != 36) );

	printf("\n\n<Paginator prompt>\n\n");
	printf("This is the prompt that appears after each screenful of\n");
	printf("text - for users that have chosen that option.  Usually\n");
	printf("a simple '<more>' will do, but some folks like to be\n");
	printf("creative...\n\n");
	set_str_val(config.c_moreprompt);

	printf("\n\n<Restrict Internet mail flag>\n\n");
	printf("If you have a gateway set up to allow Citadel users to\n");
	printf("send Internet mail, with UUCP, sendmail, or whatever, and\n");
	printf("you wish to restrict this to only users to whom you have\n");
	printf("given this privilege, set this flag to 1.  Otherwise, set\n");
	printf("it to 0 to allow everyone to send Internet mail.\n");
	printf("(Obviously, if your system doesn't have the ability to\n");
	printf("send mail to the outside world, this is all irrelevant.)\n\n");
	set_char_val(&config.c_restrict);

	printf("\n\n<Message base size>\n\n");
	printf("This is the size of the file ALL messages are stored in.\n");
	printf("The file is a fixed size, is created during setup, and\n");
	printf("never grows or shrinks.  Once you have created the file,\n");
	printf("you cannot change its size.\n");
	printf("Two megabytes (2097152 bytes) is fine for most systems.\n");
	set_long_val(&config.c_msgbase);


	fp=fopen("citadel.config","w");
	if (fp==NULL) {
		fprintf(stderr,"setup: cannot open citadel.config\n");
		exit(1);
		}
	fwrite((char *)&config,sizeof(struct config),1,fp);
	fclose(fp);

	printf("\n\n\n\n\n");
	printf("DO NOT re-create files that you wish to keep intact.\n");
	printf("They will be ERASED if you do so!\n");
	printf("If you are setting up Citadel/UX for the first time,\n");
	printf("answer 'yes' to all of the prompts.\n\n");

	created_msgmain = 0;
	fp=fopen("msgmain","r");
	if (fp==NULL) {
		printf("Message file does not exist, creating...\n");
		cre8msg();
		created_msgmain = 1;
		}
	else {
		fclose(fp);
		printf("\nCreate message file? ");
		if (yesno_s() == 1) {
			cre8msg();
			created_msgmain = 1;
			}
		}

	if (created_msgmain == 1) {
		printf("Since a new message file was created, a new room\n");
		printf("file will be created automatically.\n");
		cre8room();
		}
	else {
		fp=fopen("quickroom","r");
		if (fp==NULL) {
			printf("Room files do not exist, creating...\n");
			cre8room();
			}
		else {
			fclose(fp);
			printf("\n  Create room files? ");
			if (yesno_s()==1) cre8room();
			}
		}

	fp=fopen("usersupp","r");
	if (fp==NULL) {
		printf("User file does not exist, creating...\n");
		cre8user();
		}
	else {
		fclose(fp);
		printf("\nCreate user file? ");
		if (yesno_s()==1) cre8user();
		}

	a=0;
	fp=fopen("calllog","r");
	if (fp==NULL) {
		printf("Call log does not exist, creating...\n");
		cre8clog();
		}
	else {
		fclose(fp);
		printf("\nCreate call log? ");
		if (yesno_s()==1) cre8clog();
		}

	printf("\nSetup finished.\n");
	exit(0);
}
