/* 
 * netcmd.c  -- utility to enter network commands
 * see copyright.doc for copyright information
 */

#include <stdio.h>
#include "citadel.h"

int geti() {
	char buf[8];
	gets(buf);
	return atoi(buf);
	}

int yesno() {
	char buf[8];
	printf("Ok to submit command (y/n)? ");
	gets(buf);
	return(tolower(buf[0]=='y'));
	}


submit_cmd(text)
char *text; {
	FILE *spool;
	char tmpflnm[64];
	long now;

	sprintf(tmpflnm,"./network/spoolin/netcmd%d",getpid());
	time(&now);

	spool=fopen(tmpflnm,"w");
	putc(255,spool); putc(65,spool); putc(1,spool);
	fprintf(spool,"Psysop"); putc(0,spool);
	fprintf(spool,"T%ld",now); putc(0,spool);
	fprintf(spool,"ANetwork Control"); putc(0,spool);
	fprintf(spool,"OControl"); putc(0,spool);
	fprintf(spool,"N%s",NODENAME); putc(0,spool);
	fprintf(spool,"M%s\n\n",text);
	fprintf(spool,"(network command entered by netcmd program -\n");
	fprintf(spool,"do not attempt to enter net commands manually)\n");
	putc(0,spool);
	fclose(spool);
	execlp("netproc","netproc",NULL);
	fprintf(stderr,"netcmd: warning: cannot execute netproc\n");
	exit(0);
	}


main(argc,argv)
int argc;
char *argv[]; {
	char buf[64];
	int sel;

	chdir(BBSDIR);

	if ((argc==2)&&(!strcmp(argv[1],"-d"))) {
		generate_discovery_packet(1);
		exit(0);
		}


	while(1) {
		printf("\n\n\nEnter network command\n\n");
		printf("1. Add network-wide room\n");
		printf("2. Delete network-wide room\n");
		printf("3. Disconnect room only, do not delete\n");
		printf("4. Rename network-wide room\n");
		printf("5. Generate discovery packet\n");
		printf("\nEnter selection or <return> to abort: ");
		gets(buf); sel=atoi(buf);
		switch(sel) {
			case 0:	exit(0);
				break;
			case 1: enter_net_room();
				break;
			case 2: delete_net_room();
				break;
			case 3: disconnect_net_room();
				break;
			case 4: rename_net_room();
				break;
			case 5:	generate_discovery_packet(0);
				break;
			default: printf("Selection %d is not available\n",sel);
			}
		}
	}

enter_net_room() {
	char new_room_name[20],password[15],command_line[128];
	int new_room_type;
	printf("Enter name for new room: ");
	gets(new_room_name);
	if (strlen(new_room_name)==0) exit(0);
	new_room_name[19]=0;
	new_room_type = 0;
	while( (new_room_type < 1) || (new_room_type > 4) ) {
		printf("<1> Public\n<2> Guess-name\n");
		printf("<3> Passworded\n<4> Invitation only\n");
		new_room_type=geti();
		if (new_room_type==3) {
			printf("Enter room password: ");
			gets(password);
			}
		else strcpy(password,"");
		}
	if (yesno()) {
		sprintf(command_line,"#netcmd\naddroom\n%s\n%d\n%s\n",
			new_room_name,new_room_type,password);
		submit_cmd(command_line);
		}
	}

rename_net_room() {
	char old_room_name[20],new_room_name[20],command_line[128];
	printf("Enter old room name: ");
	gets(old_room_name);
	if (strlen(old_room_name)==0) exit(0);
	printf("Enter new room name: ");
	gets(new_room_name);
	if (strlen(new_room_name)==0) exit(0);
	new_room_name[19]=0;
	if (yesno()) {
		sprintf(command_line,"#netcmd\nrenameroom\n%s\n%s\n",
			old_room_name,new_room_name);
		submit_cmd(command_line);
		}
	}

delete_net_room() {
	char room_name[20],command_line[128];
	printf("Enter room name: ");
	gets(room_name);
	if (strlen(room_name)==0) exit(0);
	printf("Ok to submit cmd (y/n)? ");
	if (yesno()) {
		sprintf(command_line,"#netcmd\ndeleteroom\n%s\n",
			room_name);
		submit_cmd(command_line);
		}
	}

disconnect_net_room() {
	char room_name[20],command_line[128];
	printf("Enter room name: ");
	gets(room_name);
	if (strlen(room_name)==0) exit(0);
	if (yesno()) {
		sprintf(command_line,"#netcmd\ndisconnect\n%s\n",
			room_name);
		submit_cmd(command_line);
		}
	}

generate_discovery_packet(is_cmdl)
int is_cmdl; {
	int r_is_cmdl;
	char command_line[128];
	
	r_is_cmdl = is_cmdl;
	if (r_is_cmdl==0) r_is_cmdl=yesno();
	if (r_is_cmdl) {
		sprintf(command_line,"#netcmd\ndiscovery\n");
		submit_cmd(command_line);
		}
	}
