/* Citadel/UX message routines
 * 
 * contents:
 * 
 * read_message() - called by Read routines to print messages
 * send_message() - read message in temp file & store in msgmain
 * make_message() - assemble temp message file - msg editor
 * msgform()      - msg formatter / called by read_message() and others
 * readmsgs()     - read messages in a room
 * entmsg()       - enter a message
 * save_message() - file a message into the current room
 */

#include <fcntl.h>
#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <pwd.h>
#include <setjmp.h>
#include <termio.h>
#include "citadel.h"

#define IFEXPERT if (usersupp.flags&US_EXPERT)
#define IFNEXPERT if ((usersupp.flags&US_EXPERT)==0)
#define IFUPASS if (upass!=0)
#define IFNUPASS if (upass==0)
#define IFAIDE if (usersupp.axlevel>=6)
#define IFNAIDE if (usersupp.axlevel<6)
long atol();
long lseek();
long finduser();
char *getenv();

extern int curr_rm,hold_rm,twitroom;
extern struct smreturn smreturn;
extern struct usersupp usersupp;
extern struct quickroom quickroom;
extern struct fullroom fullroom;
extern struct config config;
extern jmp_buf nextbuf;
extern int (*backnext())();
extern int (*backstop())();
extern char temp[];
extern long highest_msg_read;

extern char editorfile[16];

read_message(pos,pagin)	/* Read a message from the master file */
long pos;	/* Position in master file */
char pagin;	/* 0 = normal read, 1 = read with pagination, 2 = header */
{
	int a;
	a=setjmp(nextbuf);
	sttybbs(0);
	if ((a==1)||(a==2)) {
		printf("\n\n");
		return(a);
		}
	signal(SIGINT,(*backnext));
	signal(SIGQUIT,(*backstop));
	sttybbs(1);
	msgform(SCREENWIDTH,pos,"msgmain",pagin);
	sttybbs(0);
	return(0);
}

send_message(filename,retbuf)	/* send a message to the master file */
char filename[];		/* tempfilename of proper message */
struct smreturn *retbuf;	/* return information */
{

int file,a,c,d,file2;
long bb,cc,templen,hibytes,origpos;
char sbuf[BUFSIZ];
char mid[30];
FILE *fp;
struct msgmain msgmain;

	file=eopen("MMstructure",O_RDWR);

	do {
		lseek(file,0L,0);
		a=read(file,&msgmain,sizeof(struct msgmain));
		if (a<1) interr(14);
		if (msgmain.MMflags & MM_BUSY) sleep(1);
		} while(msgmain.MMflags & MM_BUSY);

	lseek(file,0L,0);
	msgmain.MMflags=(msgmain.MMflags|MM_BUSY);
	a=write(file,&msgmain,sizeof(struct msgmain)); if (a<1) interr(16);
	close(file);
	origpos=msgmain.MMcurpos;
	++msgmain.MMhighest;
	sprintf(mid,"I%ld",msgmain.MMhighest);
/* measure the message */
file=eopen(filename,O_RDONLY);
templen=lseek(file,0L,2);
close(file);
templen=templen+(long)strlen(mid);
++templen;

/* check for FF bytes */
hibytes=0L;
fp=fopen("msgmain","rb");
if (fp==NULL) interr(18);
bb=fseek(fp,msgmain.MMcurpos,0);

cc=ftell(fp);
for (bb=0L; bb<templen; ++bb) {
	if (cc>=MM_FILELEN) cc=fseek(fp,0L,0);
	c=getc(fp); ++cc;
	if (c>127) ++hibytes;		/* bump count if hi bit set */
	}

fclose(fp);
msgmain.MMlowest=msgmain.MMlowest+hibytes;

file=eopen("msgmain",O_RDWR);
cc=lseek(file,msgmain.MMcurpos,0);
file2=eopen(filename,O_RDONLY);
cc=lseek(file,0L,1);
d=read(file2,sbuf,3);
write(file,sbuf,d);
write(file,mid,strlen(mid));
d=0; write(file,&d,1);
do {
	d=read(file2,sbuf,BUFSIZ);
	write(file,sbuf,d);
	cc=cc+(long)d;
	if (((long)cc)>=((long)MM_FILELEN)) cc=lseek(file,0L,0);
	} while(d>0);

msgmain.MMcurpos=lseek(file,0L,1);
close(file2);	/* done with temp file */
close(file);	/* done with master file */

/* now update the message structure */

msgmain.MMflags=msgmain.MMflags & ~MM_BUSY;

file=eopen("MMstructure",O_RDWR);
a=write(file,&msgmain,sizeof(struct msgmain)); if (a<1) interr(21);
close(file);

retbuf->smnumber=msgmain.MMhighest;
retbuf->smpos=origpos;

return(0);
}

make_message(filename,author,recipient,room,type,mode)
char filename[];	/* temporary file name */
struct usersupp *author;  /* author's usersupp structure */
char recipient[];	/* NULL if it's not mail */
char room[];		/* room where it's going */
int type;		/* see MES_ types in header file */
int mode;		/* 0 for normal, 1 for ASCII, 2 for editor */
{ 
	FILE *fp,*fp2;
	int a,b,old,editor_exit;
	long aa,beg,now;
	char aaa[100];

	if (mode==2) if (getenv("EDITOR")==NULL) {
		printf("*** No editor available\n");
		mode=0;
		}
	time(&now);
	fp=fopen(filename,"wb"); if (fp==NULL) interr(22);
	putc(255,fp);
	putc(type,fp);	/* Normal or anonymous, see MES_ flags */
	putc(((mode!=0)?1:0),fp);	/* Formatted or unformatted */
	fprintf(fp,"Pcit%ld",author->eternal); putc(0,fp); /* path */
	fprintf(fp,"T%ld",now); putc(0,fp);		/* date/time */
	fprintf(fp,"A%s",author->fullname); putc(0,fp);	/* author */
	fprintf(fp,"O%s",quickroom.QRname); putc(0,fp);	/* room */
	fprintf(fp,"N%s",NODENAME); putc(0,fp);		/* nodename */
	fprintf(fp,"H%s",HUMANNODE); putc(0,fp);	/* human nodename */

	if (recipient[0]!=0) { fprintf(fp,"R%s",recipient); putc(0,fp); }
	fflush(fp);
	msgform(SCREENWIDTH,0L,filename,0);
	putc('M',fp);
	if (mode==1) printf("(Press ctrl-d when finished)\n");
	beg=ftell(fp); old=1;

ME1:	switch(mode) {

	   case 0:
		a=inkey(); a=(a&127);
		aa=ftell(fp);
		if ((a==8)&&(aa>beg)) {
			back(1); fseek(fp,-1L,1); goto ME1;
			}
		if ((a<32)&&(a!=13)) goto ME1;
		putc(a,stdout);
		if ((old==13)&&(a==13)) goto MECR;
		putc(a,fp); if (a==13) putc(10,stdout);
		old=a;
		goto ME1;
		break;

	   case 1:
		do {
			a=inkey(); if (a==255) a=32;
			if (a==13) a=10;
			if (a!=4) {
				putc(a,fp);
				putc(a,stdout);
				}
			if (a==10) putc(13,stdout);
			} while(a!=4);
		break;

	   case 2:
		a=fork();
		if (a==0) {
			setuid(getuid()); /* use real uid & gid */
			setgid(getgid());
			setsane();
		     execlp(getenv("EDITOR"),getenv("EDITOR"),editorfile,NULL);
			exit(1);
			}
		if (a>0) do {
			editor_exit = 0;
			b=wait(&editor_exit);
			} while((b!=a)&&(b>=0));
		sttybbs(0);
		break;
		}

MECR:	if (mode==2) {
		fseek(fp,beg,0);
		fp2=fopen(editorfile,"r");
		if (fp2!=NULL) {
			while(b=getc(fp2),b>0) putc(b,fp);
			fclose(fp2);
			}
		}
	putc(0,fp); fseek(fp,-1L,1); fflush(fp);
	if ((mode==2)&&(strucmp(getenv("EDITOR_EXIT"),""))) {
		if (editor_exit==0) goto MEFIN;
		goto MEABT2;
		}
	else printf("<A>bort <C>ontinue <P>rint <S>ave -> ");
MECR2:	b=inkey(); b=(b&127); b=tolower(b);
	if (b=='a') { printf("Abort\n");	goto MEABT; }
	if (b=='c') { printf("Continue\n");	goto ME1; }
	if (b=='s') { printf("Save buffer\n"); goto MEFIN; } 
	if (b=='p') { printf("Print formatted\n");
		msgform(SCREENWIDTH,0L,filename,0);
		goto MECR; }
	goto MECR2;

MEFIN:	putc(0,fp);
	fclose(fp);
	if (mode==2) unlink(editorfile);
	return(0);

MEABT:	printf("Are you sure? ");
	if (yesno()==0) goto ME1;
MEABT2:	fseek(fp,0L,0);
	putc(0,fp);
	putc(0,fp);
	fclose(fp);
	if (mode==2) unlink(editorfile);
	return(2);

}

msgform(width,spos,msgfile,pagin)
int width;
long spos;
char *msgfile;
char pagin;
	{
	struct tm *tm;
	int a,b,e,mtype,aflag;
	int lines_printed = 2;
	char bbb[1024];
	FILE *fp;
	long now;

	fp=fopen(msgfile,"rb");
	if (fp==NULL) return(1);
	fseek(fp,spos,0);
	e=getc(fp);
	if (e!=255) {
		printf("*** CANNOT LOCATE MESSAGE / pos=%ld\n",spos);
		return(1);
		}
	mtype=getc(fp); aflag=getc(fp);
	printf("\n ");
	if (mtype==MES_ANON) printf("-----\n");
	if (mtype==MES_AN2) printf("<anonymous> ");

   do {
	b=getc(fp);
	if (b=='M') {
		printf("\n");
		if (pagin==READ_HEADER) while(getc(fp)>0) ;
		else if (aflag!=1) fmout(width,fp);
		   else while(a=getc(fp), a>0) {
			if (a==13) a=10;
			putc(a,stdout);
			if (a==10) {
				++lines_printed;
				if ( ((lines_printed%23)==0) && (pagin==1)) {
					hit_any_key();
					}
				}
			if (ftell(fp)>=MM_FILELEN) fseek(fp,0L,0);
			}
		}
	if ((b!='M')&&(b>0)) fpgetfield(fp,bbb);

           if ( (mtype!=MES_ANON && mtype!=MES_AN2)
             || (usersupp.axlevel >= 6)
	     || (usersupp.eternal == quickroom.QRroomaide) ) {
	if (b=='A') printf("from %s ",bbb);
	if ((pagin==READ_HEADER)&&(b=='P')) printf("\nPath      : %s\n",bbb);
	if ((pagin==READ_HEADER)&&(b=='I')) printf("\nMessage ID: %s\n",bbb);
	if ((pagin==READ_HEADER)&&(b=='U')) printf("\nSubject   : %s\n",bbb);
	if ((b=='H')&&(strucmp(bbb,HUMANNODE))) printf("(%s) ",bbb);
	if ((b=='O')&&(strucmp(bbb,quickroom.QRname))) printf("in %s> ",bbb);
	if ((b=='N')&&((quickroom.QRflags&QR_NETWORK)||((strucmp(bbb,NODENAME)
	   &&(strucmp(bbb,FQDN))))))
		printf("@%s ",bbb);
	if (b=='R') printf("to %s ",bbb);
	if (b=='T') {
		now=atol(bbb);
		tm=(struct tm *)localtime(&now);
		strcpy(bbb,asctime(tm)); bbb[strlen(bbb)-1]=0;
		strcpy(&bbb[16],&bbb[19]);
		printf("%s ",&bbb[4]);
		}
              }
	   } while ((b!='M')&&(b>0));
	printf("\n"); fclose(fp); return(0);
}


entmsg(e,c)
int e,c; {
	char buf[300];
	int file,a,b;
	char mtsflag;
	struct usersupp tempUS;
	long aa;
	if ((usersupp.axlevel<2)&&(curr_rm!=1)) {
		printf("Need to be validated to enter\n");
		printf("(except in Mail> to Sysop)\n");
		return(0);
		}
	if ((usersupp.axlevel<4)&&(quickroom.QRflags&QR_NETWORK)) {
		printf("Need net privileges to enter here\n");
		return(0);
		}
	mtsflag=0;
	hold_rm=curr_rm;
	IFNEXPERT formout("messages/entermsg");
		
	buf[0]=0; if (curr_rm==1) {
		if (usersupp.axlevel>=2) {
			printf("Enter recipient: ");
			getline(buf,299);
			}
		else strcpy(buf,"sysop");
		e=alias(buf);			/* alias and mail type */
		if (buf[0]==0) return(1);
		if (e==M_ERROR) {
			printf("Unknown address - cannot send message.\n");
			return(1);
			}
		if ((e!=M_LOCAL)&&(usersupp.axlevel<4)) {
			printf("Net privileges required for network mail.\n");
			return(1);
			}
		if ((RESTRICT_INTERNET==1)&&(e==M_UUCP)
		   &&((usersupp.flags&US_INTERNET)==0)) {
			printf("You don't have access to Internet mail.\n");
			return(1);
			}
	if (!strucmp(buf,"sysop")) { mtsflag=1; goto SKFALL; }
	if (e!=M_LOCAL) goto SKFALL;	/* don't search local file if remote */
	if (!strucmp(buf,usersupp.fullname)) {
		printf("Can't send mail to yourself!\n");
		return(1);
		}

	file=eopen("usersupp",O_RDONLY);	/* check to make sure the */
	aa=finduser(file,buf);			/* user exists; also get  */
	if (aa==(-1)) {				/* the right upper/lower  */
		printf("No such user.\n");	/* casing of the name     */
		close(file);
		return(1);
		}
	read(file,&tempUS,sizeof(struct usersupp));
	strcpy(buf,tempUS.fullname);
	close(file);
	}
	
SKFALL: b=MES_NORMAL; if (quickroom.QRflags&QR_ANONONLY) b=MES_ANON;
	if (quickroom.QRflags&QR_ANON2) {
		printf("Anonymous (Y/N)? ");
		if (yesno()==1) b=MES_AN2;
		}
	if (curr_rm!=1) buf[0]=0;
	a=make_message(temp,&usersupp,buf,quickroom.QRname,b,c);
	if (a!=0) return(1);
	save_message(temp,buf,mtsflag,e);
	return(0);
   }

process_quote() {	/* do editing on quoted file */
FILE *qfile,*tfile;
char buf[128];
int line,qstart,qend;

	qfile = fopen(editorfile,"r");
	line = 0;
	fgets(buf,128,qfile);
	while (fgets(buf,128,qfile)!=NULL) {
		printf("%2d %s",++line,buf);
		}
	printf("Begin quoting at [ 1] : ");
	getline(buf,3);
	qstart = (buf[0]==0) ? (1) : atoi(buf);
	printf("  End quoting at [%d] : ",line);
	getline(buf,3);
	qend = (buf[0]==0) ? (line) : atoi(buf);
	rewind(qfile);
	line=0;
	fgets(buf,128,qfile);
	tfile=fopen(temp,"w");
	while(fgets(buf,128,qfile)!=NULL) {
		if ((++line>=qstart)&&(line<=qend)) fprintf(tfile,">%s",buf);
		}
	fclose(qfile);
	fclose(tfile);
	unlink(editorfile);
	link(temp,editorfile);
	unlink(temp);
	chmod(editorfile,0666);
	return(0);
	}


readmsgs(b,c,rdir)	/* read contents of a room */
int b;		/* starting point in room to read */
int c;		/* 0=Read all  1=Read new  2=Read old */
int rdir;	/* 1=Forward (-1)=Reverse */
	{
int a,d,e,file,f,g;
char arcflag = 0;
char quotflag = 0;
long cc;
struct msgmain msgmain;
char prtfile[16];
char pagin;
	signal(SIGINT,SIG_IGN);
	signal(SIGQUIT,SIG_IGN);
	sprintf(prtfile,"/tmp/CPrt%d",getpid());
	cc=usersupp.lastseen[curr_rm]+1L;
	if (usersupp.flags & US_LASTOLD) --cc;
	file=eopen("./MMstructure",O_RDONLY);
	a=read(file,&msgmain,sizeof(struct msgmain)); if (a<1) interr(45);
	close(file);
	for (a=b; ((a<MSGSPERRM)&&(a>=0)); a=a+rdir) {
		while ( (fullroom.FRnum[a]==0L)
		||  (fullroom.FRnum[a]<msgmain.MMlowest)
		|| ((c==1)&&(fullroom.FRnum[a]<cc))
		|| ((c==2)&&(fullroom.FRnum[a]>=cc))
			) {
			a=a+rdir; if ((a==MSGSPERRM)||(a==(-1))) return(0);
			}
RAGAIN:		pagin=((arcflag==0)&&(quotflag==0)&&
			(usersupp.flags & US_PAGINATOR)) ? 1 : 0;
		e=read_message(fullroom.FRpos[a],pagin);
RMSGREAD:	fflush(stdout);
		highest_msg_read = fullroom.FRnum[a];
		if (quotflag) {
			freopen("/dev/tty","r+",stdout);
			quotflag=0;
			process_quote();
			}
		if (arcflag) {
			freopen("/dev/tty","r+",stdout);
			arcflag=0;
			f=fork();
			if (f==0) {
				freopen(prtfile,"r",stdin);
				setuid(getuid()); /* use real uid & gid */
				setgid(getgid());
				setsane();
				system(getenv("PRINTCMD"));
				sttybbs(0);
				unlink(prtfile);
				exit(0);
				}
			if (f>0) do {
				g=wait(NULL);
				} while((g!=f)&&(g>=0));
			printf("Message printed.\n");
			}
		if (e==2) return(0);
		if ((usersupp.flags&US_NOPROMPT)||(e==1)) e='n';
		else {
			if (rdir==1) printf("(%d) ",MSGSPERRM-a-1);
			if (getenv("PRINTCMD")!=NULL) printf("<P>rint ");
		printf("<B>ack <A>gain <Q>uote <H>eader <N>ext <S>top -> ");
			do {
				e=(inkey()&127); e=tolower(e);
	if((usersupp.axlevel<6)&&(usersupp.eternal!=quickroom.QRroomaide))
				if ((e=='d')||(e=='m')) e=0;
				if ((e=='p')&&(getenv("PRINTCMD")==NULL)) e=0;
				if ((e=='p')&&(getenv("EDITOR")==NULL)) e=0;
				if ((e=='m')&&(curr_rm==1)) e=0;
				} while((e!='a')&&(e!='n')&&(e!='s')
					&&(e!='d')&&(e!='m')&&(e!='p')
					&&(e!='q')&&(e!='b')&&(e!='h'));
			switch(e) {
				case 's':	printf("Stop\r");	break;
				case 'a':	printf("Again\r");	break;
				case 'd':	printf("Delete\r");	break;
				case 'm':	printf("Move\r");	break;
				case 'n':	printf("Next\r");	break;
				case 'p':	printf("Print\r");	break;
				case 'q':	printf("Quote\r");	break;
				case 'b':	printf("Back\r");	break;
				case 'h':	printf("Header\r");	break;
				}
			if (usersupp.flags & US_DISAPPEAR)
				printf("%75s\r","");
			else
				printf("\n");
			}
		switch(e) {
		   case 'p':	fflush(stdout);
				freopen(prtfile,"w",stdout);
				arcflag = 1;
				goto RAGAIN;
		   case 'q':	fflush(stdout);
				freopen(editorfile,"w",stdout);
				quotflag = 1;
				goto RAGAIN;
		   case 's':	return(0);
		   case 'a':	goto RAGAIN;
		   case 'b':	a=a-(rdir*2);
				break;
		   case 'd':	printf("---> Delete this message? ");
				if (yesno()==1)
					delete_message(fullroom.FRnum[a]);
				break;
		   case 'm':	if (move_message(fullroom.FRpos[a],
					fullroom.FRnum[a])==0)
					delete_message(fullroom.FRnum[a]);
				break;
		   case 'h':	read_message(fullroom.FRpos[a],READ_HEADER);
				goto RMSGREAD;
			}
		} /* end for loop */
	} /* end read routine */

save_message(mtmp,rec,mtsflag,mailtype)
char mtmp[];			/* file containing proper message */
char rec[];			/* Recipient (if mail) */
char mtsflag;			/* 0 for normal, 1 to force Aide> room */
int mailtype; {			/* local or remote type, see citadel.h */
	int a,d,e,file;
	long aa,ee;
	struct usersupp tempUS;
	char aaa[100];

	send_message(mtmp,&smreturn);
	hold_rm=(-1);
      if (TWITDETECT) if (usersupp.axlevel==2) {
		if (twitroom<0) loadtroom();
		hold_rm=curr_rm;
		curr_rm=twitroom;
		gotocurr();
		}
	if (mtsflag) {
		hold_rm=curr_rm;
		curr_rm=2;
		gotocurr(); }
	sprintf(aaa,"./rooms/fullrm%d",curr_rm);
	file=eopen(aaa,O_RDWR);
	a=read(file,&fullroom,sizeof(struct fullroom)); if (a<1) interr(49);
	if (curr_rm==1) readmail();
	for (a=0; a<(MSGSPERRM-1); ++a) {
		fullroom.FRnum[a]=fullroom.FRnum[a+1];
		fullroom.FRpos[a]=fullroom.FRpos[a+1];
		}
	fullroom.FRnum[MSGSPERRM-1]=smreturn.smnumber;
	fullroom.FRpos[MSGSPERRM-1]=smreturn.smpos;
	lseek(file,0L,0);
	a=write(file,&fullroom,sizeof(struct fullroom)); if (a<1) interr(50);
	close(file);

	file=eopen("quickroom",O_RDWR);
	aa=(long)(curr_rm * sizeof(struct quickroom));
	lseek(file,aa,0);
	a=read(file,&quickroom,sizeof(struct quickroom)); if (a<1) interr(52);
	quickroom.QRhighest=fullroom.FRnum[MSGSPERRM-1];
	lseek(file,aa,0);
	a=write(file,&quickroom,sizeof(struct quickroom)); if (a<1) interr(53);
	close(file);
	readyerself(); ++usersupp.posted;
	if (curr_rm==twitroom) usersupp.generation[twitroom]=quickroom.QRgen;
	writeyerself();
	if (curr_rm!=1) goto ENTFIN;	/* if mail, there's still more to do */
	writemail();			/* keep a copy for yourself */
	if (mtsflag) goto ENTFIN;
	if (mailtype!=M_LOCAL) {
		printf("Filing network mail...\n");
		if ((a=fork())==0) {
			chdir(BBSDIR);
		execlp("netmailer","netmailer",mtmp,&mailtype,NULL);
			printf("*** Netmailer not installed.\n");
			exit(0);
			}
		do {
			d=wait(NULL);
			} while((d!=a)&&(d!=(-1)));
		}
	if (mailtype==M_LOCAL) {
		file=eopen("usersupp",O_RDWR);
		ee=finduser(file,rec);
		if (ee!=(-1L)) {
			read(file,&tempUS,sizeof(struct usersupp));
			for (e=0; e<(MAILSLOTS-1); ++e) {
				tempUS.mailnum[e]=tempUS.mailnum[e+1];
				tempUS.mailpos[e]=tempUS.mailpos[e+1];
				}
			tempUS.mailnum[MAILSLOTS-1]=smreturn.smnumber;
			tempUS.mailpos[MAILSLOTS-1]=smreturn.smpos;
			lseek(file,ee,0);
			write(file,&tempUS,sizeof(struct usersupp)); 
			}
		close(file);
		}

ENTFIN:	if (TWITDETECT) if (hold_rm!=(-1)) {
		curr_rm=hold_rm;
		gotocurr();
		}
	if (mtsflag) { 
		curr_rm=hold_rm;
		gotocurr();
		}
	unlink(mtmp);
	return(0);
	}
