/*
 * Citadel/UX
 *
 * commands.c - Command parser for room prompts
 *
 */

#include <stdio.h>
#include <ctype.h>
#include "citadel.h"

#define IFAIDE if(usersupp.axlevel>=6)
#define IFNAIDE if (usersupp.axlevel<6)
#define IFNEXPERT if ((usersupp.flags&US_EXPERT)==0)
struct passwd *getpwuid();
long lseek();

extern struct usersupp usersupp;
extern int curr_rm;
extern struct quickroom quickroom;
extern struct config config;

int lkey() {	/* returns a lower case value */
	int a;
	a=inkey();
	if (isupper(a)) a=tolower(a);
	return(a);
	}

/*
 * This routine is called to get and parse a command.
 * It returns the command number.  If the command also requires an
 * argument (like .Goto: or .Help: etc.) it will be placed in strbuf.
 */
int getcmd(strbuf)
char *strbuf; {

	int a,b,c,d;
	strcpy(strbuf,"");

	/* if we're running in idiot mode, display a cute little menu */
	IFNEXPERT formout("messages/mainmenu");

/* now the room prompt... */
printf("\n%s%c ",quickroom.QRname,room_prompt(&quickroom));

 while (1) {
  a=lkey();
  IFNAIDE if (a=='!') a=0;
  if (a=='?') a='h';
  switch(a) {
   case 'h':	printf("Help\n");
		return(1);
   case '*':	printf("Doorway\n");
		return(2);
   case 'c':	printf("Chat\n");
		return(3);
   case 'e':	printf("Enter message\n");
		return(DEFAULT_ENTRY);
   case 'g':	printf("Goto\n");
		return(5);
   case 's':	printf("Skip %s\n",quickroom.QRname);
		return(6);
   case 'z':	printf("Zap (forget) room\n");
		return(7);
   case 'k':	printf("Known rooms\n");
		return(8);
   case 'l':	printf("Last five msgs\n");
		return(9);
   case 'f':	printf("Forward read\n");
		return(10);
   case 'r':	printf("Reverse read\n");
		return(11);
   case 'o':	printf("Old msgs reverse\n");
		return(12);
   case 'n':	printf("New messages\n");
		return(13);
   case 'd':	printf("Directory\n");
		return(14);
   case 't':	printf("Terminate\n");
		return(15);
   case 'u':	printf("Ungoto\n");
		return(16);
   case 'w':	printf("Who is online\n");
		return(17);
   case 'a':	printf("Abandon room, goto...\n");
		return(47);
   case 'x':	printf("toggle eXpert mode\n");
		return(50);
   case '!':	printf("! <shell>\n");
		return(18);
   case '.': printf(".");
	     do {
		b=lkey();
if ((b=='a')&&(usersupp.axlevel<6)&&(quickroom.QRroomaide!=usersupp.eternal))
	b=0;
		switch(b) {
		   case 'z':	printf("Zapped list\n");
				return(19);
		   case 's':	printf("Skip this room, goto: ");
				getline(strbuf,19);
				return(52);
		   case 'g':	printf("Goto: ");
				getline(strbuf,19);
				return(20);
		   case 'h':	printf("Help: ");
				getline(strbuf,31);
				return(21);

/* start of aide options */
		   case 'a': printf("Aide ");
			     do {
				c=lkey();
IFNAIDE
    if ((c!='r')&&(c!='e')&&(c!='w')&&(c!='i')&&(c!='f')&&(c!='?')&&(c!=8))
	c=0;
				switch(c) {
				   case 'k':	printf("Kill this room\n");
						return(22);
				   case 'e':	printf("Edit this room\n");
						return(23);
				   case 'w':	printf("Who knows room\n");
						return(24);
				   case 'u':	printf("User edit\n");
						return(25);
				   case 'v':	printf("Validate new users\n");
						return(26);
				   case 'i':	printf("enter Info file\n");
						return(48);

/* start of room options */
				   case 'r': printf("Room cmd: ");
					     do {
						d=lkey();
						switch(d) {
					case 'i': printf("Invite user\n");
						  return(27);
					case 'k': printf("Kick out user\n");
						  return(28);
						  }
						} while(d!=8);
					     back(10);
					     break;
/* end of room options */

/* start of file options */
				   case 'f': printf("File cmd: ");
					     do {
						d=lkey();
						switch(d) {
					case 'd': printf("Delete file\n");
						  return(51);
						  }
						} while(d!=8);
					     back(10);
					     break;
/* end of room options */

				   case '?':	printf("(options)\n");
						formout("messages/aideopt");
printf("%s%c .Aide ",quickroom.QRname,room_prompt(&quickroom));
					}
				} while(c!=8);
			     back(5);
			     break;
/* end of aide options */

/* start of terminate options */
		   case 't': printf("Terminate ");
			     do {
				c=lkey();
				switch(c) {
				   case 'q':	printf("and Quit\n");
						return(29);
				   case 's':	printf("and Stay online\n");
						return(30);
					}
				} while(c!=8);
			     back(10);
			     break;
/* end of terminate options */

/* start of read options */
		   case 'r': printf("Read ");
			     do {
				c=lkey();
				switch(c) {
				   case 'f':	printf("File unformatted\n");
						return(31);
				   case 'u':	printf("User listing\n");
						return(32);
				   case 't':	printf("Textfile paginated\n");
						return(33);
				   case 'x':	printf("file using Xmodem\n");
						return(34);
				   case 'y':	printf("file using Ymodem\n");
						return(43);
				   case 'z':	printf("file using Zmodem\n");
						return(45);
				   case 'n':	printf("New messages\n");
						return(13);
				   case 'o':	printf("Old msgs reverse\n");
						return(12);
				   case 'l':	printf("Last five msgs\n");
						return(9);
				   case 'd':	printf("Directory\n");
						return(14);
				   case 'i':	printf("Info file\n");
						return(49);
				   case '?':	printf("(options)\n");
						formout("messages/readopt");
printf("%s%c .Read ",quickroom.QRname,room_prompt(&quickroom));
					}
				} while(c!=8);
			     back(5);
			     break;
/* end of read options */

/* start of enter options */
		   case 'e': printf("Enter ");
			     do {
				c=lkey();
				switch(c) {
				   case 'p':	printf("Password\n");
						return(35);
				   case 'a':	printf("ASCII message\n");
						return(36);
				   case 'c':	printf("Configuration\n");
						return(37);
				   case 'r':	printf("a new Room\n");
						return(38);
				   case 't':	printf("Textfile\n");
						return(39);
				   case 'x':	printf("file using Xmodem\n");
						return(40);
				   case 'y':	printf("file using Ymodem\n");
						return(42);
				   case 'z':	printf("file using Zmodem\n");
						return(44);
				   case 'g':	printf("reGistration\n");
						return(41);
				   case 'm':	printf("Message\n");
						return(4);
				   case 'e':	printf("message with Editor\n");
						return(46);
				   case '?':	printf("(options)\n");
						formout("messages/entopt");
printf("%s%c .Enter ",quickroom.QRname,room_prompt(&quickroom));
					}
				} while(c!=8);
			     back(6);
			     break;
/* end of enter options */

		   case '?':	printf("(options)\n");
				formout("messages/dotopt");
printf("%s%c .",quickroom.QRname,room_prompt(&quickroom));
		   }
		} while(b!=8);
		back(1);
		break;

    }	/* end switch	*/
  }	/* end while	*/
}	/* end getcmd()	*/
