/* citadel.h
 * main Citadel/UX header file
 * see copyright.doc for copyright information
 */

/* system customizations are in sysconfig.h */
#include "sysconfig.h"

#undef	tolower
#define tolower(x)	( ((x>='A')&&(x<='Z')) ? (x+'a'-'A') : x )
#define strucmp(lstr,rstr) struncmp(lstr,rstr,32767)
#define NEW_CONFIG

struct config {
	char c_nodename[16];		/* UUCP and Citadel nodename        */
	char c_fqdn[64];		/* Fully Qualified Domain Name      */
	char c_humannode[21];		/* Long name of system              */
	char c_phonenum[16];		/* Dialup number of system          */
	int c_bbsuid;			/* UID of the bbs-only user         */
	int c_pwcrypt;			/* password encryption seed         */
	char c_creataide;		/* room creator = room aide  flag   */
	int c_sleeping;			/* watchdog timer setting           */
	char c_initax;			/* initial access level             */
	char c_regiscall;		/* call number to register on       */
	char c_twitdetect;		/* twit detect flag                 */
	char c_twitroom[20];		/* twit detect msg move to room     */
	int c_defent;			/* command generated by <E> key     */
	char c_moreprompt[80];		/* paginator prompt                 */
	char c_restrict;		/* restrict Internet mail flag      */
	long c_msgbase;			/* size of message base             */
	char c_bbs_city[32];		/* city and state you are located in*/
	char c_sysadm[26];		/* name of system administrator     */
	};

#define NODENAME		config.c_nodename
#define FQDN			config.c_fqdn
#define HUMANNODE		config.c_humannode
#define PHONENUM		config.c_phonenum
#define BBSUID			config.c_bbsuid
#define PWCRYPT			config.c_pwcrypt
#define CREATAIDE		config.c_creataide
#define SLEEPING		config.c_sleeping
#define INITAX			config.c_initax
#define REGISCALL		config.c_regiscall
#define TWITDETECT		config.c_twitdetect
#define TWITROOM		config.c_twitroom
#define DEFAULT_ENTRY		config.c_defent
#define MORE_PROMPT		config.c_moreprompt
#define RESTRICT_INTERNET	config.c_restrict
#define MM_FILELEN		config.c_msgbase

struct usersupp {			/* User record                      */
	int USuid;			/* userid (==BBSUID for bbs only)   */
	char password[20];		/* password (for BBS-only users)    */
	long lastseen[MAXROOMS];	/* Last message seen in each room   */
	char generation[MAXROOMS];	/* Generation # (for private rooms) */
	char forget[MAXROOMS];		/* Forgotten generation number      */
	long mailnum[MAILSLOTS];	/* Message #'s of each mail message */
	long mailpos[MAILSLOTS];	/* Disk positions of each mail      */
	unsigned flags;			/* See US_ flags below              */
	int timescalled;		/* Total number of logins           */
	int posted;			/* Number of messages posted (ever) */
	char fullname[26];		/* Name for Citadel messages & mail */
	char axlevel;			/* Access level                     */
	char spare[3];			/* spare bytes in the user account  */
	long eternal;			/* Eternal user number              */
	long lastcall;			/* Last time the user called        */
	char USname[30];
	char USaddr[25];
	char UScity[15];
	char USstate[3];
	char USzip[10];
	char USphone[11];
				};

#define US_NEEDVALID	1		/* User needs to be validated       */
#define US_PERM		4		/* Permanent user                   */
#define US_LASTOLD	16		/* Print last old message with new  */
#define US_EXPERT	32		/* Experienced user		    */
#define US_UNLISTED	64		/* Unlisted userlog entry           */
#define US_NOPROMPT	128		/* Don't prompt after each message  */
#define US_DISAPPEAR	512		/* Use "disappearing msg prompts"   */
#define US_REGIS	1024		/* Registered user                  */
#define US_PAGINATOR	2048		/* Pause after each screen of text  */
#define US_INTERNET	4096		/* UUCP/Internet mail privileges    */
/****************************************************************************/

struct msgmain {
	long MMlowest;			/* lowest message number in file    */
	long MMhighest;			/* highest message number in file   */
	long MMcurpos;			/* Current position in file         */
	unsigned MMflags;		/* Global system flags              */
		};

#define MM_BUSY		1		/* Another process is using file    */
#define MM_CHAOS	2		/* Something is really messed up    */
#define MM_VALID	4		/* New users need validating        */
#define MM_USEINUSE	8		/* Use table is currently in use    */

/****************************************************************************/

struct smreturn {			/* Return from the send_message()   */
	long smnumber;			/* Message number (if sent)	    */
	long smpos;			/* Position in file (if sent)       */
	int smerror;			/* Error code                       */
		};

/****************************************************************************/

struct quickroom {
	char QRname[20];		/* Max. len is 19, plus null term   */
	char QRpasswd[10];		/* Only valid if it's a private rm  */
	long QRroomaide;		/* User number of room aide         */
	long QRhighest;			/* Highest message NUMBER in room   */
	char QRgen;			/* Generation number of room        */
	unsigned QRflags;		/* See flag values below            */
	char QRdirname[15];		/* Directory name, if applicable    */
	long QRinfo;			/* Info file update relative to msgs*/
		};

#define QR_BUSY		1		/* This would be a nice addition :-)*/
#define QR_INUSE	2		/* Set if in use, clear if avail    */
#define QR_PRIVATE	4		/* Set for any type of private room */
#define QR_PASSWORDED	8		/* Set if there's a password too    */
#define QR_GUESSNAME	16		/* Set if it's a guessname room     */
#define QR_DIRECTORY	32		/* Directory room                   */
#define QR_UPLOAD	64		/* Allowed to upload                */
#define QR_DOWNLOAD	128		/* Allowed to download              */
#define QR_VISDIR	256		/* Visible directory                */
#define QR_ANONONLY	512		/* Anonymous-Only room              */
#define QR_ANON2	1024		/* Anonymous-Option room            */
#define QR_NETWORK	2048		/* Shared network room              */
#define QR_PREFONLY	4096		/* Preferred status needed to enter */

/* Private rooms are always flagged with QR_PRIVATE. If neither QR_PASSWORDED
 * or QR_GUESSNAME is set, then it is invitation-only. Passworded rooms are
 * flagged with both QR_PRIVATE and QR_PASSWORDED while guess-name rooms are
 * flagged with both QR_PRIVATE and QR_GUESSNAME. DO NOT set all three flags.
 */
/****************************************************************************/

struct fullroom {
	long FRnum[MSGSPERRM];		/* Message NUMBERS		    */
	long FRpos[MSGSPERRM];		/* Message POSITIONS in master file */
		};

/* This structure is not 'circular'. When scrolling, each message moves
 * down a slot, and the oldest one falls off the bottom. A null message is 
 * represented by the value 0L in both fields.
 *
*****************************************************************************/

struct calllog {
	char CLfullname[30];		/* Name of user                     */
	long CLtime;			/* Date/time of record              */
	unsigned CLflags;		/* Info on record		    */
	};
#define CL_IN300	1		/* Carrier, 300 baud		    */
#define CL_IN1200	2		/* Carrier, 1200 baud		    */
#define CL_IN2400	4		/* Carrier, 2400 baud		    */
#define CL_INOTHER	8		/* Console or misc. baud rate	    */
#define CL_LOGIN	16		/* CLfullname logged in		    */
#define CL_NEWUSER	32		/* CLfullname is a new user	    */
#define CL_BADPW	64		/* Bad attempt at CLfullname's pw   */
#define CL_TERMINATE	128		/* Logout - proper termination	    */
#define CL_DROPCARR	256		/* Logout - dropped carrier	    */
#define CL_SLEEPING	512		/* Logout - sleeping		    */
#define CL_PWCHANGE	1024		/* CLfullname changed passwords     */

/* Miscellaneous                                                            */

#define MES_NORMAL	65		/* Normal message                   */
#define MES_ANON	66		/* "****" header                    */
#define MES_AN2		67		/* "Anonymous" header               */
#define BADSIG		(int(*)())-1	/* don't ask me - I have no idea!   */

#define M_ERROR		(-1)	/* Can't send message due to bad address   */
#define M_LOCAL		0	/* Local message, do no network processing */
#define M_UUCP		1	/* Translate to ASCII and use uucp main    */
#define M_BINARY	2	/* Process recipient and send through bin  */

/****************************************************************************/

struct recentmsg {
	char RMnodename[10];
	long RMnum;			/* Number or time of message        */
	};

struct wtmpsupp {
	char WStty[16];
	char WSname[30];
	char WSroom[20];
	};

#define SCREENWIDTH	80
#define NEWREGISTER	0		/* new user to register */
#define REREGISTER	1		/* existing user reregistering */

#define READ_HEADER	2

