
/*
 * Copyright (C) 1990 by Jay Konigsberg. mail: jak@sactoh0
 *
 * Permission to use, copy, modify, and distribute this  software  and  its
 * documentation is hereby  granted,  provided  that  the  above  copyright
 * notice appear in all copies  and that  both  the  copyright  notice  and
 * this permission notice appear in supporting documentation. This software
 * is provided "as is" without express or implied  warranty.  However,  the
 * author retains all Copyright priviliges and rights  to  renumeration  if
 * this software is sold.
 */

/*
 * get options for simped. -p postnews, -a append mode.
 */

#include	"simped.h"

char *options (argc, argv, postnews, append, editfile)
int	argc;
char	**argv,
	*postnews,	/* flag to add a '--' line to file */
	*append,	/* always come up in append mode */
	*editfile;
{
/* system calls and library functions */
int	getopt(),
	fprintf(),
	exit();

/* variables */
/* extern char *optarg; UNUSED */
extern int optind;

int	option,			/* getopt variable */
	error=FALSE;		/* error checking the options */

while ((option = getopt(argc, argv, "pa")) != -1)
    {
    switch (option)
	{
	case 'p':
	    *postnews=TRUE;
	    break;
	case 'a':
	    *append=TRUE;
	    break;
	case '?':
	    error=TRUE;
	    break;
	}
    }
if ( argc > optind+1 )
    {
    fprintf(stderr, "Max one filename on command line.\n");
    error=TRUE;
    }
else
    {
    editfile=argv[optind];
    }

if (error)
    {
    fprintf(stderr,
    "usage: simped [-p] [-a] filename\n");
    exit(2);
    }
return(editfile);
}
