
/*
 * Copyright (C) 1990 by Jay Konigsberg. mail: jak@sactoh0
 *
 * Permission to use, copy, modify, and distribute this  software  and  its
 * documentation is hereby  granted,  provided  that  the  above  copyright
 * notice appear in all copies  and that  both  the  copyright  notice  and
 * this permission notice appear in supporting documentation. This software
 * is provided "as is" without express or implied  warranty.  However,  the
 * author retains all Copyright priviliges and rights  to  renumeration  if
 * this software is sold.
 */

/*
 * listtext - display the text buffer area starting at 'start' line
 * number and pausing every PAUSE lines.
 */

#include "simped.h"
#define BS "\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b"
#define SP "                 "

void listtext(text, count, start)
char	**text;		/* the text buffer area */
int	count;		/* lines in text area */
int	start;		/* the line to start the listing at */
{
int	puts(),
	fputs(),
	printf();

int	loop,		/* loop var */
	inpchar;	/* input char for pause */

puts("");
if (! count)
    {
    puts("There is no text.");
    }
else
    {
    for(loop=start-1; loop < count; ++loop)
	{
	if ( !((loop+start-1) % PAUSE) && loop && loop != count-1
	    && loop != start-1 && count - start > PAUSE)
	    {
	    fputs ("[Press q to quit]", stdout);
	    if ( (inpchar = getchar()) == 'q' || inpchar == 'Q')
		{
		puts("q");
		return;
		}
	    else
		{
		fputs(BS, stdout);
		fputs(SP, stdout);
		fputs(BS, stdout);
		}
	    }
	printf("%3d> ", loop+1);
	fputs(text[loop], stdout);
	}
    }
}
