
/*
 * Copyright (C) 1990 by Jay Konigsberg. mail: jak@sactoh0
 *
 * Permission to use, copy, modify, and distribute this  software  and  its
 * documentation is hereby  granted,  provided  that  the  above  copyright
 * notice appear in all copies  and that  both  the  copyright  notice  and
 * this permission notice appear in supporting documentation. This software
 * is provided "as is" without express or implied  warranty.  However,  the
 * author retains all Copyright priviliges and rights  to  renumeration  if
 * this software is sold.
 */

/*
 * help - on-line help information.
 */

/* global to replace \b in input */
extern unsigned char bs_char;

#include "simped.h"
#define MARKER "--------------------------------------------------------"

void help()
{
int	puts(),
	fputs(),
	fflush();

int	inpchar,
	getcr;		/* get a return to go */

puts("");
puts("Help - S)ave");
puts("       A)bort");
puts("       L)ist");
puts("       E)dit");
puts("       I)nsert");
puts("       D)elete");
puts("       C)ontinue");
puts("       M)odify");
puts("");
fputs ("Enter the command you want help with? ", stdout);
    inpchar=getchar();
    putchar(inpchar); puts("\n");
puts(MARKER);
switch(inpchar)
    {
    case 'S':
    case 's':
	puts("\n* S)ave and quit\n");
	puts("Saves the file and quits the editor.\n");
	puts("No options.");
	break;
    case 'A':
    case 'a':
	puts("\n* A)bort/cancel\n");
	puts("Verifies that no save is to be done and then abandons any");
	puts("editing that was done.\n");
	puts("No options.");
	break;
    case 'L':
    case 'l':
	puts("\n* List text\n");
	puts("Lists the text entered, pausing every half page or so. The");
	puts("number of lines listed is set at compile time.\n");
	puts("Options: A starting line number may be entered. A return");
	puts("         will start listing at line 1.");
	break;
    case 'E':
    case 'e':
	puts("\n* Edit line\n");
	puts("Substitute old text for new text on a line.\n");
	puts("Example 1:\n");
	puts("Command? e <RETURN>");
	puts("Line number: 1 <RETURN>\n");
	puts("  1> A line of text\n");
	puts("Old text: f t <RETURN>");
	puts("New text: f modified t <RETURN>\n");
	puts("  1> A line of modified text\n");
	puts("(returns to the command prompt)\n\n");
	fputs("Touch any key to continue: ", stdout);
	fflush(stdout);
	inpchar=getchar();
	puts("\n\nExample 2:\n");
	puts("Command? e1/f t/f modified t/\n");
	puts("  1> A line of modified text\n");
	puts("(returns to the command prompt)\n");
	puts("To insert characters at the beginning of a line, enter");
	puts("nothing for the \"Old text:\" and the characters to be");
	puts("inserted for the \"New text:\".\n");
	puts("To delete characters, enter them in the \"Old text:\" and");
	puts("nothing in the new text.\n");
	puts("Entering nothing in both \"Old text:\" and \"New text:\" will");
	puts("result in no change.");
	break;
    case 'I':
    case 'i':
	puts("\n* Insert line\n");
	puts("Insert lines of text BEFORE the line number specified. The");
	puts("user is dropped into 'insert mode'.\n");
	puts("Option: The line number you want the inserted text to");
	puts("        appear BEFORE.");
	break;
    case 'D':
    case 'd':
	puts("\n* Delete line\n");
	puts("Delete a line. The line will be printed and you must enter");
	puts("a 'y' for the line to be deleted.\n");
	puts("Option: The line number you want deleted.");
	break;
    case 'C':
    case 'c':
	puts("\n* Continue\n");
	puts("Continue entry. Drops the user into input mode AFTER the");
	puts("last line in the file.\n");
	puts("No options.");
	break;
    case 'M':
    case 'm':
	puts("\n* Modify\n");
	puts("This is a multi-use editing function added in a effort");
	puts("to regain some of the flexibility lost in making this");
	puts("editor simple.\n");
	puts("Option: The line number you want to modify.\n");
	puts("This command can:\n");
	puts("  - replace text");
	puts("  - put blanks in place of characters");
	puts("  - delete text");
	puts("  - insert text\n");
	puts("The line is printed and and the cursor is placed under the");
	puts("first character on the next line. Changes are made by placing");
	puts("one or more of the available options below the portion of");
	puts("the line.\n");
	fputs("Touch any key to continue: ", stdout);
	fflush(stdout);
	inpchar=getchar();
	puts("\n\nOPTION              EXPLANATION");
	puts("------              -----------");
	puts("^text#              Inserts the characters between the '^'");
	puts("                    and the '#' BEFORE the character");
	puts("                    pointed to by the '^'. Inside the '^'");
	puts("                    and the '#', both the '&' and the '^'");
	puts("                    are treated as regular characters.\n");
	puts("  ^#                Inserts a # before ^ (special case)\n");
	puts("   #                (When not the first character after a");
	puts("                    '^') causes the character above it to");
	puts("                    be deleted and the space closed.\n");
	puts("   &                Replaces the character above it with a");
	puts("                    blank space.\n");
	puts("(space)             No effect.\n");
	puts("ANY OTHER CHARACTER WILL REPLACE THE CHARACTER ABOVE IT!");
	puts("========================================================\n");
	fputs("Touch any key to continue: ", stdout);
	fflush(stdout);
	inpchar=getchar();
	puts("\n\nExample:\n");
	puts("Command? m1 <RETURN>\n");
	puts("   1> Thos sentence isstoobbe mortifd");
	puts("edit>   i  ^is the ####  #&     d   ^ie#\n");
	puts("   1> This is the sentence to be modified\n");
	puts("Command? _");
	break;
    default :
	puts("\nNo such command");
	break;
    }
puts(MARKER);
}
