
/*
 * Copyright (C) 1990 by Jay Konigsberg. mail: jak@sactoh0
 *
 * Permission to use, copy, modify, and distribute this  software  and  its
 * documentation is hereby  granted,  provided  that  the  above  copyright
 * notice appear in all copies  and that  both  the  copyright  notice  and
 * this permission notice appear in supporting documentation. This software
 * is provided "as is" without express or implied  warranty.  However,  the
 * author retains all Copyright priviliges and rights  to  renumeration  if
 * this software is sold.
 */

/*
 * getlinenum - gets a line number for use with other editor commands.
 *
 * arg 2 is a flag for special return. 
 * "cr=1"  will return 1 if nothing entered. Mainly for list.
 * "/?=cr" will return on / or ? instead of cr. Mainly for editline.
 *	   This will return ? or / in *delimiter. (arg 3), otherwise,
 *	   agr 3 will be null.
 * ""      (null) is the default and will ask for a "Line number:" if
 *         one isn't entered.
 */

/* global to replace \b char in input */
extern unsigned char bs_char;

#include "simped.h"
#define	PLACES	3	/* 3 mantissa places [0], [1], [2], [3]=NULL*/

int getlinenum(count, flag, delimiter)
int  count;
char *flag;
char *delimiter;
{
int	printf(),
	fflush(),
	puts(),
	fputs(),
	atoi();

char	linenum[PLACES],/* the line number before atoi */
	inpdigit;	/* each digit as it is read in */

int	theline,	/* returns the line number, 0 if the screen
			 * hasnt changed or -1 on error */
	linenuminx=0,	/* an index to line */
	creturn=FALSE;	/* flag that "theline" may not equal zero */


do
    {
    if ((inpdigit=getchar()) == '\n' && linenuminx == 0)
	{
	if (creturn)
	    {
	    return(theline = -1);
	    }
	else
	    {
	    if ( ! strcmp(flag, "cr=1") )
		{
		return(theline = 1);
		}
	    else
		{
		fputs("\nLine number: ", stdout);
		fflush(stdout);
		creturn = TRUE;
		inpdigit=' ';
		}
	    }
	}
    else
	{
	if(inpdigit == bs_char)
	    {
	    fputs("\b \b", stdout);
	    fflush(stdout);
	    if ( --linenuminx >= 0 )
		linenum[linenuminx] = '\0';
	    if (linenuminx == -1)
		{
		if (creturn)
		    {
		    return(theline = -1);
		    }
		else /* returning from the function via bs, no screen change */
		    {
		    return(theline = 0);
		    }
		}
	    }
	else
	    {
	    if (linenuminx < PLACES && inpdigit >= '0' &&
		inpdigit <= '9' && inpdigit != '\n')
		{
		putchar(inpdigit);
		fflush(stdout);
		linenum[linenuminx++]=inpdigit;
		linenum[linenuminx]='\0';
		}
	    else
		{
		if (inpdigit != '\n')
		    {
		    if ( ! strcmp(flag, "/?=cr") )
			{
			putchar(inpdigit);
			fflush(stdout);
			*delimiter=(char)inpdigit;
			inpdigit=(int)'\0';
			break;
			}
		    else
			{
			putchar(BELL);
			fflush(stdout);
			}
		    }
		}
	    }
	}
    }
while (inpdigit != '\n');

theline=atoi(linenum);
if(theline > count)
    {
    printf("\nThere are only %d lines.\n", count);
    theline = -1;
    }
else
    if (theline == 0)
	{
	puts("\nThere is no line 0.");
	theline = -1;
	}
fflush(stdout);
return(theline);
}
