
/*
 * Copyright (C) 1990 by Jay Konigsberg. mail: jak@sactoh0
 *
 * Permission to use, copy, modify, and distribute this  software  and  its
 * documentation is hereby  granted,  provided  that  the  above  copyright
 * notice appear in all copies  and that  both  the  copyright  notice  and
 * this permission notice appear in supporting documentation. This software
 * is provided "as is" without express or implied  warranty.  However,  the
 * author retains all Copyright priviliges and rights  to  renumeration  if
 * this software is sold.
 */

/*
 * getline - gets a line of text from the fd: in_file. If the line of
 * text is longer than the allowed length (LINELEN) it strips off the
 * last word if there is whitespace, or the last char if not. The
 * overflow is saved, unless the dumpoverflow flag is set.
 *
 * The overflow is returned to the caller and maintained in static
 * space.
 */

#include "simped.h"

/* global to replace \b char in input */
extern unsigned char bs_char;
extern unsigned char del_char;

char *getline(buffer, text_entered, in_file, delimiter, dumpoverflow)
char buffer[];		/* input buffer to be passed out */
int  *text_entered;	/* flag that something was entered */
FILE *in_file;		/* stdin, or the fd of a file */
char delimiter;		/* if set, will return like a return will */
int  dumpoverflow;	/* boolean */
{
int	fflush(),
	fputs(),
	puts();

static	char *overflow;
static	char extrachar = '\0';	/* autowrap char when there is no whitespace */


int	blankchar,		/* location of blanking during autowrap */
	inpchar,		/* char read in for procesing into buffer */
	curchar=0,		/* input buffer pointer */
	whitespace,		/* location of autowrap cut */
	have_nl=FALSE;		/* newline flag */

*text_entered = FALSE;
have_nl = FALSE;
fflush(stdout);

for (curchar=0; (curchar<=LINELEN && (! have_nl)); ++curchar)
    {
    if (overflow)
	{
	curchar = strlen(overflow);
	if (in_file == stdin)
	    {
	    fputs(overflow, stdout);
	    fflush(stdout);
	    }
	buffer[0]='\0';
	strcat(buffer, overflow);
	overflow = NULL;
	}
    else
	{
	if (extrachar)
	    {
	    curchar = 1;
	    if (in_file == stdin)
		{
		putchar(extrachar);
		}
	    buffer[0]=extrachar;
	    buffer[1]=extrachar='\0';
	    }
	}
    inpchar = getc(in_file);
	if (inpchar==27) inpchar='X';
    if (inpchar == EOF)
	{
	*text_entered = EOF;
	break;
	}
    if (( inpchar == bs_char ) || (inpchar == del_char))
	{
	if ( curchar > 0)
	    {
	    if (in_file == stdin)
		{
		fputs("\b \b", stdout);
		}
	    curchar -= 2; /* one will be added back in the for loop */
	    }
	else
	    {
	    putchar(BELL);
	    curchar--;
	    }
	buffer[curchar+1]='\0';
	}
    else 
	{
	if ( inpchar == '\t' )
	    {
	    inpchar = ' ';
	    }
	else
	    {
	    if ( inpchar == '\n' )
		{
		have_nl = TRUE;
		}
	    }
	if ( delimiter == inpchar )
	    {
	    putchar(delimiter);
	    buffer[curchar]='\n';
	    buffer[curchar+1]='\0';
	    break;
	    }
	if (inpchar != EOF)
	    {
	    buffer[curchar] = inpchar; 
	    buffer[curchar+1] = '\0'; 
	    if (in_file == stdin)
		{
		putchar(inpchar);
		}
	    }
	}
    fflush(stdout);
    }
/* At least 1 char & a CR */
if ( curchar >= 2 || ( curchar > 1 && delimiter != '0') )
    {
	*text_entered = TRUE;
    }
/* If the line overflowed - do an autowrap */
if (curchar == LINELEN+1 && ! have_nl)
    {
    /* look for the last whitespace */
    for (whitespace=curchar-1; whitespace >= 0; --whitespace)
	{
	    if ( buffer[whitespace] == ' ' )
		{
		break;
		}
	}
    if (whitespace > 0)
	{
	for(blankchar=LINELEN; blankchar>whitespace; --blankchar)
		{
		if (in_file == stdin)
		    {
		    fputs("\b \b", stdout);
		    }
		}
	if (in_file == stdin)
	    {
	    puts("");
	    }
	overflow=(char *)&buffer[whitespace+1];
	buffer[whitespace] = '\0';
	}
    else /* No whitespace, put the last char in overflow */
	{
	if (in_file == stdin)
	    {
	    fputs("\b \b", stdout);
	    puts("");
	    }
	extrachar = buffer[LINELEN];
	buffer[LINELEN] = '\n';
	buffer[LINELEN+1] = '\0';
	}
    }
if (dumpoverflow)
    {
    overflow=NULL;
    extrachar='\0';
    return('\0');
    }
return(overflow);
}
