
/*
 * Copyright (C) 1990 by Jay Konigsberg. mail: jak@sactoh0
 *
 * Permission to use, copy, modify, and distribute this  software  and  its
 * documentation is hereby  granted,  provided  that  the  above  copyright
 * notice appear in all copies  and that  both  the  copyright  notice  and
 * this permission notice appear in supporting documentation. This software
 * is provided "as is" without express or implied  warranty.  However,  the
 * author retains all Copyright priviliges and rights  to  renumeration  if
 * this software is sold.
 */

/*
 * editline - edit a line in the text buffer. e.g. e/old/new
 */

#include "simped.h"

char **editline(text, linenum, delimiter)
char **text;
int  linenum;
char delimiter;
{
int	position(),		/* where is oldtext in text[], -1 if err */
	cleanup(),
	puts(),
	fputs(),
	fflush(),
	printf(),
	fprintf();

char	*realloc(),
	*getline();


char	*oldtext,
	*newtext,
	buffer[LINELEN+2];

int	text_entered,		/* boolean to tell if something was entered */
	textinx=0,		/* index for the subsitutation */
	textlen,		/* length of the original string */
	newlen,			/* length of new text */
	oldlen,			/* length of old text */
	point=0;		/* subscript of text[] where oldtext begins */

textlen=strlen(text[linenum-1]);
if ( ! delimiter )
    {
    printf("%3d> ", linenum);
    fputs(text[linenum-1], stdout);
    puts("Return by itself to insert at the beginning.");
    }
    for(;;)
    {
    if ( ! delimiter)
	{
	fputs("Old text: ", stdout);
	fflush(stdout);
	}
    if (getline(buffer, &text_entered, stdin, delimiter, TRUE))
	{
	if ( ! delimiter)
	    {
	    printf("Max line is %d characters, continuing...\n", LINELEN);
	    }
	else
	    {
	    /* printf("%c%c", delimiter, BELL); */
	    }
	buffer[LINELEN+1]='\n';
	buffer[LINELEN+2]='\0';
	}
    fflush(stdout);
    /* if (text_entered == FALSE) */
    if ( strlen(buffer) == 1) /* a single '\n' was entered */
	{
	/* setup to insert at the begining of the line */
	oldlen=0;
	break;
	}
    else
	{
	buffer[strlen(buffer)-1]='\0';
	oldtext=strdup(buffer);
	oldlen=strlen(oldtext);
	if( (point=position(oldtext, text[linenum-1])) == -1)
	    {
	    printf("\nstring: %s, not found in line %d\n", oldtext, linenum);
	    delimiter='\0';
	    }
	else
	    {
	    break;
	    }
	}
    }
if ( ! delimiter )
    {
    fputs("New text: ", stdout);
    fflush(stdout);
    }
if(getline(buffer, &text_entered, stdin, delimiter, TRUE))
    {
    if ( ! delimiter )
	    {
	    printf("Max line is %d characters, continuing...\n", LINELEN);
	    }
	else
	    {
	    /* printf("%c%c", delimiter, BELL); */
	    fflush(stdout);
	    }
    buffer[LINELEN+1]='\n';
    buffer[LINELEN+2]='\0';
    }
/* if (text_entered == FALSE && oldlen == 0) */
if (strlen(buffer) == 1 && oldlen == 0) /* a singal '\n' was entered */
    {
    /* nothing entered, exit */
    puts("\nNo change...");
    return(text);
    }
if (text_entered == FALSE)
    {
    buffer[0]='\0';
    }
else
    {
    buffer[strlen(buffer)-1]='\0';
    }
newtext=strdup(buffer);
newlen=strlen(newtext);
/* Conditions to handle
 *
 *				* no realloc
 * 1) oldlen == newlen		- strings are same length
 *				* relloc after change so no text is lost
 * 2) newlen == 0 & oldlen > 1	- remove some text
 * 3) newlen <  oldlen		- downsize text[]
 *				* realloc before change so there is
 *				  room for more characters
 * 4) oldlen == 0 & newlen > 1	- insert at beginning of line
 * 5) newlen >  oldlen		- increase size-of text[]
 */
if (newlen == oldlen) /* case 1, same length */
    {
    for (textinx=point; textinx < point+newlen; ++textinx)
	{
	text[linenum-1][textinx] = newtext[textinx-point];
	}
    }
else
    {
    if (newlen < oldlen) /* case 2 & 3 - have extra space */
	{
	/* copy over old text - non-op if new=0 */
	for (textinx=point; textinx < point+newlen; ++textinx)
	    {
	    text[linenum-1][textinx] = newtext[textinx-point];
	    }
	/* roll remaining text back over the oldtext */
	point=textinx;
	for (textinx=point; textinx < textlen; ++textinx)
	    {
	    text[linenum-1][textinx]=text[linenum-1][textinx+oldlen-newlen];
	    }
	text[linenum-1][textlen+newlen-oldlen]='\0';
	if((text[linenum-1]=realloc(text[linenum-1],
	    (unsigned int)(textinx+FUDGE)))==NULL)
	    {
	    fprintf(stderr, "realloc: error=%d\n", errno);
	    cleanup(2);
	    }
	}
    else /* case 4 & 5 - more space is needed */
	{
	if((text[linenum-1]=realloc(text[linenum-1],
		(unsigned int)(textlen+newlen-oldlen+FUDGE)))==NULL)
	    {
	    fprintf(stderr, "realloc: error=%d\n", errno);
	    cleanup(2);
	    }
	/* roll out char to make room for insert */
	
	for (textinx=textlen+newlen-oldlen;
	    textinx >= point+newlen-oldlen; --textinx)
	    {
	    text[linenum-1][textinx]=text[linenum-1][textinx-newlen+oldlen];
	    }
	/* place newtext in the text area */
	for (textinx=point; textinx < point+newlen; ++textinx)
	    {
	    text[linenum-1][textinx] = newtext[textinx-point];
	    }
	text[linenum-1][textlen+newlen-oldlen-1]='\n';
	text[linenum-1][textlen+newlen-oldlen]='\0';
	}
    }
printf("\n%3d> ", linenum);
fputs(text[linenum-1], stdout);
return(text);
}
