
/*
 * Copyright (C) 1990 by Jay Konigsberg. mail: jak@sactoh0
 *
 * Permission to use, copy, modify, and distribute this  software  and  its
 * documentation is hereby  granted,  provided  that  the  above  copyright
 * notice appear in all copies  and that  both  the  copyright  notice  and
 * this permission notice appear in supporting documentation. This software
 * is provided "as is" without express or implied  warranty.  However,  the
 * author retains all Copyright priviliges and rights  to  renumeration  if
 * this software is sold.
 */

/*
 * cleanup - resets port settings to what they were before entering
 * raw mode.
 */

#include "simped.h"

/* Global for interrupt routine: cleanup() */
extern	struct	  termio  ttyset;	/* terminal settings */
extern	unsigned  short   c_lflag_hold;	/* hold original values for reset */
extern	unsigned  char    VEOF_hold;	/* hold original value for reset */

int cleanup(sig_caught) /* Signal trap for SIGINT */
int	sig_caught;
{
void	exit();

int	ioctl(),
	fprintf();

/* reset terminal charastics */
ttyset.c_lflag = c_lflag_hold;
ttyset.c_cc[4] = VEOF_hold;
if ( ioctl(0, TCSETAW, &ttyset) == -1) {
    fprintf(stderr, "ioctl: error=%d\n", errno);
    exit(2);
}
if (sig_caught)
    {
    fprintf(stderr,"\nMessage aborted.\n");
    }
exit(sig_caught);
return(0);
}
