
/*
 * Copyright (C) 1990 by Jay Konigsberg. mail: jak@sactoh0
 *
 * Permission to use, copy, modify, and distribute this  software  and  its
 * documentation is hereby  granted,  provided  that  the  above  copyright
 * notice appear in all copies  and that  both  the  copyright  notice  and
 * this permission notice appear in supporting documentation. This software
 * is provided "as is" without express or implied  warranty.  However,  the
 * author retains all Copyright priviliges and rights  to  renumeration  if
 * this software is sold.
 */

/*
 * allocate - makes room in the text buffer for whatever was just entered.
 */
#include "simped.h"

char **allocate(text, buffer, overflow, location, count)
char	**text;
char	buffer[];
char	*overflow;
int	location;	/* where to allocate space for the buffer */
int	count;		/* number of lines in the text area */
{
int	fprintf(),
	cleanup();

extern char *malloc(),
	    *realloc();

int	linelen,	/* length of the input buffer */
	textinx;	/* text index for insert adjustment */

if ( ! (count % PTR_CHUNK) )
    {
    if ( (text = (char **)realloc((char *)text, (unsigned)
	((count+PTR_CHUNK) * sizeof(char *)))) == (char **)0)
	{
	fprintf(stderr, "realloc: error=%d\n", errno);
	cleanup(2);
	}
    }
if (location < count) /* insert vs. append */
    {
    for(textinx=count; textinx >= location; --textinx)
	text[textinx]=text[textinx-1];
    }
if (overflow)
    {
    linelen=strlen(buffer);
    if((text[location-1]=malloc((unsigned)(linelen+FUDGE))) == NULL)
	{
	fprintf(stderr, "malloc: error=%d\n", errno);
	cleanup(2);
	}
    text[location-1] = strcpy(text[location-1], buffer);
    text[location-1][linelen]='\n';
    text[location-1][linelen+1]='\0';
    /* text[location-1] = strcat(text[location-1], "\n"); */
    }
else
    {
    text[location-1] = strdup(buffer);
    }
return(text);
}
