;more/asm.
;
;THIS IS WHERE WE GO IF WE GET AN ERROR DURING A PROTOCOL COMMUNICATION.
;  CALL ERROR PRINTS THE ERROR PACKET ON LINE 6 OR SO.
;  CALL ERROR1 PRINT CRLF FOLLOWED BY THE ERROR PACKET.
;  CALL ERROR2 JUST PRINTS THE ERROR PACKET.
;  CALL ERROR3 POSITIONS CURSOR AND PRINTS ERROR MESSAGE SPECIFIED IN DE.
ERROR	CALL	ERROR9		;POSITION THE CURSOR.
	LD	A,'A'		;SET THE STATE TO ABORT.
	LD	(STATE),A
	JP	ERROR2
ERROR1	LD	DE,CRLF		;PRINT A CRLF.
	CALL	PRTSTR
ERROR2	LD	A,(ARGBLK+1)	;GET THE LENGTH OF THE DATA.
	LD	C,A
	LD	B,0		;PUT IT INTO BC
	LD	HL,DATA		;GET THE ADDRESS OF THE DATA.
	ADD	HL,BC		;GET TO THE END OF THE STRING.
	LD	A,'$'		;PUT A DOLLAR SIGN AT THE END.
	LD	(HL),A
	LD	DE,DATA		;PRINT ERROR MESSAGE
	CALL	PRTSTR
	RET
ERROR3	PUSH	DE		;SAVE THE POINTER TO THE MESSAGE.
	CALL	ERROR9		;POSITION THE CURSOR.
	LD	DE,CLRLIN	;CLEAR THE LINE
	CALL	PRTSTR
	POP	DE		;GET THE POINTER BACK.
	CALL	PRTSTR		;PRINT ERROR MESSAGE
	RET
ERROR9	LD	DE,SCRERR	;POSITION CURSOR
	CALL	PRTSTR
	RET
ERRORD	OR	A		;display disk error
	RET	Z
	OR	80H
	OR	40H
	CALL	@ERROR
	RET
FINMES	PUSH	DE		;SAVE MESSAGE.
	LD	DE,SCRST
	CALL	PRTSTR
	POP	DE		;PRINT THE TERMINATION MESSAGE
	CALL	PRTSTR
	LD	DE,SCREND	;POSITION CURSOR FOR PROMPT
	CALL	PRTSTR
	RET
;
;THIS IS THE FINISH COMMAND.  IT TELLS THE REMOTE KERSRV TO EXIT.
FINISH	LD	A,CMCFM
	CALL	COMND		;GET A CONFIRM.
	JP	KERMT3
	XOR	A		; DIDN'T GET A CONFIRM.
	LD	(NUMTRY),A	;INITITIALIZE COUNT.
	LD	A,'1'		;RESET BLOCK CHECK TYPE TO SINGLE CHARACTER
	LD	(CURCHK),A	; .  .  .
FINSH1	LD	A,(NUMTRY)	;HOW MANY TIMES HAVE WE TRIED?
	CP	MAXTRY		;TOO MANY TIMES?
	JP	M,FINSH3	;NO, TRY IT.
FINSH2	LD	DE,ERMS18	;SAY WE COULDN'T DO IT.
	CALL	PRTSTR
	JP	KERMIT		;GO HOME.
FINSH3	INC	A		;INCREMENT THE NUMBER OF TRIES.
	LD	(NUMTRY),A
	XOR	A
	LD	(ARGBLK),A	;MAKE IT PACKET NUMBER ZERO.
	LD	A,1
	LD	(ARGBLK+1),A	;ONE PIECE OF DATA.
	LD	HL,DATA
	LD	(HL),'F'	;FINISH RUNNING KERMIT.
	LD	A,'G'		;GENERIC COMMAND PACKET.
	CALL	SPACK
	JP	FINSH1
	CALL	RPACK		;GET AN ACKNOWLEDGEMENT.
	JP	FINSH1
	CP	'Y'		;ACK?
	JP	Z,KERMIT	;YES, WE ARE DONE.
	CP	'E'		;IS IT AN ERROR PACKET?
	JP	NZ,FINSH1	;TRY SENDING THE PACKET AGAIN.
	CALL	ERROR1		;PRINT THE ERROR MESSAGE.
	JP	KERMIT
;
;THIS IS THE LOGOUT COMMAND.  IT TELLS THE REMOTE KERSRV TO LOGOUT.
LOGOUT	LD	A,CMCFM
	CALL	COMND		;GET A CONFIRM.
	JP	KERMT3
	CALL	LOGO		;SEND THE LOGOUT PACKET.
	JP	KERMIT		;GO GET ANOTHER COMMAND
	JP	KERMIT		; WHETHER WE SUCCEED OR NOT.
LOGO	XOR	A
	LD	(NUMTRY),A	;INITITIALIZE COUNT.
	LD	A,'1'		;RESET BLOCK CHECK TYPE TO SINGLE CHARACTER
	LD	(CURCHK),A	; .  .  .
LOGO1	LD	A,(NUMTRY)	;HOW MANY TIMES HAVE WE TRIED?
	CP	MAXTRY		;TOO MANY TIMES?
	JP	M,LOGO3		;NO, TRY IT.
LOGO2	LD	DE,ERMS19	;SAY WE COULDN'T DO IT.
	CALL	PRTSTR
	RET			;FINISHED.
LOGO3	INC	A		;INCREMENT THE NUMBER OF TRIES.
	LD	(NUMTRY),A
	XOR	A
	LD	(ARGBLK),A	;MAKE IT PACKET NUMBER ZERO.
	LD	A,1
	LD	(ARGBLK+1),A	;ONE PIECE OF DATA.
	LD	HL,DATA
	LD	(HL),'L'	;LOGOUT THE REMOTE HOST.
	LD	A,'G'		;GENERIC COMMAND PACKET.
	CALL	SPACK
	JP	LOGO2
	CALL	RPACK		;GET AN ACKNOWLEDGEMENT
	JP	LOGO1
	CP	'Y'		;ACK?
	JP	Z,RSKP		;YES, WE ARE DONE.
	CP	'E'		;IS IT AN ERROR PACKET?
	JP	NZ,LOGO1	;TRY SENDING THE PACKET AGAIN.
	CALL	ERROR1		;PRINT THE ERROR MESSAGE.
	RET			;ALL DONE.
;
;THIS IS THE BYE COMMAND.  IT TELLS THE REMOTE KERSRV TO LOGOUT AND EXITS.
BYE	LD	A,CMCFM
	CALL	COMND		;GET A CONFIRM.
	JP	KERMT3
	CALL	LOGO		;TELL THE MAIN FRAME TO LOGOUT.
	JP	KERMIT		;IF IT FAILS, DON'T EXIT.
	JP	EXIT1		;EXIT KERMIT.
;
;THIS IS THE LOG COMMAND.  IT LOGS A SESSION TO A FILE.
LOG	LD	A,CMOFI		;PARSE AN INPUT FILE SPEC.
	LD	DE,LFCB
	CALL	COMND
	JP	KERMT3
	LD	A,CMCFM		;PARSE A CONFIRM.
	CALL	COMND
	JP	KERMT3
	LD	HL,LOGFLG
	LD	(HL),0FFH	;SET THE LOG FLAG.
	LD	HL,LBUFF
	LD	(BUFPNT),HL
	LD	DE,LFCB
	CALL	@OPEN
	JR	NZ,LOG1A
	LD	DE,LFCB
	CALL	@KILL
	LD	DE,LFCB
	LD	HL,(BUFPNT)
LOG1A	CALL	@INIT
	JP	NZ,KERMIT	;[UTK3]
	CALL	ERRORD
	JP	KERMIT
;
;this is the connect command
TELNET	LD	A,CMCFM
	CALL	COMND
	JP	KERMT3
	LD	DE,INFMS7
	CALL	PRTSTR
	CALL	ESCPR
	LD	DE,INFMS8
	CALL	PRTSTR
CHRLUP	CALL	PRTCHR
	CALL	CONCHR
	JP	KERMIT
	JP	CHRLUP
;
;More machine dependant code!
PRTCHR	IN	A,(RDSTAT)	;********
	BIT	DAV,A		;********
;
;System-80 has value of DAV bit reversed.
	IF	F_SYS80
	RET	NZ		;sys80
	ELSE
	RET	Z		;Trs80,Zeta,Aterm
	ENDIF
;
;
PRTCH2	IN	A,(RDDATA)	;********
	AND	7FH
	CP	LF
	JR	Z,PRTCHR
	LD	E,A
	LD	A,(VTFLG)
	OR	A
	JR	Z,PRTCH1
	LD	A,(ESCFLG)
	OR	A
	JP	NZ,VT52
	LD	A,E
	CP	DEL
	RET	Z
	CP	ESC
	JR	NZ,PRTCH1
	LD	(ESCFLG),A
	JP	PRTCHR
PRTCH1	CP	FF
	JP	Z,CMBLNK
	LD	A,(LOGFLG)
	OR	A
	CALL	NZ,LOGIT
	LD	A,(PRTFLG)
	OR	A
	CALL	NZ,PRTIT
	LD	A,E
	CALL	CONOUT
	JP	PRTCHR
CONCHR	CALL	CONIN
	AND	7FH
	OR	A
	JP	Z,RSKP
	LD	E,A
	LD	A,(ESCCHR)
	CP	E
	JP	Z,INTCHR
	LD	A,E
	CALL	SETPAR
	LD	E,A
	PUSH	DE
	CALL	PRTOUT
	POP	DE
	LD	A,(ECOFLG)
	OR	A
	JP	Z,RSKP
	LD	A,E
	AND	7FH
	CALL	CONOUT
	JP	RSKP
;
INTCHR	CALL	ESCPR
INTCH0	CALL	CONIN
	OR	A
	JR	Z,INTCH0
	LD	B,A
	CALL	CONOUT
	LD	A,B
	CP	CTRLC		;control-c?
	JR	Z,CONTC		;yes
	AND	137O
	CP	'C'		;is it close?
	JP	NZ,INTCHR0	;no
CONTC	LD	DE,INFMS9
	CALL	PRTSTR
	LD	A,(LOGFLG)	;is log file on?
	OR	A
	RET	Z		;no
	XOR	A
	LD	(LOGFLG),A	;turn it off
	LD	DE,INFMS6
	CALL	PRTSTR
	LD	DE,LFCB
	CALL	@CLOSE
	RET
;
INTCHR0	CP	'S'		;status?
	JR	NZ,INCH01
	CALL	STAT01		;print out status
	JP	RSKP
;
INCH01	LD	A,B
	CP	'?'
	JR	NZ,INTCH1
	LD	DE,INTHLP
	CALL	PRTSTR
	JP	INTCH0
;
INTCH1	LD	A,B
	AND	7FH
	CP	'B'
	JR	NZ,INTCH2
	LD	DE,INMS12
	CALL	PRTSTR
	JP	RSKP
;
INTCH2	LD	A,B
	CP	'0'
	JR	NZ,INTCH3
	LD	A,0
	CALL	OUTCHR
	JP	RSKP
;
INTCH3	LD	E,A
	LD	A,(ESCCHR)
	CP	E
	JR	Z,INTCHZ
	LD	A,E
	CALL	SETPAR
	CALL	PRTOUT
	JP	RSKP
;
INTCHZ	LD	A,BELL
	CALL	CONOUT
	JP	RSKP
;
VT52	XOR	A
	LD	(ESCFLG),A
	LD	A,E
	CP	'A'
	RET	M
	CP	'K'+1
	RET	P
	SUB	'A'
	RLCA
	RLCA
	LD	HL,TA
	LD	E,A
	LD	D,0
	ADD	HL,DE
	EX	DE,HL
	CALL	PRTSTR
	RET
;
LOGIT	LD	A,E
	LD	HL,(LOGPTR)
	LD	(HL),A
	INC	HL
	LD	(LOGPTR),HL
	PUSH	HL
	POP	BC
	LD	HL,LBUFF+257
	OR	A
	SBC	HL,BC
	RET	NZ		;not full yet
	PUSH	DE
	LD	A,XOFF		;stop data flow
	CALL	OUTCHR		;send it out
	LD	DE,LFCB
	CALL	@VER		;write out the buffer
	JR	Z,LOGIT2
	LD	DE,ERMS11
	CALL	PRTSTR
LOGIT2	LD	HL,LBUFF
	LD	(LOGPTR),HL
	LD	A,XON
	CALL	OUTCHR		;start data flow
	POP	DE
	RET
;
PRTIT	LD	A,(37E8H)	;get printer status
	AND	0F0H
	CP	30H
	RET	NZ		;skip this one
	LD	A,E
	PUSH	DE
	CALL	@PRT		;dos printer routine
	POP	DE
	RET
;
PRTOUT	OR	A
	RET	Z
	LD	E,A
	CALL	OUTCHR
	RET
;
;THIS IS THE SET COMMAND.
SETCOM	LD	DE,SETTAB	;PARSE A KEYWORD FROM THE SET TABLE.
	LD	HL,SETHLP
	LD	A,CMKEY
	CALL	COMND
	JP	KERMT2
	LD	HL,SETJTB	;GET THE ADDRESS OF THE JUMP TABLE.
	LD	C,A
	LD	B,0
	ADD	HL,BC
	JP	(HL)
SETJTB	JP	ESCAPE		;00H SET ESC
	JP	IBMSET		;03H SET IBM
	JP	LOCAL		;06H SET LOCAL
	JP	KERMT3		;09H SET RECEIVE (NOT CURRENTLY USED)
	JP	SETSND		;0CH SET SEND (NOT CURRENTLY USED)
	JP	FILWAR		;0FH SET WARNING
	JP	SETCPM		;12H SET FILE-MODE
	JP	PARSET		;15H SET PARITY
	JP	BLKSET		;18H SET BLOCK-CHECK-TYPE
	JP	VT52EM		;1BH SET VT52
	JP	PRTSET		;1EH SET PORT
	JP	BAUD		;21H SET BAUD
	JP	PRINTR		;24H	set printer
	JP	SETBUG		;27H SET DEBUG
BLKSET	LD	DE,BLKTAB	;GET THE ADDRESS OF THE BLOCK-CHECK TABLE
	LD	HL,BLKHLP	;AND THE ADDRESS OF THE HELP TEXT
	LD	A,CMKEY		;PARSE A KEYWORD
	CALL	COMND		;GO GET IT
	JP	KERMT2		;COULDN'T, COMPLAIN
	LD	(TEMP1),A	;SAVE THE PARSED ITEM
	LD	A,CMCFM		;WANT TO END THE COMMAND
	CALL	COMND		;GO DO IT
	JP	KERMT2		;GIVE UP
	LD	A,(TEMP1)	;GET THE VALUE BACK
	LD	(CHKTYP),A	;SAVE DESIRED CHECKSUM TYPE
	JP	KERMIT		;GO GET ANOTHER COMMAND
;
;SET DEFAULT DISK COMMAND
;SETDISK:	JP	KERMT3		;not used on trs80
;SETDI1:	LD     A,(FCB)
;	cp	0
;	JP     NZ,SETDI2	;HE TYPED A DRIVE-SPEC
;	LD     A,(CURDSK)	;HE DIDN'T - GIVE HIM DEFAULT
;SETDI2:	LD     (CURDSK),A
;	JP     KERMIT	;ALL DONE
;SET SEND COMMAND.
SETSND	LD	DE,STSNTB	;PARSE A KEYWORD FROM THE SET SEND TABLE.
	LD	HL,STSHLP
	LD	A,CMKEY
	CALL	COMND
	JP	KERMT2
	LD	HL,STSJTB	;GET THE ADDRESS OF THE JUMP TABLE.
	LD	C,A
	LD	B,0
	ADD	HL,BC
	JP	(HL)
STSJTB	JP	STPDCH
	JP	STPAD
STPAD	LD	A,CMCFM
	CALL	COMND		;GET A CONFIRM.
	JP	KERMT3		; DIDN'T GET A CONFIRM.
	JP	KERMIT
;
STPDCH	LD	A,CMCFM
	CALL	COMND		;GET A CONFIRM.
	JP	KERMT3		; DIDN'T GET A CONFIRM.
	JP	KERMIT
;
;THIS IS THE SET SPEED COMMAND
BAUD	LD	DE,SPDTAB
	LD	HL,SPDHLP
	CALL	ONOFFA
	LD	(SPEED),A	;SET THE SPEED.
	CALL	MDMRST		;set the speed
	JP	KERMIT
;
;	THIS IS THE ESCAPE CHARACTER SET SUBCOMMAND.
ESCAPE	LD	A,CMCFM		;NOT (BRAIN OR OSBRN1 OR KPII)
	CALL	COMND		;GET A CONFIRM.
	JP	KERMT3		; DIDN'T GET A CONFIRM.
	LD	DE,ESCMES	;GET THE ADDRESS OF THE ESCAPE MESSAGE.
	CALL	PRTSTR
	CALL	@KEY
	CALL	CONOUT
	LD	(ESCCHR),A	;STORE THE NEW ESCAPE CHARACTER.
	JP	KERMIT
;
;	THIS IS THE LOCAL ECHO SET SUBCOMMAND.
LOCAL	CALL	ONOFF
	LD	A,(TEMP1)	;GET THE PARSED VALUE.
	LD	(ECOFLG),A	;SET THE LOCAL ECHO FLAG.
	JP	KERMIT
;
;	THIS IS THE VT52 EMULATION SET SUBCOMMAND.
VT52EM	CALL	ONOFF
	LD	(VTFLG),A	;SET THE VT52 EMULATION FLAG.
	JP	KERMIT
;THIS IS THE FILE-WARNING SET SUBCOMMAND
FILWAR	CALL	ONOFF
	LD	(FLWFLG),A	;SET THE FILE-WARNING FLAG.
	JP	KERMIT
;
;	THIS IS THE SET IBM COMMAND.
IBMSET	CALL	ONOFF
	LD	(IBMFLG),A	;SET THE IBM FLAG.
	OR	A		;IS IT TURNED ON?
	JR	Z,IBMST1	;IF NOT, SET PARITY TO THE DEFAULT.
	LD	A,IBMPAR	;GET THE IBM PARITY.
	LD	B,1		;SET LOCAL ECHO ON.
	JR	IBMST2
IBMST1	LD	A,DEFPAR
	LD	B,0		;SET LOCAL ECHO OFF.
IBMST2	LD	(PARITY),A	;SAVE THEM.
	LD	A,B
	LD	(ECOFLG),A
	JP	KERMIT
;
;	THIS IS THE SET PORT COMMAND.
PRTSET	LD	DE,PRTTAB	;GET THE TABLE ADDRESS
	LD	HL,PRTHLP	;AND THE ADDRESS OF THE HELP TEXT
	LD	A,CMKEY		;WANT A KEYWORD
	CALL	COMND		;GET THE FIELD OF THE COMMAND
	JP	KERMT2		;NOT VALID, GIVE ERROR
	LD	(TEMP1),A	;SAVE THE PARSED VALUE.
	LD	A,D		;GET THE FUNCTION TO USE
	LD	(TEMP2),A	;SAVE FOR LATER
	LD	A,CMCFM		;MAKE SURE COMMAND IS FINISHED
	CALL	COMND		;GET A CONFIRM.
	JP	KERMT3		; DIDN'T GET A CONFIRM.
	LD	HL,(TEMP1)	;GET THE TABLE POINTER
	LD	A,(HL)		;GET THE I/O port
	LD	(PORT),A	;save as current
	JP	KERMIT
;
;TABLE ENTRIES ARE:
;	DB	port,port
;
;
;	SET FILE-MODE COMMAND.
;********************************************************
; Set the file mode: ASCII :- obsolete
;                   BINARY :- obsolete
;                  DEFAULT :- obsolete
SETCPM	LD	DE,TYPTAB
	LD	HL,TYPHLP
	CALL	ONOFFA
	LD	(CPMFLG),A	;SET THE CPM FLAG
	JP	KERMIT
;
;	Set Printer command
PRINTR	CALL	ONOFF
	LD	(PRTFLG),A
	JP	KERMIT
PARSET	LD	DE,PARTAB
	LD	HL,PARHLP
	CALL	ONOFFA
	LD	(PARITY),A	;SET THE CPM FLAG.
	JP	KERMIT
;
;SET DEBUG
SETBUG	CALL	ONOFF
	LD	(DBFLG),A
	JP	KERMIT
;
ONOFF	LD	DE,ONTAB
	LD	HL,ONHLP
ONOFFA	LD	A,CMKEY
	CALL	COMND
	JP	ONOFF2
	LD	(TEMP1),A
	LD	A,CMCFM
	CALL	COMND
	JP	ONOFF3
	LD	A,(TEMP1)
	RET
ONOFF2	POP	AF
	JP	KERMT2
ONOFF3	POP	AF
	JP	KERMT3
;
;THIS IS THE SHOW COMMAND.
SHOW	LD	A,CMCFM
;* RECONCILE THIS AND STATUS.
	CALL	STAT01		;FOR NOW JUST COP OUT.
	JP	KERMIT		;(nick: Bloody typical!)
;
;	THIS IS THE STATUS COMMAND.
STATUS	CALL	STAT01
	JP	KERMIT
STAT01	LD	DE,LOCST	;GET THE ADDRESS OF THE LOCAL ECHO STRING.
	CALL	PRTSTR
	LD	DE,OFFSTR
	LD	A,(ECOFLG)	;GET THE LOCAL ECHO FLAG.
	OR	A		;IS IT ON?
	JR	Z,STAT03	;IF NOT SAY SO.
	LD	DE,ONSTR	;SAY ON.
STAT03	CALL	PRTSTR
	LD	DE,VTEMST	;GET THE ADDRESS OF THE VT52 EMULATION STRING.
	CALL	PRTSTR
	LD	DE,OFFSTR
	LD	A,(VTFLG)	;GET THE VT52 EMULATION FLAG.
	OR	A		;IS IT ON?
	JR	Z,STAT11	;IF NOT SAY SO.
	LD	DE,ONSTR	;SAY ON.
STAT11	CALL	PRTSTR
	LD	DE,CPMST	;GET THE ADDRESS OF THE CPM CREATED FILE.
	CALL	PRTSTR
	LD	A,(CPMFLG)
	OR	A		;IS IT ON?
	JR	Z,STAT2		;IF NOT SAY SO.
	CP	1		;ASCII?
	LD	DE,ASCSTR	;
	JR	Z,STAT21	;SAY ASCII
	LD	DE,BINSTR	;SAY BINARY
	JR	STAT21
STAT2	LD	DE,DEFSTR	;SAY DEFAULT.
STAT21	CALL	PRTSTR
	LD	DE,IBMST	;IBM STRING.
	CALL	PRTSTR
	LD	DE,OFFSTR
	LD	A,(IBMFLG)	;IBM FLAG.
	OR	A		;IS IT ON?
	JR	Z,STAT3		;IF NOT SAY SO.
	LD	DE,ONSTR	;SAY ON.
STAT3	CALL	PRTSTR
	LD	DE,FILST	;FILE WARNING STRING.
	CALL	PRTSTR
	LD	DE,OFFSTR
	LD	A,(FLWFLG)	;FILE WARNING FLAG.
	OR	A		;IS IT ON?
	JR	Z,STAT4		;IF NOT SAY SO.
	LD	DE,ONSTR	;SAY ON.
STAT4	CALL	PRTSTR
	LD	DE,BUGST	;debug string
	CALL	PRTSTR
	LD	DE,OFFSTR
	LD	A,(DBFLG)
	OR	A
	JR	Z,STAT4A
	LD	DE,ONSTR
STAT4A	CALL	PRTSTR
	LD	DE,PARST	;PARITY STRING.
	LD	DE,PNTSTR	;printer string
	CALL	PRTSTR
	LD	DE,OFFSTR
	LD	A,(PRTFLG)	;get printer flag
	OR	A
	JR	Z,STAT4D
	LD	DE,ONSTR
STAT4D	CALL	PRTSTR
	LD	DE,PARST
	CALL	PRTSTR
	LD	A,(PARITY)	;GET THE PARITY SETTING.
	LD	DE,PNONST	;NONE BY DEFAULT.
	CP	PARMRK		;IS IT MARK?
	JR	NZ,STAT5	;IF NOT SAY SO.
	LD	DE,PMRKST	;SAY MARK.
	JR	STAT55
STAT5	CP	PARSPC		;IS IT SPACE?
	JR	NZ,STAT51	;IF NOT SAY SO.
	LD	DE,PSPCST	;SAY SPACE.
	JR	STAT55
STAT51	CP	PARODD		;IS IT ODD?
	JR	NZ,STAT52	;IF NOT SAY SO.
	LD	DE,PODDST	;SAY ODD.
	JR	STAT55
STAT52	CP	PAREVN		;IS IT EVEN?
	JR	NZ,STAT55	;IF NOT SAY SO.
	LD	DE,PEVNST	;SAY EVEN.
STAT55	CALL	PRTSTR
;PRINT OUT CURRENT BLOCK-CHECK-TYPE
	LD	DE,BCKST	;GET THE STRING
	CALL	PRTSTR		;PRINT "BLOCK CHECK TYPE: "
	LD	A,(CHKTYP)	;GET THE TYPE (CHARACTER 1, 2, OR 3)
	CALL	CONOUT
	LD	DE,BCKST1	;GET REST OF TEXT ("-CHARACTER")
	CALL	PRTSTR		; .  .  .
;PRINT THE CURRENT ESCAPE CHARACTER
	LD	DE,ESCST	;ESCAPE STRING.
	CALL	PRTSTR
	CALL	ESCPR		;PRINT THE ESCAPE CHAR.
	LD	DE,CRLF		;GET THE ADDRESS OF A CRLF.
	CALL	PRTSTR
;print current baud rate
	LD	DE,SPEDST	;line speed
	CALL	PRTSTR
	LD	A,(SPEED)
	SUB	11H		;decement baud bit
	LD	HL,SPDTAB	;baud speed table
	LD	BC,CMSTAT-SPDTAB
	CPIR			;block compare
	INC	HL
	INC	HL
	EX	DE,HL
	CALL	PRTSTR		;print baud rate
	LD	DE,BAUST	;' baud'
	CALL	PRTSTR
	RET
;
                                                                                                                                                                                                                                  